/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx.references;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXNamespaceReference;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.resolve.JSQualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSXResolveUtil {
    public static final String CHILDREN = "children";
    public static final String JSX_ELEMENT_FULL = "JSX.Element";
    public static final String JSX_ELEMENT = "Element";
    public static final String JSX_SOURCE = "JSX";
    public static final String JSX_INTRINSIC_ELEMENTS = "IntrinsicElements";
    public static final String FORWARD_REF = "forwardRef";
    public static final String CHILDREN_PROPERTY = "children";
    public static final String KEY_PROP = "key";
    public static final String REF_PROP = "ref";

    public static ResolveResult @NotNull [] resolveTopLevelName(@NotNull PsiElement context2, @NotNull String name) {
        Collection<PsiElement> topElements;
        if (context2 == null) {
            JSXResolveUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            JSXResolveUtil.$$$reportNull$$$0(1);
        }
        if ((topElements = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(name, context2)).isEmpty()) {
            JSQualifiedNameResolver resolver = ES6PsiUtil.createResolver(context2);
            topElements = resolver.getTopLevelElements(name, false);
        }
        ResolveResultSink sink = new ResolveResultSink(context2, name);
        for (PsiElement element : topElements) {
            sink.addResult(element, null, null);
        }
        ResolveResult[] resolveResultArray = sink.getResultsAsResolveResults();
        if (resolveResultArray == null) {
            JSXResolveUtil.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    @NotNull
    public static @NotNull ResolveResult @NotNull [] resolveNestedName(@NotNull PsiElement context2, @NotNull String name, @NotNull Collection<? extends PsiElement> scopes, @NotNull JSXNamespaceReference parent) {
        if (context2 == null) {
            JSXResolveUtil.$$$reportNull$$$0(3);
        }
        if (name == null) {
            JSXResolveUtil.$$$reportNull$$$0(4);
        }
        if (scopes == null) {
            JSXResolveUtil.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            JSXResolveUtil.$$$reportNull$$$0(6);
        }
        if (parent.isThisQualifier()) {
            ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(scopes.stream().flatMap(scope2 -> Stream.of(JSQualifiedNameResolver.processDeclarationsForScope(name, scope2, false))).filter(ResolveResult::isValidResult).map(ResolveResult::getElement).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet()));
            if (resolveResultArray == null) {
                JSXResolveUtil.$$$reportNull$$$0(7);
            }
            return resolveResultArray;
        }
        JSQualifiedNameResolver resolver = ES6PsiUtil.createResolver(context2);
        Collection<PsiElement> elements = resolver.getLocalElements(name, scopes);
        ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(elements);
        if (resolveResultArray == null) {
            JSXResolveUtil.$$$reportNull$$$0(8);
        }
        return resolveResultArray;
    }

    @NotNull
    public static Collection<PsiElement> expandReferenceElements(@NotNull PsiElement context2, @NotNull JSXNamespaceReference reference) {
        Collection<PsiElement> elements;
        if (context2 == null) {
            JSXResolveUtil.$$$reportNull$$$0(9);
        }
        if (reference == null) {
            JSXResolveUtil.$$$reportNull$$$0(10);
        }
        if ((elements = JSResolveResult.resolveReference(reference)).isEmpty()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSXResolveUtil.$$$reportNull$$$0(11);
            }
            return list2;
        }
        Collection<PsiElement> collection = ES6PsiUtil.expandElements(context2, elements);
        if (collection == null) {
            JSXResolveUtil.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @Nullable
    public static PsiPolyVariantReference getTopLevelReference(@NotNull JSXmlLiteralExpression xmlLiteral) {
        if (xmlLiteral == null) {
            JSXResolveUtil.$$$reportNull$$$0(13);
        }
        PsiReference tagNameReference = xmlLiteral.getReference();
        return (PsiPolyVariantReference)ObjectUtils.coalesce((Object)JSXResolveUtil.getFirstQualifierReference((XmlTag)xmlLiteral), (Object)((PsiPolyVariantReference)ObjectUtils.tryCast((Object)tagNameReference, PsiPolyVariantReference.class)));
    }

    @Nullable
    public static JSXNamespaceReference getFirstQualifierReference(@NotNull XmlTag tag) {
        PsiReference[] references;
        if (tag == null) {
            JSXResolveUtil.$$$reportNull$$$0(14);
        }
        for (PsiReference reference : references = tag.getReferences()) {
            if (!(reference instanceof JSXNamespaceReference)) continue;
            return (JSXNamespaceReference)reference;
        }
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isComponentName(@Nullable String tagName) {
        if (tagName == null) {
            return false;
        }
        if (tagName.indexOf(".") > 0 && tagName.charAt(0) != '[') {
            return true;
        }
        if (tagName.isEmpty()) {
            return false;
        }
        char firstChar = tagName.charAt(0);
        boolean isLowCaseLatin = firstChar >= 'a' && firstChar <= 'z';
        return !isLowCaseLatin;
    }

    public static boolean areReferencesResolvedOrEmpty(@NotNull JSXmlLiteralExpression expression) {
        PsiReference[] references;
        if (expression == null) {
            JSXResolveUtil.$$$reportNull$$$0(15);
        }
        if ((references = expression.getReferences()).length == 0) {
            return true;
        }
        ArrayList<PsiElement> resolved = new ArrayList<PsiElement>();
        for (PsiReference reference : references) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
                List<PsiElement> elements = JSResolveResult.toElements(results);
                resolved.addAll(ContainerUtil.filter(elements, el -> !el.equals(expression)));
                continue;
            }
            PsiElement resolve2 = reference.resolve();
            if (resolve2 == null || resolve2.equals(expression)) continue;
            resolved.add(resolve2);
        }
        return !resolved.isEmpty();
    }

    public static boolean isJSXContextPlace(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSXResolveUtil.$$$reportNull$$$0(16);
        }
        return context2 instanceof JSXmlLiteralExpression || DialectDetector.isJSX(context2) && ObjectUtils.doIfNotNull((Object)context2.getNode(), ASTNode::getElementType) == JSTokenTypes.XML_TAG_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 8, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/jsx/references/JSXResolveUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlLiteral";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/jsx/references/JSXResolveUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTopLevelName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNestedName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "expandReferenceElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveTopLevelName";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveNestedName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "expandReferenceElements";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelReference";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFirstQualifierReference";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "areReferencesResolvedOrEmpty";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isJSXContextPlace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 8, 11, 12 -> new IllegalStateException(string);
        };
    }
}

