/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.google.gson.JsonObject;
import com.intellij.lang.javascript.flow.Location;
import com.intellij.lang.javascript.flow.MessageObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0006"}, d2={"buildLocation", "Lcom/intellij/lang/javascript/flow/Location;", "messageObject", "Lcom/google/gson/JsonObject;", "buildMessageObject", "Lcom/intellij/lang/javascript/flow/MessageObject;", "intellij.javascript.impl"})
public final class FlowJSErrorsParserKt {
    private static final MessageObject buildMessageObject(JsonObject messageObject) {
        boolean bl = Intrinsics.areEqual((Object)messageObject.get("type").getAsString(), (Object)"Blame");
        String string = messageObject.get("descr").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
        return new MessageObject(bl, string, FlowJSErrorsParserKt.buildLocation(messageObject));
    }

    private static final Location buildLocation(JsonObject messageObject) {
        try {
            String string = messageObject.get("path").getAsString();
            if (string == null) {
                return null;
            }
            String filePath = string;
            JsonObject loc = messageObject.get("loc").getAsJsonObject();
            JsonObject start = loc.get("start").getAsJsonObject();
            JsonObject end = loc.get("end").getAsJsonObject();
            int line = start.get("line").getAsInt();
            int column = start.get("column").getAsInt();
            int lineEnd = end.get("line").getAsInt();
            int columnEnd = end.get("column").getAsInt() + 1;
            return new Location(filePath, line, column, lineEnd, columnEnd);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static final /* synthetic */ MessageObject access$buildMessageObject(JsonObject messageObject) {
        return FlowJSErrorsParserKt.buildMessageObject(messageObject);
    }
}

