/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.javascript.JSParameterInfoHandlerKt;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSRecursiveNodeVisitor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocParameterInfoPrinter;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationMappings;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptQuickNavigateBuilder
extends JSQuickNavigateBuilder {
    @Override
    @Nullable
    @NlsSafe
    public String getQuickNavigateInfoForNavigationElement(@NotNull PsiElement element, @NotNull PsiElement originalElement, boolean jsDoc) {
        if (element == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(1);
        }
        if (element instanceof TypeScriptModule) {
            String prefix = ((TypeScriptModule)element).isInternal() ? "namespace " : "module ";
            return this.createQuickNavigateForJSElement((TypeScriptModule)element, originalElement, prefix, JSQuickNavigateBuilder.ObjectKind.SIMPLE_DECLARATION, jsDoc);
        }
        if (element instanceof ES6ImportExportDeclarationPart) {
            ES6ImportExportDeclarationPart part = (ES6ImportExportDeclarationPart)element;
            JSQuickNavigateBuilder.ObjectKind kind = this.getKindForImport(part);
            return this.createQuickNavigateForJSElement(part, originalElement, jsDoc ? kind.toJSDocPrefix() : "", kind, jsDoc);
        }
        return super.getQuickNavigateInfoForNavigationElement(element, originalElement, jsDoc);
    }

    @NotNull
    protected JSQuickNavigateBuilder.ObjectKind getKindForImport(@NotNull ES6ImportExportDeclarationPart part) {
        if (part == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(2);
        }
        if (part instanceof ES6ImportSpecifier) {
            JSQuickNavigateBuilder.ObjectKind objectKind = JSQuickNavigateBuilder.ObjectKind.IMPORT_SPECIFIER;
            if (objectKind == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(3);
            }
            return objectKind;
        }
        if (part instanceof ES6ImportedBinding) {
            JSQuickNavigateBuilder.ObjectKind objectKind = ((ES6ImportedBinding)part).isNamespaceImport() ? JSQuickNavigateBuilder.ObjectKind.IMPORT_ALL : JSQuickNavigateBuilder.ObjectKind.IMPORT_DEFAULT;
            if (objectKind == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(4);
            }
            return objectKind;
        }
        if (part instanceof ES6ExportSpecifier || part instanceof ES6ExportedDefaultBinding) {
            JSQuickNavigateBuilder.ObjectKind objectKind = JSQuickNavigateBuilder.ObjectKind.EXPORT;
            if (objectKind == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(5);
            }
            return objectKind;
        }
        JSQuickNavigateBuilder.ObjectKind objectKind = JSQuickNavigateBuilder.ObjectKind.SIMPLE_DECLARATION;
        if (objectKind == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(6);
        }
        return objectKind;
    }

    @Override
    @NotNull
    protected JSQuickNavigateBuilder.ObjectKind getFieldOrVariableKind(@NotNull JSFieldVariable variableOrField) {
        if (variableOrField == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(7);
        }
        if (variableOrField instanceof JSField || variableOrField instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)variableOrField)) {
            JSQuickNavigateBuilder.ObjectKind objectKind = JSQuickNavigateBuilder.ObjectKind.PROPERTY;
            if (objectKind == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(8);
            }
            return objectKind;
        }
        JSQuickNavigateBuilder.ObjectKind objectKind = super.getFieldOrVariableKind(variableOrField);
        if (objectKind == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(9);
        }
        return objectKind;
    }

    @Override
    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutor(@NotNull JSElement candidate, @NotNull PsiElement originalElement) {
        if (candidate == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(10);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(11);
        }
        originalElement = JSDocumentationUtils.getOriginalElementOrParentIfLeaf(originalElement);
        boolean isSourceElement = JavaScriptQuickNavigateBuilder.isElementFromTSSources(candidate, originalElement);
        JSElement typeSubstitutorTarget = candidate;
        if (isSourceElement) {
            typeSubstitutorTarget = JavaScriptQuickNavigateBuilder.getOriginalResolvedElement(candidate, (JSReferenceExpression)originalElement);
        }
        JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getInstance().getTypeSubstitutorForMember(typeSubstitutorTarget, originalElement);
        if (jSTypeSubstitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(12);
        }
        return jSTypeSubstitutor;
    }

    private static boolean isElementFromTSSources(@NotNull JSElement member, @NotNull PsiElement originalElement) {
        if (member == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(13);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(14);
        }
        return originalElement instanceof JSReferenceExpression && Boolean.TRUE.equals(TypeScriptDeclarationMappings.SOURCE_FILE_MARKER.get((UserDataHolder)member));
    }

    @NotNull
    private static JSElement getOriginalResolvedElement(@NotNull JSElement member, @NotNull JSReferenceExpression originalElement) {
        ResolveResult[] results;
        List<PsiElement> resolvedElements;
        if (member == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(15);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(16);
        }
        if ((resolvedElements = JSResolveResult.toElements(results = originalElement.multiResolve(false))).size() != 1) {
            JSElement jSElement = member;
            if (jSElement == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(17);
            }
            return jSElement;
        }
        PsiElement candidate = (PsiElement)ContainerUtil.getFirstItem(resolvedElements);
        if (candidate instanceof JSElement) {
            member = (JSElement)candidate;
        }
        JSElement jSElement = member;
        if (jSElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(18);
        }
        return jSElement;
    }

    @Nullable
    protected static String getGenerics(@NotNull JSElement element, @NotNull JSTypeSubstitutor substitutor) {
        if (element == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(19);
        }
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(20);
        }
        if (!(element instanceof TypeScriptTypeParameterListOwner)) {
            return null;
        }
        TypeScriptTypeParameterListOwner owner = (TypeScriptTypeParameterListOwner)element;
        TypeScriptTypeParameterList list2 = owner.getTypeParameterList();
        if (list2 == null) {
            return null;
        }
        Object[] parameters = list2.getTypeParameters();
        if (parameters.length == 0) {
            return null;
        }
        StringBuilder newBuilder = new StringBuilder();
        newBuilder.append("<");
        newBuilder.append(StringUtil.join((Object[])parameters, el -> {
            JSTypeGenericId id;
            JSType type2;
            String name = el.getName();
            if (name == null) {
                name = "?";
            }
            return (type2 = substitutor.get(id = el.getGenericId())) == null ? name : type2.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        }, (String)","));
        newBuilder.append(">");
        return newBuilder.toString();
    }

    @Override
    protected void appendClassAttributes(@NotNull JSClass jsClass, @NotNull PsiElement originalElement, @Nullable String packageOrModule, @NotNull StringBuilder result2) {
        if (jsClass == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(21);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(22);
        }
        if (result2 == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(23);
        }
        boolean isAlias = jsClass instanceof TypeScriptTypeAlias;
        boolean isEnum = jsClass instanceof TypeScriptEnum;
        if (isAlias || isEnum) {
            this.appendAttrList(jsClass, result2);
            result2.append(isAlias ? "type " : "enum ");
        } else {
            super.appendClassAttributes(jsClass, originalElement, packageOrModule, result2);
        }
    }

    @Override
    @NotNull
    protected String getClassGenerics(@NotNull JSClass jsClass, @NotNull PsiElement originalElement) {
        JSTypeSubstitutor substitutor;
        String generics;
        if (jsClass == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(24);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(25);
        }
        if (jsClass instanceof TypeScriptTypeParameterListOwner && (generics = JavaScriptQuickNavigateBuilder.getGenerics(jsClass, substitutor = this.getTypeSubstitutor(jsClass, originalElement))) != null) {
            String string = generics;
            if (string == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(26);
            }
            return string;
        }
        return "";
    }

    @Override
    @NotNull
    protected String getVarPrefix(@NotNull JSVariable variable) {
        if (variable == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(27);
        }
        if (variable instanceof JSField || variable instanceof JSParameter) {
            return "";
        }
        String string = super.getVarPrefix(variable);
        if (string == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Override
    @Nullable
    protected PsiElement getParentContainer(@NotNull PsiNamedElement element) {
        JSParameter parameter;
        if (element == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(29);
        }
        if (element instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter(parameter = (JSParameter)element)) {
            return JSUtils.getMemberContainingClass((PsiElement)element);
        }
        return super.getParentContainer(element);
    }

    @Override
    protected String getParentInfo(@Nullable PsiElement parent, @NotNull PsiNamedElement element, @NotNull JSTypeSubstitutor substitutor) {
        TypeScriptModule module;
        TypeScriptInterfaceClass tsClass;
        String generics;
        PsiElement parentContainer;
        if (element == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(30);
        }
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(31);
        }
        if ((parentContainer = (PsiElement)ObjectUtils.coalesce((Object)this.getParentContainer(element), (Object)parent)) instanceof TypeScriptInterfaceClass && (generics = JavaScriptQuickNavigateBuilder.getGenerics(tsClass = (TypeScriptInterfaceClass)parentContainer, substitutor)) != null) {
            String className = StringUtil.notNullize((String)((JSClass)parentContainer).getQualifiedName(), (String)"default");
            return className + StringUtil.escapeXmlEntities((String)generics);
        }
        if (parentContainer instanceof TypeScriptModule && (module = (TypeScriptModule)parentContainer).isInternal()) {
            return module.getQualifiedName();
        }
        return super.getParentInfo(parentContainer, element, substitutor);
    }

    @Override
    @Nullable
    protected String formatVisibility(@NotNull JSAttributeListOwner owner, @NotNull JSAttributeList attributeList, @NotNull JSAttributeList.AccessType type2) {
        if (owner == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(32);
        }
        if (attributeList == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(33);
        }
        if (type2 == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(34);
        }
        if (type2 == JSAttributeList.AccessType.PUBLIC && attributeList.getExplicitAccessType() == null) {
            return null;
        }
        if (type2 == JSAttributeList.AccessType.PRIVATE && attributeList.hasPrivateSharp()) {
            return null;
        }
        return super.formatVisibility(owner, attributeList, type2);
    }

    @Override
    @NotNull
    protected Collection<JSDocParameterInfoPrinter> expandParameters(@NotNull JSFunctionItem functionItem, @NotNull Collection<? extends JSDocParameterInfoPrinter> parameters, @NotNull JSTypeSubstitutor substitutor) {
        if (functionItem == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(35);
        }
        if (parameters == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(36);
        }
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(37);
        }
        ArrayList<JSDocParameterInfoPrinter> result2 = new ArrayList<JSDocParameterInfoPrinter>();
        JSFunctionType functionType2 = JSParameterInfoHandlerKt.mapToFunction(functionItem, substitutor);
        List<JSParameterTypeDecorator> decorators = TypeScriptJSFunctionTypeImpl.expandRestTupleTypes(functionType2.getParameters(), -1);
        SmartList infos = new SmartList(parameters);
        for (int i = 0; i < decorators.size(); ++i) {
            JSParameterTypeDecorator decorator = decorators.get(i);
            if (infos.size() > i) {
                JSDocParameterInfoPrinter info2 = (JSDocParameterInfoPrinter)infos.get(i);
                JSParameterItem item = info2.getParameterItem();
                if (!info2.hasTypeElement() || item.getTypeDecorator().isEquivalentTo(decorator, null, true)) {
                    result2.add(info2);
                    continue;
                }
                result2.add(new JSDocParameterInfoPrinter(decorator));
                continue;
            }
            result2.add(new JSDocParameterInfoPrinter(decorator));
        }
        ArrayList<JSDocParameterInfoPrinter> arrayList = result2;
        if (arrayList == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected JSType getNarrowedType(@NotNull PsiElement originalElement, @NotNull JSTypeSubstitutor substitutor) {
        JSType narrowType;
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(39);
        }
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(40);
        }
        if ((originalElement = JSDocumentationUtils.getOriginalElementOrParentIfLeaf(originalElement)) instanceof JSReferenceExpression && JSTypeGuardChecker.isNarrowableReference((JSExpression)originalElement) && (narrowType = JSResolveUtil.getExpressionJSType((JSExpression)originalElement)) != null && (narrowType.isTypeScript() || !(narrowType instanceof JSRecordType))) {
            return this.getTypeWithAppliedSubstitutor(narrowType, substitutor);
        }
        return null;
    }

    @Override
    protected boolean isGuessedOptional(@NotNull JSElement variableLikeElement) {
        if (variableLikeElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(41);
        }
        if (variableLikeElement instanceof JSParameter && DialectDetector.isJavaScript((PsiElement)variableLikeElement) && ((JSParameter)variableLikeElement).getJSType() == null) {
            JSFunction function2 = ((JSParameter)variableLikeElement).getDeclaringFunction();
            String name = variableLikeElement.getName();
            if (function2 != null && name != null) {
                Set optionalCandidates = (Set)CachedValuesManager.getCachedValue((PsiElement)function2, () -> {
                    JSOptionalityEvaluator visitor = new JSOptionalityEvaluator();
                    visitor.visitElement(function2.getNode());
                    return new CachedValueProvider.Result(visitor.myOptionalCandidates, new Object[]{function2});
                });
                return optionalCandidates != null && optionalCandidates.contains(name);
            }
        }
        return super.isGuessedOptional(variableLikeElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8, 9, 12, 17, 18, 26, 28, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 16: 
            case 22: 
            case 25: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 26: 
            case 28: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JavaScriptQuickNavigateBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableOrField";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 20: 
            case 31: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeList";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableLikeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JavaScriptQuickNavigateBuilder";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindForImport";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldOrVariableKind";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutor";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalResolvedElement";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassGenerics";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarPrefix";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "expandParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfoForNavigationElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getKindForImport";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 26: 
            case 28: 
            case 38: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFieldOrVariableKind";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isElementFromTSSources";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalResolvedElement";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getGenerics";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "appendClassAttributes";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getClassGenerics";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getVarPrefix";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getParentContainer";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getParentInfo";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "formatVisibility";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "expandParameters";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getNarrowedType";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isGuessedOptional";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8, 9, 12, 17, 18, 26, 28, 38 -> new IllegalStateException(string);
        };
    }

    private static final class JSOptionalityEvaluator
    extends JSRecursiveNodeVisitor {
        private final Set<String> myOptionalCandidates = new HashSet<String>();

        private JSOptionalityEvaluator() {
        }

        @Override
        public void visitBinaryExpression(ASTNode node) {
            ASTNode child = node.findChildByType(JSTokenTypes.OROR);
            if (child != null) {
                this.addRef(node);
            } else {
                child = node.findChildByType(JSTokenTypes.ANDAND);
                if (child != null) {
                    this.addRef(node);
                } else {
                    ASTNode identifier;
                    ASTNode childByType = node.findChildByType(JSTokenTypes.EQUALITY_OPERATIONS);
                    if (childByType != null && (identifier = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET, childByType)) != null) {
                        if (identifier.findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                            this.addRef(node);
                        } else {
                            ASTNode firstIdentifier = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET);
                            if (firstIdentifier != null && firstIdentifier.findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                                this.addExpr(identifier);
                            }
                        }
                    }
                }
            }
            super.visitBinaryExpression(node);
        }

        @Override
        public void visitPrefixExpression(ASTNode node) {
            ASTNode child = node.findChildByType(JSTokenTypes.TYPEOF_KEYWORD);
            if (child == null) {
                child = node.findChildByType(JSTokenTypes.EXCL);
            }
            if (child != null) {
                this.addRef(node);
            }
            super.visitPrefixExpression(node);
        }

        @Override
        public void visitIfStatement(ASTNode node) {
            this.addRef(node);
            super.visitIfStatement(node);
        }

        @Override
        public void visitProperty(ASTNode node) {
            ASTNode expr;
            ASTNode name = JSPropertyImpl.findNameIdentifier(node);
            if (name != null && (expr = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET, name.getTreeNext())) != null && expr != name) {
                this.addExpr(expr);
            }
            super.visitProperty(node);
        }

        @Override
        public void visitArgumentList(ASTNode node) {
            ASTNode expr = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET);
            while (expr != null) {
                this.addExpr(expr);
                ASTNode treeNext = expr.getTreeNext();
                expr = treeNext != null ? node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET, treeNext) : null;
            }
            super.visitArgumentList(node);
        }

        private void addRef(ASTNode node) {
            ASTNode treeNext;
            ASTNode treeParent;
            ASTNode firstExpr = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET);
            this.addExpr(firstExpr);
            if (firstExpr != null && node.getElementType() == JSElementTypes.BINARY_EXPRESSION && (treeParent = node.getTreeParent()).getElementType() == JSElementTypes.BINARY_EXPRESSION && (treeNext = firstExpr.getTreeNext()) != null) {
                this.addExpr(node.findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS, treeNext));
            }
        }

        private void addExpr(ASTNode expr) {
            if (expr != null && expr.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && JSReferenceExpressionImpl.getQualifierNode(expr) == null) {
                ASTNode node = expr.getFirstChildNode();
                if (node == null) {
                    return;
                }
                if (node.getTreeNext() == null) {
                    String ref = node.getText();
                    this.myOptionalCandidates.add(ref);
                }
            }
        }

        @Override
        public boolean visitAsFunction(ASTNode function2) {
            return true;
        }

        @Override
        public void visitDocComment(ASTNode node) {
        }
    }
}

