/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypeEx;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.lookup.CommaTailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupContext;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSPipeExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeArgumentsOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6DecoratorDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentsListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.util.JSAsyncUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInsertHandler
implements InsertHandler<LookupElement> {
    private static final JSInsertHandler DEFAULT_INTERNAL;
    public static final InsertHandler<LookupElement> DEFAULT;
    public static final InsertHandler<LookupElement> DEFAULT_AS_INDEXER;
    public static final Key<Boolean> FORCED_COMPLETE_AS_FUNCTION;
    public static final Key<ForcedCompleteFunctionType> FORCED_COMPLETE_FUNCTION;
    public static final Key<TailType> FORCED_TAIL_TYPE;
    private final boolean myInsertAsIndexer;

    protected JSInsertHandler(boolean insertAsIndexer) {
        this.myInsertAsIndexer = insertAsIndexer;
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        if (context2 == null) {
            JSInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            JSInsertHandler.$$$reportNull$$$0(1);
        }
        this.handleInsertInternal(context2, context2.getEditor().getCaretModel().getCurrentCaret(), item);
    }

    private void handleInsertInternal(@NotNull InsertionContext context2, @NotNull Caret caret, @NotNull LookupElement item) {
        TailType tailType;
        if (context2 == null) {
            JSInsertHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            JSInsertHandler.$$$reportNull$$$0(3);
        }
        if (item == null) {
            JSInsertHandler.$$$reportNull$$$0(4);
        }
        if (context2.getCompletionChar() != '\r') {
            context2.setAddCompletionChar(false);
        }
        if (this.myInsertAsIndexer) {
            JSInsertHandler.insertAsIndexer(context2);
            PsiDocumentManager.getInstance((Project)context2.getProject()).commitDocument(context2.getEditor().getDocument());
        }
        if (context2.getCompletionChar() == '(') {
            tailType = TailTypeEx.SMART_LPARENTH;
        } else {
            tailType = LookupItem.getDefaultTailType((char)context2.getCompletionChar());
            TailType forcedTailType = (TailType)item.getUserData(FORCED_TAIL_TYPE);
            if (forcedTailType != null) {
                tailType = forcedTailType;
            }
            if (tailType == null) {
                tailType = TailTypes.noneType();
            }
        }
        tailType.processTail(context2.getEditor(), context2.getSelectionEndOffset());
        int offsetToImport = context2.getStartOffset();
        PsiElement elementAtOffset = context2.getFile().findElementAt(offsetToImport);
        PsiElement contextElement = elementAtOffset != null ? elementAtOffset.getParent().getParent() : null;
        boolean showParameterInfo = false;
        char completionChar = context2.getCompletionChar();
        AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)context2.getProject());
        if (tailType == TailTypes.dotType() || completionChar == '.' || (showParameterInfo = (tailType == CommaTailType.INSTANCE || completionChar == ',') && contextElement instanceof JSArgumentList)) {
            if (showParameterInfo) {
                autoPopupController.autoPopupParameterInfo(context2.getEditor(), null);
            } else {
                autoPopupController.autoPopupMemberLookup(context2.getEditor(), null);
            }
        }
        if (item.getLookupString().endsWith("()") || item.getLookupString().endsWith("[]")) {
            caret.moveCaretRelatively(-1, 0, false, true);
        } else {
            Object object;
            PsiElement itemPsiElement = item.getPsiElement();
            PsiElement element = itemPsiElement != null && itemPsiElement.isValid() ? itemPsiElement : null;
            boolean weAreNearCall = JSInsertHandler.weAreNearCall(context2.getFile().findElementAt(context2.getTailOffset()), completionChar);
            if (completionChar != '.' && completionChar != ',' && completionChar != ' ') {
                boolean forcedCompleteAsFunction;
                JSFunction constructor;
                PsiElement prevLeaf;
                SmartPsiElementPointer<JSFunctionItem> pointer2;
                JSLookupUtilImpl.JSLookupElementFunctionData possibleFunctionData;
                JSFunction functionInitializer;
                JSElement parent;
                if (element instanceof JSProperty && !((parent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, (Class[])new Class[]{JSObjectLiteralExpression.class, JSExpressionStatement.class, JSVariable.class})) instanceof JSObjectLiteralExpression) && (functionInitializer = ((JSProperty)element).tryGetFunctionInitializer()) != null && !JSResolveUtil.isFromPredefinedFile(functionInitializer.getContainingFile())) {
                    element = functionInitializer;
                }
                if ((possibleFunctionData = (JSLookupUtilImpl.JSLookupElementFunctionData)item.getUserData(JSLookupUtilImpl.POSSIBLE_FUNCTION_DATA_KEY)) == null && element != null) {
                    JSFunction possibleFunctionFast;
                    if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
                        JSLookupUtilImpl.getTypeAndTailTexts(item, element, new JSLookupContext((PsiElement)context2.getFile().getOriginalFile(), null));
                        possibleFunctionData = (JSLookupUtilImpl.JSLookupElementFunctionData)item.getUserData(JSLookupUtilImpl.POSSIBLE_FUNCTION_DATA_KEY);
                        if (possibleFunctionData == null) {
                            Logger.getInstance(JSInsertHandler.class).error("possibleFunctionData must be added in JSLookupUtilImpl.getTypeAndTailTexts");
                        }
                    } else {
                        Logger.getInstance(JSInsertHandler.class).warn("possibleFunctionData wasn't calculated");
                    }
                    if (possibleFunctionData == null && (possibleFunctionFast = JSPsiImplUtils.getPossibleFunction(element)) != null) {
                        possibleFunctionData = new JSLookupUtilImpl.JSLookupElementFunctionData(possibleFunctionFast, false, false);
                    }
                }
                if (possibleFunctionData == null) {
                    possibleFunctionData = JSLookupUtilImpl.JSLookupElementFunctionData.EMPTY;
                }
                JSFunctionItem possibleFun = (pointer2 = possibleFunctionData.possibleFunction) != null ? (JSFunctionItem)pointer2.getElement() : null;
                boolean atNew = false;
                if (elementAtOffset != null && JSKeywordSets.IDENTIFIER_NAMES.contains(elementAtOffset.getNode().getElementType()) && (prevLeaf = PsiTreeUtil.prevCodeLeaf((PsiElement)elementAtOffset)) != null && prevLeaf.getNode().getElementType() == JSTokenTypes.NEW_KEYWORD) {
                    atNew = true;
                }
                if (element instanceof JSClass && atNew && (constructor = ((JSClass)element).getConstructor()) != null) {
                    possibleFun = constructor;
                }
                if (JSInsertHandler.needGenerics(contextElement, element, context2.getTailOffset())) {
                    JSInsertHandler.insertGenericType(context2, (TypeScriptTypeParameterListOwner)element, (JSTypeArgumentsOwner)contextElement);
                }
                ForcedCompleteFunctionType forcedCompleteFunctionType = (ForcedCompleteFunctionType)((Object)item.getUserData(FORCED_COMPLETE_FUNCTION));
                boolean bl = forcedCompleteAsFunction = item.getUserData(FORCED_COMPLETE_AS_FUNCTION) == Boolean.TRUE;
                if (possibleFun != null && !possibleFun.isGetProperty() && !possibleFun.isSetProperty() || forcedCompleteFunctionType != null || forcedCompleteAsFunction) {
                    int offset = caret.getOffset();
                    boolean completingWithLParen = completionChar == '(';
                    boolean needParens = true;
                    if (!completingWithLParen) {
                        boolean bl2 = needParens = EditorSettingsExternalizable.getInstance().isInsertParenthesesAutomatically() && JSInsertHandler.needParensByContext(elementAtOffset, offset) && JSInsertHandler.needsParensByElement(contextElement, element, possibleFun, possibleFunctionData, forcedCompleteAsFunction);
                        if (needParens && !weAreNearCall) {
                            JSInsertHandler.insertParens(context2, caret);
                        }
                    }
                    boolean shiftInsideParens = false;
                    if (needParens) {
                        if (possibleFun != null) {
                            shiftInsideParens = possibleFunctionData.hasOtherNonEmptySignature || possibleFun.getParameters().length > 0 || possibleFun.isReferencesArguments();
                        } else {
                            boolean bl3 = shiftInsideParens = forcedCompleteFunctionType == ForcedCompleteFunctionType.WITH_PARAMETERS;
                        }
                    }
                    if (completingWithLParen) {
                        if (shiftInsideParens) {
                            autoPopupController.autoPopupParameterInfo(context2.getEditor(), (PsiElement)possibleFun);
                        } else {
                            caret.moveToOffset(offset + 1);
                        }
                    } else if (shiftInsideParens) {
                        caret.moveToOffset(offset + 1);
                        autoPopupController.autoPopupParameterInfo(context2.getEditor(), (PsiElement)possibleFun);
                    } else {
                        caret.moveToOffset(offset + (needParens ? 2 : 0));
                    }
                    if (shiftInsideParens) {
                        TabOutScopesTracker.getInstance().registerEmptyScopeAtCaret(context2.getEditor());
                    }
                } else if (element instanceof JSProperty) {
                    PsiElement grandParent;
                    int offset = caret.getOffset();
                    PsiElement psiElement = context2.getFile().findElementAt(offset - 1);
                    if (psiElement != null && JSKeywordSets.IDENTIFIER_NAMES.contains(psiElement.getNode().getElementType()) && psiElement.getParent() instanceof JSReferenceExpression && (grandParent = psiElement.getParent().getParent()) instanceof ES6Property && ((ES6Property)grandParent).isShorthanded()) {
                        JSCodeStyleSettings settings2 = JSCodeStyleSettings.getSettings(element);
                        String beforeColon = settings2.SPACE_BEFORE_PROPERTY_COLON ? " " : "";
                        String afterColon = settings2.SPACE_AFTER_PROPERTY_COLON ? " " : "";
                        String toInsert = beforeColon + ":" + afterColon;
                        context2.getEditor().getDocument().insertString(offset, (CharSequence)toInsert);
                        caret.moveToOffset(offset + toInsert.length());
                    }
                } else if (element instanceof JSClass && atNew && !weAreNearCall && completionChar != '(' && EditorSettingsExternalizable.getInstance().isInsertParenthesesAutomatically()) {
                    int offset = caret.getOffset();
                    JSInsertHandler.insertParens(context2, caret);
                    caret.moveToOffset(offset + 2);
                }
            }
            PsiDocumentManager.getInstance((Project)context2.getProject()).commitAllDocuments();
            if (elementAtOffset != null && !elementAtOffset.isValid()) {
                elementAtOffset = context2.getFile().findElementAt(offsetToImport);
            }
            if ((elementAtOffset = JSInsertHandler.addActionScriptImport(context2, offsetToImport, elementAtOffset, element)) != null && elementAtOffset.getNode().getElementType() == JSDocTokenTypes.DOC_TAG_NAME && ("return".equals(object = item.getObject()) || "returns".equals(object))) {
                JSDocumentationProvider.setReturnTag((String)object);
            }
        }
    }

    private static boolean needsParensByElement(PsiElement contextElement, PsiElement element, JSFunctionItem possibleFun, JSLookupUtilImpl.JSLookupElementFunctionData possibleFunctionData, Boolean forcedCompleteAsFunction) {
        TypeScriptTypeArgumentList list2;
        if (possibleFun != null && !(contextElement instanceof JSNewExpression) && JSSymbolUtil.isConstructorSymbol(possibleFun)) {
            return false;
        }
        if (possibleFun instanceof ES6DecoratorDeclaration && possibleFun.getParameters().length == 0) {
            return false;
        }
        if (contextElement instanceof JSTypeArgumentsOwner && (list2 = (TypeScriptTypeArgumentList)PsiTreeUtil.getStubChildOfType((PsiElement)contextElement, TypeScriptTypeArgumentList.class)) != null) {
            return false;
        }
        return possibleFun == null || contextElement instanceof JSNewExpression || !DialectDetector.isTypeScript(element) || !possibleFunctionData.hasProperty || forcedCompleteAsFunction != false;
    }

    private static boolean needGenerics(@Nullable PsiElement contextElement, @Nullable PsiElement element, int offset) {
        TypeScriptTypeParameter[] parameters;
        if (contextElement == null || element == null) {
            return false;
        }
        if (!DialectDetector.isTypeScript(contextElement)) {
            return false;
        }
        if (!(element instanceof TypeScriptTypeParameterListOwner)) {
            return false;
        }
        TypeScriptTypeParameterListOwner listOwner = (TypeScriptTypeParameterListOwner)element;
        if (!(contextElement instanceof JSTypeArgumentsOwner) || contextElement instanceof JSCallExpression) {
            return false;
        }
        if (contextElement instanceof TypeScriptTypeArgumentsListOwner && ((TypeScriptTypeArgumentsListOwner)contextElement).getTypeArgumentList() != null) {
            return false;
        }
        if (JSInsertHandler.isFollowedBySomethingNoBreak(contextElement, offset)) {
            return false;
        }
        for (TypeScriptTypeParameter parameter : parameters = listOwner.getTypeParameters()) {
            if (parameter.getDefault() != null) continue;
            return true;
        }
        return false;
    }

    private static boolean isFollowedBySomethingNoBreak(@NotNull PsiElement contextElement, int offset) {
        if (contextElement == null) {
            JSInsertHandler.$$$reportNull$$$0(5);
        }
        if (contextElement instanceof TypeScriptSingleType && contextElement.getTextRange().contains(offset)) {
            return true;
        }
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)contextElement);
        if (nextLeaf instanceof PsiErrorElement) {
            nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
        }
        if (nextLeaf instanceof PsiWhiteSpace) {
            PsiElement psiElement = nextLeaf = nextLeaf.getText().contains("\n") ? null : PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
        }
        if (nextLeaf instanceof JSAttributeList && StringUtil.isEmpty((String)nextLeaf.getText())) {
            nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
        }
        return PsiUtilCore.getElementType((PsiElement)nextLeaf) == JSTokenTypes.IDENTIFIER;
    }

    @Nullable
    private static PsiElement addActionScriptImport(@NotNull InsertionContext context2, int offsetToImport, @Nullable PsiElement elementAtOffset, @Nullable PsiElement element) {
        if (context2 == null) {
            JSInsertHandler.$$$reportNull$$$0(6);
        }
        if (elementAtOffset == null || element == null || !DialectDetector.isActionScript(element)) {
            return elementAtOffset;
        }
        PsiElement elementForQNameImport = element;
        String qNameToImport = null;
        JSReferenceExpression contextExpr = (JSReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, JSReferenceExpression.class);
        if (elementForQNameImport instanceof JSAttributeListOwner) {
            JSClass contextClass;
            JSClass clazz;
            JSAttributeList attributeList = ((JSAttributeListOwner)elementForQNameImport).getAttributeList();
            if (elementForQNameImport instanceof JSVariable && attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && (clazz = JSUtils.getMemberContainingClass(elementForQNameImport)) != null && ((contextClass = JSResolveUtil.getClassOfContext(elementAtOffset)) == null || !JSInheritanceUtil.isParentClass(contextClass, clazz, false))) {
                elementForQNameImport = clazz;
                offsetToImport = (contextExpr = JSInsertHandler.updateContextExpr(contextExpr)) != null ? contextExpr.getTextRange().getStartOffset() : 0;
            }
            String qName = ((JSQualifiedNamedElement)elementForQNameImport).getQualifiedName();
            if (contextExpr != null && qName != null && StringUtil.isNotEmpty((String)StringUtil.getPackageName((String)qName))) {
                qNameToImport = qName;
            }
        }
        if (qNameToImport != null) {
            PsiDocumentManager.getInstance((Project)context2.getProject()).commitDocument(context2.getEditor().getDocument());
            elementAtOffset = context2.getFile().findElementAt(offsetToImport);
            if (elementAtOffset != null) {
                ImportUtils.doImport(elementAtOffset, qNameToImport, true);
            }
        }
        return elementAtOffset;
    }

    protected static boolean needParensByContext(PsiElement elementAtOffset, int offset) {
        Boolean hasFunctionType;
        PsiElement grandParentElementAtOffset;
        PsiElement parentElementAtOffset = elementAtOffset != null ? elementAtOffset.getParent() : null;
        PsiElement psiElement = grandParentElementAtOffset = parentElementAtOffset != null ? parentElementAtOffset.getParent() : null;
        if (grandParentElementAtOffset instanceof JSPipeExpression && ((JSPipeExpression)grandParentElementAtOffset).getMethodExpression() == parentElementAtOffset) {
            return false;
        }
        if (grandParentElementAtOffset instanceof JSBinaryExpression && ((JSBinaryExpression)grandParentElementAtOffset).getOperationSign() == JSTokenTypes.INSTANCEOF_KEYWORD && parentElementAtOffset == ((JSBinaryExpression)grandParentElementAtOffset).getROperand() || (grandParentElementAtOffset instanceof JSVariable || grandParentElementAtOffset instanceof JSFunction) && parentElementAtOffset.getPrevSibling() != null && parentElementAtOffset.getPrevSibling().getNode().getElementType() == JSTokenTypes.COLON || grandParentElementAtOffset instanceof JSImportStatement || parentElementAtOffset instanceof JSDocTagType || parentElementAtOffset instanceof JSAttributeNameValuePair || parentElementAtOffset instanceof PsiComment) {
            return false;
        }
        if (parentElementAtOffset instanceof JSExpression && !(grandParentElementAtOffset instanceof JSAssignmentExpression) && Boolean.TRUE.equals(hasFunctionType = (Boolean)JSAsyncUtils.runWithTimeout(200L, () -> {
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parentElementAtOffset);
            return JSTypeUtils.getFunctionType(expectedType, false, elementAtOffset).anyMatch(el -> !JSTypeCastUtil.isAlwaysAssignableType(el, parentElementAtOffset));
        }))) {
            return false;
        }
        if (parentElementAtOffset instanceof JSReferenceExpression && grandParentElementAtOffset instanceof ES6Property && ((ES6Property)grandParentElementAtOffset).getNameIdentifier() == parentElementAtOffset) {
            return false;
        }
        if (parentElementAtOffset instanceof JSVariable && grandParentElementAtOffset instanceof JSDestructuringShorthandedProperty) {
            return false;
        }
        if (parentElementAtOffset instanceof JSReferenceExpression) {
            return true;
        }
        if (parentElementAtOffset instanceof JSLiteralExpression && grandParentElementAtOffset instanceof JSIndexedPropertyAccessExpression) {
            return offset != -1 && offset > elementAtOffset.getTextRange().getEndOffset() && ((JSLiteralExpression)parentElementAtOffset).isQuotedLiteral();
        }
        return false;
    }

    private static void insertGenericType(@NotNull InsertionContext insertionContext, @NotNull TypeScriptTypeParameterListOwner resolveElement, @NotNull JSTypeArgumentsOwner place) {
        TypeScriptTypeParameterList list2;
        if (insertionContext == null) {
            JSInsertHandler.$$$reportNull$$$0(7);
        }
        if (resolveElement == null) {
            JSInsertHandler.$$$reportNull$$$0(8);
        }
        if (place == null) {
            JSInsertHandler.$$$reportNull$$$0(9);
        }
        if ((list2 = resolveElement.getTypeParameterList()) == null) {
            return;
        }
        Project project = insertionContext.getProject();
        Editor editor = insertionContext.getEditor();
        JSCompletionUtil.createAndStartAddGenericsTemplate(project, editor, place, list2);
    }

    public static boolean weAreNearCall(PsiElement elementAt, char ch) {
        if (elementAt != null) {
            if (ch == '\t') {
                if (JSInsertHandler.isIdentifier(elementAt)) {
                    elementAt = PsiTreeUtil.nextLeaf((PsiElement)elementAt);
                }
                if (elementAt instanceof PsiWhiteSpace && !elementAt.textContains('\n')) {
                    elementAt = PsiTreeUtil.nextLeaf((PsiElement)elementAt);
                }
            }
            return elementAt != null && elementAt.getText().equals("(");
        }
        return false;
    }

    @Contract(value="null -> false")
    private static boolean isIdentifier(@Nullable PsiElement elementAt) {
        if (elementAt == null) {
            return false;
        }
        ASTNode node = elementAt.getNode();
        return node != null && JSKeywordSets.IDENTIFIER_TOKENS_SET.contains(node.getElementType());
    }

    @NotNull
    public static <T extends LookupElement> InsertHandler<T> insertBracesIfNeeded(@NotNull PsiElement element, @Nullable PsiElement place) {
        if (element == null) {
            JSInsertHandler.$$$reportNull$$$0(10);
        }
        InsertHandler insertHandler = (context2, item) -> JSInsertHandler.insertBracesIfNeeded(context2, element, place);
        if (insertHandler == null) {
            JSInsertHandler.$$$reportNull$$$0(11);
        }
        return insertHandler;
    }

    public static void insertBracesIfNeeded(@NotNull InsertionContext insertionContext, @NotNull PsiElement element, @Nullable PsiElement place) {
        if (insertionContext == null) {
            JSInsertHandler.$$$reportNull$$$0(12);
        }
        if (element == null) {
            JSInsertHandler.$$$reportNull$$$0(13);
        }
        if (!JSInsertHandler.isAcceptablePlace(element, place)) {
            return;
        }
        JSFunction function2 = null;
        if (element instanceof JSFunction) {
            if (((JSFunction)element).isGetProperty()) {
                return;
            }
            function2 = (JSFunction)element;
        }
        if (element instanceof JSClass) {
            function2 = ((JSClass)element).getConstructor();
        }
        JSInsertHandler.insertBracesIfNeeded(insertionContext, function2 == null || function2.getParameters().length == 0 ? 2 : 1);
    }

    public static boolean isAcceptablePlace(@NotNull PsiElement element, @Nullable PsiElement place) {
        if (element == null) {
            JSInsertHandler.$$$reportNull$$$0(14);
        }
        if (element instanceof JSFunction) {
            return true;
        }
        return element instanceof JSClass && place instanceof JSReferenceExpression && place.getParent() instanceof JSNewExpression;
    }

    public static void insertBracesIfNeeded(@NotNull InsertionContext context2, int toMoveCaret) {
        if (context2 == null) {
            JSInsertHandler.$$$reportNull$$$0(15);
        }
        char completionChar = context2.getCompletionChar();
        if (!JSInsertHandler.weAreNearCall(context2.getFile().findElementAt(context2.getTailOffset()), completionChar) && EditorSettingsExternalizable.getInstance().isInsertParenthesesAutomatically() && completionChar != '(') {
            JSInsertHandler.insertParens(context2);
            context2.getEditor().getCaretModel().moveToOffset(context2.getEditor().getCaretModel().getOffset() + toMoveCaret);
            if (toMoveCaret == 1) {
                TabOutScopesTracker.getInstance().registerEmptyScopeAtCaret(context2.getEditor());
            }
        }
    }

    public static void insertParens(@NotNull InsertionContext context2) {
        if (context2 == null) {
            JSInsertHandler.$$$reportNull$$$0(16);
        }
        JSInsertHandler.insertParens(context2, context2.getEditor().getCaretModel().getCurrentCaret());
    }

    private static void insertParens(@NotNull InsertionContext context2, @NotNull Caret caret) {
        if (context2 == null) {
            JSInsertHandler.$$$reportNull$$$0(17);
        }
        if (caret == null) {
            JSInsertHandler.$$$reportNull$$$0(18);
        }
        char completionChar = context2.getCompletionChar();
        int offset = caret.getOffset();
        int diff = completionChar == '\n' || completionChar == '\t' || completionChar == '\r' || completionChar == '\u0000' ? 0 : 1;
        boolean shouldInsertRPar = completionChar != '\r';
        String text2 = shouldInsertRPar ? "()" : "(";
        context2.getEditor().getDocument().insertString(offset - diff, (CharSequence)text2);
    }

    private static JSReferenceExpression updateContextExpr(JSReferenceExpression contextExpr) {
        JSExpression contextExprParent;
        JSExpression jSExpression = contextExprParent = contextExpr != null ? contextExpr.getQualifier() : null;
        if (contextExprParent instanceof JSReferenceExpression) {
            contextExpr = (JSReferenceExpression)contextExprParent;
        }
        return contextExpr;
    }

    public static boolean isIndexer(@NotNull String name) {
        if (name == null) {
            JSInsertHandler.$$$reportNull$$$0(19);
        }
        return !JSSymbolUtil.isValidPropertyName(name);
    }

    private static void insertAsIndexer(@NotNull InsertionContext context2) {
        if (context2 == null) {
            JSInsertHandler.$$$reportNull$$$0(20);
        }
        Editor editor = context2.getEditor();
        PsiDocumentManager.getInstance((Project)context2.getProject()).commitDocument(editor.getDocument());
        PsiElement el = context2.getFile().findElementAt(editor.getCaretModel().getOffset() - 1);
        if (el == null) {
            return;
        }
        ASTNode node = el.getNode();
        if (node.getElementType() == JSTokenTypes.RBRACKET) {
            int offset;
            JSExpression index;
            PsiElement parent = el.getParent();
            if (parent instanceof JSIndexedPropertyAccessExpression && (index = ((JSIndexedPropertyAccessExpression)parent).getIndexExpression()) != null && ((offset = index.getTextOffset()) - 3 < 0 || !editor.getDocument().getText(new TextRange(offset - 3, offset - 2)).equals("?"))) {
                editor.getDocument().deleteString(offset - 2, offset - 1);
            }
        } else {
            String beforeDot;
            TextRange range = el.getTextRange();
            int startDotOffset = range.getStartOffset() - 1;
            int endDotOffset = range.getStartOffset();
            Document document2 = editor.getDocument();
            String text2 = endDotOffset > startDotOffset ? document2.getText(new TextRange(startDotOffset, endDotOffset)) : "";
            String string = beforeDot = startDotOffset > 1 ? document2.getText(new TextRange(startDotOffset - 1, startDotOffset)) : "";
            if (!".".equals(text2) && node.getElementType() == JSTokenTypes.NUMERIC_LITERAL && node.getText().startsWith(".")) {
                startDotOffset = range.getStartOffset();
                endDotOffset = range.getStartOffset() + 1;
            }
            int offset = range.getEndOffset();
            if (!"?".equals(beforeDot)) {
                editor.getDocument().replaceString(startDotOffset, endDotOffset, (CharSequence)"[");
            } else {
                editor.getDocument().insertString(endDotOffset, (CharSequence)"[");
                ++offset;
            }
            editor.getDocument().insertString(offset, (CharSequence)"]");
            editor.getCaretModel().moveToOffset(offset + 1);
        }
    }

    static void handleInsertForAllCarets(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        if (context2 == null) {
            JSInsertHandler.$$$reportNull$$$0(21);
        }
        if (item == null) {
            JSInsertHandler.$$$reportNull$$$0(22);
        }
        for (Caret caret : context2.getEditor().getCaretModel().getAllCarets()) {
            DEFAULT_INTERNAL.handleInsertInternal(context2, caret, item);
        }
    }

    static {
        DEFAULT = DEFAULT_INTERNAL = new JSInsertHandler(false);
        DEFAULT_AS_INDEXER = new JSInsertHandler(true);
        FORCED_COMPLETE_AS_FUNCTION = Key.create((String)"js.forced.complete.as.function");
        FORCED_COMPLETE_FUNCTION = Key.create((String)"js.forced.complete.function");
        FORCED_TAIL_TYPE = Key.create((String)"forced.tail.type");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertionContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSInsertHandler";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSInsertHandler";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "insertBracesIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleInsertInternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFollowedBySomethingNoBreak";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addActionScriptImport";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "insertGenericType";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "insertBracesIfNeeded";
                break;
            }
            case 11: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptablePlace";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "insertParens";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isIndexer";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "insertAsIndexer";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "handleInsertForAllCarets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }

    public static enum ForcedCompleteFunctionType {
        WITH_PARAMETERS,
        EMPTY_PARAMETERS;

    }
}

