/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtExecutor {
    private final Project myProject;
    private final JsbtService myService;
    private final JsbtTaskSet myTaskSet;

    public JsbtExecutor(@NotNull Project project, @NotNull JsbtService service2, @NotNull JsbtTaskSet taskSet) {
        if (project == null) {
            JsbtExecutor.$$$reportNull$$$0(0);
        }
        if (service2 == null) {
            JsbtExecutor.$$$reportNull$$$0(1);
        }
        if (taskSet == null) {
            JsbtExecutor.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myService = service2;
        this.myTaskSet = taskSet;
    }

    public void run() {
        this.execute(DefaultRunExecutor.getRunExecutorInstance());
    }

    public void editSettings() {
        RunEntry runEntry = this.findOrCreateRunEntry();
        RunnerAndConfigurationSettings settings2 = runEntry.getSettings();
        boolean ok = RunDialog.editConfiguration((Project)this.myProject, (RunnerAndConfigurationSettings)settings2, (String)JavaScriptBundle.message("dialog.title.edit.run.debug.configuration", settings2.getName()));
        if (ok) {
            RunManager runManager = RunManager.getInstance((Project)this.myProject);
            if (!runEntry.isExisting()) {
                runManager.addConfiguration(settings2);
            }
            runManager.setSelectedConfiguration(settings2);
        }
    }

    void execute(@NotNull Executor executor) {
        ExecutionEnvironmentBuilder builder2;
        if (executor == null) {
            JsbtExecutor.$$$reportNull$$$0(3);
        }
        RunEntry runEntry = this.findOrCreateRunEntry();
        RunnerAndConfigurationSettings settings2 = runEntry.getSettings();
        if (!runEntry.isExisting()) {
            settings2.setTemporary(true);
            RunManager.getInstance((Project)this.myProject).addConfiguration(settings2);
        }
        if ((builder2 = ExecutionEnvironmentBuilder.createOrNull((Executor)executor, (RunnerAndConfigurationSettings)settings2)) != null) {
            ExecutionManager.getInstance((Project)this.myProject).restartRunProfile(builder2.build());
        }
    }

    @NotNull
    private RunEntry findOrCreateRunEntry() {
        boolean existing;
        RunnerAndConfigurationSettings settings2 = this.findExistingConfiguration();
        boolean bl = existing = settings2 != null;
        if (settings2 == null) {
            RunManager runManager = RunManager.getInstance((Project)this.myProject);
            settings2 = runManager.createConfiguration("", this.myService.getConfigurationFactory());
            RunConfiguration rcFromTemplate = settings2.getConfiguration();
            this.myService.setupRunConfiguration(rcFromTemplate, this.myTaskSet);
            runManager.setUniqueNameIfNeeded(settings2);
        }
        return new RunEntry(settings2, existing);
    }

    @Nullable
    private RunnerAndConfigurationSettings findExistingConfiguration() {
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        List configurations = runManager.getConfigurationSettingsList(this.myService.getConfigurationFactory().getType());
        for (RunnerAndConfigurationSettings configurationSettings : configurations) {
            RunConfiguration configuration = configurationSettings.getConfiguration();
            if (!this.myService.isConfigurationMatched(configuration, this.myTaskSet)) continue;
            return configurationSettings;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RunEntry {
        private final RunnerAndConfigurationSettings mySettings;
        private final boolean myExisting;

        RunEntry(@NotNull RunnerAndConfigurationSettings settings2, boolean existing) {
            if (settings2 == null) {
                RunEntry.$$$reportNull$$$0(0);
            }
            this.mySettings = settings2;
            this.myExisting = existing;
        }

        @NotNull
        public RunnerAndConfigurationSettings getSettings() {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.mySettings;
            if (runnerAndConfigurationSettings == null) {
                RunEntry.$$$reportNull$$$0(1);
            }
            return runnerAndConfigurationSettings;
        }

        public boolean isExisting() {
            return this.myExisting;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtExecutor$RunEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtExecutor$RunEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

