/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ecmascript6.psi.impl.JSCrossLocalPackageImports;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.config.JSFileImports;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.lang.javascript.config.JSImportSimpleResolveContextImpl;
import com.intellij.lang.javascript.config.graph.JSImportGraph;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSFileImportsResolverImpl;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeIndex;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/ecmascript6/psi/impl/JSCrossLocalPackageImports;", "Lcom/intellij/lang/javascript/config/JSFileImports;", "project", "Lcom/intellij/openapi/project/Project;", "rootDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "resolver", "Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSFileImportsResolverImpl;", "getOutFiles", "", "file", "getRootFiles", "resolveFile", "moduleName", "", "containingFile", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSCrossLocalPackageImports.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSCrossLocalPackageImports.kt\ncom/intellij/lang/ecmascript6/psi/impl/JSCrossLocalPackageImports\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,96:1\n37#2,2:97\n*S KotlinDebug\n*F\n+ 1 JSCrossLocalPackageImports.kt\ncom/intellij/lang/ecmascript6/psi/impl/JSCrossLocalPackageImports\n*L\n65#1:97,2\n*E\n"})
public final class JSCrossLocalPackageImports
implements JSFileImports {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile rootDirectory;
    @NotNull
    private final JSFileImportsResolverImpl resolver;

    public JSCrossLocalPackageImports(@NotNull Project project, @NotNull VirtualFile rootDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        this.project = project;
        this.rootDirectory = rootDirectory;
        JSImportResolveContext jSImportResolveContext = new JSImportSimpleResolveContextImpl(this.rootDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)JSFileReferencesUtil.IMPLICIT_EXTENSIONS, (String)"IMPLICIT_EXTENSIONS");
        this.resolver = new JSFileImportsResolverImpl(this.project, jSImportResolveContext, JSFileReferencesUtil.IMPLICIT_EXTENSIONS);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRootFiles() {
        Set<FileType> set = JavaScriptIndex.getFileTypesToIndexJS();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getFileTypesToIndexJS(...)");
        Set<FileType> fileTypes = set;
        Collection $this$toTypedArray$iv = fileTypes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FileType[] fileTypeArray = thisCollection$iv.toArray(new FileType[0]);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.project), (FileType[])Arrays.copyOf(fileTypeArray, fileTypeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getScopeRestrictedByFileTypes(...)");
        GlobalSearchScope parentScope = globalSearchScope;
        DelegatingGlobalSearchScope scope2 = new DelegatingGlobalSearchScope(parentScope, this){
            final /* synthetic */ JSCrossLocalPackageImports this$0;
            {
                this.this$0 = $receiver;
                super($parentScope);
            }

            public boolean contains(@NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return VfsUtil.isAncestor((VirtualFile)JSCrossLocalPackageImports.access$getRootDirectory$p(this.this$0), (VirtualFile)file, (boolean)true) && !JSLibraryUtil.isProbableLibraryFile(file) && super.contains(file);
            }
        };
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        for (FileType type2 : fileTypes) {
            ProgressManager.checkCanceled();
            FileTypeIndex.processFiles((FileType)type2, (Processor)((Processor)processor), (GlobalSearchScope)((GlobalSearchScope)scope2));
        }
        Collection collection = processor.getResults();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getResults(...)");
        return CollectionsKt.toSet((Iterable)collection);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getOutFiles(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List list2 = FileIncludeIndex.getIncludes((VirtualFile)file, (Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getIncludes(...)");
        return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)getOutFiles.1.INSTANCE), (Function1)getOutFiles.2.INSTANCE), (Function1)((Function1)new Function1<String, VirtualFile>(this, file){
            final /* synthetic */ JSCrossLocalPackageImports this$0;
            final /* synthetic */ VirtualFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(1);
            }

            @Nullable
            public final VirtualFile invoke(String it) {
                Intrinsics.checkNotNull((Object)it);
                return this.this$0.resolveFile(it, this.$file);
            }
        })));
    }

    @Override
    @Nullable
    public VirtualFile resolveFile(@NotNull String moduleName, @NotNull VirtualFile containingFile2) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)containingFile2, (String)"containingFile");
        return this.resolver.resolveFileModule(moduleName, containingFile2);
    }

    public static final /* synthetic */ VirtualFile access$getRootDirectory$p(JSCrossLocalPackageImports $this) {
        return $this.rootDirectory;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/ecmascript6/psi/impl/JSCrossLocalPackageImports$Companion;", "", "()V", "calculateRelatedRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "rootDirectory", "detectRelatedRoots", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nJSCrossLocalPackageImports.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSCrossLocalPackageImports.kt\ncom/intellij/lang/ecmascript6/psi/impl/JSCrossLocalPackageImports$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1855#2:97\n1856#2:99\n1#3:98\n*S KotlinDebug\n*F\n+ 1 JSCrossLocalPackageImports.kt\ncom/intellij/lang/ecmascript6/psi/impl/JSCrossLocalPackageImports$Companion\n*L\n45#1:97\n45#1:99\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<VirtualFile> detectRelatedRoots(@NotNull Project project, @NotNull VirtualFile rootDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
            PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(rootDirectory);
            if (psiDirectory == null) {
                return SetsKt.emptySet();
            }
            PsiDirectory psi = psiDirectory;
            Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)psi), () -> Companion.detectRelatedRoots$lambda$0(project, psi));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            return (Set)object;
        }

        private final Set<VirtualFile> calculateRelatedRoots(Project project, VirtualFile rootDirectory) {
            JSCrossLocalPackageImports packageImports = new JSCrossLocalPackageImports(project, rootDirectory);
            Set relatedRoots = new LinkedHashSet();
            Collection collection = new JSImportGraph(packageImports).initialize().getNodes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getNodes(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            block0: for (Object element$iv : $this$forEach$iv) {
                VirtualFile it;
                VirtualFile file = (VirtualFile)element$iv;
                boolean bl = false;
                ProgressManager.checkCanceled();
                for (VirtualFile root : relatedRoots) {
                    if (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true)) continue;
                    continue block0;
                }
                if (NodeModuleUtil.findMainModuleRoot(project, file) == null) continue;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                relatedRoots.add(it);
            }
            return relatedRoots;
        }

        private static final CachedValueProvider.Result detectRelatedRoots$lambda$0(Project $project, PsiDirectory $psi) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$psi, (String)"$psi");
            VirtualFile virtualFile = $psi.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            Set<VirtualFile> roots = Companion.calculateRelatedRoots($project, virtualFile);
            Object[] objectArray = new Object[]{JSTypeUtils.getTypeInvalidationDependency()};
            return CachedValueProvider.Result.create(roots, (Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

