/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.webSymbols.symbols;

import com.intellij.javascript.webSymbols.symbols.JSPropertySymbolKt;
import com.intellij.javascript.webSymbols.symbols.JSWebSymbolBase;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.model.Pointer;
import com.intellij.psi.PsiElement;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.js.WebSymbolJsKind;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0017\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0003\u001a\u00020\n\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bB\u0017\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fB3\b\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00000\u001eH\u0016R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\u00060\tj\u0002`\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lcom/intellij/javascript/webSymbols/symbols/JSPropertySymbol;", "Lcom/intellij/javascript/webSymbols/symbols/JSWebSymbolBase;", "Lcom/intellij/lang/javascript/psi/JSElement;", "member", "Lcom/intellij/lang/javascript/psi/JSRecordType$PropertySignature;", "jsPropertySymbolProvider", "Lcom/intellij/webSymbols/WebSymbol;", "(Lcom/intellij/lang/javascript/psi/JSRecordType$PropertySignature;Lcom/intellij/webSymbols/WebSymbol;)V", "name", "", "Lcom/intellij/lang/javascript/psi/JSRecordType$IndexSignature;", "(Ljava/lang/String;Lcom/intellij/lang/javascript/psi/JSRecordType$IndexSignature;Lcom/intellij/webSymbols/WebSymbol;)V", "(Ljava/lang/String;Lcom/intellij/webSymbols/WebSymbol;)V", "type", "Lcom/intellij/lang/javascript/psi/JSType;", "typeMember", "Lcom/intellij/lang/javascript/psi/JSRecordType$TypeMember;", "jsKind", "Lcom/intellij/webSymbols/js/WebSymbolJsKind;", "(Ljava/lang/String;Lcom/intellij/lang/javascript/psi/JSType;Lcom/intellij/lang/javascript/psi/JSRecordType$TypeMember;Lcom/intellij/webSymbols/WebSymbol;Lcom/intellij/webSymbols/js/WebSymbolJsKind;)V", "getJsKind", "()Lcom/intellij/webSymbols/js/WebSymbolJsKind;", "kind", "Lcom/intellij/webSymbols/SymbolKind;", "getKind", "()Ljava/lang/String;", "getName", "getType", "()Lcom/intellij/lang/javascript/psi/JSType;", "createPointer", "Lcom/intellij/model/Pointer;", "intellij.javascript.web"})
public final class JSPropertySymbol
extends JSWebSymbolBase<JSElement> {
    @NotNull
    private final String name;
    @Nullable
    private final JSType type;
    @NotNull
    private final WebSymbol jsPropertySymbolProvider;
    @NotNull
    private final WebSymbolJsKind jsKind;

    private JSPropertySymbol(String name, JSType type2, JSRecordType.TypeMember typeMember, WebSymbol jsPropertySymbolProvider, WebSymbolJsKind jsKind) {
        Object object = typeMember;
        PsiElement psiElement = object != null && (object = object.getMemberSource()) != null ? object.getSingleElement() : null;
        super(psiElement instanceof JSElement ? (JSElement)psiElement : null);
        this.name = name;
        this.type = type2;
        this.jsPropertySymbolProvider = jsPropertySymbolProvider;
        this.jsKind = jsKind;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public JSType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public WebSymbolJsKind getJsKind() {
        return this.jsKind;
    }

    public JSPropertySymbol(@NotNull JSRecordType.PropertySignature member, @NotNull WebSymbol jsPropertySymbolProvider) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)jsPropertySymbolProvider, (String)"jsPropertySymbolProvider");
        String string = member.getMemberName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMemberName(...)");
        this(string, member.getJSTypeWithOptionality(), member, jsPropertySymbolProvider, member instanceof JSRecordType.FunctionMember ? WebSymbolJsKind.Method : WebSymbolJsKind.Property);
    }

    public JSPropertySymbol(@NotNull String name, @NotNull JSRecordType.IndexSignature member, @NotNull WebSymbol jsPropertySymbolProvider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)jsPropertySymbolProvider, (String)"jsPropertySymbolProvider");
        this(name, member.getMemberType(), member, jsPropertySymbolProvider, WebSymbolJsKind.Property);
    }

    public JSPropertySymbol(@NotNull String name, @NotNull WebSymbol jsPropertySymbolProvider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)jsPropertySymbolProvider, (String)"jsPropertySymbolProvider");
        this(name, null, null, jsPropertySymbolProvider, WebSymbolJsKind.Property);
    }

    @NotNull
    public String getKind() {
        return "properties";
    }

    @Override
    @NotNull
    public Pointer<JSPropertySymbol> createPointer() {
        Pointer ptr = this.jsPropertySymbolProvider.createPointer();
        String name = this.getName();
        return () -> JSPropertySymbol.createPointer$lambda$0(ptr, name);
    }

    private static final JSPropertySymbol createPointer$lambda$0(Pointer $ptr, String $name) {
        Intrinsics.checkNotNullParameter((Object)$ptr, (String)"$ptr");
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        WebSymbol webSymbol = (WebSymbol)$ptr.dereference();
        return webSymbol != null ? JSPropertySymbolKt.access$resolveJSProperty(webSymbol, CollectionsKt.listOf((Object)$name)) : null;
    }
}

