/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.runConfiguration;

import com.intellij.execution.actions.CompatibleRunConfigurationProducer;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000b*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/testing/runConfiguration/JsTestRunConfigurationProducer;", "T", "Lcom/intellij/execution/configurations/RunConfiguration;", "Lcom/intellij/execution/actions/CompatibleRunConfigurationProducer;", "()V", "isTestRunnerAvailableFor", "", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "Companion", "intellij.javascript.impl"})
public abstract class JsTestRunConfigurationProducer<T extends RunConfiguration>
extends CompatibleRunConfigurationProducer<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public abstract boolean isTestRunnerAvailableFor(@NotNull PsiElement var1);

    protected final boolean isTestRunnerAvailableFor(@NotNull PsiElement element, @NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        RunConfiguration contextRunConfiguration = context2.getOriginalConfiguration(this.getConfigurationType());
        return contextRunConfiguration != null && Intrinsics.areEqual((Object)contextRunConfiguration.getType(), (Object)this.getConfigurationType()) ? true : this.isTestRunnerAvailableFor(element);
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile guessWorkingDirectory(@NotNull Project project, @NotNull String contextFilePath) {
        return Companion.guessWorkingDirectory(project, contextFilePath);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/testing/runConfiguration/JsTestRunConfigurationProducer$Companion;", "", "()V", "guessWorkingDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "contextFilePath", "", "hasTestScript", "", "packageJson", "data", "Lcom/intellij/javascript/nodejs/PackageJsonData;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final VirtualFile guessWorkingDirectory(@NotNull Project project, @NotNull String contextFilePath) {
            VirtualFile packageJson2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)contextFilePath, (String)"contextFilePath");
            String string = PathUtil.getParentPath((String)contextFilePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
            String dirPath = string;
            if (StringsKt.isBlank((CharSequence)dirPath)) {
                return ProjectUtil.guessProjectDir((Project)project);
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(dirPath);
            if (virtualFile == null) {
                return ProjectUtil.guessProjectDir((Project)project);
            }
            VirtualFile dir = virtualFile;
            Ref ref = Ref.create();
            Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
            Ref ref2 = ref;
            PackageJsonUtil.processUpPackageJsonFiles(project, dir, (Processor<? super VirtualFile>)((Processor)arg_0 -> Companion.guessWorkingDirectory$lambda$0((Function1)new Function1<VirtualFile, Boolean>((Ref<VirtualFile>)ref2){
                final /* synthetic */ Ref<VirtualFile> $ref;
                {
                    this.$ref = $ref;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@Nullable VirtualFile packageJson2) {
                    this.$ref.set((Object)packageJson2);
                    return false;
                }
            }, arg_0)));
            VirtualFile virtualFile2 = packageJson2 = (VirtualFile)ref2.get();
            Object result2 = virtualFile2 != null ? virtualFile2.getParent() : null;
            VirtualFile virtualFile3 = result2;
            if (virtualFile3 == null) {
                virtualFile3 = dir;
            }
            return virtualFile3;
        }

        public final boolean hasTestScript(@NotNull Project project, @NotNull VirtualFile packageJson2, @NotNull PackageJsonData data) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)packageJson2, (String)"packageJson");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!data.getTopLevelProperties().contains("scripts")) {
                return false;
            }
            try {
                NpmScriptsStructure npmScriptsStructure = NpmScriptsService.getInstance(project).fetchBuildfileStructure(packageJson2);
                Intrinsics.checkNotNullExpressionValue((Object)npmScriptsStructure, (String)"fetchBuildfileStructure(...)");
                NpmScriptsStructure structure = npmScriptsStructure;
                return structure.getTaskNames().contains("test");
            }
            catch (JsbtTaskFetchException jsbtTaskFetchException) {
                return false;
            }
        }

        private static final boolean guessWorkingDirectory$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

