/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004J \u0010\u000e\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/testing/JsTestConfigurationUtil;", "", "()V", "readValue", "", "element", "Lorg/jdom/Element;", "key", "validatePath", "", "shouldBeDirectory", "", "pathLabelName", "path", "writeValue", "tagName", "value", "intellij.javascript.impl"})
public final class JsTestConfigurationUtil {
    @NotNull
    public static final JsTestConfigurationUtil INSTANCE = new JsTestConfigurationUtil();

    private JsTestConfigurationUtil() {
    }

    public final void validatePath(boolean shouldBeDirectory, @NotNull String pathLabelName, @Nullable String path2) throws RuntimeConfigurationException {
        boolean exists;
        Intrinsics.checkNotNullParameter((Object)pathLabelName, (String)"pathLabelName");
        Object[] objectArray = (Object[])path2;
        if (objectArray == null || StringsKt.isBlank((CharSequence)objectArray)) {
            objectArray = new Object[]{pathLabelName};
            throw new RuntimeConfigurationError(JavaScriptBundle.message("dialog.message.unspecified", objectArray));
        }
        File file = new File(path2);
        if (!file.isAbsolute()) {
            Object[] objectArray2 = new Object[]{pathLabelName};
            throw new RuntimeConfigurationError(JavaScriptBundle.message("dialog.message.no.such", objectArray2));
        }
        boolean bl = exists = shouldBeDirectory ? file.isDirectory() : file.isFile();
        if (!exists) {
            Object[] objectArray3 = new Object[]{pathLabelName};
            throw new RuntimeConfigurationError(JavaScriptBundle.message("dialog.message.no.such", objectArray3));
        }
    }

    public final void writeValue(@NotNull Element element, @NotNull String tagName, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        CharSequence charSequence = value;
        if (!(charSequence == null || charSequence.length() == 0)) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)tagName, (String)value);
        }
    }

    @Nullable
    public final String readValue(@NotNull Element element, @NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        return JDOMExternalizerUtil.readCustomField((Element)element, (String)key2);
    }
}

