/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestFqn {
    private final JSTestFileType myType;
    private final List<String> myNames;
    private final boolean myIsSuit;

    @Deprecated(forRemoval=true)
    public JsTestFqn(@NotNull JSTestFileType type2, @NotNull List<String> names) {
        if (type2 == null) {
            JsTestFqn.$$$reportNull$$$0(0);
        }
        if (names == null) {
            JsTestFqn.$$$reportNull$$$0(1);
        }
        this(type2, names, false);
    }

    public JsTestFqn(@NotNull JSTestFileType type2, @NotNull List<String> suites, @Nullable String testName) {
        if (type2 == null) {
            JsTestFqn.$$$reportNull$$$0(2);
        }
        if (suites == null) {
            JsTestFqn.$$$reportNull$$$0(3);
        }
        this(type2, JsTestFqn.concatSuitesAndSpec(suites, testName), testName == null);
    }

    public JsTestFqn(@NotNull JSTestFileType type2, @NotNull List<String> names, boolean isSuit) {
        if (type2 == null) {
            JsTestFqn.$$$reportNull$$$0(4);
        }
        if (names == null) {
            JsTestFqn.$$$reportNull$$$0(5);
        }
        this.myType = type2;
        this.myNames = names;
        this.myIsSuit = isSuit;
    }

    @NotNull
    public String getPresentableName() {
        return JsTestFqn.getPresentableName(this.myNames);
    }

    @Nullable
    public PsiElement findNavigationElement(@NotNull JSFile file) {
        if (file == null) {
            JsTestFqn.$$$reportNull$$$0(6);
        }
        if (this.myType == JSTestFileType.JASMINE) {
            JasmineFileStructure jasmineFileStructure = JasmineFileStructureBuilder.getInstance().buildTestFileStructure(file);
            return jasmineFileStructure.findPsiElement(this);
        }
        return null;
    }

    @NotNull
    public JSTestFileType getType() {
        JSTestFileType jSTestFileType = this.myType;
        if (jSTestFileType == null) {
            JsTestFqn.$$$reportNull$$$0(7);
        }
        return jSTestFileType;
    }

    @NotNull
    public List<String> getNames() {
        List<String> list2 = this.myNames;
        if (list2 == null) {
            JsTestFqn.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public List<String> getSuitNames() {
        List<String> list2 = this.myIsSuit ? this.myNames : this.myNames.subList(0, this.myNames.size() - 1);
        if (list2 == null) {
            JsTestFqn.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Nullable
    public String getTestName() {
        return this.myIsSuit ? null : (String)ContainerUtil.getLastItem(this.myNames);
    }

    @NotNull
    @NlsSafe
    public static String getPresentableName(@NotNull List<String> names) {
        if (names == null) {
            JsTestFqn.$$$reportNull$$$0(10);
        }
        StringBuilder result2 = new StringBuilder();
        boolean first = true;
        for (String name : names) {
            if (!first && !name.startsWith(".")) {
                result2.append(".");
            }
            first = false;
            result2.append(name);
        }
        String string = result2.toString();
        if (string == null) {
            JsTestFqn.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static List<String> concatSuitesAndSpec(@NotNull List<String> suites, @Nullable String specName) {
        if (suites == null) {
            JsTestFqn.$$$reportNull$$$0(12);
        }
        List list2 = ContainerUtil.concat(suites, (List)ContainerUtil.createMaybeSingletonList((Object)specName));
        if (list2 == null) {
            JsTestFqn.$$$reportNull$$$0(13);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suites";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/util/JsTestFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/util/JsTestFqn";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "concatSuitesAndSpec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findNavigationElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "concatSuitesAndSpec";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 11, 13 -> new IllegalStateException(string);
        };
    }
}

