/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.LiveTemplateWeigher;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.registry.CustomNpmRegistryService;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.nodejs.packageJson.PackageJsonReferenceContributor;
import com.intellij.javascript.nodejs.packageJson.PackageJsonScriptReferenceSupport;
import com.intellij.javascript.nodejs.packageJson.codeInsight.popularPackages.PopularNodePackagesProvider;
import com.intellij.json.JsonLanguage;
import com.intellij.json.codeinsight.JsonStringPropertyInsertHandler;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(PackageJsonCompletionContributor.class);
    private static final ElementPattern<? extends PsiElement> SCRIPT_PATTERN = PackageJsonReferenceContributor.createScriptValuePattern();

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(1);
        }
        if (PackageJsonUtil.isInsidePackageJsonFile((PsiElement)parameters.getOriginalFile())) {
            if (SCRIPT_PATTERN.accepts((Object)parameters.getPosition().getParent())) {
                PackageJsonScriptReferenceSupport.complete(parameters, result2);
            }
            PackageJsonCompletionContributor.completeDependencies(parameters, result2);
        }
    }

    private static void completeDependencies(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(3);
        }
        VirtualFile packageJson2 = parameters.getOriginalFile().getVirtualFile();
        JsonProperty dependencyProperty = PackageJsonUtil.findContainingProperty(parameters.getPosition());
        if (packageJson2 != null && dependencyProperty != null && PackageJsonUtil.isPackageDependencyProperty(dependencyProperty)) {
            CompletionSorter sorter = CompletionSorter.emptySorter().weigh((LookupElementWeigher)new LiveTemplateWeigher()).weigh(new LookupElementWeigher("priority"){

                @NotNull
                public Double weigh(@NotNull LookupElement element) {
                    PrioritizedLookupElement ple;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Double d = (ple = (PrioritizedLookupElement)ObjectUtils.tryCast((Object)element, PrioritizedLookupElement.class)) != null ? ple.getPriority() : 0.0;
                    if (d == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return d;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "weigh";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "weigh";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            });
            result2 = result2.withRelevanceSorter(sorter);
            JsonValue nameElement = dependencyProperty.getNameElement();
            if (nameElement.getTextRange().containsOffset(parameters.getOffset())) {
                String prefix = PackageJsonCompletionContributor.findPrefix(parameters, (PsiElement)nameElement);
                result2 = result2.withPrefixMatcher(prefix);
                PackageJsonCompletionContributor.completeDependenciesNames(parameters, packageJson2, result2, prefix);
            } else {
                String packageName = StringUtil.unquoteString((String)nameElement.getText());
                PackageJsonCompletionContributor.completeDependenciesVersions(parameters, packageJson2, result2, packageName);
            }
        }
    }

    private static void completeDependenciesNames(@NotNull CompletionParameters parameters, @NotNull VirtualFile packageJson2, @NotNull CompletionResultSet result2, @NotNull String packageNamePrefix) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(4);
        }
        if (packageJson2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(6);
        }
        if (packageNamePrefix == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(7);
        }
        Set<String> alreadyUsedNames = PackageJsonCompletionContributor.getUsedPackageNames(parameters);
        List<NodePackageBasicInfo> popularPackages = PopularNodePackagesProvider.getInstance().findByPrefix(packageNamePrefix, packageNamePrefix.isEmpty() ? 20 : 10, info2 -> !alreadyUsedNames.contains(info2.getName()));
        AtomicInteger priority = new AtomicInteger(0);
        for (NodePackageBasicInfo pkg : popularPackages) {
            PackageJsonCompletionContributor.addPackageInfo(parameters, result2, pkg, priority.getAndIncrement());
        }
        if (!packageNamePrefix.isEmpty()) {
            Set popularNames = ContainerUtil.map2Set(popularPackages, NodePackageBasicInfo::getName);
            PackageJsonCompletionContributor.findPackagesInRegistryByPrefix(parameters.getPosition().getProject(), packageJson2, packageNamePrefix, Math.max(0, 10 - popularPackages.size()), (Condition<NodePackageBasicInfo>)((Condition)info2 -> !alreadyUsedNames.contains(info2.getName()) && !popularNames.contains(info2.getName())), info2 -> PackageJsonCompletionContributor.addPackageInfo(parameters, result2, info2, priority.getAndIncrement()));
        }
        result2.restartCompletionOnAnyPrefixChange();
        result2.addLookupAdvertisement(JavaScriptBundle.message("popup.advertisement.start.typing.package.name", new Object[0]));
    }

    private static boolean isInsideStringLiteral(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(8);
        }
        return parameters.getPosition().getParent() instanceof JsonStringLiteral;
    }

    private static void completeDependenciesVersions(@NotNull CompletionParameters parameters, @NotNull VirtualFile packageJson2, @NotNull CompletionResultSet result2, @NotNull String packageName) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(9);
        }
        if (packageJson2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(11);
        }
        if (packageName == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(12);
        }
        String prefix = PackageJsonCompletionContributor.findPrefix(parameters, parameters.getPosition());
        result2 = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(prefix, true));
        AvailablePackageVersions versions2 = PackageJsonCompletionContributor.fetchPackageVersions(parameters.getPosition().getProject(), packageJson2, packageName);
        int order = 0;
        String[] versionPrefixes = PackageJsonCompletionContributor.getVersionPrefixesSortedByRelevance(parameters);
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (SemVer semVer : versions2.getVersions()) {
            String[] distTag = versions2.findDistTagByVersion(semVer);
            if (distTag == null && prefix.isEmpty() && parameters.getInvocationCount() <= 1) continue;
            pairs.add("latest".equals(distTag) ? 0 : pairs.size(), Pair.create((Object)semVer, (Object)distTag));
        }
        for (Pair pair : pairs) {
            for (String versionPrefix : versionPrefixes) {
                PackageJsonCompletionContributor.addValueCompletionItem(parameters, result2, versionPrefix, ((SemVer)pair.first).getRawVersion(), (String)pair.getSecond(), order++);
            }
        }
        if (!prefix.isEmpty() || parameters.getInvocationCount() > 1) {
            for (Pair pair : versions2.getDistTags()) {
                SemVer v = (SemVer)pair.getSecond();
                PackageJsonCompletionContributor.addValueCompletionItem(parameters, result2, "", (String)pair.getFirst(), v != null ? v.getRawVersion() : null, order++);
            }
        }
        if (pairs.size() > 0 && prefix.isEmpty()) {
            result2.addLookupAdvertisement(JavaScriptBundle.message("popup.advertisement.latest.available.versions.for.all.distribution.tags", new Object[0]));
        }
    }

    private static String @NotNull [] getVersionPrefixesSortedByRelevance(@NotNull CompletionParameters parameters) {
        Object[] versionPrefixes;
        int ind;
        String versionPrefix;
        PsiElement element;
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(13);
        }
        String text2 = PackageJsonCompletionContributor.unquote((element = parameters.getOriginalPosition()) != null ? element.getText() : "");
        String string = versionPrefix = text2.isEmpty() ? "^" : text2.substring(0, 1);
        if (Character.isDigit(versionPrefix.charAt(0))) {
            versionPrefix = "";
        }
        if ((ind = ArrayUtil.find((Object[])(versionPrefixes = new String[]{"^", "~", ""}), (Object)versionPrefix)) >= 0) {
            ArrayUtil.rotateRight((Object[])versionPrefixes, (int)0, (int)ind);
        }
        if (versionPrefixes == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(14);
        }
        return versionPrefixes;
    }

    private static void addPackageInfo(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, final @NotNull NodePackageBasicInfo info2, int priority) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(15);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(16);
        }
        if (info2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(17);
        }
        Object lookupString = info2.getName() + " ";
        if (!PackageJsonCompletionContributor.isInsideStringLiteral(parameters)) {
            lookupString = StringUtil.wrapWithDoubleQuote((String)lookupString);
        }
        LookupElementBuilder builder2 = LookupElementBuilder.create((Object)info2, (String)lookupString);
        builder2 = builder2.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setItemText(info2.getName());
                presentation.setTypeGrayed(true);
                presentation.setTypeText(info2.getDescription());
            }
        }).withInsertHandler((InsertHandler)new JsonStringPropertyInsertHandler(info2.getName()));
        result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)builder2.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)priority));
    }

    private static void addValueCompletionItem(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, final @NotNull String itemTextPrefix, @NotNull String itemText, final @Nullable String typeText, int order) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(18);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(19);
        }
        if (itemTextPrefix == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(20);
        }
        if (itemText == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(21);
        }
        final String value = itemTextPrefix + itemText;
        Object lookupString = PackageJsonCompletionContributor.isInsideStringLiteral(parameters) ? value : StringUtil.wrapWithDoubleQuote((String)value);
        LookupElementBuilder builder2 = LookupElementBuilder.create((String)lookupString).withLookupString(value);
        builder2 = builder2.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setItemText((String)(itemTextPrefix.isEmpty() ? " " + value : value));
                presentation.setTypeGrayed(true);
                presentation.setTypeText(typeText);
            }
        }).withInsertHandler((InsertHandler)new JsonStringPropertyInsertHandler(value));
        result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)builder2.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)order));
    }

    public static void findPackagesInRegistryByPrefix(@NotNull Project project, @NotNull VirtualFile packageJson2, @NotNull String prefix, int limit, @NotNull Condition<NodePackageBasicInfo> filter, @NotNull Consumer<NodePackageBasicInfo> consumer) {
        if (project == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(22);
        }
        if (packageJson2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(23);
        }
        if (prefix == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(24);
        }
        if (filter == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(25);
        }
        if (consumer == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(26);
        }
        List<NodePackageBasicInfo> packages = CustomNpmRegistryService.getInstance(project).findPackages(ProgressManager.getInstance().getProgressIndicator(), packageJson2, prefix, limit, filter);
        for (NodePackageBasicInfo pkg : packages) {
            consumer.accept(pkg);
        }
        try {
            NpmRegistryService.getInstance().findPackages(ProgressManager.getInstance().getProgressIndicator(), NpmRegistryService.namePrefixSearch(prefix), Math.max(0, limit - packages.size()), filter, consumer);
        }
        catch (ProcessCanceledException e) {
            LOG.info("Fetching '" + prefix + "*' packages from registry cancelled");
        }
        catch (IOException e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(e);
            }
            LOG.info("Cannot fetch '" + prefix + "*' packages from registry", (Throwable)e);
        }
    }

    @NotNull
    private static AvailablePackageVersions fetchPackageVersions(@NotNull Project project, @NotNull VirtualFile packageJson2, @NotNull String packageName) {
        AvailablePackageVersions availablePackageVersions;
        if (project == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(27);
        }
        if (packageJson2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(28);
        }
        if (packageName == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(29);
        }
        try {
            ProgressIndicator indicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
            availablePackageVersions = (AvailablePackageVersions)ApplicationUtil.runWithCheckCanceled(() -> {
                AvailablePackageVersions r = CustomNpmRegistryService.getInstance(project).getPackageVersions(indicator, packageJson2, packageName);
                if (r != null) {
                    return r;
                }
                return NpmRegistryService.getInstance().getCachedOrFetchPackageVersions(indicator, packageName);
            }, (ProgressIndicator)indicator);
        }
        catch (ProcessCanceledException e) {
            LOG.info("Fetching versions for " + packageName + " cancelled");
            AvailablePackageVersions availablePackageVersions2 = AvailablePackageVersions.createEmpty();
            if (availablePackageVersions2 == null) {
                PackageJsonCompletionContributor.$$$reportNull$$$0(31);
            }
            return availablePackageVersions2;
        }
        catch (Exception e) {
            LOG.info("Cannot fetch versions for " + packageName, (Throwable)e);
            AvailablePackageVersions availablePackageVersions3 = AvailablePackageVersions.createEmpty();
            if (availablePackageVersions3 == null) {
                PackageJsonCompletionContributor.$$$reportNull$$$0(32);
            }
            return availablePackageVersions3;
        }
        if (availablePackageVersions == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(30);
        }
        return availablePackageVersions;
    }

    @NotNull
    private static String findPrefix(@NotNull CompletionParameters parameters, @NotNull PsiElement element) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(33);
        }
        if (element == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(34);
        }
        String name = element.getText();
        int prefixLength = Math.min(name.length(), parameters.getOffset() - element.getTextRange().getStartOffset());
        return PackageJsonCompletionContributor.unquote(name.substring(0, prefixLength));
    }

    @NotNull
    private static String unquote(@NotNull String str) {
        if (str == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(35);
        }
        String string = StringUtil.trimStart((String)StringUtil.unquoteString((String)str), (String)"\"");
        if (string == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    private static Set<String> getUsedPackageNames(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(37);
        }
        PsiElement position = parameters.getPosition();
        JsonProperty currentProperty = PackageJsonUtil.findContainingProperty(position);
        JsonFile file = (JsonFile)ObjectUtils.tryCast((Object)position.getContainingFile(), JsonFile.class);
        if (file == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PackageJsonCompletionContributor.$$$reportNull$$$0(38);
            }
            return set;
        }
        List<JsonProperty> props = PackageJsonUtil.getAllDependencies(file);
        HashSet<String> usedNames = new HashSet<String>();
        for (JsonProperty prop : props) {
            if (prop == currentProperty) continue;
            usedNames.add(prop.getName());
        }
        HashSet<String> hashSet = usedNames;
        if (hashSet == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(39);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 30, 31, 32, 36, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 11: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 10: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNamePrefix";
                break;
            }
            case 12: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 14: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemTextPrefix";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemText";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionPrefixesSortedByRelevance";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchPackageVersions";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "unquote";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedPackageNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "completeDependencies";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "completeDependenciesNames";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInsideStringLiteral";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "completeDependenciesVersions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getVersionPrefixesSortedByRelevance";
                break;
            }
            case 14: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 38: 
            case 39: {
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addPackageInfo";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addValueCompletionItem";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findPackagesInRegistryByPrefix";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "fetchPackageVersions";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findPrefix";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "unquote";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getUsedPackageNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 30, 31, 32, 36, 38, 39 -> new IllegalStateException(string);
        };
    }

    public static class PackageJsonCompletionTypedHandled
    extends TypedHandlerDelegate {
        @NotNull
        public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            PsiElement element;
            JsonProperty property;
            if (project == null) {
                PackageJsonCompletionTypedHandled.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                PackageJsonCompletionTypedHandled.$$$reportNull$$$0(1);
            }
            if (file == null) {
                PackageJsonCompletionTypedHandled.$$$reportNull$$$0(2);
            }
            if (PackageJsonUtil.isPackageJsonFile(file) && !Character.isWhitespace(charTyped) && charTyped != ',' && PackageJsonUtil.isPackageDependenciesProperty(property = PackageJsonUtil.findContainingTopLevelProperty(element = file.findElementAt(editor.getCaretModel().getOffset())))) {
                AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor);
                TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.STOP;
                if (result2 == null) {
                    PackageJsonCompletionTypedHandled.$$$reportNull$$$0(3);
                }
                return result2;
            }
            TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
            if (result3 == null) {
                PackageJsonCompletionTypedHandled.$$$reportNull$$$0(4);
            }
            return result3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor$PackageJsonCompletionTypedHandled";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor$PackageJsonCompletionTypedHandled";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "checkAutoPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "checkAutoPopup";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class DependencyCharFilter
    extends CharFilter {
        @Nullable
        public CharFilter.Result acceptChar(char c2, int prefixLength, Lookup lookup) {
            if (!lookup.isCompletion()) {
                return null;
            }
            PsiElement element = lookup.getPsiElement();
            if (element != null && JsonLanguage.INSTANCE.equals(element.getLanguage())) {
                if (StringUtil.containsChar((String)"@/-.^~", (char)c2)) {
                    return CharFilter.Result.ADD_TO_PREFIX;
                }
                if (c2 == '\"' && element instanceof PsiWhiteSpace) {
                    return CharFilter.Result.ADD_TO_PREFIX;
                }
                if (c2 == ',') {
                    return prefixLength == 0 ? CharFilter.Result.HIDE_LOOKUP : CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                }
            }
            return null;
        }
    }
}

