/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.download;

import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.download.NodeDownloadDialog;
import com.intellij.javascript.nodejs.interpreter.download.NodeDownloadService;
import com.intellij.javascript.nodejs.interpreter.download.NodeDownloadVersionInfo;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import icons.JavaScriptLanguageIcons;
import java.nio.file.Path;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u0005\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/nodejs/interpreter/download/NodeDownloadEditorNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "disableNotification", "", "isFileAccepted", "", "isLocalProject", "isNotificationAllowed", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nNodeDownloadEditorNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeDownloadEditorNotificationProvider.kt\ncom/intellij/javascript/nodejs/interpreter/download/NodeDownloadEditorNotificationProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,98:1\n31#2,2:99\n*S KotlinDebug\n*F\n+ 1 NodeDownloadEditorNotificationProvider.kt\ncom/intellij/javascript/nodejs/interpreter/download/NodeDownloadEditorNotificationProvider\n*L\n49#1:99,2\n*E\n"})
public final class NodeDownloadEditorNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        String[] stringArray;
        VirtualFile packageJson2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.isFileAccepted(file) && this.isNotificationAllowed(project) && (packageJson2 = JSProjectUtil.findFileUpToContentRoot(project, file, stringArray = new String[]{"package.json"})) != null) {
            NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterManager.getInstance(project).getInterpreterRef();
            Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"getInterpreterRef(...)");
            NodeJsInterpreterRef interpreterRef = nodeJsInterpreterRef;
            if (interpreterRef.resolve(project) == null && this.isLocalProject(project)) {
                NodeDownloadEditorNotificationProvider notificationProvider = this;
                return arg_0 -> NodeDownloadEditorNotificationProvider.collectNotificationData$lambda$5(project, notificationProvider, this, arg_0);
            }
        }
        return null;
    }

    private final void disableNotification(Project project) {
        PropertiesComponent.getInstance((Project)project).setValue("disable.download.node.interpreter.editor.notification", true, false);
        EditorNotifications.getInstance((Project)project).updateNotifications((EditorNotificationProvider)this);
    }

    private final boolean isNotificationAllowed(Project project) {
        boolean disabled = PropertiesComponent.getInstance((Project)project).getBoolean("disable.download.node.interpreter.editor.notification", false);
        return !disabled;
    }

    private final boolean isFileAccepted(VirtualFile file) {
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(file.getNameSequence());
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFileName(...)");
        FileType fileType2 = fileType;
        LanguageFileType languageFileType = fileType2 instanceof LanguageFileType ? (LanguageFileType)fileType2 : null;
        Language language = languageFileType != null ? languageFileType.getLanguage() : null;
        return Intrinsics.areEqual((Object)language, (Object)((Object)JavascriptLanguage.INSTANCE)) || Intrinsics.areEqual((Object)language, (Object)((Object)JavaScriptSupportLoader.TYPESCRIPT)) || Intrinsics.areEqual((Object)language, (Object)((Object)JavaScriptSupportLoader.FLOW_JS)) || Intrinsics.areEqual((Object)language, (Object)((Object)JavaScriptSupportLoader.TYPESCRIPT_JSX)) || language instanceof HTMLLanguage;
    }

    private final boolean isLocalProject(Project project) {
        Object object = ReadAction.compute(() -> NodeDownloadEditorNotificationProvider.isLocalProject$lambda$6(project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (Boolean)object;
    }

    private static final void collectNotificationData$lambda$5$lambda$4$lambda$1$lambda$0(NodeDownloadService $downloadService, Project $project, NodeDownloadEditorNotificationProvider $notificationProvider, NodeJsInterpreter interpreter2) {
        Intrinsics.checkNotNullParameter((Object)$downloadService, (String)"$downloadService");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$notificationProvider, (String)"$notificationProvider");
        $downloadService.defaultHandler().accept(interpreter2);
        EditorNotifications.getInstance((Project)$project).updateNotifications((EditorNotificationProvider)$notificationProvider);
    }

    private static final void collectNotificationData$lambda$5$lambda$4$lambda$1(Project $project, NodeDownloadEditorNotificationProvider $notificationProvider) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$notificationProvider, (String)"$notificationProvider");
        Pair<NodeDownloadVersionInfo, Path> pair = new NodeDownloadDialog($project).provideVersionAndPath();
        if (pair == null) {
            return;
        }
        Pair<NodeDownloadVersionInfo, Path> pair2 = pair;
        NodeDownloadVersionInfo versionInfo = (NodeDownloadVersionInfo)pair2.component1();
        Path downloadLocation = (Path)pair2.component2();
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<NodeDownloadService> serviceClass$iv = NodeDownloadService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        NodeDownloadService downloadService = (NodeDownloadService)object;
        NodeDownloadService.download$default(downloadService, versionInfo.getVersion(), downloadLocation, null, arg_0 -> NodeDownloadEditorNotificationProvider.collectNotificationData$lambda$5$lambda$4$lambda$1$lambda$0(downloadService, $project, $notificationProvider, arg_0), 4, null);
    }

    private static final void collectNotificationData$lambda$5$lambda$4$lambda$2(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        NodeSettingsConfigurable.showSettingsDialog($project);
    }

    private static final void collectNotificationData$lambda$5$lambda$4$lambda$3(NodeDownloadEditorNotificationProvider this$0, Project $project) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        this$0.disableNotification($project);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$5(Project $project, NodeDownloadEditorNotificationProvider $notificationProvider, NodeDownloadEditorNotificationProvider this$0, FileEditor fileEditor2) {
        EditorNotificationPanel editorNotificationPanel;
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$notificationProvider, (String)"$notificationProvider");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)fileEditor2, (String)"fileEditor");
        EditorNotificationPanel $this$collectNotificationData_u24lambda_u245_u24lambda_u244 = editorNotificationPanel = new EditorNotificationPanel(fileEditor2, EditorNotificationPanel.Status.Warning);
        boolean bl = false;
        Object[] objectArray = new Object[]{ApplicationInfo.getInstance().getVersionName()};
        $this$collectNotificationData_u24lambda_u245_u24lambda_u244.text(JavaScriptBundle.message("node.download.editor.suggestion", objectArray));
        $this$collectNotificationData_u24lambda_u245_u24lambda_u244.icon(JavaScriptLanguageIcons.Nodejs.Nodejs);
        $this$collectNotificationData_u24lambda_u245_u24lambda_u244.createActionLabel(JavaScriptBundle.message("node.interpreter.download", new Object[0]), () -> NodeDownloadEditorNotificationProvider.collectNotificationData$lambda$5$lambda$4$lambda$1($project, $notificationProvider));
        objectArray = new Object[]{"Node.js"};
        $this$collectNotificationData_u24lambda_u245_u24lambda_u244.createActionLabel(JavaScriptBundle.message("node.js.configure.interpreter", objectArray), () -> NodeDownloadEditorNotificationProvider.collectNotificationData$lambda$5$lambda$4$lambda$2($project));
        $this$collectNotificationData_u24lambda_u245_u24lambda_u244.setCloseAction(() -> NodeDownloadEditorNotificationProvider.collectNotificationData$lambda$5$lambda$4$lambda$3(this$0, $project));
        return editorNotificationPanel;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Boolean isLocalProject$lambda$6(Project $project) {
        boolean bl;
        VirtualFile root;
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        VirtualFile virtualFile = root = $project.isDisposed() ? null : ProjectUtil.guessProjectDir((Project)$project);
        if (root != null) {
            String string = root.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (!WslPath.Companion.isWslUncPath(string)) {
                bl = true;
                return bl;
            }
        }
        bl = false;
        return bl;
    }
}

