/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.interpreter.NodeInterpreterNotificationServiceKt;
import com.intellij.javascript.nodejs.interpreter.UnresolvedProjectInterpreterNotification;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformUtils;
import com.intellij.util.text.SemVer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\r\u0010\f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000eJ\u0006\u0010\u000f\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/nodejs/interpreter/NodeInterpreterNotificationService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "unresolvedProjectInterpreterNotification", "Lcom/intellij/javascript/nodejs/interpreter/UnresolvedProjectInterpreterNotification;", "dispose", "", "showNotificationAboutDownload", "version", "Lcom/intellij/util/text/SemVer;", "error", "", "Lorg/jetbrains/annotations/Nls;", "showNotificationForUnresolvedProjectInterpreter", "Companion", "intellij.javascript.impl"})
public final class NodeInterpreterNotificationService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final UnresolvedProjectInterpreterNotification unresolvedProjectInterpreterNotification;

    public NodeInterpreterNotificationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.unresolvedProjectInterpreterNotification = new UnresolvedProjectInterpreterNotification(this.project, this);
    }

    public final void showNotificationForUnresolvedProjectInterpreter() {
        if (PlatformUtils.isWebStorm()) {
            this.unresolvedProjectInterpreterNotification.showIfUnresolved();
        }
    }

    public final void showNotificationAboutDownload(@NotNull SemVer version2, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        if (error == null) {
            NotificationGroup notificationGroup = NodeInterpreterNotificationServiceKt.getNotificationGroup();
            Object[] objectArray = new Object[]{version2};
            String string = JavaScriptBundle.message("node.download.success.notification", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Notification notification = notificationGroup.createNotification(string, NotificationType.INFORMATION);
            notification.addAction(NodeSettingsConfigurable.createOpenSettingsAction(this.project, () -> ((Notification)notification).expire()));
            notification.notify(this.project);
        } else {
            NotificationGroup notificationGroup = NodeInterpreterNotificationServiceKt.getNotificationGroup();
            Object[] objectArray = new Object[]{version2, error};
            String string = JavaScriptBundle.message("node.download.failure.notification", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Notification notification = notificationGroup.createNotification(string, NotificationType.ERROR);
            notification.notify(this.project);
        }
    }

    public void dispose() {
    }

    @JvmStatic
    @NotNull
    public static final NodeInterpreterNotificationService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/nodejs/interpreter/NodeInterpreterNotificationService$Companion;", "", "()V", "getInstance", "Lcom/intellij/javascript/nodejs/interpreter/NodeInterpreterNotificationService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nNodeInterpreterNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeInterpreterNotificationService.kt\ncom/intellij/javascript/nodejs/interpreter/NodeInterpreterNotificationService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,156:1\n31#2,2:157\n*S KotlinDebug\n*F\n+ 1 NodeInterpreterNotificationService.kt\ncom/intellij/javascript/nodejs/interpreter/NodeInterpreterNotificationService$Companion\n*L\n63#1:157,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final NodeInterpreterNotificationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<NodeInterpreterNotificationService> serviceClass$iv = NodeInterpreterNotificationService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NodeInterpreterNotificationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

