/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices.nestjs;

import com.intellij.javascript.microservices.nestjs.NestJSMethodDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSCallExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000626\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00040\bH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0006H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/javascript/microservices/nestjs/NestJSIndexingHandler;", "Lcom/intellij/lang/javascript/index/FrameworkIndexingHandler;", "()V", "checkCallExpression", "", "callNode", "Lcom/intellij/lang/ASTNode;", "check", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "referenceName", "hasQualifier", "getMarkers", "", "elementToIndex", "Lcom/intellij/psi/PsiElement;", "isDecoratorArgument", "literalExpressionNode", "isMappingDecorator", "isMappingDecoratorCall", "isNestJSControllerClass", "psiElement", "shouldCreateStubForCallExpression", "node", "shouldCreateStubForLiteral", "intellij.javascript.langInjection"})
@SourceDebugExtension(value={"SMAP\nNestJSIndexingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NestJSIndexingHandler.kt\ncom/intellij/javascript/microservices/nestjs/NestJSIndexingHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,83:1\n1549#2:84\n1620#2,3:85\n14#3:88\n12474#4,2:89\n*S KotlinDebug\n*F\n+ 1 NestJSIndexingHandler.kt\ncom/intellij/javascript/microservices/nestjs/NestJSIndexingHandler\n*L\n62#1:84\n62#1:85,3\n78#1:88\n81#1:89,2\n*E\n"})
public final class NestJSIndexingHandler
extends FrameworkIndexingHandler {
    @Override
    @NotNull
    public List<String> getMarkers(@NotNull PsiElement elementToIndex) {
        Intrinsics.checkNotNullParameter((Object)elementToIndex, (String)"elementToIndex");
        if (this.isNestJSControllerClass(elementToIndex)) {
            return CollectionsKt.listOf((Object)"NESTJS_CONTROLLER_CLASS");
        }
        List<String> list2 = super.getMarkers(elementToIndex);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getMarkers(...)");
        return list2;
    }

    @Override
    public boolean shouldCreateStubForCallExpression(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.isMappingDecoratorCall(node);
    }

    @Override
    public boolean shouldCreateStubForLiteral(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.isDecoratorArgument(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDecoratorArgument(ASTNode literalExpressionNode) {
        ASTNode treeParent;
        ASTNode aSTNode = treeParent = literalExpressionNode.getTreeParent();
        ASTNode aSTNode2 = aSTNode;
        if (aSTNode == null) return false;
        if ((aSTNode2 = aSTNode2.getElementType()) == null) {
            return false;
        }
        ASTNode parentType = aSTNode2;
        if (!Intrinsics.areEqual((Object)parentType, (Object)JSElementTypes.ARGUMENT_LIST)) return false;
        ASTNode aSTNode3 = treeParent.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"getTreeParent(...)");
        if (!this.isMappingDecoratorCall(aSTNode3)) return false;
        return true;
    }

    private final boolean isMappingDecoratorCall(ASTNode callNode) {
        ASTNode aSTNode = callNode.getTreeParent();
        return Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)JSElementTypes.ES6_DECORATOR) && this.checkCallExpression(callNode, (Function2<? super String, ? super Boolean, Boolean>)((Function2)new Function2<String, Boolean, Boolean>(this){
            final /* synthetic */ NestJSIndexingHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull String refName, boolean hasQualifier) {
                Intrinsics.checkNotNullParameter((Object)refName, (String)"refName");
                return !hasQualifier && NestJSIndexingHandler.access$isMappingDecorator(this.this$0, refName);
            }
        }));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMappingDecorator(String referenceName) {
        void $this$mapTo$iv$iv;
        if (Intrinsics.areEqual((Object)referenceName, (Object)"Controller")) return true;
        Iterable $this$map$iv = (Iterable)NestJSMethodDecorator.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NestJSMethodDecorator nestJSMethodDecorator = (NestJSMethodDecorator)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDecoratorName());
        }
        if (!((List)destination$iv$iv).contains(referenceName)) return false;
        return true;
    }

    private final boolean checkCallExpression(ASTNode callNode, Function2<? super String, ? super Boolean, Boolean> check) {
        if (!Intrinsics.areEqual((Object)callNode.getElementType(), (Object)JSElementTypes.CALL_EXPRESSION)) {
            return false;
        }
        ASTNode methodExpression = JSCallExpressionImpl.getMethodExpression(callNode);
        if (methodExpression == null || !Intrinsics.areEqual((Object)methodExpression.getElementType(), (Object)JSElementTypes.REFERENCE_EXPRESSION)) {
            return false;
        }
        String string = JSReferenceExpressionImpl.getReferenceName(methodExpression);
        if (string == null) {
            return false;
        }
        String referenceName = string;
        boolean hasQualifier = JSReferenceExpressionImpl.getQualifierNode(methodExpression) != null;
        return (Boolean)check.invoke((Object)referenceName, (Object)hasQualifier);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isNestJSControllerClass(PsiElement psiElement) {
        boolean bl;
        ES6Decorator[] eS6DecoratorArray;
        JSAttributeList jSAttributeList;
        TypeScriptClass typeScriptClass;
        PsiElement $this$asSafely$iv = psiElement;
        boolean $i$f$asSafely = false;
        PsiElement psiElement2 = $this$asSafely$iv;
        if (!(psiElement2 instanceof TypeScriptClass)) {
            psiElement2 = null;
        }
        if ((typeScriptClass = (TypeScriptClass)psiElement2) != null && (jSAttributeList = typeScriptClass.getAttributeList()) != null && (eS6DecoratorArray = jSAttributeList.getDecorators()) != null) {
            boolean bl2;
            block4: {
                void $this$any$iv;
                ES6Decorator[] eS6DecoratorArray2 = eS6DecoratorArray;
                boolean $i$f$any = false;
                int n = ((void)$this$any$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv;
                    void it = element$iv = $this$any$iv[i];
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getDecoratorName(), (Object)"Controller")) continue;
                    bl2 = true;
                    break block4;
                }
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$isMappingDecorator(NestJSIndexingHandler $this, String referenceName) {
        return $this.isMappingDecorator(referenceName);
    }
}

