/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices.nestjs;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.microservices.nestjs.NestJSController;
import com.intellij.javascript.microservices.nestjs.NestJSEndpointsKt;
import com.intellij.javascript.microservices.nestjs.NestJSMapping;
import com.intellij.javascript.microservices.nestjs.NestJSUrlTargetInfo;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.dialects.TypeScriptLanguageDialect;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.SearchScopeEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00122\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\""}, d2={"Lcom/intellij/javascript/microservices/nestjs/NestJSEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsUrlTargetProvider;", "Lcom/intellij/javascript/microservices/nestjs/NestJSController;", "Lcom/intellij/javascript/microservices/nestjs/NestJSMapping;", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "group", "endpoint", "getEndpointGroups", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getEndpoints", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "isValidEndpoint", "", "intellij.javascript.langInjection"})
@SourceDebugExtension(value={"SMAP\nNestJSEndpointsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NestJSEndpointsProvider.kt\ncom/intellij/javascript/microservices/nestjs/NestJSEndpointsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class NestJSEndpointsProvider
implements EndpointsUrlTargetProvider<NestJSController, NestJSMapping> {
    @NotNull
    private final EndpointType endpointType = EndpointTypes.HTTP_SERVER_TYPE;
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("NestJS", "NestJS", AllIcons.FileTypes.JavaScript);

    @NotNull
    public EndpointType getEndpointType() {
        return this.endpointType;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return NestJSEndpointsKt.hasNestJS(project) ? EndpointsProvider.Status.HAS_ENDPOINTS : EndpointsProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public Iterable<NestJSController> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof SearchScopeEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        if (!NestJSEndpointsKt.hasNestJS(project)) {
            return CollectionsKt.emptyList();
        }
        return NestJSEndpointsKt.getNestJSControllers(project);
    }

    @NotNull
    public Iterable<NestJSMapping> getEndpoints(@NotNull NestJSController group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return NestJSEndpointsKt.getNestJSMappings(group);
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull NestJSController group, @NotNull NestJSMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        String it = endpoint.getPath();
        boolean bl = false;
        Object endpointPath = StringsKt.startsWith$default((CharSequence)it, (char)'/', (boolean)false, (int)2, null) ? it : "/" + it;
        return (ItemPresentation)new HttpMethodPresentation((String)endpointPath, CollectionsKt.toList((Iterable)endpoint.getHttpMethods()), group.getName(), AllIcons.FileTypes.JavaScript, null, 16, null);
    }

    public boolean isValidEndpoint(@NotNull NestJSController group, @NotNull NestJSMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        PsiElement psiElement = endpoint.getDeclaration().getElement();
        return psiElement != null ? psiElement.isValid() : false;
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ModificationTracker modificationTracker = PsiManager.getInstance((Project)project).getModificationTracker().forLanguage((Language)TypeScriptLanguageDialect.getInstance());
        Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"forLanguage(...)");
        return modificationTracker;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull NestJSController group, @NotNull NestJSMapping endpoint) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Object object = endpoint.toUrlTargetInfo$intellij_javascript_langInjection();
        if (object != null) {
            NestJSUrlTargetInfo p0 = object;
            boolean bl = false;
            List list2 = CollectionsKt.listOf((Object)p0);
            object = list2;
            if (list2 != null) {
                iterable = (Iterable)object;
                return iterable;
            }
        }
        iterable = CollectionsKt.emptyList();
        return iterable;
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull NestJSController group, @NotNull NestJSMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.getDeclaration().getElement();
    }
}

