/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aqua.runners.js.core;

import com.intellij.aqua.runners.js.core.JsTestRunSettings;
import com.intellij.aqua.runners.js.core.JsTestRunSettingsBuilder;
import com.intellij.execution.RunManager;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.nodejs.execution.AbstractNodeTargetRunProfile;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.javascript.testing.runConfiguration.JsTestRunConfigurationProducer;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.runScope.JsTestRunScopeKind;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 #*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0001#B%\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001d\u001a\u0004\u0018\u00010\fJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\u00028\u0000X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lcom/intellij/aqua/runners/js/core/JsTestRunConfiguration;", "Settings", "Lcom/intellij/aqua/runners/js/core/JsTestRunSettings;", "Lcom/intellij/javascript/nodejs/execution/AbstractNodeTargetRunProfile;", "Lcom/intellij/javascript/testFramework/PreferableRunConfiguration;", "Lcom/intellij/javascript/JSRunProfileWithCompileBeforeLaunchOption;", "Lcom/intellij/execution/testframework/sm/runner/SMRunnerConsolePropertiesProvider;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "packageDescriptor", "Lcom/intellij/javascript/nodejs/util/NodePackageDescriptor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;Lcom/intellij/javascript/nodejs/util/NodePackageDescriptor;)V", "envData", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "getEnvData", "()Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "getInterpreter", "()Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "settings", "getSettings", "()Lcom/intellij/aqua/runners/js/core/JsTestRunSettings;", "setSettings", "(Lcom/intellij/aqua/runners/js/core/JsTestRunSettings;)V", "getActionName", "getOrDetectPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "onNewConfigurationCreated", "", "suggestedName", "Companion", "intellij.aqua.runners.js.core"})
public abstract class JsTestRunConfiguration<Settings extends JsTestRunSettings<Settings>>
extends AbstractNodeTargetRunProfile
implements PreferableRunConfiguration,
JSRunProfileWithCompileBeforeLaunchOption,
SMRunnerConsolePropertiesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NodePackageDescriptor packageDescriptor;

    public JsTestRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name, @NotNull NodePackageDescriptor packageDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)packageDescriptor, (String)"packageDescriptor");
        super(project, factory, name);
        this.packageDescriptor = packageDescriptor;
    }

    @NotNull
    public abstract Settings getSettings();

    public abstract void setSettings(@NotNull Settings var1);

    @Override
    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return ((JsTestRunSettings)this.getSettings()).getInterpreterRef().resolve(this.getProject());
    }

    @NotNull
    public final NodePackage getOrDetectPackage() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (RunManager.Companion.getInstance(project).isTemplate((RunConfiguration)this)) {
            NodePackage nodePackage = ((JsTestRunSettings)this.getSettings()).getFrameworkPackage();
            if (nodePackage == null) {
                nodePackage = new NodePackage("");
            }
            return nodePackage;
        }
        NodePackage pkg = ((JsTestRunSettings)this.getSettings()).getFrameworkPackage();
        if (pkg == null) {
            pkg = this.packageDescriptor.findFirstDirectDependencyPackage(this.getProject(), null, JsTestRunConfiguration.Companion.findContextFile(this.getSettings()));
            this.setSettings(((JsTestRunSettings)this.getSettings()).builder().frameworkPackage(pkg).build());
        }
        return pkg;
    }

    public final void onNewConfigurationCreated() {
        block1: {
            if (!StringsKt.isBlank((CharSequence)((JsTestRunSettings)this.getSettings()).getWorkingDir())) break block1;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VirtualFile virtualFile = JsTestRunConfigurationProducer.Companion.guessWorkingDirectory(project, ((JsTestRunSettings)this.getSettings()).getConfigFilePath());
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                JsTestRunSettingsBuilder jsTestRunSettingsBuilder = ((JsTestRunSettings)this.getSettings()).builder();
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                this.setSettings(jsTestRunSettingsBuilder.workingDir(string).build());
            }
        }
    }

    @NotNull
    public final String suggestedName() {
        JsTestRunScope scope2 = ((JsTestRunSettings)this.getSettings()).getScope();
        if (scope2.getKind() == JsTestRunScopeKind.DIRECTORY) {
            Object[] objectArray = new Object[]{PathUtil.getFileName((String)scope2.getTestDirectoryPath()) + File.separator};
            String string = JavaScriptBundle.message("rc.testDirectory.presentable.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        if (scope2.getKind() == JsTestRunScopeKind.TEST_FILE) {
            String string = PathUtil.getFileName((String)scope2.getTestFilePath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            return string;
        }
        if (scope2.getKind() == JsTestRunScopeKind.SUITE || scope2.getKind() == JsTestRunScopeKind.TEST) {
            String string = JsTestFqn.getPresentableName(scope2.getTestNames());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
            return string;
        }
        if (!StringsKt.isBlank((CharSequence)((JsTestRunSettings)this.getSettings()).getConfigFilePath())) {
            Object[] objectArray = new Object[]{PathUtil.getFileName((String)((JsTestRunSettings)this.getSettings()).getConfigFilePath())};
            String string = JavaScriptBundle.message("rc.testConfig.presentable.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        String string = TestRunnerBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public final String getActionName() {
        JsTestRunScope scope2 = ((JsTestRunSettings)this.getSettings()).getScope();
        if (scope2.getKind() == JsTestRunScopeKind.SUITE || scope2.getKind() == JsTestRunScopeKind.TEST) {
            String string = (String)CollectionsKt.lastOrNull(scope2.getTestNames());
            if (string != null) {
                String it = string;
                boolean bl = false;
                return it;
            }
        }
        return super.getActionName();
    }

    @Override
    @NotNull
    public final EnvironmentVariablesData getEnvData() {
        return ((JsTestRunSettings)this.getSettings()).getEnvData();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/aqua/runners/js/core/JsTestRunConfiguration$Companion;", "", "()V", "findContextFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "settings", "Lcom/intellij/aqua/runners/js/core/JsTestRunSettings;", "findFile", "path", "", "intellij.aqua.runners.js.core"})
    public static final class Companion {
        private Companion() {
        }

        private final VirtualFile findContextFile(JsTestRunSettings<?> settings2) {
            VirtualFile virtualFile = this.findFile(settings2.getConfigFilePath());
            if (virtualFile == null) {
                virtualFile = this.findFile(settings2.getWorkingDir());
            }
            return virtualFile;
        }

        private final VirtualFile findFile(String path2) {
            return FileUtil.isAbsolute((String)path2) ? LocalFileSystem.getInstance().findFileByPath(path2) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

