/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class MappingsToRoots {
    public static VirtualFile @NotNull [] getRootsUnderVcs(@NotNull Project project, @NotNull NewMappings newMappings, @NotNull AbstractVcs vcs) {
        if (project == null) {
            MappingsToRoots.$$$reportNull$$$0(0);
        }
        if (newMappings == null) {
            MappingsToRoots.$$$reportNull$$$0(1);
        }
        if (vcs == null) {
            MappingsToRoots.$$$reportNull$$$0(2);
        }
        List mappings = newMappings.getMappingsAsFilesUnderVcs(vcs);
        AbstractVcs.RootsConvertor convertor = vcs.getCustomConvertor();
        List result2 = convertor != null ? convertor.convertRoots(new ArrayList<VirtualFile>(mappings)) : mappings;
        return MappingsToRoots.filterAllowedRoots(project, result2, vcs);
    }

    public static VirtualFile @NotNull [] filterAllowedRoots(@NotNull Project project, @NotNull List<VirtualFile> mappings, @NotNull AbstractVcs vcs) {
        if (project == null) {
            MappingsToRoots.$$$reportNull$$$0(3);
        }
        if (mappings == null) {
            MappingsToRoots.$$$reportNull$$$0(4);
        }
        if (vcs == null) {
            MappingsToRoots.$$$reportNull$$$0(5);
        }
        if (vcs.allowsNestedRoots()) {
            VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(mappings);
            if (virtualFileArray == null) {
                MappingsToRoots.$$$reportNull$$$0(6);
            }
            return virtualFileArray;
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(mappings);
        result2.sort((Comparator<VirtualFile>)FilePathComparator.getInstance());
        ApplicationManager.getApplication().runReadAction(() -> {
            FileIndexFacade facade = FileIndexFacade.getInstance((Project)project);
            int i = 1;
            while (i < result2.size()) {
                VirtualFile current;
                VirtualFile previous = (VirtualFile)result2.get(i - 1);
                if (facade.isValidAncestor(previous, current = (VirtualFile)result2.get(i))) {
                    result2.remove(i);
                    continue;
                }
                ++i;
            }
        });
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            MappingsToRoots.$$$reportNull$$$0(7);
        }
        return virtualFileArray;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static List<VirtualFile> getDetailedVcsMappings(@NotNull Project project, @NotNull NewMappings newMappings, @NotNull AbstractVcs vcs) {
        if (project == null) {
            MappingsToRoots.$$$reportNull$$$0(8);
        }
        if (newMappings == null) {
            MappingsToRoots.$$$reportNull$$$0(9);
        }
        if (vcs == null) {
            MappingsToRoots.$$$reportNull$$$0(10);
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(newMappings.getMappingsAsFilesUnderVcs(vcs));
        Collection<VirtualFile> modules = DefaultVcsRootPolicy.getInstance(project).getDefaultVcsRoots();
        List modulesUnderVcs = ContainerUtil.filter(modules, file -> {
            if (!file.isDirectory()) {
                return false;
            }
            NewMappings.MappedRoot root = newMappings.getMappedRootFor((VirtualFile)file);
            return root != null && vcs.equals((Object)root.vcs);
        });
        List modulesToAdd = (List)ApplicationManager.getApplication().runReadAction(() -> {
            FileIndexFacade facade = FileIndexFacade.getInstance((Project)project);
            return ContainerUtil.filter((Collection)modulesUnderVcs, module -> ContainerUtil.or((Iterable)roots, root -> facade.isValidAncestor(root, module)));
        });
        return new ArrayList<VirtualFile>(ContainerUtil.union(roots, (Collection)modulesToAdd));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMappings";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/projectlevelman/MappingsToRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/MappingsToRoots";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAllowedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootsUnderVcs";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterAllowedRoots";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDetailedVcsMappings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

