/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.OutOfSourcesChecker;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class CheckinHandlerUtil {
    public static boolean isGeneratedOrExcluded(@NotNull Project project, @NotNull VirtualFile file) {
        ProjectFileIndex fileIndex;
        if (project == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(1);
        }
        return (fileIndex = ProjectFileIndex.getInstance((Project)project)).isExcluded(file) || GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file, (Project)project);
    }

    @NotNull
    public static List<VirtualFile> filterOutGeneratedAndExcludedFiles(@NotNull Collection<? extends VirtualFile> files2, @NotNull Project project) {
        if (files2 == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(2);
        }
        if (project == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(3);
        }
        List list = ContainerUtil.filter(files2, file -> !CheckinHandlerUtil.isGeneratedOrExcluded(project, file));
        if (list == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    public static PsiFile[] getPsiFiles(Project project, Collection<? extends VirtualFile> selectedFiles) {
        ArrayList<PsiFile> result2 = new ArrayList<PsiFile>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        IProjectStore projectStore = ProjectKt.getStateStore((Project)project);
        for (VirtualFile virtualFile : selectedFiles) {
            PsiFile psiFile2;
            if (!virtualFile.isValid() || projectStore.isProjectFile(virtualFile) || !CheckinHandlerUtil.isFileUnderSourceRoot(project, virtualFile) || CheckinHandlerUtil.isOutOfSources(project, virtualFile) || (psiFile2 = psiManager.findFile(virtualFile)) == null) continue;
            result2.add(psiFile2);
        }
        return PsiUtilCore.toPsiFileArray(result2);
    }

    private static boolean isFileUnderSourceRoot(@NotNull Project project, @NotNull VirtualFile file) {
        ProjectFileIndex index;
        if (project == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(5);
        }
        if (file == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(6);
        }
        return (index = ProjectRootManager.getInstance((Project)project).getFileIndex()).isInContent(file) && !index.isInLibrarySource(file);
    }

    private static boolean isOutOfSources(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(7);
        }
        if (file == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(8);
        }
        return OutOfSourcesChecker.EP_NAME.getExtensionList().stream().anyMatch(checker -> FileTypeRegistry.getInstance().isFileOfType(file, checker.getFileType()) && checker.isOutOfSources(project, file));
    }

    public static void disableWhenDumb(@NotNull Project project, @NotNull JCheckBox checkBox2, @NotNull @Nls String tooltip2) {
        boolean dumb;
        if (project == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(9);
        }
        if (checkBox2 == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(10);
        }
        if (tooltip2 == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(11);
        }
        checkBox2.setEnabled(!(dumb = DumbService.isDumb((Project)project)));
        checkBox2.setToolTipText(dumb ? tooltip2 : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutGeneratedAndExcludedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isGeneratedOrExcluded";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterOutGeneratedAndExcludedFiles";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFileUnderSourceRoot";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isOutOfSources";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "disableWhenDumb";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

