/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContextUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectAndCompareWithSelectedRevisionAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SelectAndCompareWithSelectedRevisionAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        VirtualFile file = VcsContextUtil.selectedFile(e.getDataContext());
        if (project == null || file == null) {
            return;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
        if (vcs == null) {
            return;
        }
        RevisionSelector selector = vcs.getRevisionSelector();
        DiffProvider diffProvider = vcs.getDiffProvider();
        if (selector == null || diffProvider == null) {
            return;
        }
        VcsRevisionNumber vcsRevisionNumber = selector.selectNumber(file);
        if (vcsRevisionNumber != null) {
            DiffActionExecutor.showDiff(diffProvider, vcsRevisionNumber, file, project);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SelectAndCompareWithSelectedRevisionAction.$$$reportNull$$$0(1);
        }
        boolean isVisible = SelectAndCompareWithSelectedRevisionAction.isVisible(e.getDataContext());
        e.getPresentation().setEnabled(isVisible && SelectAndCompareWithSelectedRevisionAction.isEnabled(e.getDataContext()));
        e.getPresentation().setVisible(isVisible);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SelectAndCompareWithSelectedRevisionAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static boolean isVisible(@NotNull DataContext context) {
        Project project;
        if (context == null) {
            SelectAndCompareWithSelectedRevisionAction.$$$reportNull$$$0(3);
        }
        if ((project = (Project)context.getData(CommonDataKeys.PROJECT)) == null) {
            return false;
        }
        Object[] vcss = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss();
        return ContainerUtil.exists((Object[])vcss, SelectAndCompareWithSelectedRevisionAction::canShowDiffForVcs);
    }

    private static boolean isEnabled(@NotNull DataContext context) {
        if (context == null) {
            SelectAndCompareWithSelectedRevisionAction.$$$reportNull$$$0(4);
        }
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        VirtualFile file = VcsContextUtil.selectedFile(context);
        if (project == null || file == null || file.isDirectory()) {
            return false;
        }
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project);
        if (!SelectAndCompareWithSelectedRevisionAction.canShowDiffForVcs(vcs)) {
            return false;
        }
        return AbstractVcs.fileInVcsByFileStatus((Project)project, (VirtualFile)file);
    }

    private static boolean canShowDiffForVcs(@Nullable AbstractVcs vcs) {
        return vcs != null && vcs.getDiffProvider() != null && vcs.getRevisionSelector() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/SelectAndCompareWithSelectedRevisionAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/SelectAndCompareWithSelectedRevisionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

