/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.lang.makefile.MakeSettings;
import com.jetbrains.lang.makefile.MakefileProjectSettings;
import com.jetbrains.lang.makefile.MakefileRunConfiguration;
import com.jetbrains.lang.makefile.MakefileRunConfigurationEditor;
import com.jetbrains.lang.makefile.MakefileRunConfigurationFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\u0018\u0000 K2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001KB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001f\u001a\u00020 H\u0016JI\u0010!\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u000b0\"2\u0011\u0010#\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u000b0\"2\u001c\u0010$\u001a\u0018\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u000b\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u000b0%H\u0003\u00a2\u0006\u0002\u0010&J\u001e\u0010$\u001a\u0018\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u000b\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u000b0%H\u0002J\b\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0017J&\u0010.\u001a\u00020/2\r\u00100\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\u000b2\r\u00101\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\u000bH\u0002J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u000206H\u0003J\u001d\u00107\u001a\u0002032\u000b\u00104\u001a\u00070\b\u00a2\u0006\u0002\b\u000b2\u0006\u00105\u001a\u000206H\u0003J\u0010\u00108\u001a\u0002032\u0006\u00109\u001a\u00020:H\u0003J\u0010\u0010;\u001a\u00020 2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020 2\u0006\u0010<\u001a\u00020=H\u0016J\"\u0010?\u001a\u00020 *\u00020@2\u0013\b\u0004\u0010A\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\bC0BH\u0083\bJ_\u0010D\u001a\u000203*\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u000b0\"2\f\u0010E\u001a\b\u0012\u0004\u0012\u0002030B2\r\u00101\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\u000b2\u001c\u0010$\u001a\u0018\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u000b\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u000b0F2\u0006\u0010G\u001a\u000206H\u0002\u00a2\u0006\u0002\u0010HJ\u001c\u0010I\u001a\n J*\u0004\u0018\u00010303*\u0002032\u0006\u0010G\u001a\u000206H\u0002R\u001f\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001f\u0010\u0016\u001a\u00070\b\u00a2\u0006\u0002\b\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u001f\u0010\u0019\u001a\u00070\b\u00a2\u0006\u0002\b\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u001f\u0010\u001c\u001a\u00070\b\u00a2\u0006\u0002\b\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u000f\u00a8\u0006L"}, d2={"Lcom/jetbrains/lang/makefile/MakefileRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/intellij/execution/configurations/RunProfileState;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/jetbrains/lang/makefile/MakefileRunConfigurationFactory;", "name", "", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/lang/makefile/MakefileRunConfigurationFactory;Ljava/lang/String;)V", "arguments", "Lcom/intellij/openapi/util/NlsSafe;", "getArguments", "()Ljava/lang/String;", "setArguments", "(Ljava/lang/String;)V", "environmentVariables", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "getEnvironmentVariables", "()Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "setEnvironmentVariables", "(Lcom/intellij/execution/configuration/EnvironmentVariablesData;)V", "filename", "getFilename", "setFilename", "target", "getTarget", "setTarget", "workingDirectory", "getWorkingDirectory", "setWorkingDirectory", "checkConfiguration", "", "customizeCommandAndEnvironment", "", "command", "environment", "", "([Ljava/lang/String;Ljava/util/Map;)[Ljava/lang/String;", "getConfigurationEditor", "Lcom/jetbrains/lang/makefile/MakefileRunConfigurationEditor;", "getState", "executor", "Lcom/intellij/execution/Executor;", "executionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "makeSwitches", "Lcom/intellij/execution/configurations/ParametersList;", "makefile", "workDirectory", "newCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "localMakePath", "useCygwin", "", "newCommandLineLocal", "newCommandLineWsl", "remoteMakePath", "Lcom/intellij/execution/wsl/WslPath;", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "debugInBackground", "Lcom/intellij/openapi/diagnostic/Logger;", "lazyMessage", "Lkotlin/Function0;", "Lorg/jetbrains/annotations/NonNls;", "toCommandLine", "commandLineInit", "", "useCygwinLaunch", "([Ljava/lang/String;Lkotlin/jvm/functions/Function0;Ljava/lang/String;Ljava/util/Map;Z)Lcom/intellij/execution/configurations/GeneralCommandLine;", "withUseCygwinLaunchEx", "kotlin.jvm.PlatformType", "Companion", "intellij.makefile"})
@SourceDebugExtension(value={"SMAP\nMakefileRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MakefileRunConfiguration.kt\ncom/jetbrains/lang/makefile/MakefileRunConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,330:1\n323#1,6:331\n1#2:337\n1789#3,3:338\n13#4:341\n*S KotlinDebug\n*F\n+ 1 MakefileRunConfiguration.kt\ncom/jetbrains/lang/makefile/MakefileRunConfiguration\n*L\n160#1:331,6\n301#1:338,3\n36#1:341\n*E\n"})
public final class MakefileRunConfiguration
extends LocatableConfigurationBase<RunProfileState> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private String filename;
    @NotNull
    private String target;
    @NotNull
    private String workingDirectory;
    @NotNull
    private EnvironmentVariablesData environmentVariables;
    @NotNull
    private String arguments;
    @NotNull
    private static final Logger LOGGER;
    @Deprecated
    @NotNull
    public static final String MAKEFILE = "makefile";
    @Deprecated
    @NotNull
    public static final String FILENAME = "filename";
    @Deprecated
    @NotNull
    public static final String TARGET = "target";
    @Deprecated
    @NotNull
    public static final String WORKING_DIRECTORY = "workingDirectory";
    @Deprecated
    @NotNull
    public static final String ARGUMENTS = "arguments";
    @NotNull
    private static final String SWITCH_FILE = "-f";
    @NotNull
    private static final String SWITCH_DIRECTORY = "-C";

    public MakefileRunConfiguration(@NotNull Project project, @NotNull MakefileRunConfigurationFactory factory, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)factory), (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(project, (ConfigurationFactory)factory, name);
        this.filename = "";
        this.target = "";
        this.workingDirectory = "";
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"DEFAULT");
        this.environmentVariables = environmentVariablesData;
        this.arguments = "";
    }

    @NotNull
    public final String getFilename() {
        return this.filename;
    }

    public final void setFilename(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.filename = string;
    }

    @NotNull
    public final String getTarget() {
        return this.target;
    }

    public final void setTarget(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.target = string;
    }

    @NotNull
    public final String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setWorkingDirectory(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.workingDirectory = string;
    }

    @NotNull
    public final EnvironmentVariablesData getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public final void setEnvironmentVariables(@NotNull EnvironmentVariablesData environmentVariablesData) {
        Intrinsics.checkNotNullParameter((Object)environmentVariablesData, (String)"<set-?>");
        this.environmentVariables = environmentVariablesData;
    }

    @NotNull
    public final String getArguments() {
        return this.arguments;
    }

    public final void setArguments(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.arguments = string;
    }

    public void checkConfiguration() {
    }

    @NotNull
    public MakefileRunConfigurationEditor getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new MakefileRunConfigurationEditor(project);
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        Element child = element.getOrCreateChild(MAKEFILE);
        child.setAttribute(FILENAME, this.filename);
        child.setAttribute(TARGET, this.target);
        child.setAttribute(WORKING_DIRECTORY, this.workingDirectory);
        child.setAttribute(ARGUMENTS, this.arguments);
        this.environmentVariables.writeExternal(child);
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        Element child = element.getChild(MAKEFILE);
        if (child != null) {
            String string;
            String string2;
            String string3;
            String string4 = child.getAttributeValue(FILENAME);
            if (string4 == null) {
                string4 = this.filename = "";
            }
            if ((string3 = child.getAttributeValue(TARGET)) == null) {
                string3 = this.target = "";
            }
            if ((string2 = child.getAttributeValue(WORKING_DIRECTORY)) == null) {
                string2 = this.workingDirectory = "";
            }
            if ((string = child.getAttributeValue(ARGUMENTS)) == null) {
                string = "";
            }
            this.arguments = string;
            EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.readExternal((Element)child);
            Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"readExternal(...)");
            this.environmentVariables = environmentVariablesData;
        }
    }

    @RequiresEdt
    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)executionEnvironment, (String)"executionEnvironment");
        MakeSettings makeSettings = ((MakefileProjectSettings)this.getProject().getService(MakefileProjectSettings.class)).getSettings();
        Object object = makeSettings;
        if (object == null || (object = ((MakeSettings)object).getPath()) == null) {
            object = "/usr/bin/make";
        }
        Object makePath = object;
        MakeSettings makeSettings2 = makeSettings;
        boolean useCygwin = makeSettings2 != null ? makeSettings2.getUseCygwin() : false;
        return (RunProfileState)new CommandLineState(executionEnvironment, this, (String)makePath, useCygwin){
            final /* synthetic */ MakefileRunConfiguration this$0;
            final /* synthetic */ String $makePath;
            final /* synthetic */ boolean $useCygwin;
            {
                this.this$0 = $receiver;
                this.$makePath = $makePath;
                this.$useCygwin = $useCygwin;
                super($executionEnvironment);
            }

            @NotNull
            protected ProcessHandler startProcess() {
                GeneralCommandLine cmd = MakefileRunConfiguration.access$newCommandLine(this.this$0, this.$makePath, this.$useCygwin);
                ColoredProcessHandler processHandler = new ColoredProcessHandler(cmd);
                processHandler.setShouldKillProcessSoftly(true);
                ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)processHandler));
                return (ProcessHandler)processHandler;
            }
        };
    }

    @RequiresEdt
    private final GeneralCommandLine newCommandLine(String localMakePath, boolean useCygwin) throws ExecutionException {
        WslPath remoteMakePath = WslPath.Companion.parseWindowsUncPath(localMakePath);
        return remoteMakePath == null ? this.newCommandLineLocal(localMakePath, useCygwin) : this.newCommandLineWsl(remoteMakePath);
    }

    @RequiresEdt
    private final GeneralCommandLine newCommandLineLocal(String localMakePath, boolean useCygwin) {
        String string;
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
        PathMacroManager macroManager = pathMacroManager;
        String localMakefile = macroManager.expandPath(this.filename);
        if (((CharSequence)this.workingDirectory).length() > 0) {
            string = macroManager.expandPath(this.workingDirectory);
        } else {
            Path path = Paths.get(localMakefile, new String[0]).getParent();
            string = path != null ? ((Object)path).toString() : null;
        }
        String localWorkDirectory = string;
        ParametersList makeSwitches = this.makeSwitches(localMakefile, localWorkDirectory);
        Map<String, String> environment = this.environment();
        Object[] objectArray = new String[]{localMakePath};
        String[] stringArray = makeSwitches.getArray();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getArray(...)");
        String[] command = (String[])ArraysKt.plus((Object[])objectArray, (Object[])stringArray);
        command = this.customizeCommandAndEnvironment(command, environment);
        return this.toCommandLine(command, (Function0<? extends GeneralCommandLine>)((Function0)newCommandLineLocal.1.INSTANCE), localWorkDirectory, environment, useCygwin);
    }

    @RequiresEdt
    private final GeneralCommandLine newCommandLineWsl(WslPath remoteMakePath) throws ExecutionException {
        String string;
        String localWorkDirectory;
        String string2;
        WSLDistribution distribution = remoteMakePath.getDistribution();
        MakefileRunConfiguration makefileRunConfiguration = this;
        Logger $this$debugInBackground$iv = LOGGER;
        boolean $i$f$debugInBackground = false;
        if ($this$debugInBackground$iv.isDebugEnabled()) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable($this$debugInBackground$iv, distribution){
                final /* synthetic */ Logger $this_debugInBackground;
                final /* synthetic */ WSLDistribution $distribution$inlined;
                {
                    this.$this_debugInBackground = $receiver;
                    this.$distribution$inlined = wSLDistribution;
                }

                public final void run() {
                    Logger logger = this.$this_debugInBackground;
                    boolean bl = false;
                    logger.debug("The current user's home within the " + this.$distribution$inlined.getMsId() + " WSL distribution is " + this.$distribution$inlined.getUserHome() + ". Edit /etc/wsl.conf to change the default user.");
                }
            });
        }
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
        PathMacroManager macroManager = pathMacroManager;
        String localMakefile = macroManager.expandPath(this.filename);
        String remoteMakefile = distribution.getWslPath(localMakefile);
        if (((CharSequence)this.workingDirectory).length() > 0) {
            string2 = macroManager.expandPath(this.workingDirectory);
        } else {
            Path path = Paths.get(localMakefile, new String[0]).getParent();
            string2 = path != null ? ((Object)path).toString() : null;
        }
        String string3 = localWorkDirectory = string2;
        if (string3 != null) {
            String p0 = string3;
            boolean bl = false;
            string = distribution.getWslPath(p0);
        } else {
            string = null;
        }
        String remoteWorkDirectory = string;
        ParametersList makeSwitches = this.makeSwitches(remoteMakefile, remoteWorkDirectory);
        Map<String, String> environment = this.environment();
        Object[] objectArray = new String[]{remoteMakePath.getLinuxPath()};
        String[] stringArray = makeSwitches.getArray();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getArray(...)");
        String[] command = (String[])ArraysKt.plus((Object[])objectArray, (Object[])stringArray);
        command = this.customizeCommandAndEnvironment(command, environment);
        GeneralCommandLine localCommandLine2 = this.toCommandLine(command, (Function0<? extends GeneralCommandLine>)((Function0)newCommandLineWsl.localCommandLine.1.INSTANCE), localWorkDirectory, environment, false);
        WSLCommandLineOptions wSLCommandLineOptions = new WSLCommandLineOptions().setLaunchWithWslExe(true).setExecuteCommandInShell(false).setRemoteWorkingDirectory(remoteWorkDirectory).setPassEnvVarsUsingInterop(true);
        Intrinsics.checkNotNullExpressionValue((Object)wSLCommandLineOptions, (String)"setPassEnvVarsUsingInterop(...)");
        WSLCommandLineOptions wslOptions = wSLCommandLineOptions;
        GeneralCommandLine generalCommandLine = distribution.patchCommandLine(localCommandLine2, this.getProject(), wslOptions);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"patchCommandLine(...)");
        return generalCommandLine;
    }

    private final ParametersList makeSwitches(String makefile, String workDirectory) {
        String[] stringArray;
        ParametersList makeSwitches = new ParametersList();
        if (makefile != null) {
            stringArray = new String[]{SWITCH_FILE, makefile};
            makeSwitches.addAll(stringArray);
        }
        if (workDirectory != null) {
            stringArray = new String[]{SWITCH_DIRECTORY, workDirectory};
            makeSwitches.addAll(stringArray);
        }
        makeSwitches.addParametersString(this.arguments);
        if (((CharSequence)this.target).length() > 0) {
            makeSwitches.addParametersString(this.target);
        }
        return makeSwitches;
    }

    private final Map<String, String> environment() {
        Map map;
        if (this.environmentVariables.isPassParentEnvs()) {
            Map map2 = EnvironmentUtil.getEnvironmentMap();
            map = map2;
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvironmentMap(...)");
        } else {
            map = MapsKt.emptyMap();
        }
        Map parentEnvironment = map;
        Map map3 = this.environmentVariables.getEnvs();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getEnvs(...)");
        return MapsKt.toMutableMap((Map)MapsKt.plus((Map)parentEnvironment, (Map)map3));
    }

    private final GeneralCommandLine toCommandLine(String[] $this$toCommandLine, Function0<? extends GeneralCommandLine> commandLineInit, String workDirectory, Map<String, String> environment, boolean useCygwinLaunch) {
        GeneralCommandLine generalCommandLine = this.withUseCygwinLaunchEx((GeneralCommandLine)commandLineInit.invoke(), useCygwinLaunch).withExePath($this$toCommandLine[0]).withWorkDirectory(workDirectory).withEnvironment(environment).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.NONE).withParameters(ArraysKt.slice((Object[])$this$toCommandLine, (IntRange)RangesKt.until((int)1, (int)$this$toCommandLine.length))).withCharset(EncodingManager.getInstance().getDefaultConsoleEncoding());
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withCharset(...)");
        return generalCommandLine;
    }

    private final GeneralCommandLine withUseCygwinLaunchEx(GeneralCommandLine $this$withUseCygwinLaunchEx, boolean useCygwinLaunch) {
        return $this$withUseCygwinLaunchEx instanceof PtyCommandLine ? (GeneralCommandLine)((PtyCommandLine)$this$withUseCygwinLaunchEx).withUseCygwinLaunch(useCygwinLaunch) : $this$withUseCygwinLaunchEx;
    }

    /*
     * Unable to fully structure code
     */
    @RequiresEdt
    private final String[] customizeCommandAndEnvironment(String[] command, Map<String, String> environment) {
        lastCommand = null;
        lastCommand = command;
        try {
            $this$fold$iv = LocalTerminalCustomizer.EP_NAME.getExtensionList();
            $i$f$fold = false;
            accumulator$iv = command;
            var7_8 = $this$fold$iv.iterator();
            if (var7_8.hasNext()) {
                element$iv = var7_8.next();
                var9_10 = (LocalTerminalCustomizer)element$iv;
                acc = accumulator$iv;
                $i$a$-fold-MakefileRunConfiguration$customizeCommandAndEnvironment$1 = false;
                var12_13 = customizer.customizeCommandAndEnvironment(this.getProject(), null, acc, environment);
                ** finally { 
            }
            var4_4 = accumulator$iv;
        }
        catch (Throwable _) {
            var4_4 = lastCommand;
        }
        return var4_4;
    }

    @RequiresEdt
    private final void debugInBackground(Logger $this$debugInBackground, Function0<String> lazyMessage) {
        boolean $i$f$debugInBackground = false;
        if ($this$debugInBackground.isDebugEnabled()) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable($this$debugInBackground, lazyMessage){
                final /* synthetic */ Logger $this_debugInBackground;
                final /* synthetic */ Function0<String> $lazyMessage;
                {
                    this.$this_debugInBackground = $receiver;
                    this.$lazyMessage = $lazyMessage;
                }

                public final void run() {
                    this.$this_debugInBackground.debug((String)this.$lazyMessage.invoke());
                }
            });
        }
    }

    public static final /* synthetic */ GeneralCommandLine access$newCommandLine(MakefileRunConfiguration $this, String localMakePath, boolean useCygwin) {
        return $this.newCommandLine(localMakePath, useCygwin);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MakefileRunConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/lang/makefile/MakefileRunConfiguration$Companion;", "", "()V", "ARGUMENTS", "", "FILENAME", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "MAKEFILE", "SWITCH_DIRECTORY", "SWITCH_FILE", "TARGET", "WORKING_DIRECTORY", "intellij.makefile"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

