/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.runner;

import com.google.gson.stream.JsonReader;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.plugins.meteor.runner.MeteorFileFinderKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/plugins/meteor/runner/MeteorFileFinder;", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "workDir", "", "(Ljava/lang/String;)V", "isopacksDir", "Ljava/io/File;", "localPackagesExists", "Lcom/intellij/util/ThreeState;", "meteorDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "virtualDir", "findFileForLocalPackage", "url", "Lcom/intellij/util/Url;", "findFileForMeteorSpecificUrl", "findFileInWorkingDirectory", "path", "getRemoteUrls", "", "file", "guessFile", "project", "Lcom/intellij/openapi/project/Project;", "isOnlySourceMappedBreakpoints", "", "readSourceRoot", "buildInfo", "packageName", "intellij.javascript.chrome.connector"})
public final class MeteorFileFinder
implements DebuggableFileFinder {
    @Nullable
    private final VirtualFile virtualDir;
    @Nullable
    private final VirtualFile meteorDir;
    @NotNull
    private final File isopacksDir;
    @NotNull
    private ThreeState localPackagesExists;

    public MeteorFileFinder(@NotNull String workDir) {
        Intrinsics.checkNotNullParameter((Object)workDir, (String)"workDir");
        VirtualFile virtualFile = this.virtualDir = LocalFileSystem.getInstance().findFileByPath(workDir);
        this.meteorDir = virtualFile != null ? virtualFile.findChild(".meteor") : null;
        this.isopacksDir = new File(workDir, ".meteor" + File.separatorChar + "local" + File.separatorChar + "isopacks");
        this.localPackagesExists = ThreeState.UNSURE;
        JavaScriptDebugProcessKt.getLOG().assertTrue(this.virtualDir != null);
        JavaScriptDebugProcessKt.getLOG().assertTrue(this.meteorDir != null);
    }

    @Nullable
    public VirtualFile guessFile(@NotNull Url url, @NotNull Project project) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile file = this.findFileForMeteorSpecificUrl(url);
        if (file == null && this.virtualDir != null) {
            String string = url.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            virtualFile = this.findFileInWorkingDirectory(string);
        } else {
            virtualFile = file;
        }
        return virtualFile;
    }

    private final VirtualFile findFileInWorkingDirectory(String path) {
        int i = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        while (i != -1) {
            String subPath;
            boolean bl;
            Intrinsics.checkNotNullExpressionValue((Object)path.substring(i + 1, path.length()), (String)"substring(...)");
            boolean bl2 = bl = this.virtualDir != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            VirtualFile virtualFile = this.virtualDir;
            Intrinsics.checkNotNull((Object)virtualFile);
            VirtualFile file = virtualFile.findFileByRelativePath(subPath);
            if (file != null) {
                return file;
            }
            i = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)(i + 2), (boolean)false, (int)4, null);
        }
        return null;
    }

    public boolean isOnlySourceMappedBreakpoints(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean result = super.isOnlySourceMappedBreakpoints(file);
        return !result && this.meteorDir != null ? !VfsUtilCore.isAncestor((VirtualFile)this.meteorDir, (VirtualFile)file, (boolean)true) : result;
    }

    private final VirtualFile findFileForMeteorSpecificUrl(Url url) {
        try {
            String string = url.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String scriptPath = string;
            String urlString = url.toString();
            String meteorDirSlashedName = "/.meteor/";
            int index = StringsKt.lastIndexOf$default((CharSequence)scriptPath, (String)meteorDirSlashedName, (int)0, (boolean)false, (int)6, null);
            if (index != -1 && StringsKt.startsWith$default((String)scriptPath, (String)"local/build/programs/server/app/", (int)(index + meteorDirSlashedName.length()), (boolean)false, (int)4, null)) {
                String string2 = scriptPath.substring(0, index + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String sourceRoot = string2;
                JavaScriptDebugProcessKt.getLOG().assertTrue(StringsKt.startsWith$default((String)urlString, (String)"meteor://\ud83d\udcbbapp/", (boolean)false, (int)2, null));
                LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                String string3 = urlString.substring(15);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                return localFileSystem.findFileByPath(sourceRoot + string3);
            }
            return this.findFileForLocalPackage(url);
        }
        catch (Exception e) {
            JavaScriptDebugProcessKt.getLOG().warn((Throwable)e);
            return null;
        }
    }

    private final VirtualFile findFileForLocalPackage(Url url) {
        File buildInfo;
        int i;
        String urlString = url.toString();
        Object packageName = null;
        String packageFileName = null;
        int prefixLength = -1;
        if (StringsKt.startsWith$default((String)urlString, (String)"meteor://\ud83d\udcbbapp/", (boolean)false, (int)2, null)) {
            String string = PathUtil.getFileName((String)url.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            String fileName = string;
            int dotIndex = StringsKt.indexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dotIndex > 0) {
                int firstUnderscoreIndex = StringsKt.indexOf$default((CharSequence)fileName, (char)'_', (int)0, (boolean)false, (int)4, null);
                if (firstUnderscoreIndex > 0 && firstUnderscoreIndex < dotIndex) {
                    String string2 = fileName.substring(0, dotIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    packageFileName = string2;
                    String string3 = fileName.substring(0, firstUnderscoreIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    String string4 = fileName.substring(firstUnderscoreIndex + 1, dotIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    packageName = string3 + ":" + string4;
                } else {
                    String string5 = fileName.substring(0, dotIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    packageFileName = string5;
                    packageName = packageFileName;
                }
                prefixLength = 14;
                if (StringsKt.startsWith$default((String)urlString, (String)"packages/", (int)15, (boolean)false, (int)4, null)) {
                    Character c = StringsKt.getOrNull((CharSequence)urlString, (int)((prefixLength += 9) + 1 + ((String)packageName).length()));
                    char c2 = '/';
                    if (c != null && c.charValue() == c2 && (StringsKt.startsWith$default((String)urlString, (String)packageFileName, (int)(prefixLength + 1), (boolean)false, (int)4, null) || StringsKt.startsWith$default((String)urlString, (String)packageName, (int)(prefixLength + 1), (boolean)false, (int)4, null))) {
                        prefixLength += ((String)packageName).length() + 1;
                    }
                }
            }
        } else if (!SourceResolver.Companion.isAbsolute(urlString) && (i = StringsKt.indexOf$default((CharSequence)urlString, (char)'/', (int)0, (boolean)false, (int)6, null)) > 0) {
            String string = urlString.substring(0, i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            packageName = string;
        }
        if (packageName == null) {
            return null;
        }
        File isopacksDir = this.isopacksDir;
        if (this.localPackagesExists == ThreeState.UNSURE) {
            ThreeState threeState = ThreeState.fromBoolean((boolean)isopacksDir.exists());
            Intrinsics.checkNotNullExpressionValue((Object)threeState, (String)"fromBoolean(...)");
            this.localPackagesExists = threeState;
        }
        if (this.localPackagesExists == ThreeState.NO) {
            return null;
        }
        String string = packageFileName;
        if (string == null) {
            string = StringsKt.replace$default((String)packageName, (char)':', (char)'_', (boolean)false, (int)4, null);
        }
        if (!(buildInfo = new File(isopacksDir, string + File.separatorChar + "isopack-buildinfo.json")).exists()) {
            return null;
        }
        String string6 = this.readSourceRoot(buildInfo, (String)packageName);
        if (string6 == null) {
            return null;
        }
        Object sourceRoot = string6;
        if (SystemInfo.isWindows && ((String)sourceRoot).length() > 4 && ((String)sourceRoot).charAt(0) == '/' && ((String)sourceRoot).charAt(2) == '/') {
            char c = ((String)sourceRoot).charAt(1);
            String string7 = ((String)sourceRoot).substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            sourceRoot = c + ":" + string7;
        }
        if (prefixLength == -1) {
            prefixLength = ((String)packageName).length();
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        String string8 = urlString.substring(prefixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
        return localFileSystem.findFileByPath((String)sourceRoot + string8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readSourceRoot(File buildInfo, String packageName) {
        String sourceRoot = null;
        Closeable closeable = new FileInputStream(buildInfo);
        Object object = Charsets.UTF_8;
        closeable = (Closeable)new JsonReader((Reader)new InputStreamReader((InputStream)closeable, (Charset)object));
        object = null;
        try {
            JsonReader reader = (JsonReader)closeable;
            boolean bl = false;
            if (MeteorFileFinderKt.access$readUntilName(reader, "pluginProviderPackageMap")) {
                String string = packageName;
                Intrinsics.checkNotNull((Object)string);
                if (MeteorFileFinderKt.access$readUntilName(reader, string)) {
                    reader.beginObject();
                    String kind = null;
                    while (reader.hasNext()) {
                        String string2 = reader.nextName();
                        if (Intrinsics.areEqual((Object)string2, (Object)"kind")) {
                            kind = reader.nextString();
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)string2, (Object)"sourceRoot")) {
                            sourceRoot = reader.nextString();
                            continue;
                        }
                        reader.skipValue();
                    }
                    if (!Intrinsics.areEqual((Object)"local", kind)) {
                        String string3 = null;
                        return string3;
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return sourceRoot;
    }

    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return CollectionsKt.listOf((Object)Urls.newLocalFileUrl((String)string));
    }
}

