/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.portForwarding.socket;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.remoteDev.tracing.RdctScopesKt;
import com.intellij.util.ApplicationKt;
import com.jetbrains.codeWithMe.model.DebugTrafficInfo;
import com.jetbrains.codeWithMe.model.PortStrategy;
import com.jetbrains.codeWithMe.model.RdConnection;
import com.jetbrains.codeWithMe.model.RdForwardedPort;
import com.jetbrains.codeWithMe.model.RdPortState;
import com.jetbrains.codeWithMe.model.RdSocketAddress;
import com.jetbrains.codeWithMe.model.SocketState;
import com.jetbrains.codeWithMe.model.k;
import com.jetbrains.rd.platform.codeWithMe.CodeWithMePlatformBundle;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortState;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketWrapper;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.utils.PortForwardingUtilsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.threading.SingleThreadScheduler;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u0001:\u0001.B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000eJ\b\u0010%\u001a\u00020\nH\u0002J\u0010\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\nH\u0002J\u0010\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u000eH\u0002J\u0010\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,H\u0002J\u0006\u0010-\u001a\u00020#R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006/"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketWrapper;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "rdPort", "Lcom/jetbrains/codeWithMe/model/RdForwardedPort;", "uniqueId", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/codeWithMe/model/RdForwardedPort;Ljava/lang/String;)V", "_serverSocket", "Ljava/net/ServerSocket;", "_trafficThread", "Ljava/lang/Thread;", "acceptTimeout", "", "getAcceptTimeout", "()I", "clientConnectionTimeout", "getClientConnectionTimeout", "meter", "Lio/opentelemetry/api/metrics/Meter;", "name", "getRdPort", "()Lcom/jetbrains/codeWithMe/model/RdForwardedPort;", "receivedBytesCounter", "Lio/opentelemetry/api/metrics/LongCounter;", "kotlin.jvm.PlatformType", "sentBytesCounter", "serverSocket", "getServerSocket", "()Ljava/net/ServerSocket;", "trafficThread", "getTrafficThread", "()Ljava/lang/Thread;", "changeListeningSocket", "", "newPort", "createListeningSocket", "createListeningThread", "socket", "createNewSocket", "port", "monitorOneConnection", "clientSocket", "Ljava/net/Socket;", "start", "Companion", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nServerSocketWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerSocketWrapper.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketWrapper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,324:1\n58#2,5:325\n58#2,5:330\n13#2:336\n13#3:335\n*S KotlinDebug\n*F\n+ 1 ServerSocketWrapper.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketWrapper\n*L\n144#1:325,5\n281#1:330,5\n33#1:336\n33#1:335\n*E\n"})
public final class ServerSocketWrapper {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final RdForwardedPort rdPort;
    @NotNull
    private final String name;
    @NotNull
    private final Meter meter;
    private final LongCounter sentBytesCounter;
    private final LongCounter receivedBytesCounter;
    @Nullable
    private ServerSocket _serverSocket;
    @Nullable
    private Thread _trafficThread;
    @NotNull
    private static final Logger logger;
    private static final String[] a;
    private static final String[] b;

    public ServerSocketWrapper(@NotNull Lifetime lifetime, @NotNull RdForwardedPort rdPort, @NotNull String uniqueId) {
        long l2 = 13378224924585L;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)ServerSocketWrapper.a(598203480 + 1092, -598203480 - -23044, (int)l2));
        Intrinsics.checkNotNullParameter((Object)rdPort, (String)ServerSocketWrapper.a(598203480 + 1093, -598203480 - -10739, (int)l2));
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)ServerSocketWrapper.a(598203480 + 1094, -598203480 + -6944, (int)l2));
        this.lifetime = lifetime;
        this.rdPort = rdPort;
        int[] nArray = ServerSocketPortState.C();
        this.name = StringsKt.take((String)uniqueId, (int)7);
        this.meter = TelemetryManager.Companion.getMeter(RdctScopesKt.RDCT);
        this.sentBytesCounter = this.meter.counterBuilder(ServerSocketWrapper.a(598203480 + 1095, 598203480 - 20405, (int)l2) + this.name).setUnit(ServerSocketWrapper.a(598203480 + 1088, 598203480 - 6030, (int)l2)).build();
        this.receivedBytesCounter = this.meter.counterBuilder(ServerSocketWrapper.a(598203480 + 1089, -598203480 + -185, (int)l2) + this.name).setUnit(ServerSocketWrapper.a(598203480 + 1090, 598203480 - 19579, (int)l2)).build();
        this.lifetime.onTermination((Function0)new Function0<Unit>(){

            /*
             * Loose catch block
             */
            public final void invoke() {
                block7: {
                    long l2 = 32624606086239L;
                    int[] nArray = ServerSocketPortState.C();
                    try {
                        ServerSocket serverSocket;
                        block6: {
                            serverSocket = this.getServerSocket();
                            if (nArray != null) break block6;
                            try {
                                block8: {
                                    if (serverSocket.isClosed()) break block7;
                                    break block8;
                                    catch (Throwable throwable) {
                                        throw 1.a(throwable);
                                    }
                                }
                                serverSocket = this.getServerSocket();
                            }
                            catch (Throwable throwable) {
                                throw 1.a(throwable);
                            }
                        }
                        serverSocket.close();
                    }
                    catch (Throwable throwable) {
                        Companion.getLogger().warn(throwable);
                    }
                }
            }

            private static Throwable a(Throwable throwable) {
                return throwable;
            }
        });
        int[] nArray2 = nArray;
        try {
            if (CodeWithMePlatformBundle.C() != null) {
                ServerSocketPortState.C(new int[5]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ServerSocketWrapper.a(illegalStateException);
        }
    }

    @NotNull
    public final RdForwardedPort getRdPort() {
        return this.rdPort;
    }

    private final int getAcceptTimeout() {
        long l2 = 58638778089823L;
        return Registry.intValue((String)ServerSocketWrapper.a(410380170 + 7907, -410380170 + -14066, (int)l2));
    }

    private final int getClientConnectionTimeout() {
        long l2 = 73611621867736L;
        return Registry.intValue((String)ServerSocketWrapper.a(-177337710 + -((char)-23891), -177337710 + -((char)-7898), (int)l2));
    }

    private final ServerSocket getServerSocket() {
        ServerSocket serverSocket;
        block5: {
            long l2;
            block4: {
                l2 = 95409436199035L;
                int[] nArray = ServerSocketPortState.C();
                try {
                    try {
                        if (nArray != null) break block4;
                        serverSocket = this._serverSocket;
                        if (serverSocket != null) break block5;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ServerSocketWrapper.a(illegalStateException);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw ServerSocketWrapper.a(illegalStateException);
                }
            }
            throw new IllegalStateException(ServerSocketWrapper.a(-1032700530 - -4537, 1032700530 - 15060, (int)l2).toString());
        }
        return serverSocket;
    }

    private final Thread getTrafficThread() {
        Thread thread2;
        block5: {
            long l2;
            block4: {
                l2 = 43905160937755L;
                int[] nArray = ServerSocketPortState.C();
                try {
                    try {
                        if (nArray != null) break block4;
                        thread2 = this._trafficThread;
                        if (thread2 != null) break block5;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ServerSocketWrapper.a(illegalStateException);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw ServerSocketWrapper.a(illegalStateException);
                }
            }
            throw new IllegalStateException(ServerSocketWrapper.a(-2005239930 + -12642, -2005239930 + -13520, (int)l2).toString());
        }
        return thread2;
    }

    public final void start() {
        long l2 = 52695270668726L;
        this._serverSocket = this.createListeningSocket();
        this._trafficThread = this.createListeningThread(this.getServerSocket());
        logger.info(ServerSocketWrapper.a(-316927260 - -27556, 316927260 - 5156, (int)l2) + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.rdPort.getRdPortState()))) + ServerSocketWrapper.a(-316927260 - -27563, -316927260 + -1264, (int)l2) + this.rdPort.getPortNumber());
        this.getTrafficThread().start();
    }

    public final void changeListeningSocket(int newPort) {
        ServerSocket serverSocket = this.createNewSocket(newPort);
        Thread thread2 = this.createListeningThread(serverSocket);
        this.getServerSocket().close();
        this._serverSocket = serverSocket;
        this._trafficThread = thread2;
        ApplicationKt.getApplication().invokeLater(() -> ServerSocketWrapper.changeListeningSocket$lambda$0(this), ModalityState.any());
        this.getTrafficThread().start();
    }

    private final ServerSocket createNewSocket(int port) throws IllegalStateException, IOException {
        Object object;
        ServerSocket serverSocket;
        block15: {
            Object object2;
            long l2;
            block12: {
                block13: {
                    l2 = 34854093983874L;
                    serverSocket = new ServerSocket();
                    int[] nArray = ServerSocketPortState.C();
                    try {
                        try {
                            serverSocket.setReuseAddress(true);
                            object2 = this;
                            if (nArray != null) break block12;
                            if (((ServerSocketWrapper)object2).getAcceptTimeout() <= 0) break block13;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw ServerSocketWrapper.a(illegalStateException);
                        }
                        serverSocket.setSoTimeout(this.getAcceptTimeout());
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ServerSocketWrapper.a(illegalStateException);
                    }
                }
                object2 = this.rdPort.getRdPortState().getValueOrNull();
            }
            try {
                block14: {
                    try {
                        try {
                            try {
                                object = (RdPortState)object2;
                                if (object == null || (object = object.getSocketAddress()) == null) break block14;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw ServerSocketWrapper.a(illegalStateException);
                            }
                            if ((object = PortForwardingUtilsKt.toSocketAddress((RdSocketAddress)object)) == null) break block14;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw ServerSocketWrapper.a(illegalStateException);
                        }
                        if ((object = ((InetSocketAddress)object).getAddress()) != null) break block15;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ServerSocketWrapper.a(illegalStateException);
                    }
                }
                object = Inet4Address.getByName(ServerSocketWrapper.a(-434365980 + -16938, 434365980 + 18132, (int)l2));
            }
            catch (IllegalStateException illegalStateException) {
                throw ServerSocketWrapper.a(illegalStateException);
            }
        }
        Object object3 = object;
        serverSocket.bind(new InetSocketAddress((InetAddress)object3, port), 1000);
        return serverSocket;
    }

    /*
     * Unable to fully structure code
     */
    private final ServerSocket createListeningSocket() {
        block16: {
            block15: {
                block14: {
                    var1_1 = 39579090429879L;
                    var4_2 = this.rdPort.getPortStrategy();
                    var3_3 = ServerSocketPortState.C();
                    if (var3_3 != null) break block14;
                    try {
                        v0 = this.rdPort.getDesiredSocketAddress();
                        if (v0 != null) break block15;
                        break block14;
                        catch (IOException v1) {
                            throw ServerSocketWrapper.a(v1);
                        }
                    }
                    catch (IOException v2) {
                        throw ServerSocketWrapper.a(v2);
                    }
                }
                v0 = new RdSocketAddress(ServerSocketWrapper.a(-966772320 + -22804, 966772320 + (char)-23810, (int)var1_1), this.rdPort.getPortNumber());
            }
            var5_4 = v0;
            var6_5 = new ServerSocket();
            var6_5.setReuseAddress(true);
            v3 = this;
            if (var3_3 != null) ** GOTO lbl38
            try {
                block17: {
                    if (v3.getAcceptTimeout() <= 0) break block16;
                    break block17;
                    catch (IOException v4) {
                        throw ServerSocketWrapper.a(v4);
                    }
                }
                var6_5.setSoTimeout(this.getAcceptTimeout());
            }
            catch (IOException v5) {
                throw ServerSocketWrapper.a(v5);
            }
        }
        try {
            var6_5.bind(PortForwardingUtilsKt.toSocketAddress(var5_4), 1000);
            v3 = this;
lbl38:
            // 2 sources

            v3.rdPort.getRdPortState().set((Object)new RdPortState(SocketState.LISTENING, var5_4, null));
            return var6_5;
        }
        catch (IOException var7_6) {
            switch (WhenMappings.$EnumSwitchMapping$0[var4_2.ordinal()]) {
                case 1: {
                    var8_7 = PortForwardingUtilsKt.toSocketAddress(var5_4).getAddress();
                    var6_5.bind(new InetSocketAddress(var8_7, 0), 1000);
                    v6 = this.rdPort.getRdPortState();
                    v7 = var8_7.getHostAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)ServerSocketWrapper.a(-966772320 + -22803, -966772320 + -((char)-23526), (int)var1_1));
                    v8 = var6_5.getLocalSocketAddress();
                    Intrinsics.checkNotNull((Object)v8, (String)ServerSocketWrapper.a(-966772320 + -22798, -966772320 + -((char)-26193), (int)var1_1));
                    v6.set((Object)new RdPortState(SocketState.LISTENING, new RdSocketAddress(v7, ((InetSocketAddress)v8).getPort()), null));
                    return var6_5;
                }
                case 2: {
                    throw var7_6;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void monitorOneConnection(Socket clientSocket) {
        block9: {
            RdConnection rdConnection;
            block10: {
                Object object;
                Logger logger;
                int n2;
                LifetimeDefinition lifetimeDefinition;
                int[] nArray;
                Logger logger2;
                String string;
                int n3;
                long l2;
                block7: {
                    block8: {
                        l2 = 31802203785542L;
                        n3 = this.rdPort.getPortNumber();
                        String string2 = UUID.randomUUID().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)ServerSocketWrapper.a(2029094670 - (char)-1876, -2028963600 + -((char)-1197), (int)l2));
                        string = string2;
                        logger2 = ServerSocketWrapper.logger;
                        nArray = ServerSocketPortState.C();
                        lifetimeDefinition = null;
                        boolean bl = false;
                        try {
                            n2 = logger2.isDebugEnabled();
                            if (nArray != null) break block7;
                            if (n2 == 0) break block8;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw ServerSocketWrapper.a(illegalStateException);
                        }
                        logger = logger2;
                        boolean bl2 = false;
                        String string3 = string;
                        int n4 = n3;
                        String string4 = PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.rdPort.getRdPortState())));
                        int n5 = clientSocket.getPort();
                        logger.debug(ServerSocketWrapper.a(2029094670 - (char)-1875, -2029094670 - -((char)-20602), (int)l2) + n5 + ServerSocketWrapper.a(2029094670 - (char)-1874, 2029094670 - (char)-18366, (int)l2) + string4 + ServerSocketWrapper.a(2029094670 - (char)-1874, 2029094670 - (char)-18366, (int)l2) + n4 + ServerSocketWrapper.a(2029094670 - (char)-1881, 2028963600 + (char)-1345, (int)l2) + string3, (Throwable)lifetimeDefinition);
                    }
                    n2 = this.getClientConnectionTimeout();
                }
                try {
                    if (n2 > 0) {
                        clientSocket.setSoTimeout(this.getClientConnectionTimeout());
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw ServerSocketWrapper.a(illegalStateException);
                }
                logger2 = new SingleThreadScheduler(this.lifetime, ServerSocketWrapper.a(2029094670 - (char)-1880, -2029094670 - -((char)-673), (int)l2) + n3);
                lifetimeDefinition = this.lifetime.createNested();
                Lifetime lifetime = lifetimeDefinition.getLifetime();
                Object object2 = object = new RdConnection(string, clientSocket.getPort());
                boolean bl = false;
                PortForwardingUtilsKt.setScheduler(object2, (IScheduler)logger2);
                rdConnection = object;
                rdConnection.getToServerSocket().advise(lifetime, (Function1)new Function1<DebugTrafficInfo, Unit>(this, clientSocket, string, lifetimeDefinition){
                    final /* synthetic */ ServerSocketWrapper this$0;
                    final /* synthetic */ Socket $clientSocket;
                    final /* synthetic */ String $connectionId;
                    final /* synthetic */ LifetimeDefinition $rdConnectionLifetimeDef;
                    private static final String[] a;
                    private static final String[] b;
                    {
                        this.this$0 = $receiver;
                        this.$clientSocket = $clientSocket;
                        this.$connectionId = $connectionId;
                        this.$rdConnectionLifetimeDef = $rdConnectionLifetimeDef;
                        super(1);
                    }

                    public final void invoke(@NotNull DebugTrafficInfo it) {
                        block4: {
                            long l2;
                            block5: {
                                l2 = 46867656180105L;
                                int[] nArray = ServerSocketPortState.C();
                                Intrinsics.checkNotNullParameter((Object)it, (String)monitorOneConnection.2.a(-973063680 - -14038, -973063680 + -9112, (int)l2));
                                Logger logger = ServerSocketWrapper.Companion.getLogger();
                                int[] nArray2 = nArray;
                                String string = this.$connectionId;
                                boolean bl = false;
                                try {
                                    if (nArray2 != null) break block4;
                                    if (!logger.isTraceEnabled()) break block5;
                                }
                                catch (IOException iOException) {
                                    throw monitorOneConnection.2.a(iOException);
                                }
                                Logger logger2 = logger;
                                boolean bl2 = false;
                                String string2 = string;
                                int n2 = it.getBytes().length;
                                int n3 = it.getCounter();
                                logger2.trace(monitorOneConnection.2.a(-973063680 - -14039, 973063680 + 10201, (int)l2) + n3 + monitorOneConnection.2.a(-973063680 - -14036, 973063680 + 6673, (int)l2) + n2 + monitorOneConnection.2.a(-973063680 - -14037, 973063680 - 6554, (int)l2) + string2);
                            }
                            try {
                                ServerSocketWrapper.access$getReceivedBytesCounter$p(this.this$0).add((long)it.getBytes().length);
                                this.$clientSocket.getOutputStream().write(it.getBytes());
                            }
                            catch (IOException iOException) {
                                ServerSocketWrapper.Companion.getLogger().warn(monitorOneConnection.2.a(-973063680 - -14034, 973063680 + 3609, (int)l2) + this.$connectionId);
                                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$rdConnectionLifetimeDef, (boolean)false, (int)1, null);
                            }
                        }
                    }

                    private static IOException a(IOException iOException) {
                        return iOException;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    static {
                        block20: {
                            block19: {
                                var5 = new String[5];
                                var3_1 = 0;
                                var2_2 = "\u00e3\u00c8\u0010\u00fb@A\u00bb\u00a3\u00aa\u00f2KQ\u0082d\u00f5S\u00d6p\u00d5\u0013\u00e3,K_\u00d5+\u00b0\u00ecT\u001b\u0011i\u0081\u0012\u00bf\u00c3\u00b7h\u00f2";
                                var4_3 = "\u00e3\u00c8\u0010\u00fb@A\u00bb\u00a3\u00aa\u00f2KQ\u0082d\u00f5S\u00d6p\u00d5\u0013\u00e3,K_\u00d5+\u00b0\u00ecT\u001b\u0011i\u0081\u0012\u00bf\u00c3\u00b7h\u00f2".length();
                                var1_4 = 2;
                                var0_5 = -1;
lbl7:
                                // 2 sources

                                while (true) {
                                    v0 = 66;
                                    v1 = ++var0_5;
                                    v2 = var2_2.substring(v1, v1 + var1_4);
                                    v3 = -1;
                                    break block19;
                                    break;
                                }
lbl13:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    var2_2 = "|\u000eZ\u00ea\u00ac\u0083:\u0004\u00a8r_\u00f6x\u00e4%Ek6\u00a2 \u00cf\u0093\u00b1\u00da\u0016\u00185\u0098v\u0005\u00f1v$Q\u001c\u00e2\u00f8#\u0006\u001a\f\u001ek\u00f1{xb:\u001c\u0019ZW\u00cc\u00b5O\u00d89\u001c\u0018F\u0019\u001e\u00b0\u000bL";
                                    var4_3 = "|\u000eZ\u00ea\u00ac\u0083:\u0004\u00a8r_\u00f6x\u00e4%Ek6\u00a2 \u00cf\u0093\u00b1\u00da\u0016\u00185\u0098v\u0005\u00f1v$Q\u001c\u00e2\u00f8#\u0006\u001a\f\u001ek\u00f1{xb:\u001c\u0019ZW\u00cc\u00b5O\u00d89\u001c\u0018F\u0019\u001e\u00b0\u000bL".length();
                                    var1_4 = 6;
                                    var0_5 = -1;
lbl22:
                                    // 2 sources

                                    while (true) {
                                        v0 = 112;
                                        v5 = ++var0_5;
                                        v2 = var2_2.substring(v5, v5 + var1_4);
                                        v3 = 0;
                                        break block19;
                                        break;
                                    }
                                    break;
                                }
lbl28:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    break block20;
                                    break;
                                }
                            }
                            v6 = v2.toCharArray();
                            v7 = v6.length;
                            var6_6 = 0;
                            v8 = v0;
                            v9 = v6;
                            v10 = v7;
                            if (v7 > 1) ** GOTO lbl85
                            do {
                                v11 = v8;
                                v9 = v9;
                                v12 = v9;
                                v13 = v8;
                                v14 = var6_6;
                                while (true) {
                                    switch (var6_6 % 7) {
                                        case 0: {
                                            v15 = 33;
                                            break;
                                        }
                                        case 1: {
                                            v15 = 97;
                                            break;
                                        }
                                        case 2: {
                                            v15 = 79;
                                            break;
                                        }
                                        case 3: {
                                            v15 = 57;
                                            break;
                                        }
                                        case 4: {
                                            v15 = 14;
                                            break;
                                        }
                                        case 5: {
                                            v15 = 79;
                                            break;
                                        }
                                        default: {
                                            v15 = 108;
                                        }
                                    }
                                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                                    ++var6_6;
                                    v8 = v11;
                                    if (v11 != 0) break;
                                    v11 = v8;
                                    v9 = v9;
                                    v14 = v8;
                                    v12 = v9;
                                    v13 = v8;
                                }
lbl85:
                                // 2 sources

                                v16 = v9;
                                v10 = v10;
                            } while (v10 > var6_6);
                            v4 = new String(v16);
                            switch (v3) {
                                default: {
                                    ** continue;
                                }
                                ** case 0:
lbl95:
                                // 1 sources

                                ** continue;
                            }
                        }
                        monitorOneConnection.2.a = var5;
                        monitorOneConnection.2.b = new String[5];
                    }

                    private static String a(int n2, int n3, int n4) {
                        int n5 = (n2 ^ n4 ^ 0xFFFFF15F) & 0xFFFF;
                        if (b[n5] == null) {
                            int n6;
                            char[] cArray = a[n5].toCharArray();
                            int n7 = switch (cArray[0] & 0xFF) {
                                case 0 -> 0;
                                case 1 -> 161;
                                case 2 -> 52;
                                case 3 -> 130;
                                case 4 -> 95;
                                case 5 -> 231;
                                case 6 -> 89;
                                case 7 -> 59;
                                case 8 -> 142;
                                case 9 -> 38;
                                case 10 -> 255;
                                case 11 -> 35;
                                case 12 -> 50;
                                case 13 -> 195;
                                case 14 -> 126;
                                case 15 -> 220;
                                case 16 -> 113;
                                case 17 -> 105;
                                case 18 -> 155;
                                case 19 -> 109;
                                case 20 -> 147;
                                case 21 -> 29;
                                case 22 -> 68;
                                case 23 -> 145;
                                case 24 -> 224;
                                case 25 -> 206;
                                case 26 -> 176;
                                case 27 -> 121;
                                case 28 -> 74;
                                case 29 -> 78;
                                case 30 -> 3;
                                case 31 -> 24;
                                case 32 -> 228;
                                case 33 -> 151;
                                case 34 -> 22;
                                case 35 -> 234;
                                case 36 -> 76;
                                case 37 -> 232;
                                case 38 -> 242;
                                case 39 -> 129;
                                case 40 -> 233;
                                case 41 -> 140;
                                case 42 -> 62;
                                case 43 -> 58;
                                case 44 -> 97;
                                case 45 -> 238;
                                case 46 -> 72;
                                case 47 -> 69;
                                case 48 -> 197;
                                case 49 -> 179;
                                case 50 -> 180;
                                case 51 -> 189;
                                case 52 -> 196;
                                case 53 -> 124;
                                case 54 -> 250;
                                case 55 -> 182;
                                case 56 -> 103;
                                case 57 -> 213;
                                case 58 -> 221;
                                case 59 -> 45;
                                case 60 -> 114;
                                case 61 -> 253;
                                case 62 -> 239;
                                case 63 -> 51;
                                case 64 -> 185;
                                case 65 -> 8;
                                case 66 -> 168;
                                case 67 -> 33;
                                case 68 -> 44;
                                case 69 -> 164;
                                case 70 -> 230;
                                case 71 -> 12;
                                case 72 -> 53;
                                case 73 -> 41;
                                case 74 -> 31;
                                case 75 -> 150;
                                case 76 -> 226;
                                case 77 -> 119;
                                case 78 -> 92;
                                case 79 -> 159;
                                case 80 -> 77;
                                case 81 -> 144;
                                case 82 -> 7;
                                case 83 -> 71;
                                case 84 -> 137;
                                case 85 -> 125;
                                case 86 -> 254;
                                case 87 -> 86;
                                case 88 -> 177;
                                case 89 -> 108;
                                case 90 -> 223;
                                case 91 -> 235;
                                case 92 -> 27;
                                case 93 -> 132;
                                case 94 -> 37;
                                case 95 -> 215;
                                case 96 -> 158;
                                case 97 -> 96;
                                case 98 -> 85;
                                case 99 -> 236;
                                case 100 -> 100;
                                case 101 -> 61;
                                case 102 -> 75;
                                case 103 -> 152;
                                case 104 -> 56;
                                case 105 -> 20;
                                case 106 -> 11;
                                case 107 -> 141;
                                case 108 -> 209;
                                case 109 -> 19;
                                case 110 -> 101;
                                case 111 -> 60;
                                case 112 -> 192;
                                case 113 -> 188;
                                case 114 -> 5;
                                case 115 -> 1;
                                case 116 -> 202;
                                case 117 -> 156;
                                case 118 -> 14;
                                case 119 -> 208;
                                case 120 -> 135;
                                case 121 -> 104;
                                case 122 -> 244;
                                case 123 -> 66;
                                case 124 -> 115;
                                case 125 -> 139;
                                case 126 -> 153;
                                case 127 -> 118;
                                case 128 -> 248;
                                case 129 -> 201;
                                case 130 -> 23;
                                case 131 -> 81;
                                case 132 -> 249;
                                case 133 -> 191;
                                case 134 -> 143;
                                case 135 -> 64;
                                case 136 -> 154;
                                case 137 -> 222;
                                case 138 -> 171;
                                case 139 -> 99;
                                case 140 -> 172;
                                case 141 -> 111;
                                case 142 -> 83;
                                case 143 -> 243;
                                case 144 -> 88;
                                case 145 -> 21;
                                case 146 -> 184;
                                case 147 -> 10;
                                case 148 -> 200;
                                case 149 -> 175;
                                case 150 -> 194;
                                case 151 -> 169;
                                case 152 -> 102;
                                case 153 -> 73;
                                case 154 -> 157;
                                case 155 -> 199;
                                case 156 -> 218;
                                case 157 -> 120;
                                case 158 -> 122;
                                case 159 -> 170;
                                case 160 -> 91;
                                case 161 -> 227;
                                case 162 -> 90;
                                case 163 -> 28;
                                case 164 -> 94;
                                case 165 -> 112;
                                case 166 -> 166;
                                case 167 -> 39;
                                case 168 -> 30;
                                case 169 -> 25;
                                case 170 -> 127;
                                case 171 -> 2;
                                case 172 -> 9;
                                case 173 -> 93;
                                case 174 -> 34;
                                case 175 -> 160;
                                case 176 -> 190;
                                case 177 -> 116;
                                case 178 -> 134;
                                case 179 -> 187;
                                case 180 -> 216;
                                case 181 -> 54;
                                case 182 -> 162;
                                case 183 -> 246;
                                case 184 -> 84;
                                case 185 -> 43;
                                case 186 -> 217;
                                case 187 -> 26;
                                case 188 -> 36;
                                case 189 -> 98;
                                case 190 -> 212;
                                case 191 -> 16;
                                case 192 -> 167;
                                case 193 -> 181;
                                case 194 -> 174;
                                case 195 -> 80;
                                case 196 -> 57;
                                case 197 -> 225;
                                case 198 -> 55;
                                case 199 -> 198;
                                case 200 -> 46;
                                case 201 -> 82;
                                case 202 -> 123;
                                case 203 -> 65;
                                case 204 -> 117;
                                case 205 -> 165;
                                case 206 -> 42;
                                case 207 -> 128;
                                case 208 -> 186;
                                case 209 -> 251;
                                case 210 -> 241;
                                case 211 -> 133;
                                case 212 -> 214;
                                case 213 -> 204;
                                case 214 -> 252;
                                case 215 -> 207;
                                case 216 -> 205;
                                case 217 -> 245;
                                case 218 -> 47;
                                case 219 -> 40;
                                case 220 -> 79;
                                case 221 -> 149;
                                case 222 -> 17;
                                case 223 -> 6;
                                case 224 -> 178;
                                case 225 -> 48;
                                case 226 -> 203;
                                case 227 -> 193;
                                case 228 -> 229;
                                case 229 -> 183;
                                case 230 -> 240;
                                case 231 -> 146;
                                case 232 -> 49;
                                case 233 -> 210;
                                case 234 -> 67;
                                case 235 -> 15;
                                case 236 -> 70;
                                case 237 -> 136;
                                case 238 -> 173;
                                case 239 -> 4;
                                case 240 -> 237;
                                case 241 -> 247;
                                case 242 -> 138;
                                case 243 -> 219;
                                case 244 -> 106;
                                case 245 -> 32;
                                case 246 -> 13;
                                case 247 -> 163;
                                case 248 -> 63;
                                case 249 -> 211;
                                case 250 -> 110;
                                case 251 -> 131;
                                case 252 -> 148;
                                case 253 -> 87;
                                case 254 -> 18;
                                default -> 107;
                            };
                            int n8 = ((n3 ^= n4) & 0xFF) - n7;
                            if (n8 < 0) {
                                n8 += 256;
                            }
                            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                n6 += 256;
                            }
                            int n9 = 0;
                            while (n9 < cArray.length) {
                                int n10 = n9 % 2;
                                int n11 = n9;
                                char[] cArray2 = cArray;
                                char c2 = cArray[n11];
                                if (n10 == 0) {
                                    cArray2[n11] = (char)(c2 ^ n8);
                                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                } else {
                                    cArray2[n11] = (char)(c2 ^ n6);
                                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                }
                                ++n9;
                            }
                            monitorOneConnection.2.b[n5] = new String(cArray).intern();
                        }
                        return b[n5];
                    }
                });
                rdConnection.getDestinationSocketInputShutdown().advise(lifetime, (Function1)new Function1<Unit, Unit>(clientSocket, lifetimeDefinition, n3, string){
                    final /* synthetic */ Socket $clientSocket;
                    final /* synthetic */ LifetimeDefinition $rdConnectionLifetimeDef;
                    final /* synthetic */ int $portNumber;
                    final /* synthetic */ String $connectionId;
                    private static final String[] a;
                    private static final String[] b;
                    {
                        this.$clientSocket = $clientSocket;
                        this.$rdConnectionLifetimeDef = $rdConnectionLifetimeDef;
                        this.$portNumber = $portNumber;
                        this.$connectionId = $connectionId;
                        super(1);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final void invoke(@NotNull Unit it) {
                        block15: {
                            block13: {
                                var2_2 = 62128792454862L;
                                v0 = ServerSocketPortState.C();
                                Intrinsics.checkNotNullParameter((Object)it, (String)monitorOneConnection.3.a(2090566500 - (char)-20572, -2090566500 - -((char)-2660), (int)var2_2));
                                var5_3 = ServerSocketWrapper.Companion.getLogger();
                                var4_5 = v0;
                                var7_6 = this.$portNumber;
                                var8_7 = this.$connectionId;
                                var6_8 = null;
                                var9_9 = false;
                                try {
                                    v1 = var5_3.isDebugEnabled();
                                    if (var4_5 == null) {
                                        if (!v1) break block13;
                                    }
                                    ** GOTO lbl29
                                }
                                catch (Throwable v2) {
                                    throw monitorOneConnection.3.a(v2);
                                }
                                var11_10 = var5_3;
                                var10_11 = false;
                                var11_10.debug(monitorOneConnection.3.a(2090566500 - (char)-20573, 2090566500 - (char)-15606, (int)var2_2) + var7_6 + monitorOneConnection.3.a(2090566500 - (char)-20574, -2090566500 - -((char)-25584), (int)var2_2) + var8_7, var6_8);
                            }
                            try {
                                block16: {
                                    block14: {
                                        block17: {
                                            block18: {
                                                this.$clientSocket.shutdownOutput();
                                                v1 = this.$clientSocket.isInputShutdown();
lbl29:
                                                // 3 sources

                                                if (var4_5 != null) break block14;
                                                if (v1) break block17;
                                                break block18;
                                                catch (Throwable v3) {
                                                    throw monitorOneConnection.3.a(v3);
                                                }
                                            }
                                            try {
                                                block19: {
                                                    v1 = this.$clientSocket.isClosed();
                                                    if (var4_5 != null) break block14;
                                                    break block19;
                                                    catch (Throwable v4) {
                                                        throw monitorOneConnection.3.a(v4);
                                                    }
                                                }
                                                if (!v1) break block15;
                                            }
                                            catch (Throwable v5) {
                                                throw monitorOneConnection.3.a(v5);
                                            }
                                        }
                                        var5_3 = ServerSocketWrapper.Companion.getLogger();
                                        var7_6 = this.$portNumber;
                                        var8_7 = this.$connectionId;
                                        var6_8 = null;
                                        var9_9 = false;
                                        v1 = var5_3.isDebugEnabled();
                                    }
                                    try {
                                        if (var4_5 != null) break block15;
                                        if (!v1) break block16;
                                    }
                                    catch (Throwable v6) {
                                        throw monitorOneConnection.3.a(v6);
                                    }
                                    var11_10 = var5_3;
                                    var10_11 = false;
                                    var11_10.debug(monitorOneConnection.3.a(2090566500 - (char)-20575, -2090566500 - -((char)-19581), (int)var2_2) + var7_6 + monitorOneConnection.3.a(2090566500 - (char)-20576, -2090566500 - -((char)-12047), (int)var2_2) + var8_7, var6_8);
                                }
                                v1 = LifetimeDefinition.terminate$default((LifetimeDefinition)this.$rdConnectionLifetimeDef, (boolean)false, (int)1, null);
                            }
                            catch (Throwable var5_4) {
                                ServerSocketWrapper.Companion.getLogger().warn(monitorOneConnection.3.a(2090566500 - (char)-20577, -2090566500 - -((char)-4334), (int)var2_2) + this.$portNumber + monitorOneConnection.3.a(2090566500 - (char)-20576, -2090566500 - -((char)-12047), (int)var2_2) + this.$connectionId, var5_4);
                            }
                        }
                    }

                    private static Throwable a(Throwable throwable) {
                        return throwable;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    static {
                        block20: {
                            block19: {
                                var5 = new String[6];
                                var3_1 = 0;
                                var2_2 = "\u00a2\u008c\u001b\"\u00ca\u00beJN\u00b6\u001b\u00ce\u008cG\u00f4\u00ab\u00e4+gh\u0092\u00a4\u0094A\u008fF\u0098\u009d:&\u008f\u0006d\u009d\u00a0\u0016\u00bd`J\u00c8\u00e1\u00e3/\u00e5\u001an[\"\u00f5!\u00fd^\u00e101x\u008f\u00c9$$\u00ea\u00ed\b\u009a\u009c\u0010\u0098r\u00c1\u00af\u00ae2i\u00c4T\u008f*\u0005-_\u00b2\u00f6w\u00e5\u00e3\u00e4O\u00e1\u00f1\u0006\u0093\u0089\u0001\u000e\u0006\u0015\u0092j#\u00b9\u008dX\r\tl\u001a\u00fa\u00be\u00f6\u00c6\u00fdv\u00f8";
                                var4_3 = "\u00a2\u008c\u001b\"\u00ca\u00beJN\u00b6\u001b\u00ce\u008cG\u00f4\u00ab\u00e4+gh\u0092\u00a4\u0094A\u008fF\u0098\u009d:&\u008f\u0006d\u009d\u00a0\u0016\u00bd`J\u00c8\u00e1\u00e3/\u00e5\u001an[\"\u00f5!\u00fd^\u00e101x\u008f\u00c9$$\u00ea\u00ed\b\u009a\u009c\u0010\u0098r\u00c1\u00af\u00ae2i\u00c4T\u008f*\u0005-_\u00b2\u00f6w\u00e5\u00e3\u00e4O\u00e1\u00f1\u0006\u0093\u0089\u0001\u000e\u0006\u0015\u0092j#\u00b9\u008dX\r\tl\u001a\u00fa\u00be\u00f6\u00c6\u00fdv\u00f8".length();
                                var1_4 = 2;
                                var0_5 = -1;
lbl7:
                                // 2 sources

                                while (true) {
                                    v0 = 81;
                                    v1 = ++var0_5;
                                    v2 = var2_2.substring(v1, v1 + var1_4);
                                    v3 = -1;
                                    break block19;
                                    break;
                                }
lbl13:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    var2_2 = "\u00c6s\u0080\u00bf\u00cd!5Ab\u00a6+9\u00ee\u0081\u00b1\u00ab\u00dcd\u00ac\u0082\u00bf\u00df\u008e\u00f1\f\u008c \u00f8\u001e\u0002\u00f8R\u0087\u0011\u00eb\u0086\u00ad\u00cd\u00cd\u0086\u00ec\u00f6\u00e9c\u00cd\u00ec\u00a5\u0016\u00d7\u00ab\u00dd;\u00f8o\u008e\u001b\u00af\u0007/\u00d3";
                                    var4_3 = "\u00c6s\u0080\u00bf\u00cd!5Ab\u00a6+9\u00ee\u0081\u00b1\u00ab\u00dcd\u00ac\u0082\u00bf\u00df\u008e\u00f1\f\u008c \u00f8\u001e\u0002\u00f8R\u0087\u0011\u00eb\u0086\u00ad\u00cd\u00cd\u0086\u00ec\u00f6\u00e9c\u00cd\u00ec\u00a5\u0016\u00d7\u00ab\u00dd;\u00f8o\u008e\u001b\u00af\u0007/\u00d3".length();
                                    var1_4 = 6;
                                    var0_5 = -1;
lbl22:
                                    // 2 sources

                                    while (true) {
                                        v0 = 99;
                                        v5 = ++var0_5;
                                        v2 = var2_2.substring(v5, v5 + var1_4);
                                        v3 = 0;
                                        break block19;
                                        break;
                                    }
                                    break;
                                }
lbl28:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    break block20;
                                    break;
                                }
                            }
                            v6 = v2.toCharArray();
                            v7 = v6.length;
                            var6_6 = 0;
                            v8 = v0;
                            v9 = v6;
                            v10 = v7;
                            if (v7 > 1) ** GOTO lbl85
                            do {
                                v11 = v8;
                                v9 = v9;
                                v12 = v9;
                                v13 = v8;
                                v14 = var6_6;
                                while (true) {
                                    switch (var6_6 % 7) {
                                        case 0: {
                                            v15 = 76;
                                            break;
                                        }
                                        case 1: {
                                            v15 = 61;
                                            break;
                                        }
                                        case 2: {
                                            v15 = 30;
                                            break;
                                        }
                                        case 3: {
                                            v15 = 57;
                                            break;
                                        }
                                        case 4: {
                                            v15 = 111;
                                            break;
                                        }
                                        case 5: {
                                            v15 = 54;
                                            break;
                                        }
                                        default: {
                                            v15 = 30;
                                        }
                                    }
                                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                                    ++var6_6;
                                    v8 = v11;
                                    if (v11 != 0) break;
                                    v11 = v8;
                                    v9 = v9;
                                    v14 = v8;
                                    v12 = v9;
                                    v13 = v8;
                                }
lbl85:
                                // 2 sources

                                v16 = v9;
                                v10 = v10;
                            } while (v10 > var6_6);
                            v4 = new String(v16);
                            switch (v3) {
                                default: {
                                    ** continue;
                                }
                                ** case 0:
lbl95:
                                // 1 sources

                                ** continue;
                            }
                        }
                        monitorOneConnection.3.a = var5;
                        monitorOneConnection.3.b = new String[6];
                    }

                    private static String a(int n2, int n3, int n4) {
                        int n5 = (n2 ^ n4 ^ 0x150E) & 0xFFFF;
                        if (b[n5] == null) {
                            int n6;
                            char[] cArray = a[n5].toCharArray();
                            int n7 = switch (cArray[0] & 0xFF) {
                                case 0 -> 117;
                                case 1 -> 219;
                                case 2 -> 116;
                                case 3 -> 245;
                                case 4 -> 47;
                                case 5 -> 35;
                                case 6 -> 136;
                                case 7 -> 53;
                                case 8 -> 212;
                                case 9 -> 31;
                                case 10 -> 57;
                                case 11 -> 252;
                                case 12 -> 9;
                                case 13 -> 34;
                                case 14 -> 128;
                                case 15 -> 185;
                                case 16 -> 151;
                                case 17 -> 237;
                                case 18 -> 107;
                                case 19 -> 119;
                                case 20 -> 206;
                                case 21 -> 64;
                                case 22 -> 12;
                                case 23 -> 225;
                                case 24 -> 160;
                                case 25 -> 49;
                                case 26 -> 113;
                                case 27 -> 251;
                                case 28 -> 137;
                                case 29 -> 17;
                                case 30 -> 6;
                                case 31 -> 63;
                                case 32 -> 165;
                                case 33 -> 194;
                                case 34 -> 109;
                                case 35 -> 169;
                                case 36 -> 171;
                                case 37 -> 8;
                                case 38 -> 207;
                                case 39 -> 187;
                                case 40 -> 186;
                                case 41 -> 174;
                                case 42 -> 203;
                                case 43 -> 150;
                                case 44 -> 161;
                                case 45 -> 120;
                                case 46 -> 39;
                                case 47 -> 42;
                                case 48 -> 26;
                                case 49 -> 178;
                                case 50 -> 30;
                                case 51 -> 228;
                                case 52 -> 65;
                                case 53 -> 233;
                                case 54 -> 223;
                                case 55 -> 38;
                                case 56 -> 147;
                                case 57 -> 14;
                                case 58 -> 200;
                                case 59 -> 182;
                                case 60 -> 33;
                                case 61 -> 193;
                                case 62 -> 95;
                                case 63 -> 61;
                                case 64 -> 220;
                                case 65 -> 129;
                                case 66 -> 214;
                                case 67 -> 43;
                                case 68 -> 97;
                                case 69 -> 94;
                                case 70 -> 198;
                                case 71 -> 52;
                                case 72 -> 246;
                                case 73 -> 213;
                                case 74 -> 158;
                                case 75 -> 70;
                                case 76 -> 195;
                                case 77 -> 11;
                                case 78 -> 130;
                                case 79 -> 89;
                                case 80 -> 44;
                                case 81 -> 24;
                                case 82 -> 155;
                                case 83 -> 149;
                                case 84 -> 157;
                                case 85 -> 170;
                                case 86 -> 75;
                                case 87 -> 18;
                                case 88 -> 192;
                                case 89 -> 25;
                                case 90 -> 67;
                                case 91 -> 189;
                                case 92 -> 111;
                                case 93 -> 28;
                                case 94 -> 164;
                                case 95 -> 5;
                                case 96 -> 181;
                                case 97 -> 143;
                                case 98 -> 98;
                                case 99 -> 60;
                                case 100 -> 138;
                                case 101 -> 183;
                                case 102 -> 241;
                                case 103 -> 51;
                                case 104 -> 255;
                                case 105 -> 131;
                                case 106 -> 0;
                                case 107 -> 144;
                                case 108 -> 254;
                                case 109 -> 110;
                                case 110 -> 90;
                                case 111 -> 118;
                                case 112 -> 76;
                                case 113 -> 56;
                                case 114 -> 124;
                                case 115 -> 66;
                                case 116 -> 15;
                                case 117 -> 201;
                                case 118 -> 211;
                                case 119 -> 59;
                                case 120 -> 243;
                                case 121 -> 13;
                                case 122 -> 84;
                                case 123 -> 80;
                                case 124 -> 217;
                                case 125 -> 87;
                                case 126 -> 21;
                                case 127 -> 74;
                                case 128 -> 142;
                                case 129 -> 81;
                                case 130 -> 103;
                                case 131 -> 230;
                                case 132 -> 190;
                                case 133 -> 7;
                                case 134 -> 72;
                                case 135 -> 236;
                                case 136 -> 29;
                                case 137 -> 27;
                                case 138 -> 40;
                                case 139 -> 156;
                                case 140 -> 215;
                                case 141 -> 139;
                                case 142 -> 4;
                                case 143 -> 101;
                                case 144 -> 82;
                                case 145 -> 240;
                                case 146 -> 196;
                                case 147 -> 83;
                                case 148 -> 19;
                                case 149 -> 71;
                                case 150 -> 153;
                                case 151 -> 45;
                                case 152 -> 205;
                                case 153 -> 1;
                                case 154 -> 249;
                                case 155 -> 204;
                                case 156 -> 108;
                                case 157 -> 239;
                                case 158 -> 202;
                                case 159 -> 209;
                                case 160 -> 172;
                                case 161 -> 16;
                                case 162 -> 23;
                                case 163 -> 93;
                                case 164 -> 133;
                                case 165 -> 218;
                                case 166 -> 227;
                                case 167 -> 62;
                                case 168 -> 134;
                                case 169 -> 175;
                                case 170 -> 234;
                                case 171 -> 104;
                                case 172 -> 88;
                                case 173 -> 148;
                                case 174 -> 173;
                                case 175 -> 235;
                                case 176 -> 145;
                                case 177 -> 122;
                                case 178 -> 179;
                                case 179 -> 146;
                                case 180 -> 85;
                                case 181 -> 127;
                                case 182 -> 132;
                                case 183 -> 99;
                                case 184 -> 125;
                                case 185 -> 229;
                                case 186 -> 166;
                                case 187 -> 231;
                                case 188 -> 162;
                                case 189 -> 54;
                                case 190 -> 112;
                                case 191 -> 32;
                                case 192 -> 46;
                                case 193 -> 100;
                                case 194 -> 242;
                                case 195 -> 221;
                                case 196 -> 106;
                                case 197 -> 114;
                                case 198 -> 48;
                                case 199 -> 58;
                                case 200 -> 115;
                                case 201 -> 152;
                                case 202 -> 191;
                                case 203 -> 180;
                                case 204 -> 2;
                                case 205 -> 210;
                                case 206 -> 86;
                                case 207 -> 41;
                                case 208 -> 140;
                                case 209 -> 10;
                                case 210 -> 197;
                                case 211 -> 78;
                                case 212 -> 50;
                                case 213 -> 20;
                                case 214 -> 244;
                                case 215 -> 3;
                                case 216 -> 253;
                                case 217 -> 199;
                                case 218 -> 188;
                                case 219 -> 232;
                                case 220 -> 135;
                                case 221 -> 37;
                                case 222 -> 123;
                                case 223 -> 159;
                                case 224 -> 121;
                                case 225 -> 55;
                                case 226 -> 208;
                                case 227 -> 73;
                                case 228 -> 248;
                                case 229 -> 105;
                                case 230 -> 250;
                                case 231 -> 92;
                                case 232 -> 222;
                                case 233 -> 126;
                                case 234 -> 168;
                                case 235 -> 177;
                                case 236 -> 184;
                                case 237 -> 154;
                                case 238 -> 216;
                                case 239 -> 238;
                                case 240 -> 224;
                                case 241 -> 91;
                                case 242 -> 69;
                                case 243 -> 247;
                                case 244 -> 77;
                                case 245 -> 22;
                                case 246 -> 141;
                                case 247 -> 96;
                                case 248 -> 163;
                                case 249 -> 226;
                                case 250 -> 176;
                                case 251 -> 167;
                                case 252 -> 102;
                                case 253 -> 79;
                                case 254 -> 68;
                                default -> 36;
                            };
                            int n8 = ((n3 ^= n4) & 0xFF) - n7;
                            if (n8 < 0) {
                                n8 += 256;
                            }
                            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                n6 += 256;
                            }
                            int n9 = 0;
                            while (n9 < cArray.length) {
                                int n10 = n9 % 2;
                                int n11 = n9;
                                char[] cArray2 = cArray;
                                char c2 = cArray[n11];
                                if (n10 == 0) {
                                    cArray2[n11] = (char)(c2 ^ n8);
                                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                } else {
                                    cArray2[n11] = (char)(c2 ^ n6);
                                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                }
                                ++n9;
                            }
                            monitorOneConnection.3.b[n5] = new String(cArray).intern();
                        }
                        return b[n5];
                    }
                });
                rdConnection.getDestinationSocketOutputShutdown().advise(lifetime, (Function1)new Function1<Unit, Unit>(clientSocket, lifetimeDefinition, n3, string){
                    final /* synthetic */ Socket $clientSocket;
                    final /* synthetic */ LifetimeDefinition $rdConnectionLifetimeDef;
                    final /* synthetic */ int $portNumber;
                    final /* synthetic */ String $connectionId;
                    private static final String[] a;
                    private static final String[] b;
                    {
                        this.$clientSocket = $clientSocket;
                        this.$rdConnectionLifetimeDef = $rdConnectionLifetimeDef;
                        this.$portNumber = $portNumber;
                        this.$connectionId = $connectionId;
                        super(1);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final void invoke(@NotNull Unit it) {
                        block15: {
                            block13: {
                                var2_2 = 77179242159242L;
                                Intrinsics.checkNotNullParameter((Object)it, (String)monitorOneConnection.4.a(1320137040 - 3434, 1320137040 - 5151, (int)var2_2));
                                var5_3 = ServerSocketWrapper.Companion.getLogger();
                                var4_5 = ServerSocketPortState.C();
                                var7_6 = this.$portNumber;
                                var8_7 = this.$connectionId;
                                var6_8 = null;
                                var9_9 = false;
                                try {
                                    v0 = var5_3.isDebugEnabled();
                                    if (var4_5 == null) {
                                        if (!v0) break block13;
                                    }
                                    ** GOTO lbl28
                                }
                                catch (Throwable v1) {
                                    throw monitorOneConnection.4.a(v1);
                                }
                                var11_10 = var5_3;
                                var10_11 = false;
                                var11_10.debug(monitorOneConnection.4.a(1320137040 - 3433, -1320137040 - -9662, (int)var2_2) + var7_6 + monitorOneConnection.4.a(1320137040 - 3436, -1320137040 + -1947, (int)var2_2) + var8_7, var6_8);
                            }
                            try {
                                block16: {
                                    block14: {
                                        block17: {
                                            block18: {
                                                this.$clientSocket.shutdownInput();
                                                v0 = this.$clientSocket.isOutputShutdown();
lbl28:
                                                // 3 sources

                                                if (var4_5 != null) break block14;
                                                if (v0) break block17;
                                                break block18;
                                                catch (Throwable v2) {
                                                    throw monitorOneConnection.4.a(v2);
                                                }
                                            }
                                            try {
                                                block19: {
                                                    v0 = this.$clientSocket.isClosed();
                                                    if (var4_5 != null) break block14;
                                                    break block19;
                                                    catch (Throwable v3) {
                                                        throw monitorOneConnection.4.a(v3);
                                                    }
                                                }
                                                if (!v0) break block15;
                                            }
                                            catch (Throwable v4) {
                                                throw monitorOneConnection.4.a(v4);
                                            }
                                        }
                                        var5_3 = ServerSocketWrapper.Companion.getLogger();
                                        var7_6 = this.$portNumber;
                                        var8_7 = this.$connectionId;
                                        var6_8 = null;
                                        var9_9 = false;
                                        v0 = var5_3.isDebugEnabled();
                                    }
                                    try {
                                        if (var4_5 != null) break block15;
                                        if (!v0) break block16;
                                    }
                                    catch (Throwable v5) {
                                        throw monitorOneConnection.4.a(v5);
                                    }
                                    var11_10 = var5_3;
                                    var10_11 = false;
                                    var11_10.debug(monitorOneConnection.4.a(1320137040 - 3435, 1320137040 + 1998, (int)var2_2) + var7_6 + monitorOneConnection.4.a(1320137040 - 3438, 1320137040 - 3010, (int)var2_2) + var8_7, var6_8);
                                }
                                v0 = LifetimeDefinition.terminate$default((LifetimeDefinition)this.$rdConnectionLifetimeDef, (boolean)false, (int)1, null);
                            }
                            catch (Throwable var5_4) {
                                ServerSocketWrapper.Companion.getLogger().warn(monitorOneConnection.4.a(1320137040 - 3437, 1320137040 + 6129, (int)var2_2) + this.$portNumber + monitorOneConnection.4.a(1320137040 - 3438, 1320137040 - 3010, (int)var2_2) + this.$connectionId, var5_4);
                            }
                        }
                    }

                    private static Throwable a(Throwable throwable) {
                        return throwable;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    static {
                        block20: {
                            block19: {
                                var5 = new String[6];
                                var3_1 = 0;
                                var2_2 = "\u00c7;\u001cm\u00c9`\u0080)\u00f1\u0018\u00fe\fvH*\u00af\u0089S^9\u0016\u0000\u00a7\u00d8H\u00e1>\u00ca`o\u00c9\u0006|\u0013\u0094m\u0087\u0011LR\u0003\u0087\u00d9\u00d5\u00da\u0087\u009b\u00ff\u00da6\u00bf`;\u00aa\b\u0006\u00dc\u00e7\u00fe$c~[9\u00c2\u0019\u0016\u0089&\u00bd\u0080\u00b4\u00b6Zp$]Y\u008cNIu\u00d3\u0099\u0091\u008f\u00ae\u0019\u00a5\u00b3\u0086\u0086\u00fa\b\u009c}XQ\u0093e\u0092\u00e8\u00f8\u009f\u0089;{\u00cd\u00a8\u0007Q\u00db\u00c3R\u00ae";
                                var4_3 = "\u00c7;\u001cm\u00c9`\u0080)\u00f1\u0018\u00fe\fvH*\u00af\u0089S^9\u0016\u0000\u00a7\u00d8H\u00e1>\u00ca`o\u00c9\u0006|\u0013\u0094m\u0087\u0011LR\u0003\u0087\u00d9\u00d5\u00da\u0087\u009b\u00ff\u00da6\u00bf`;\u00aa\b\u0006\u00dc\u00e7\u00fe$c~[9\u00c2\u0019\u0016\u0089&\u00bd\u0080\u00b4\u00b6Zp$]Y\u008cNIu\u00d3\u0099\u0091\u008f\u00ae\u0019\u00a5\u00b3\u0086\u0086\u00fa\b\u009c}XQ\u0093e\u0092\u00e8\u00f8\u009f\u0089;{\u00cd\u00a8\u0007Q\u00db\u00c3R\u00ae".length();
                                var1_4 = 2;
                                var0_5 = -1;
lbl7:
                                // 2 sources

                                while (true) {
                                    v0 = 36;
                                    v1 = ++var0_5;
                                    v2 = var2_2.substring(v1, v1 + var1_4);
                                    v3 = -1;
                                    break block19;
                                    break;
                                }
lbl13:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    var2_2 = "\u00adM80\u0084,5w]\u00b5\u0084\u0005\u00e7\u000b\u00aa\u00f8j@?8\u00bd7N#\u0082\u00d5\u00a3\u00f4^\u00f2j$3]\u00d2\u00f3\u0088\u0012MV\u00d7p\u009f\f\u00f20\u00b2[2KY\u00f4?s\u00d3\u0095>\u00d4\u00c8\u00e1";
                                    var4_3 = "\u00adM80\u0084,5w]\u00b5\u0084\u0005\u00e7\u000b\u00aa\u00f8j@?8\u00bd7N#\u0082\u00d5\u00a3\u00f4^\u00f2j$3]\u00d2\u00f3\u0088\u0012MV\u00d7p\u009f\f\u00f20\u00b2[2KY\u00f4?s\u00d3\u0095>\u00d4\u00c8\u00e1".length();
                                    var1_4 = 6;
                                    var0_5 = -1;
lbl22:
                                    // 2 sources

                                    while (true) {
                                        v0 = 48;
                                        v5 = ++var0_5;
                                        v2 = var2_2.substring(v5, v5 + var1_4);
                                        v3 = 0;
                                        break block19;
                                        break;
                                    }
                                    break;
                                }
lbl28:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    break block20;
                                    break;
                                }
                            }
                            v6 = v2.toCharArray();
                            v7 = v6.length;
                            var6_6 = 0;
                            v8 = v0;
                            v9 = v6;
                            v10 = v7;
                            if (v7 > 1) ** GOTO lbl85
                            do {
                                v11 = v8;
                                v9 = v9;
                                v12 = v9;
                                v13 = v8;
                                v14 = var6_6;
                                while (true) {
                                    switch (var6_6 % 7) {
                                        case 0: {
                                            v15 = 42;
                                            break;
                                        }
                                        case 1: {
                                            v15 = 13;
                                            break;
                                        }
                                        case 2: {
                                            v15 = 62;
                                            break;
                                        }
                                        case 3: {
                                            v15 = 78;
                                            break;
                                        }
                                        case 4: {
                                            v15 = 12;
                                            break;
                                        }
                                        case 5: {
                                            v15 = 29;
                                            break;
                                        }
                                        default: {
                                            v15 = 70;
                                        }
                                    }
                                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                                    ++var6_6;
                                    v8 = v11;
                                    if (v11 != 0) break;
                                    v11 = v8;
                                    v9 = v9;
                                    v14 = v8;
                                    v12 = v9;
                                    v13 = v8;
                                }
lbl85:
                                // 2 sources

                                v16 = v9;
                                v10 = v10;
                            } while (v10 > var6_6);
                            v4 = new String(v16);
                            switch (v3) {
                                default: {
                                    ** continue;
                                }
                                ** case 0:
lbl95:
                                // 1 sources

                                ** continue;
                            }
                        }
                        monitorOneConnection.4.a = var5;
                        monitorOneConnection.4.b = new String[6];
                    }

                    private static String a(int n2, int n3, int n4) {
                        int n5 = (n2 ^ n4 ^ 0xFFFFBF6C) & 0xFFFF;
                        if (b[n5] == null) {
                            int n6;
                            char[] cArray = a[n5].toCharArray();
                            int n7 = switch (cArray[0] & 0xFF) {
                                case 0 -> 136;
                                case 1 -> 237;
                                case 2 -> 63;
                                case 3 -> 75;
                                case 4 -> 212;
                                case 5 -> 164;
                                case 6 -> 60;
                                case 7 -> 2;
                                case 8 -> 154;
                                case 9 -> 219;
                                case 10 -> 134;
                                case 11 -> 156;
                                case 12 -> 17;
                                case 13 -> 5;
                                case 14 -> 74;
                                case 15 -> 77;
                                case 16 -> 93;
                                case 17 -> 83;
                                case 18 -> 232;
                                case 19 -> 113;
                                case 20 -> 224;
                                case 21 -> 193;
                                case 22 -> 153;
                                case 23 -> 95;
                                case 24 -> 146;
                                case 25 -> 132;
                                case 26 -> 199;
                                case 27 -> 91;
                                case 28 -> 131;
                                case 29 -> 36;
                                case 30 -> 140;
                                case 31 -> 150;
                                case 32 -> 108;
                                case 33 -> 56;
                                case 34 -> 202;
                                case 35 -> 247;
                                case 36 -> 189;
                                case 37 -> 168;
                                case 38 -> 122;
                                case 39 -> 191;
                                case 40 -> 130;
                                case 41 -> 22;
                                case 42 -> 230;
                                case 43 -> 196;
                                case 44 -> 222;
                                case 45 -> 106;
                                case 46 -> 81;
                                case 47 -> 142;
                                case 48 -> 207;
                                case 49 -> 149;
                                case 50 -> 220;
                                case 51 -> 20;
                                case 52 -> 128;
                                case 53 -> 76;
                                case 54 -> 238;
                                case 55 -> 152;
                                case 56 -> 120;
                                case 57 -> 33;
                                case 58 -> 185;
                                case 59 -> 41;
                                case 60 -> 194;
                                case 61 -> 39;
                                case 62 -> 177;
                                case 63 -> 86;
                                case 64 -> 66;
                                case 65 -> 205;
                                case 66 -> 251;
                                case 67 -> 181;
                                case 68 -> 88;
                                case 69 -> 255;
                                case 70 -> 200;
                                case 71 -> 38;
                                case 72 -> 169;
                                case 73 -> 85;
                                case 74 -> 69;
                                case 75 -> 206;
                                case 76 -> 225;
                                case 77 -> 250;
                                case 78 -> 9;
                                case 79 -> 236;
                                case 80 -> 104;
                                case 81 -> 173;
                                case 82 -> 253;
                                case 83 -> 201;
                                case 84 -> 249;
                                case 85 -> 182;
                                case 86 -> 114;
                                case 87 -> 231;
                                case 88 -> 161;
                                case 89 -> 94;
                                case 90 -> 55;
                                case 91 -> 52;
                                case 92 -> 96;
                                case 93 -> 57;
                                case 94 -> 112;
                                case 95 -> 195;
                                case 96 -> 226;
                                case 97 -> 110;
                                case 98 -> 133;
                                case 99 -> 217;
                                case 100 -> 73;
                                case 101 -> 233;
                                case 102 -> 127;
                                case 103 -> 139;
                                case 104 -> 172;
                                case 105 -> 42;
                                case 106 -> 32;
                                case 107 -> 14;
                                case 108 -> 72;
                                case 109 -> 198;
                                case 110 -> 184;
                                case 111 -> 25;
                                case 112 -> 0;
                                case 113 -> 145;
                                case 114 -> 65;
                                case 115 -> 117;
                                case 116 -> 116;
                                case 117 -> 4;
                                case 118 -> 227;
                                case 119 -> 171;
                                case 120 -> 239;
                                case 121 -> 223;
                                case 122 -> 192;
                                case 123 -> 46;
                                case 124 -> 143;
                                case 125 -> 163;
                                case 126 -> 68;
                                case 127 -> 62;
                                case 128 -> 241;
                                case 129 -> 43;
                                case 130 -> 147;
                                case 131 -> 40;
                                case 132 -> 101;
                                case 133 -> 115;
                                case 134 -> 170;
                                case 135 -> 125;
                                case 136 -> 90;
                                case 137 -> 10;
                                case 138 -> 70;
                                case 139 -> 252;
                                case 140 -> 155;
                                case 141 -> 137;
                                case 142 -> 240;
                                case 143 -> 59;
                                case 144 -> 244;
                                case 145 -> 229;
                                case 146 -> 197;
                                case 147 -> 21;
                                case 148 -> 188;
                                case 149 -> 7;
                                case 150 -> 148;
                                case 151 -> 124;
                                case 152 -> 119;
                                case 153 -> 102;
                                case 154 -> 246;
                                case 155 -> 30;
                                case 156 -> 100;
                                case 157 -> 129;
                                case 158 -> 50;
                                case 159 -> 118;
                                case 160 -> 159;
                                case 161 -> 183;
                                case 162 -> 107;
                                case 163 -> 35;
                                case 164 -> 121;
                                case 165 -> 48;
                                case 166 -> 103;
                                case 167 -> 3;
                                case 168 -> 166;
                                case 169 -> 243;
                                case 170 -> 45;
                                case 171 -> 53;
                                case 172 -> 23;
                                case 173 -> 61;
                                case 174 -> 175;
                                case 175 -> 179;
                                case 176 -> 6;
                                case 177 -> 210;
                                case 178 -> 228;
                                case 179 -> 157;
                                case 180 -> 141;
                                case 181 -> 71;
                                case 182 -> 82;
                                case 183 -> 105;
                                case 184 -> 160;
                                case 185 -> 13;
                                case 186 -> 135;
                                case 187 -> 28;
                                case 188 -> 97;
                                case 189 -> 49;
                                case 190 -> 109;
                                case 191 -> 234;
                                case 192 -> 187;
                                case 193 -> 242;
                                case 194 -> 1;
                                case 195 -> 19;
                                case 196 -> 8;
                                case 197 -> 214;
                                case 198 -> 123;
                                case 199 -> 78;
                                case 200 -> 186;
                                case 201 -> 27;
                                case 202 -> 151;
                                case 203 -> 254;
                                case 204 -> 190;
                                case 205 -> 111;
                                case 206 -> 213;
                                case 207 -> 138;
                                case 208 -> 84;
                                case 209 -> 79;
                                case 210 -> 89;
                                case 211 -> 12;
                                case 212 -> 162;
                                case 213 -> 37;
                                case 214 -> 15;
                                case 215 -> 209;
                                case 216 -> 54;
                                case 217 -> 26;
                                case 218 -> 67;
                                case 219 -> 208;
                                case 220 -> 178;
                                case 221 -> 211;
                                case 222 -> 165;
                                case 223 -> 176;
                                case 224 -> 158;
                                case 225 -> 99;
                                case 226 -> 51;
                                case 227 -> 44;
                                case 228 -> 31;
                                case 229 -> 180;
                                case 230 -> 204;
                                case 231 -> 34;
                                case 232 -> 235;
                                case 233 -> 203;
                                case 234 -> 126;
                                case 235 -> 29;
                                case 236 -> 248;
                                case 237 -> 221;
                                case 238 -> 216;
                                case 239 -> 144;
                                case 240 -> 98;
                                case 241 -> 92;
                                case 242 -> 64;
                                case 243 -> 245;
                                case 244 -> 16;
                                case 245 -> 47;
                                case 246 -> 80;
                                case 247 -> 167;
                                case 248 -> 11;
                                case 249 -> 18;
                                case 250 -> 174;
                                case 251 -> 87;
                                case 252 -> 215;
                                case 253 -> 24;
                                case 254 -> 218;
                                default -> 58;
                            };
                            int n8 = ((n3 ^= n4) & 0xFF) - n7;
                            if (n8 < 0) {
                                n8 += 256;
                            }
                            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                n6 += 256;
                            }
                            int n9 = 0;
                            while (n9 < cArray.length) {
                                int n10 = n9 % 2;
                                int n11 = n9;
                                char[] cArray2 = cArray;
                                char c2 = cArray[n11];
                                if (n10 == 0) {
                                    cArray2[n11] = (char)(c2 ^ n8);
                                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                } else {
                                    cArray2[n11] = (char)(c2 ^ n6);
                                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                }
                                ++n9;
                            }
                            monitorOneConnection.4.b[n5] = new String(cArray).intern();
                        }
                        return b[n5];
                    }
                });
                lifetime.onTermination((Function0)new Function0<Unit>(clientSocket, this, n3, string, rdConnection){
                    final /* synthetic */ Socket $clientSocket;
                    final /* synthetic */ ServerSocketWrapper this$0;
                    final /* synthetic */ int $portNumber;
                    final /* synthetic */ String $connectionId;
                    final /* synthetic */ RdConnection $rdConnection;
                    private static final String[] a;
                    private static final String[] b;
                    {
                        this.$clientSocket = $clientSocket;
                        this.this$0 = $receiver;
                        this.$portNumber = $portNumber;
                        this.$connectionId = $connectionId;
                        this.$rdConnection = $rdConnection;
                        super(0);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final void invoke() {
                        block15: {
                            block11: {
                                var1_1 = 23344081833366L;
                                var4_2 = ServerSocketWrapper.Companion.getLogger();
                                var3_4 = ServerSocketPortState.C();
                                var6_5 = this.$clientSocket;
                                var7_7 = this.this$0;
                                var8_9 = this.$portNumber;
                                var9_10 = this.$connectionId;
                                var5_11 = null;
                                var10_12 = false;
                                try {
                                    v0 = var4_2;
                                    if (var3_4 == null) {
                                        if (!v0.isDebugEnabled()) break block11;
                                    }
                                    ** GOTO lbl30
                                }
                                catch (Throwable v1) {
                                    throw monitorOneConnection.5.a(v1);
                                }
                                var12_13 = var4_2;
                                var11_14 = false;
                                var13_15 = var9_10;
                                var14_16 = var8_9;
                                var15_17 = PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)var7_7.getRdPort().getRdPortState())));
                                var16_18 = var6_5.getPort();
                                var12_13.debug(monitorOneConnection.5.a(934529100 + (char)-2719, 934660170 - (char)-1305, (int)var1_1) + var16_18 + monitorOneConnection.5.a(934529100 + (char)-2720, -934660170 - -((char)-3909), (int)var1_1) + var15_17 + monitorOneConnection.5.a(934529100 + (char)-2717, -934529100 + -((char)-5754), (int)var1_1) + var14_16 + monitorOneConnection.5.a(934529100 + (char)-2718, -934529100 + -((char)-7489), (int)var1_1) + var13_15, (Throwable)var5_11);
                            }
                            try {
                                block16: {
                                    block14: {
                                        block12: {
                                            block13: {
                                                v0 = ServerSocketWrapper.Companion.getLogger();
lbl30:
                                                // 2 sources

                                                var4_2 = v0;
                                                var6_5 = this.$connectionId;
                                                var5_11 = null;
                                                var7_8 = false;
                                                try {
                                                    v2 = var4_2.isDebugEnabled();
                                                    if (var3_4 != null) break block12;
                                                    if (!v2) break block13;
                                                }
                                                catch (Throwable v3) {
                                                    throw monitorOneConnection.5.a(v3);
                                                }
                                                var12_13 = var4_2;
                                                var8_9 = 0;
                                                var12_13.debug(monitorOneConnection.5.a(934529100 + (char)-2723, 934529100 + (char)-12008, (int)var1_1) + (String)var6_5, (Throwable)var5_11);
                                            }
                                            try {
                                                v4 = this;
                                                if (var3_4 != null) break block14;
                                                v2 = v4.$clientSocket.isClosed();
                                            }
                                            catch (Throwable v5) {
                                                throw monitorOneConnection.5.a(v5);
                                            }
                                        }
                                        if (v2) break block15;
                                        var4_2 = ServerSocketWrapper.Companion.getLogger();
                                        v4 = this;
                                    }
                                    var5_11 = v4.$connectionId;
                                    var6_6 = false;
                                    try {
                                        if (var3_4 != null) break block15;
                                        if (!var4_2.isTraceEnabled()) break block16;
                                    }
                                    catch (Throwable v6) {
                                        throw monitorOneConnection.5.a(v6);
                                    }
                                    var12_13 = var4_2;
                                    var7_8 = false;
                                    var12_13.trace(monitorOneConnection.5.a(934529100 + (char)-2724, 934529100 + (char)-2799, (int)var1_1) + var5_11);
                                }
                                this.$clientSocket.close();
                            }
                            catch (Throwable var4_3) {
                                ServerSocketWrapper.Companion.getLogger().error(var4_3);
                            }
                        }
                        ApplicationKt.getApplication().invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invoke$lambda$3(com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketWrapper com.jetbrains.codeWithMe.model.RdConnection ), ()V)((ServerSocketWrapper)this.this$0, (RdConnection)this.$rdConnection));
                    }

                    private static final void invoke$lambda$3(ServerSocketWrapper this$0, RdConnection $rdConnection) {
                        long l2 = 94117871133160L;
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)monitorOneConnection.5.a(-2042201670 - -6171, 2042201670 - 8810, (int)l2));
                        Intrinsics.checkNotNullParameter((Object)$rdConnection, (String)monitorOneConnection.5.a(-2042201670 - -6170, 2042201670 - 14417, (int)l2));
                        this$0.getRdPort().getConnections().remove((Object)$rdConnection);
                    }

                    private static Throwable a(Throwable throwable) {
                        return throwable;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    static {
                        block20: {
                            block19: {
                                var5 = new String[8];
                                var3_1 = 0;
                                var2_2 = "\u0019\u00fc\u0014\u00f3\u00dc\u0086\u00cd\u00c5\u00a3\u0012\u00f5\u00cbA?\u00de\u00c3\u00ff'=O\u00a4\u0004\u008e\u00ac\u0089\u00f7\u0004\u00c4\u0091\u00c0P\u0006\u009a\u0001\u00d1\u00aa\u00ac\u008e\u001b{\u001c\u00eb\u00a5\u00b6$\u00a9\u00f9v\u009cL\u001b\b\u0004\n\u00a3H\u00c0\ba\u00f3\u00ff=}-9~\u0014\u0016\u00f9\u00c4g\u009b\u008c\u00d0${\u008d\u00db\u00b0\u0002\u00e4\u0093\u00df\u00f0q\u0088\u00f5";
                                var4_3 = "\u0019\u00fc\u0014\u00f3\u00dc\u0086\u00cd\u00c5\u00a3\u0012\u00f5\u00cbA?\u00de\u00c3\u00ff'=O\u00a4\u0004\u008e\u00ac\u0089\u00f7\u0004\u00c4\u0091\u00c0P\u0006\u009a\u0001\u00d1\u00aa\u00ac\u008e\u001b{\u001c\u00eb\u00a5\u00b6$\u00a9\u00f9v\u009cL\u001b\b\u0004\n\u00a3H\u00c0\ba\u00f3\u00ff=}-9~\u0014\u0016\u00f9\u00c4g\u009b\u008c\u00d0${\u008d\u00db\u00b0\u0002\u00e4\u0093\u00df\u00f0q\u0088\u00f5".length();
                                var1_4 = 21;
                                var0_5 = -1;
lbl7:
                                // 2 sources

                                while (true) {
                                    v0 = 110;
                                    v1 = ++var0_5;
                                    v2 = var2_2.substring(v1, v1 + var1_4);
                                    v3 = -1;
                                    break block19;
                                    break;
                                }
lbl13:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    var2_2 = "\u0018\u009b\u00b4\u00c9xa\r6\\&X\u00cd;\u00b3\u00f1I\u00a7\u00e3\u00ef#";
                                    var4_3 = "\u0018\u009b\u00b4\u00c9xa\r6\\&X\u00cd;\u00b3\u00f1I\u00a7\u00e3\u00ef#".length();
                                    var1_4 = 6;
                                    var0_5 = -1;
lbl22:
                                    // 2 sources

                                    while (true) {
                                        v0 = 76;
                                        v5 = ++var0_5;
                                        v2 = var2_2.substring(v5, v5 + var1_4);
                                        v3 = 0;
                                        break block19;
                                        break;
                                    }
                                    break;
                                }
lbl28:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    break block20;
                                    break;
                                }
                            }
                            v6 = v2.toCharArray();
                            v7 = v6.length;
                            var6_6 = 0;
                            v8 = v0;
                            v9 = v6;
                            v10 = v7;
                            if (v7 > 1) ** GOTO lbl85
                            do {
                                v11 = v8;
                                v9 = v9;
                                v12 = v9;
                                v13 = v8;
                                v14 = var6_6;
                                while (true) {
                                    switch (var6_6 % 7) {
                                        case 0: {
                                            v15 = 31;
                                            break;
                                        }
                                        case 1: {
                                            v15 = 114;
                                            break;
                                        }
                                        case 2: {
                                            v15 = 2;
                                            break;
                                        }
                                        case 3: {
                                            v15 = 39;
                                            break;
                                        }
                                        case 4: {
                                            v15 = 11;
                                            break;
                                        }
                                        case 5: {
                                            v15 = 84;
                                            break;
                                        }
                                        default: {
                                            v15 = 66;
                                        }
                                    }
                                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                                    ++var6_6;
                                    v8 = v11;
                                    if (v11 != 0) break;
                                    v11 = v8;
                                    v9 = v9;
                                    v14 = v8;
                                    v12 = v9;
                                    v13 = v8;
                                }
lbl85:
                                // 2 sources

                                v16 = v9;
                                v10 = v10;
                            } while (v10 > var6_6);
                            v4 = new String(v16);
                            switch (v3) {
                                default: {
                                    ** continue;
                                }
                                ** case 0:
lbl95:
                                // 1 sources

                                ** continue;
                            }
                        }
                        monitorOneConnection.5.a = var5;
                        monitorOneConnection.5.b = new String[8];
                    }

                    private static String a(int n2, int n3, int n4) {
                        int n5 = (n2 ^ n4 ^ 0x303B) & 0xFFFF;
                        if (b[n5] == null) {
                            int n6;
                            char[] cArray = a[n5].toCharArray();
                            int n7 = switch (cArray[0] & 0xFF) {
                                case 0 -> 153;
                                case 1 -> 98;
                                case 2 -> 205;
                                case 3 -> 193;
                                case 4 -> 251;
                                case 5 -> 36;
                                case 6 -> 228;
                                case 7 -> 164;
                                case 8 -> 26;
                                case 9 -> 50;
                                case 10 -> 165;
                                case 11 -> 166;
                                case 12 -> 89;
                                case 13 -> 20;
                                case 14 -> 30;
                                case 15 -> 57;
                                case 16 -> 44;
                                case 17 -> 230;
                                case 18 -> 246;
                                case 19 -> 189;
                                case 20 -> 215;
                                case 21 -> 202;
                                case 22 -> 184;
                                case 23 -> 163;
                                case 24 -> 79;
                                case 25 -> 100;
                                case 26 -> 211;
                                case 27 -> 21;
                                case 28 -> 107;
                                case 29 -> 138;
                                case 30 -> 250;
                                case 31 -> 243;
                                case 32 -> 81;
                                case 33 -> 105;
                                case 34 -> 9;
                                case 35 -> 66;
                                case 36 -> 178;
                                case 37 -> 133;
                                case 38 -> 210;
                                case 39 -> 54;
                                case 40 -> 252;
                                case 41 -> 233;
                                case 42 -> 249;
                                case 43 -> 114;
                                case 44 -> 172;
                                case 45 -> 47;
                                case 46 -> 4;
                                case 47 -> 209;
                                case 48 -> 196;
                                case 49 -> 118;
                                case 50 -> 199;
                                case 51 -> 119;
                                case 52 -> 76;
                                case 53 -> 143;
                                case 54 -> 222;
                                case 55 -> 242;
                                case 56 -> 192;
                                case 57 -> 134;
                                case 58 -> 239;
                                case 59 -> 71;
                                case 60 -> 65;
                                case 61 -> 99;
                                case 62 -> 152;
                                case 63 -> 227;
                                case 64 -> 141;
                                case 65 -> 247;
                                case 66 -> 63;
                                case 67 -> 212;
                                case 68 -> 122;
                                case 69 -> 188;
                                case 70 -> 10;
                                case 71 -> 248;
                                case 72 -> 170;
                                case 73 -> 86;
                                case 74 -> 2;
                                case 75 -> 245;
                                case 76 -> 33;
                                case 77 -> 45;
                                case 78 -> 174;
                                case 79 -> 3;
                                case 80 -> 117;
                                case 81 -> 191;
                                case 82 -> 112;
                                case 83 -> 218;
                                case 84 -> 129;
                                case 85 -> 62;
                                case 86 -> 201;
                                case 87 -> 190;
                                case 88 -> 25;
                                case 89 -> 226;
                                case 90 -> 27;
                                case 91 -> 135;
                                case 92 -> 173;
                                case 93 -> 73;
                                case 94 -> 123;
                                case 95 -> 38;
                                case 96 -> 181;
                                case 97 -> 75;
                                case 98 -> 77;
                                case 99 -> 139;
                                case 100 -> 146;
                                case 101 -> 220;
                                case 102 -> 90;
                                case 103 -> 167;
                                case 104 -> 187;
                                case 105 -> 103;
                                case 106 -> 82;
                                case 107 -> 84;
                                case 108 -> 87;
                                case 109 -> 195;
                                case 110 -> 131;
                                case 111 -> 213;
                                case 112 -> 159;
                                case 113 -> 253;
                                case 114 -> 255;
                                case 115 -> 179;
                                case 116 -> 244;
                                case 117 -> 46;
                                case 118 -> 126;
                                case 119 -> 32;
                                case 120 -> 108;
                                case 121 -> 183;
                                case 122 -> 208;
                                case 123 -> 78;
                                case 124 -> 127;
                                case 125 -> 232;
                                case 126 -> 22;
                                case 127 -> 236;
                                case 128 -> 88;
                                case 129 -> 197;
                                case 130 -> 185;
                                case 131 -> 41;
                                case 132 -> 13;
                                case 133 -> 231;
                                case 134 -> 29;
                                case 135 -> 68;
                                case 136 -> 67;
                                case 137 -> 180;
                                case 138 -> 160;
                                case 139 -> 74;
                                case 140 -> 115;
                                case 141 -> 93;
                                case 142 -> 6;
                                case 143 -> 37;
                                case 144 -> 145;
                                case 145 -> 176;
                                case 146 -> 94;
                                case 147 -> 102;
                                case 148 -> 12;
                                case 149 -> 169;
                                case 150 -> 161;
                                case 151 -> 147;
                                case 152 -> 106;
                                case 153 -> 83;
                                case 154 -> 28;
                                case 155 -> 204;
                                case 156 -> 0;
                                case 157 -> 51;
                                case 158 -> 168;
                                case 159 -> 151;
                                case 160 -> 42;
                                case 161 -> 97;
                                case 162 -> 148;
                                case 163 -> 5;
                                case 164 -> 132;
                                case 165 -> 15;
                                case 166 -> 113;
                                case 167 -> 136;
                                case 168 -> 104;
                                case 169 -> 121;
                                case 170 -> 171;
                                case 171 -> 144;
                                case 172 -> 111;
                                case 173 -> 234;
                                case 174 -> 40;
                                case 175 -> 182;
                                case 176 -> 7;
                                case 177 -> 43;
                                case 178 -> 31;
                                case 179 -> 155;
                                case 180 -> 150;
                                case 181 -> 35;
                                case 182 -> 110;
                                case 183 -> 48;
                                case 184 -> 130;
                                case 185 -> 24;
                                case 186 -> 95;
                                case 187 -> 61;
                                case 188 -> 223;
                                case 189 -> 69;
                                case 190 -> 177;
                                case 191 -> 92;
                                case 192 -> 120;
                                case 193 -> 128;
                                case 194 -> 17;
                                case 195 -> 207;
                                case 196 -> 1;
                                case 197 -> 162;
                                case 198 -> 60;
                                case 199 -> 14;
                                case 200 -> 142;
                                case 201 -> 19;
                                case 202 -> 237;
                                case 203 -> 18;
                                case 204 -> 91;
                                case 205 -> 229;
                                case 206 -> 72;
                                case 207 -> 219;
                                case 208 -> 137;
                                case 209 -> 52;
                                case 210 -> 157;
                                case 211 -> 241;
                                case 212 -> 23;
                                case 213 -> 149;
                                case 214 -> 125;
                                case 215 -> 109;
                                case 216 -> 64;
                                case 217 -> 200;
                                case 218 -> 216;
                                case 219 -> 70;
                                case 220 -> 124;
                                case 221 -> 240;
                                case 222 -> 16;
                                case 223 -> 206;
                                case 224 -> 225;
                                case 225 -> 140;
                                case 226 -> 221;
                                case 227 -> 101;
                                case 228 -> 214;
                                case 229 -> 238;
                                case 230 -> 254;
                                case 231 -> 224;
                                case 232 -> 80;
                                case 233 -> 96;
                                case 234 -> 85;
                                case 235 -> 156;
                                case 236 -> 158;
                                case 237 -> 203;
                                case 238 -> 154;
                                case 239 -> 217;
                                case 240 -> 116;
                                case 241 -> 39;
                                case 242 -> 49;
                                case 243 -> 235;
                                case 244 -> 58;
                                case 245 -> 186;
                                case 246 -> 194;
                                case 247 -> 11;
                                case 248 -> 59;
                                case 249 -> 53;
                                case 250 -> 198;
                                case 251 -> 56;
                                case 252 -> 55;
                                case 253 -> 175;
                                case 254 -> 34;
                                default -> 8;
                            };
                            int n8 = ((n3 ^= n4) & 0xFF) - n7;
                            if (n8 < 0) {
                                n8 += 256;
                            }
                            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                n6 += 256;
                            }
                            int n9 = 0;
                            while (n9 < cArray.length) {
                                int n10 = n9 % 2;
                                int n11 = n9;
                                char[] cArray2 = cArray;
                                char c2 = cArray[n11];
                                if (n10 == 0) {
                                    cArray2[n11] = (char)(c2 ^ n8);
                                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                } else {
                                    cArray2[n11] = (char)(c2 ^ n6);
                                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                }
                                ++n9;
                            }
                            monitorOneConnection.5.b[n5] = new String(cArray).intern();
                        }
                        return b[n5];
                    }
                });
                object = ServerSocketWrapper.a(2029094670 - (char)-1879, 2029094670 - (char)-26591, (int)l2) + string;
                object2 = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)object, (int)0, (Function0)((Function0)new Function0<Unit>((String)object, lifetime, clientSocket, string, this, rdConnection){
                    final /* synthetic */ String $threadName;
                    final /* synthetic */ Lifetime $rdConnectionLifetime;
                    final /* synthetic */ Socket $clientSocket;
                    final /* synthetic */ String $connectionId;
                    final /* synthetic */ ServerSocketWrapper this$0;
                    final /* synthetic */ RdConnection $rdConnection;
                    private static final String[] a;
                    private static final String[] b;
                    {
                        this.$threadName = $threadName;
                        this.$rdConnectionLifetime = $rdConnectionLifetime;
                        this.$clientSocket = $clientSocket;
                        this.$connectionId = $connectionId;
                        this.this$0 = $receiver;
                        this.$rdConnection = $rdConnection;
                        super(0);
                    }

                    /*
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    public final void invoke() {
                        block53: {
                            block51: {
                                block52: {
                                    block41: {
                                        var1_1 = 13363102394046L;
                                        var4_2 = 0;
                                        var3_3 = ServerSocketPortState.C();
                                        ServerSocketWrapper.Companion.getLogger().debug(monitorOneConnection.myThread.1.a(1459071240 + (char)-8340, -1459202310 - -((char)-8223), (int)var1_1) + this.$threadName + monitorOneConnection.myThread.1.a(1459071240 + (char)-8339, -1459071240 + -((char)-10298), (int)var1_1));
                                        while (RLifetimeKt.isAlive((Lifetime)this.$rdConnectionLifetime)) {
                                            try {
                                                block47: {
                                                    block48: {
                                                        block46: {
                                                            block45: {
                                                                block44: {
                                                                    block56: {
                                                                        block42: {
                                                                            block43: {
                                                                                block40: {
                                                                                    var5_4 /* !! */  = ServerSocketWrapper.Companion.getLogger();
                                                                                    var6_9 = this.$connectionId;
                                                                                    var7_12 = false;
                                                                                    if (var3_3 != null) break block40;
                                                                                    try {
                                                                                        block55: {
                                                                                            v0 = var5_4 /* !! */ ;
                                                                                            if (var3_3 != null) break block41;
                                                                                            break block55;
                                                                                            catch (SocketTimeoutException v1) {
                                                                                                throw monitorOneConnection.myThread.1.a(v1);
                                                                                            }
                                                                                        }
                                                                                        if (!v0.isTraceEnabled()) break block40;
                                                                                    }
                                                                                    catch (SocketTimeoutException v2) {
                                                                                        throw monitorOneConnection.myThread.1.a(v2);
                                                                                    }
                                                                                    var12_26 /* !! */  = var5_4 /* !! */ ;
                                                                                    var8_17 = false;
                                                                                    var12_26 /* !! */ .trace(monitorOneConnection.myThread.1.a(1459071240 + (char)-8338, 1459202310 - (char)-20099, (int)var1_1) + var6_9);
                                                                                }
                                                                                var5_4 /* !! */  = null;
                                                                                var5_4 /* !! */  = (Logger)new byte[4096];
                                                                                var6_8 = this.$clientSocket.getInputStream().read((byte[])var5_4 /* !! */ );
                                                                                try {
                                                                                    v3 = var6_8;
                                                                                    if (var3_3 != null) break block42;
                                                                                    if (v3 != -1) break block43;
                                                                                }
                                                                                catch (SocketTimeoutException v4) {
                                                                                    throw monitorOneConnection.myThread.1.a(v4);
                                                                                }
                                                                                var7_13 = ServerSocketWrapper.Companion.getLogger();
                                                                                var9_21 = this.$connectionId;
                                                                                var8_18 = null;
                                                                                var10_25 = false;
                                                                                try {
                                                                                    if (var3_3 != null || !var7_13.isDebugEnabled()) break;
                                                                                }
                                                                                catch (SocketTimeoutException v5) {
                                                                                    throw monitorOneConnection.myThread.1.a(v5);
                                                                                }
                                                                                var12_26 /* !! */  = var7_13;
                                                                                var11_30 = false;
                                                                                var12_26 /* !! */ .debug(monitorOneConnection.myThread.1.a(1459071240 + (char)-8337, -1459202310 - -((char)-3003), (int)var1_1) + var9_21, var8_18);
                                                                                break;
                                                                            }
                                                                            v3 = var6_8;
                                                                        }
                                                                        if (var3_3 != null) break block44;
                                                                        if (v3 != 0) ** GOTO lbl70
                                                                        break block56;
                                                                        catch (SocketTimeoutException v6) {
                                                                            throw monitorOneConnection.myThread.1.a(v6);
                                                                        }
                                                                    }
                                                                    try {
                                                                        block57: {
                                                                            ServerSocketWrapper.Companion.getLogger().error(monitorOneConnection.myThread.1.a(1459071240 + (char)-8344, -1459202310 - -((char)-19330), (int)var1_1) + this.$connectionId);
                                                                            if (var3_3 == null) break;
                                                                            break block57;
                                                                            catch (SocketTimeoutException v7) {
                                                                                throw monitorOneConnection.myThread.1.a(v7);
                                                                            }
                                                                        }
                                                                        v3 = var6_8;
                                                                    }
                                                                    catch (SocketTimeoutException v8) {
                                                                        throw monitorOneConnection.myThread.1.a(v8);
                                                                    }
                                                                }
                                                                if (var3_3 != null) break block45;
                                                                try {
                                                                    block58: {
                                                                        if (v3 >= ((Logger)var5_4 /* !! */ ).length) break block46;
                                                                        break block58;
                                                                        catch (SocketTimeoutException v9) {
                                                                            throw monitorOneConnection.myThread.1.a(v9);
                                                                        }
                                                                    }
                                                                    v3 = var6_8;
                                                                }
                                                                catch (SocketTimeoutException v10) {
                                                                    throw monitorOneConnection.myThread.1.a(v10);
                                                                }
                                                            }
                                                            var7_14 = new byte[v3];
                                                            try {
                                                                k.d(-6519431220586551092L, var1_1).invoke(null, k.a((Object)var5_4 /* !! */ , 0, (Object)var7_14, 0, var6_8));
                                                            }
                                                            catch (InvocationTargetException v11) {
                                                                throw v11.getTargetException();
                                                            }
                                                            var5_4 /* !! */  = (Logger)var7_14;
                                                        }
                                                        ServerSocketWrapper.access$getSentBytesCounter$p(this.this$0).add((long)((Logger)var5_4 /* !! */ ).length);
                                                        var7_11 = ServerSocketWrapper.Companion.getLogger();
                                                        var8_16 = this.$connectionId;
                                                        var9_20 = false;
                                                        try {
                                                            v12 = var7_11.isTraceEnabled();
                                                            if (var3_3 != null) break block47;
                                                            if (v12 == 0) break block48;
                                                        }
                                                        catch (SocketTimeoutException v13) {
                                                            throw monitorOneConnection.myThread.1.a(v13);
                                                        }
                                                        var12_26 /* !! */  = var7_11;
                                                        var10_25 = false;
                                                        var13_27 = var8_16;
                                                        var14_28 = ((Logger)var5_4 /* !! */ ).length;
                                                        var15_29 = var4_2;
                                                        var12_26 /* !! */ .trace(monitorOneConnection.myThread.1.a(1459071240 + (char)-8343, 1459202310 - (char)-11175, (int)var1_1) + var15_29 + monitorOneConnection.myThread.1.a(1459071240 + (char)-8342, -1459202310 - -((char)-8536), (int)var1_1) + var14_28 + monitorOneConnection.myThread.1.a(1459071240 + (char)-8341, -1459202310 - -((char)-19725), (int)var1_1) + (String)var13_27);
                                                    }
                                                    this.$rdConnection.getToDestinationSocket().fire((Object)new DebugTrafficInfo(var4_2, (byte[])var5_4 /* !! */ ));
                                                    v12 = var4_2 + 1;
                                                }
                                                var4_2 = v12;
                                            }
                                            catch (SocketTimeoutException var5_5) {
                                                var6_10 = ServerSocketWrapper.Companion.getLogger();
                                                var8_16 = this.$clientSocket;
                                                var9_22 = this.$connectionId;
                                                var7_11 = null;
                                                var10_25 = false;
                                                try {
                                                    if (var3_3 != null || !var6_10.isDebugEnabled()) break;
                                                }
                                                catch (SocketTimeoutException v14) {
                                                    throw monitorOneConnection.myThread.1.a(v14);
                                                }
                                                var12_26 /* !! */  = var6_10;
                                                var11_31 = false;
                                                var12_26 /* !! */ .debug(monitorOneConnection.myThread.1.a(1459071240 + (char)-8332, 1459071240 + (char)-1058, (int)var1_1) + var8_16.getSoTimeout() + monitorOneConnection.myThread.1.a(1459071240 + (char)-8331, -1459202310 - -((char)-16836), (int)var1_1) + var9_22, (Throwable)var7_11);
                                                break;
                                            }
                                            catch (IOException var5_6) {
                                                block49: {
                                                    block50: {
                                                        try {
                                                            try {
                                                                v15 = ServerSocketWrapper.Companion.getLogger();
                                                                v16 = var5_6.getClass();
                                                                v17 = var5_6.getMessage();
                                                                v18 = v17;
                                                                v19 = v17;
                                                                if (var3_3 != null) break block49;
                                                                if (v18 != null) break block50;
                                                            }
                                                            catch (SocketTimeoutException v20) {
                                                                throw monitorOneConnection.myThread.1.a(v20);
                                                            }
                                                            v19 = monitorOneConnection.myThread.1.a(1459071240 + (char)-8330, 1459202310 - (char)-2920, (int)var1_1);
                                                        }
                                                        catch (SocketTimeoutException v21) {
                                                            throw monitorOneConnection.myThread.1.a(v21);
                                                        }
                                                    }
                                                    v18 = this.$connectionId;
                                                }
                                                var16_32 = v18;
                                                var17_33 = v19;
                                                var18_34 = v16;
                                                v15.warn(monitorOneConnection.myThread.1.a(1459071240 + (char)-8329, -1459202310 - -((char)-22187), (int)var1_1) + var18_34 + monitorOneConnection.myThread.1.a(1459071240 + (char)-8336, 1459071240 + (char)-3724, (int)var1_1) + var17_33 + monitorOneConnection.myThread.1.a(1459071240 + (char)-8335, -1459071240 + -((char)-4909), (int)var1_1) + var16_32);
                                                break;
                                            }
                                            catch (Throwable var5_7) {
                                                ServerSocketWrapper.Companion.getLogger().error(monitorOneConnection.myThread.1.a(1459071240 + (char)-8334, 1459202310 - (char)-7498, (int)var1_1) + this.$connectionId, var5_7);
                                                break;
                                            }
                                        }
                                        v0 = ServerSocketWrapper.Companion.getLogger();
                                    }
                                    var5_4 /* !! */  = v0;
                                    var7_15 = this.$connectionId;
                                    var6_9 = null;
                                    var8_19 = false;
                                    try {
                                        v22 = var5_4 /* !! */ .isDebugEnabled();
                                        if (var3_3 != null) break block51;
                                        if (!v22) break block52;
                                    }
                                    catch (SocketTimeoutException v23) {
                                        throw monitorOneConnection.myThread.1.a(v23);
                                    }
                                    var12_26 /* !! */  = var5_4 /* !! */ ;
                                    var9_23 = false;
                                    var12_26 /* !! */ .debug(monitorOneConnection.myThread.1.a(1459071240 + (char)-8333, 1459071240 + (char)-5102, (int)var1_1) + var7_15, (Throwable)var6_9);
                                }
                                try {
                                    this.$rdConnection.getAcceptedConnectionSocketInputShutdown().fire((Object)Unit.INSTANCE);
                                    if (var3_3 != null) break block53;
                                    v22 = this.$clientSocket.isClosed();
                                }
                                catch (SocketTimeoutException v24) {
                                    throw monitorOneConnection.myThread.1.a(v24);
                                }
                            }
                            if (v22) {
                                block54: {
                                    var5_4 /* !! */  = ServerSocketWrapper.Companion.getLogger();
                                    var7_15 = this.$connectionId;
                                    var6_9 = null;
                                    var8_19 = false;
                                    try {
                                        if (var3_3 != null || !var5_4 /* !! */ .isDebugEnabled()) break block54;
                                    }
                                    catch (SocketTimeoutException v25) {
                                        throw monitorOneConnection.myThread.1.a(v25);
                                    }
                                    var12_26 /* !! */  = var5_4 /* !! */ ;
                                    var9_24 = false;
                                    var12_26 /* !! */ .debug(monitorOneConnection.myThread.1.a(1459071240 + (char)-8356, -1459071240 + -((char)-9121), (int)var1_1) + var7_15, (Throwable)var6_9);
                                }
                                this.$rdConnection.getAcceptedConnectionSocketOutputShutdown().fire((Object)Unit.INSTANCE);
                            }
                            ServerSocketWrapper.Companion.getLogger().debug(monitorOneConnection.myThread.1.a(1459071240 + (char)-8355, 1459202310 - (char)-17231, (int)var1_1) + this.$threadName + monitorOneConnection.myThread.1.a(1459071240 + (char)-8354, 1459202310 - (char)-17782, (int)var1_1));
                        }
                    }

                    private static SocketTimeoutException a(SocketTimeoutException socketTimeoutException) {
                        return socketTimeoutException;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    static {
                        block20: {
                            block19: {
                                var5 = new String[19];
                                var3_1 = 0;
                                var2_2 = ";8\u00bb\u001a\u00a7\\\u009b\u00bb\tDFl\u0085|\u008a\u00b4\u00f7X\u001f/%wU@\u009b\u00f5\u00c74\\\u00da[D\u0004\u00f9\u0086\u00ae\u009c\u00fa\u0092\u0016\u00d3{D\u0000\u00e0h\u00de\u00b2\u00f5\u00ca\u0013<\u00d7\u00aaJ\u00b5>\u00a1\u0090\u0011\u001be\u00dd\u0097\\0\u001b\u0012\u0000\u0007>\u00b9\u00f3\u00dd\u00b8\u008f\u00b7\u00ee\u00b4\u00e7\\\b\u0094\u00f2\u00d7\u0007\u00bbZ\u0087I\u00ec\u00fc\u0081\u0015c\u00ee\u00a9\u00d2\u00f8}\u00a6\u00b5\u0088f\u000e\u00ad\u00f6X\u00cb\u00efX\u00e3\u00b23\u001a\u0017\u000e\u0000\u00e8_\u00ce\u0098\u00a7\u00c8\u00dcL\\\u00b1\u0010\u00a2_\u00a7\u0091\u000f=\u0002\u0080\u00f0W*\u00cb9\u00c0\"Mt\u00d4T\u008c\u0011\u0017\u00b0\u00fd\u00d1\u00dd\u00c3\u001d`w\u00bf2\u00e2\u00b99\u00e9x\u0080\u0006N\u00b6]\u008bX\u000b\u0015\u0000\u00c9\u0010\u00b6d\u0017\u00ad\u009e\u001d\u00cc\u00c0\u00fd\u00c0\u00cf\u000e2\u00d7b\u00b8v\u00fc(J\u0012P\u00f3\u00afDeV\u00828,l\u00e7Gi\u00f5\u0094\u008f\u00c5H\u00f1u\u0088\u00bf\u0090Vz\u00f1\u00fb\u00b4\u00db\u00ca\u00abF\u0016\u00ffR\u00eb)8\f\u009dQ\u00a5\u00b4\u00d6ek\u00e9A\u0013\u001dM'\u0084>\u0080Hv\u00c8\u00efeU\u00b3\u00c9\u0012\u00e12*\u008dS\u0095(\u0088\u00ee\u00b5\u00c6\u001dg\u00bd\u0015\u00d1\u00ba6\u00a9\u00c9\u00c76\u00ed\u00ac\u00c7cd\u0002s\u00ab\u0012+\u00b0z\u0011j\n\u0007\u00de\"d*\"x\u00ed0\u00ad,`\u001eX\u00df\u00d1\u00f4\u00c8\u0091\fX\u00fb\u00fd\u00a7y\u009e\u008fs\u00ea[\u00ac \u00e7\u00bbe\u00b2\u00d2\u00e5T\u00ce\u00c8X\u0081&\u00fa\f\u00f7\u00b1!\u00a7\u00a5\u00e3\u00acN\fn\u008e?\u00bb\u00ed\u00ca\u00ca\u00a6kB\u0082\u00ce\u000eL\u00dew\u00c8\u00ae\u00dc\u001ej\u00fb|\u00bd0\u0099\u009a`kA\u00c5\u0018g\u0092mE\u00b5\u009a/\u00f4\u00eal7\u0087[\u0087\u0094\u00c2\u0004\u00b7\u0006\u00a8U\nTR\u00ca\u008f\u0092\u0000j1\u0095\u0092\u009c\u00ef\u00e4\u0002\u00c9\u00d1^m\u00ee\u00f4\u00c2\u00cb#r\u00a8\u00f2\u0087\u008a\u00b5\u00ba\u0086J\\yT\u00be\u000b\u00c0y*\u00b6\u00e2\u00d9\u00aeQ\u00df\u0097\u008c\r\u00a5,\u0099~\u00e8\u00d8\u0018;M\u0089F\u00f0J\u007fBb\u00b3\u00dcb\u00f8\t";
                                var4_3 = ";8\u00bb\u001a\u00a7\\\u009b\u00bb\tDFl\u0085|\u008a\u00b4\u00f7X\u001f/%wU@\u009b\u00f5\u00c74\\\u00da[D\u0004\u00f9\u0086\u00ae\u009c\u00fa\u0092\u0016\u00d3{D\u0000\u00e0h\u00de\u00b2\u00f5\u00ca\u0013<\u00d7\u00aaJ\u00b5>\u00a1\u0090\u0011\u001be\u00dd\u0097\\0\u001b\u0012\u0000\u0007>\u00b9\u00f3\u00dd\u00b8\u008f\u00b7\u00ee\u00b4\u00e7\\\b\u0094\u00f2\u00d7\u0007\u00bbZ\u0087I\u00ec\u00fc\u0081\u0015c\u00ee\u00a9\u00d2\u00f8}\u00a6\u00b5\u0088f\u000e\u00ad\u00f6X\u00cb\u00efX\u00e3\u00b23\u001a\u0017\u000e\u0000\u00e8_\u00ce\u0098\u00a7\u00c8\u00dcL\\\u00b1\u0010\u00a2_\u00a7\u0091\u000f=\u0002\u0080\u00f0W*\u00cb9\u00c0\"Mt\u00d4T\u008c\u0011\u0017\u00b0\u00fd\u00d1\u00dd\u00c3\u001d`w\u00bf2\u00e2\u00b99\u00e9x\u0080\u0006N\u00b6]\u008bX\u000b\u0015\u0000\u00c9\u0010\u00b6d\u0017\u00ad\u009e\u001d\u00cc\u00c0\u00fd\u00c0\u00cf\u000e2\u00d7b\u00b8v\u00fc(J\u0012P\u00f3\u00afDeV\u00828,l\u00e7Gi\u00f5\u0094\u008f\u00c5H\u00f1u\u0088\u00bf\u0090Vz\u00f1\u00fb\u00b4\u00db\u00ca\u00abF\u0016\u00ffR\u00eb)8\f\u009dQ\u00a5\u00b4\u00d6ek\u00e9A\u0013\u001dM'\u0084>\u0080Hv\u00c8\u00efeU\u00b3\u00c9\u0012\u00e12*\u008dS\u0095(\u0088\u00ee\u00b5\u00c6\u001dg\u00bd\u0015\u00d1\u00ba6\u00a9\u00c9\u00c76\u00ed\u00ac\u00c7cd\u0002s\u00ab\u0012+\u00b0z\u0011j\n\u0007\u00de\"d*\"x\u00ed0\u00ad,`\u001eX\u00df\u00d1\u00f4\u00c8\u0091\fX\u00fb\u00fd\u00a7y\u009e\u008fs\u00ea[\u00ac \u00e7\u00bbe\u00b2\u00d2\u00e5T\u00ce\u00c8X\u0081&\u00fa\f\u00f7\u00b1!\u00a7\u00a5\u00e3\u00acN\fn\u008e?\u00bb\u00ed\u00ca\u00ca\u00a6kB\u0082\u00ce\u000eL\u00dew\u00c8\u00ae\u00dc\u001ej\u00fb|\u00bd0\u0099\u009a`kA\u00c5\u0018g\u0092mE\u00b5\u009a/\u00f4\u00eal7\u0087[\u0087\u0094\u00c2\u0004\u00b7\u0006\u00a8U\nTR\u00ca\u008f\u0092\u0000j1\u0095\u0092\u009c\u00ef\u00e4\u0002\u00c9\u00d1^m\u00ee\u00f4\u00c2\u00cb#r\u00a8\u00f2\u0087\u008a\u00b5\u00ba\u0086J\\yT\u00be\u000b\u00c0y*\u00b6\u00e2\u00d9\u00aeQ\u00df\u0097\u008c\r\u00a5,\u0099~\u00e8\u00d8\u0018;M\u0089F\u00f0J\u007fBb\u00b3\u00dcb\u00f8\t".length();
                                var1_4 = 8;
                                var0_5 = -1;
lbl7:
                                // 2 sources

                                while (true) {
                                    v0 = 72;
                                    v1 = ++var0_5;
                                    v2 = var2_2.substring(v1, v1 + var1_4);
                                    v3 = -1;
                                    break block19;
                                    break;
                                }
lbl13:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    var2_2 = "Xm-J\u008f\u00acd_\u0007\u009ci\u009b\u0080\u00a9\u009eA";
                                    var4_3 = "Xm-J\u008f\u00acd_\u0007\u009ci\u009b\u0080\u00a9\u009eA".length();
                                    var1_4 = 8;
                                    var0_5 = -1;
lbl22:
                                    // 2 sources

                                    while (true) {
                                        v0 = 60;
                                        v5 = ++var0_5;
                                        v2 = var2_2.substring(v5, v5 + var1_4);
                                        v3 = 0;
                                        break block19;
                                        break;
                                    }
                                    break;
                                }
lbl28:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    break block20;
                                    break;
                                }
                            }
                            v6 = v2.toCharArray();
                            v7 = v6.length;
                            var6_6 = 0;
                            v8 = v0;
                            v9 = v6;
                            v10 = v7;
                            if (v7 > 1) ** GOTO lbl85
                            do {
                                v11 = v8;
                                v9 = v9;
                                v12 = v9;
                                v13 = v8;
                                v14 = var6_6;
                                while (true) {
                                    switch (var6_6 % 7) {
                                        case 0: {
                                            v15 = 25;
                                            break;
                                        }
                                        case 1: {
                                            v15 = 81;
                                            break;
                                        }
                                        case 2: {
                                            v15 = 54;
                                            break;
                                        }
                                        case 3: {
                                            v15 = 118;
                                            break;
                                        }
                                        case 4: {
                                            v15 = 10;
                                            break;
                                        }
                                        case 5: {
                                            v15 = 61;
                                            break;
                                        }
                                        default: {
                                            v15 = 2;
                                        }
                                    }
                                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                                    ++var6_6;
                                    v8 = v11;
                                    if (v11 != 0) break;
                                    v11 = v8;
                                    v9 = v9;
                                    v14 = v8;
                                    v12 = v9;
                                    v13 = v8;
                                }
lbl85:
                                // 2 sources

                                v16 = v9;
                                v10 = v10;
                            } while (v10 > var6_6);
                            v4 = new String(v16);
                            switch (v3) {
                                default: {
                                    ** continue;
                                }
                                ** case 0:
lbl95:
                                // 1 sources

                                ** continue;
                            }
                        }
                        monitorOneConnection.myThread.1.a = var5;
                        monitorOneConnection.myThread.1.b = new String[19];
                    }

                    private static String a(int n2, int n3, int n4) {
                        int n5 = (n2 ^ n4 ^ 0x2ECA) & 0xFFFF;
                        if (b[n5] == null) {
                            int n6;
                            char[] cArray = a[n5].toCharArray();
                            int n7 = switch (cArray[0] & 0xFF) {
                                case 0 -> 3;
                                case 1 -> 149;
                                case 2 -> 123;
                                case 3 -> 202;
                                case 4 -> 98;
                                case 5 -> 30;
                                case 6 -> 243;
                                case 7 -> 126;
                                case 8 -> 48;
                                case 9 -> 162;
                                case 10 -> 248;
                                case 11 -> 150;
                                case 12 -> 253;
                                case 13 -> 193;
                                case 14 -> 164;
                                case 15 -> 122;
                                case 16 -> 156;
                                case 17 -> 219;
                                case 18 -> 58;
                                case 19 -> 97;
                                case 20 -> 215;
                                case 21 -> 90;
                                case 22 -> 235;
                                case 23 -> 246;
                                case 24 -> 31;
                                case 25 -> 245;
                                case 26 -> 112;
                                case 27 -> 77;
                                case 28 -> 89;
                                case 29 -> 88;
                                case 30 -> 118;
                                case 31 -> 32;
                                case 32 -> 54;
                                case 33 -> 190;
                                case 34 -> 170;
                                case 35 -> 208;
                                case 36 -> 255;
                                case 37 -> 47;
                                case 38 -> 84;
                                case 39 -> 210;
                                case 40 -> 249;
                                case 41 -> 241;
                                case 42 -> 205;
                                case 43 -> 157;
                                case 44 -> 102;
                                case 45 -> 116;
                                case 46 -> 203;
                                case 47 -> 146;
                                case 48 -> 1;
                                case 49 -> 25;
                                case 50 -> 5;
                                case 51 -> 69;
                                case 52 -> 221;
                                case 53 -> 65;
                                case 54 -> 148;
                                case 55 -> 19;
                                case 56 -> 222;
                                case 57 -> 247;
                                case 58 -> 171;
                                case 59 -> 217;
                                case 60 -> 42;
                                case 61 -> 2;
                                case 62 -> 173;
                                case 63 -> 130;
                                case 64 -> 155;
                                case 65 -> 143;
                                case 66 -> 175;
                                case 67 -> 80;
                                case 68 -> 9;
                                case 69 -> 187;
                                case 70 -> 182;
                                case 71 -> 11;
                                case 72 -> 68;
                                case 73 -> 20;
                                case 74 -> 168;
                                case 75 -> 23;
                                case 76 -> 231;
                                case 77 -> 159;
                                case 78 -> 224;
                                case 79 -> 105;
                                case 80 -> 137;
                                case 81 -> 70;
                                case 82 -> 52;
                                case 83 -> 83;
                                case 84 -> 72;
                                case 85 -> 59;
                                case 86 -> 16;
                                case 87 -> 145;
                                case 88 -> 106;
                                case 89 -> 239;
                                case 90 -> 194;
                                case 91 -> 17;
                                case 92 -> 144;
                                case 93 -> 201;
                                case 94 -> 188;
                                case 95 -> 114;
                                case 96 -> 82;
                                case 97 -> 79;
                                case 98 -> 53;
                                case 99 -> 177;
                                case 100 -> 153;
                                case 101 -> 141;
                                case 102 -> 29;
                                case 103 -> 109;
                                case 104 -> 165;
                                case 105 -> 60;
                                case 106 -> 71;
                                case 107 -> 62;
                                case 108 -> 244;
                                case 109 -> 66;
                                case 110 -> 99;
                                case 111 -> 34;
                                case 112 -> 218;
                                case 113 -> 228;
                                case 114 -> 21;
                                case 115 -> 24;
                                case 116 -> 131;
                                case 117 -> 135;
                                case 118 -> 237;
                                case 119 -> 100;
                                case 120 -> 107;
                                case 121 -> 40;
                                case 122 -> 67;
                                case 123 -> 132;
                                case 124 -> 120;
                                case 125 -> 226;
                                case 126 -> 254;
                                case 127 -> 136;
                                case 128 -> 74;
                                case 129 -> 121;
                                case 130 -> 57;
                                case 131 -> 124;
                                case 132 -> 108;
                                case 133 -> 223;
                                case 134 -> 51;
                                case 135 -> 172;
                                case 136 -> 134;
                                case 137 -> 166;
                                case 138 -> 192;
                                case 139 -> 160;
                                case 140 -> 10;
                                case 141 -> 180;
                                case 142 -> 38;
                                case 143 -> 232;
                                case 144 -> 186;
                                case 145 -> 252;
                                case 146 -> 28;
                                case 147 -> 184;
                                case 148 -> 212;
                                case 149 -> 139;
                                case 150 -> 196;
                                case 151 -> 61;
                                case 152 -> 230;
                                case 153 -> 64;
                                case 154 -> 129;
                                case 155 -> 101;
                                case 156 -> 204;
                                case 157 -> 33;
                                case 158 -> 110;
                                case 159 -> 251;
                                case 160 -> 45;
                                case 161 -> 133;
                                case 162 -> 214;
                                case 163 -> 207;
                                case 164 -> 81;
                                case 165 -> 174;
                                case 166 -> 44;
                                case 167 -> 96;
                                case 168 -> 225;
                                case 169 -> 117;
                                case 170 -> 176;
                                case 171 -> 183;
                                case 172 -> 127;
                                case 173 -> 161;
                                case 174 -> 240;
                                case 175 -> 142;
                                case 176 -> 158;
                                case 177 -> 195;
                                case 178 -> 103;
                                case 179 -> 213;
                                case 180 -> 13;
                                case 181 -> 4;
                                case 182 -> 211;
                                case 183 -> 8;
                                case 184 -> 92;
                                case 185 -> 36;
                                case 186 -> 169;
                                case 187 -> 125;
                                case 188 -> 113;
                                case 189 -> 26;
                                case 190 -> 87;
                                case 191 -> 199;
                                case 192 -> 179;
                                case 193 -> 152;
                                case 194 -> 94;
                                case 195 -> 37;
                                case 196 -> 197;
                                case 197 -> 189;
                                case 198 -> 234;
                                case 199 -> 15;
                                case 200 -> 18;
                                case 201 -> 151;
                                case 202 -> 209;
                                case 203 -> 35;
                                case 204 -> 236;
                                case 205 -> 86;
                                case 206 -> 39;
                                case 207 -> 76;
                                case 208 -> 12;
                                case 209 -> 163;
                                case 210 -> 22;
                                case 211 -> 85;
                                case 212 -> 75;
                                case 213 -> 91;
                                case 214 -> 95;
                                case 215 -> 14;
                                case 216 -> 6;
                                case 217 -> 250;
                                case 218 -> 49;
                                case 219 -> 115;
                                case 220 -> 147;
                                case 221 -> 233;
                                case 222 -> 227;
                                case 223 -> 167;
                                case 224 -> 220;
                                case 225 -> 46;
                                case 226 -> 242;
                                case 227 -> 27;
                                case 228 -> 73;
                                case 229 -> 191;
                                case 230 -> 154;
                                case 231 -> 200;
                                case 232 -> 41;
                                case 233 -> 78;
                                case 234 -> 138;
                                case 235 -> 206;
                                case 236 -> 93;
                                case 237 -> 229;
                                case 238 -> 216;
                                case 239 -> 0;
                                case 240 -> 55;
                                case 241 -> 119;
                                case 242 -> 128;
                                case 243 -> 238;
                                case 244 -> 104;
                                case 245 -> 140;
                                case 246 -> 181;
                                case 247 -> 198;
                                case 248 -> 50;
                                case 249 -> 56;
                                case 250 -> 185;
                                case 251 -> 178;
                                case 252 -> 7;
                                case 253 -> 63;
                                case 254 -> 111;
                                default -> 43;
                            };
                            int n8 = ((n3 ^= n4) & 0xFF) - n7;
                            if (n8 < 0) {
                                n8 += 256;
                            }
                            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                n6 += 256;
                            }
                            int n9 = 0;
                            while (n9 < cArray.length) {
                                int n10 = n9 % 2;
                                int n11 = n9;
                                char[] cArray2 = cArray;
                                char c2 = cArray[n11];
                                if (n10 == 0) {
                                    cArray2[n11] = (char)(c2 ^ n8);
                                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                } else {
                                    cArray2[n11] = (char)(c2 ^ n6);
                                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                }
                                ++n9;
                            }
                            monitorOneConnection.myThread.1.b[n5] = new String(cArray).intern();
                        }
                        return b[n5];
                    }
                }), (int)20, null);
                rdConnection.getReady().advise(lifetime, (Function1)new Function1<Unit, Unit>((Thread)object2, string){
                    final /* synthetic */ Thread $myThread;
                    final /* synthetic */ String $connectionId;
                    private static final String[] a;
                    private static final String[] b;
                    {
                        this.$myThread = $myThread;
                        this.$connectionId = $connectionId;
                        super(1);
                    }

                    public final void invoke(@NotNull Unit it) {
                        block2: {
                            block3: {
                                long l2 = 99237453534577L;
                                Intrinsics.checkNotNullParameter((Object)it, (String)monitorOneConnection.6.a(2060813610 - 3849, -2060813610 - -13335, (int)l2));
                                Logger logger = ServerSocketWrapper.Companion.getLogger();
                                String string = this.$connectionId;
                                int[] nArray = ServerSocketPortState.C();
                                Throwable throwable = null;
                                boolean bl = false;
                                try {
                                    if (nArray != null) break block2;
                                    if (!logger.isDebugEnabled()) break block3;
                                }
                                catch (RuntimeException runtimeException) {
                                    throw monitorOneConnection.6.a(runtimeException);
                                }
                                Logger logger2 = logger;
                                boolean bl2 = false;
                                logger2.debug(monitorOneConnection.6.a(2060813610 - 3850, -2060813610 - -20676, (int)l2) + string, throwable);
                            }
                            this.$myThread.start();
                        }
                    }

                    private static RuntimeException a(RuntimeException runtimeException) {
                        return runtimeException;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    static {
                        block13: {
                            var5 = new String[2];
                            var3_1 = 0;
                            var2_2 = "\u00c3M4\u00deo\u001e\u0098>\u00139\u00ebH\u008f\u0018D\u00feoD\u00ed:\u00bb\u00bcj\u00bbw\u0095\u008b\u007f\u00ac5X\u00c6*\u00ecTCq\u00a8}\u0092\u0085M\u00e7\u00a2\u00a7\u00ac\u0088\u0004\u009f\u0002Z\u0001\u0005tv";
                            var4_3 = "\u00c3M4\u00deo\u001e\u0098>\u00139\u00ebH\u008f\u0018D\u00feoD\u00ed:\u00bb\u00bcj\u00bbw\u0095\u008b\u007f\u00ac5X\u00c6*\u00ecTCq\u00a8}\u0092\u0085M\u00e7\u00a2\u00a7\u00ac\u0088\u0004\u009f\u0002Z\u0001\u0005tv".length();
                            var1_4 = 2;
                            var0_5 = -1;
lbl7:
                            // 2 sources

                            while (true) {
                                continue;
                                break;
                            }
lbl9:
                            // 1 sources

                            while (true) {
                                var5[var3_1++] = new String(v0).intern();
                                if ((var0_5 += var1_4) < var4_3) {
                                    var1_4 = var2_2.charAt(var0_5);
                                    ** continue;
                                }
                                break block13;
                                break;
                            }
                            v1 = ++var0_5;
                            v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                            v3 = v2.length;
                            var6_6 = 0;
                            v4 = 22;
                            v5 = v2;
                            v6 = v3;
                            if (v3 > 1) ** GOTO lbl67
                            do {
                                v7 = v4;
                                v5 = v5;
                                v8 = v5;
                                v9 = v4;
                                v10 = var6_6;
                                while (true) {
                                    switch (var6_6 % 7) {
                                        case 0: {
                                            v11 = 124;
                                            break;
                                        }
                                        case 1: {
                                            v11 = 112;
                                            break;
                                        }
                                        case 2: {
                                            v11 = 69;
                                            break;
                                        }
                                        case 3: {
                                            v11 = 13;
                                            break;
                                        }
                                        case 4: {
                                            v11 = 9;
                                            break;
                                        }
                                        case 5: {
                                            v11 = 53;
                                            break;
                                        }
                                        default: {
                                            v11 = 116;
                                        }
                                    }
                                    v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                    ++var6_6;
                                    v4 = v7;
                                    if (v7 != 0) break;
                                    v7 = v4;
                                    v5 = v5;
                                    v10 = v4;
                                    v8 = v5;
                                    v9 = v4;
                                }
lbl67:
                                // 2 sources

                                v0 = v5;
                                v6 = v6;
                            } while (v6 > var6_6);
                            ** while (true)
                        }
                        monitorOneConnection.6.a = var5;
                        monitorOneConnection.6.b = new String[2];
                    }

                    private static String a(int n2, int n3, int n4) {
                        int n5 = (n2 ^ n4 ^ 0xFFFFE350) & 0xFFFF;
                        if (b[n5] == null) {
                            int n6;
                            char[] cArray = a[n5].toCharArray();
                            int n7 = switch (cArray[0] & 0xFF) {
                                case 0 -> 88;
                                case 1 -> 159;
                                case 2 -> 194;
                                case 3 -> 252;
                                case 4 -> 80;
                                case 5 -> 186;
                                case 6 -> 34;
                                case 7 -> 131;
                                case 8 -> 125;
                                case 9 -> 206;
                                case 10 -> 202;
                                case 11 -> 250;
                                case 12 -> 176;
                                case 13 -> 2;
                                case 14 -> 99;
                                case 15 -> 163;
                                case 16 -> 156;
                                case 17 -> 47;
                                case 18 -> 223;
                                case 19 -> 238;
                                case 20 -> 73;
                                case 21 -> 234;
                                case 22 -> 78;
                                case 23 -> 25;
                                case 24 -> 92;
                                case 25 -> 84;
                                case 26 -> 117;
                                case 27 -> 51;
                                case 28 -> 164;
                                case 29 -> 210;
                                case 30 -> 236;
                                case 31 -> 249;
                                case 32 -> 53;
                                case 33 -> 114;
                                case 34 -> 98;
                                case 35 -> 154;
                                case 36 -> 120;
                                case 37 -> 61;
                                case 38 -> 3;
                                case 39 -> 160;
                                case 40 -> 75;
                                case 41 -> 244;
                                case 42 -> 183;
                                case 43 -> 198;
                                case 44 -> 128;
                                case 45 -> 64;
                                case 46 -> 193;
                                case 47 -> 229;
                                case 48 -> 90;
                                case 49 -> 57;
                                case 50 -> 82;
                                case 51 -> 180;
                                case 52 -> 148;
                                case 53 -> 29;
                                case 54 -> 149;
                                case 55 -> 20;
                                case 56 -> 105;
                                case 57 -> 141;
                                case 58 -> 237;
                                case 59 -> 137;
                                case 60 -> 36;
                                case 61 -> 41;
                                case 62 -> 49;
                                case 63 -> 42;
                                case 64 -> 138;
                                case 65 -> 111;
                                case 66 -> 6;
                                case 67 -> 18;
                                case 68 -> 147;
                                case 69 -> 12;
                                case 70 -> 118;
                                case 71 -> 254;
                                case 72 -> 162;
                                case 73 -> 50;
                                case 74 -> 205;
                                case 75 -> 161;
                                case 76 -> 110;
                                case 77 -> 201;
                                case 78 -> 219;
                                case 79 -> 56;
                                case 80 -> 208;
                                case 81 -> 21;
                                case 82 -> 68;
                                case 83 -> 97;
                                case 84 -> 167;
                                case 85 -> 239;
                                case 86 -> 158;
                                case 87 -> 130;
                                case 88 -> 233;
                                case 89 -> 142;
                                case 90 -> 28;
                                case 91 -> 184;
                                case 92 -> 5;
                                case 93 -> 76;
                                case 94 -> 216;
                                case 95 -> 79;
                                case 96 -> 91;
                                case 97 -> 9;
                                case 98 -> 14;
                                case 99 -> 145;
                                case 100 -> 153;
                                case 101 -> 58;
                                case 102 -> 189;
                                case 103 -> 19;
                                case 104 -> 136;
                                case 105 -> 246;
                                case 106 -> 38;
                                case 107 -> 86;
                                case 108 -> 33;
                                case 109 -> 77;
                                case 110 -> 94;
                                case 111 -> 152;
                                case 112 -> 60;
                                case 113 -> 17;
                                case 114 -> 95;
                                case 115 -> 213;
                                case 116 -> 85;
                                case 117 -> 113;
                                case 118 -> 181;
                                case 119 -> 102;
                                case 120 -> 83;
                                case 121 -> 30;
                                case 122 -> 177;
                                case 123 -> 4;
                                case 124 -> 135;
                                case 125 -> 241;
                                case 126 -> 65;
                                case 127 -> 247;
                                case 128 -> 10;
                                case 129 -> 69;
                                case 130 -> 245;
                                case 131 -> 106;
                                case 132 -> 182;
                                case 133 -> 100;
                                case 134 -> 192;
                                case 135 -> 211;
                                case 136 -> 15;
                                case 137 -> 132;
                                case 138 -> 121;
                                case 139 -> 169;
                                case 140 -> 178;
                                case 141 -> 200;
                                case 142 -> 187;
                                case 143 -> 228;
                                case 144 -> 74;
                                case 145 -> 115;
                                case 146 -> 70;
                                case 147 -> 27;
                                case 148 -> 173;
                                case 149 -> 204;
                                case 150 -> 196;
                                case 151 -> 240;
                                case 152 -> 139;
                                case 153 -> 104;
                                case 154 -> 207;
                                case 155 -> 144;
                                case 156 -> 155;
                                case 157 -> 13;
                                case 158 -> 212;
                                case 159 -> 253;
                                case 160 -> 174;
                                case 161 -> 45;
                                case 162 -> 230;
                                case 163 -> 87;
                                case 164 -> 26;
                                case 165 -> 93;
                                case 166 -> 54;
                                case 167 -> 66;
                                case 168 -> 146;
                                case 169 -> 220;
                                case 170 -> 251;
                                case 171 -> 46;
                                case 172 -> 31;
                                case 173 -> 218;
                                case 174 -> 175;
                                case 175 -> 225;
                                case 176 -> 242;
                                case 177 -> 44;
                                case 178 -> 52;
                                case 179 -> 133;
                                case 180 -> 248;
                                case 181 -> 226;
                                case 182 -> 112;
                                case 183 -> 214;
                                case 184 -> 16;
                                case 185 -> 35;
                                case 186 -> 231;
                                case 187 -> 109;
                                case 188 -> 116;
                                case 189 -> 63;
                                case 190 -> 124;
                                case 191 -> 32;
                                case 192 -> 166;
                                case 193 -> 190;
                                case 194 -> 199;
                                case 195 -> 71;
                                case 196 -> 235;
                                case 197 -> 227;
                                case 198 -> 7;
                                case 199 -> 140;
                                case 200 -> 96;
                                case 201 -> 1;
                                case 202 -> 255;
                                case 203 -> 217;
                                case 204 -> 221;
                                case 205 -> 39;
                                case 206 -> 172;
                                case 207 -> 165;
                                case 208 -> 37;
                                case 209 -> 188;
                                case 210 -> 179;
                                case 211 -> 43;
                                case 212 -> 215;
                                case 213 -> 108;
                                case 214 -> 197;
                                case 215 -> 157;
                                case 216 -> 143;
                                case 217 -> 81;
                                case 218 -> 122;
                                case 219 -> 243;
                                case 220 -> 129;
                                case 221 -> 24;
                                case 222 -> 185;
                                case 223 -> 22;
                                case 224 -> 171;
                                case 225 -> 23;
                                case 226 -> 40;
                                case 227 -> 59;
                                case 228 -> 150;
                                case 229 -> 119;
                                case 230 -> 224;
                                case 231 -> 101;
                                case 232 -> 203;
                                case 233 -> 107;
                                case 234 -> 127;
                                case 235 -> 11;
                                case 236 -> 232;
                                case 237 -> 89;
                                case 238 -> 55;
                                case 239 -> 209;
                                case 240 -> 168;
                                case 241 -> 48;
                                case 242 -> 8;
                                case 243 -> 126;
                                case 244 -> 103;
                                case 245 -> 222;
                                case 246 -> 67;
                                case 247 -> 195;
                                case 248 -> 0;
                                case 249 -> 191;
                                case 250 -> 72;
                                case 251 -> 151;
                                case 252 -> 62;
                                case 253 -> 123;
                                case 254 -> 170;
                                default -> 134;
                            };
                            int n8 = ((n3 ^= n4) & 0xFF) - n7;
                            if (n8 < 0) {
                                n8 += 256;
                            }
                            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                n6 += 256;
                            }
                            int n9 = 0;
                            while (n9 < cArray.length) {
                                int n10 = n9 % 2;
                                int n11 = n9;
                                char[] cArray2 = cArray;
                                char c2 = cArray[n11];
                                if (n10 == 0) {
                                    cArray2[n11] = (char)(c2 ^ n8);
                                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                } else {
                                    cArray2[n11] = (char)(c2 ^ n6);
                                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                }
                                ++n9;
                            }
                            monitorOneConnection.6.b[n5] = new String(cArray).intern();
                        }
                        return b[n5];
                    }
                });
                Logger logger3 = ServerSocketWrapper.logger;
                Throwable throwable = null;
                boolean bl3 = false;
                try {
                    if (nArray != null) break block9;
                    if (!logger3.isDebugEnabled()) break block10;
                }
                catch (IllegalStateException illegalStateException) {
                    throw ServerSocketWrapper.a(illegalStateException);
                }
                logger = logger3;
                boolean bl4 = false;
                String string5 = string;
                int n6 = n3;
                String string6 = PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.rdPort.getRdPortState())));
                int n7 = clientSocket.getPort();
                logger.debug(ServerSocketWrapper.a(2029094670 - (char)-1878, 2029094670 - (char)-13458, (int)l2) + n7 + ServerSocketWrapper.a(2029094670 - (char)-1874, 2029094670 - (char)-18366, (int)l2) + string6 + ServerSocketWrapper.a(2029094670 - (char)-1874, 2029094670 - (char)-18366, (int)l2) + n6 + ServerSocketWrapper.a(2029094670 - (char)-1885, -2029094670 - -((char)-18699), (int)l2) + string5, throwable);
            }
            ApplicationKt.getApplication().invokeLater(() -> ServerSocketWrapper.monitorOneConnection$lambda$4(this, rdConnection), ModalityState.any());
        }
    }

    private final Thread createListeningThread(ServerSocket socket2) {
        long l2 = 87177108810714L;
        int n2 = this.rdPort.getPortNumber();
        return ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)(ServerSocketWrapper.a(2137358490 + 11356, -2137358490 + -14367, (int)l2) + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.rdPort.getRdPortState()))) + ServerSocketWrapper.a(2137358490 + 11362, 2137358490 + 27574, (int)l2) + n2), (int)0, (Function0)((Function0)new Function0<Unit>(this, n2, socket2){
            final /* synthetic */ ServerSocketWrapper this$0;
            final /* synthetic */ int $hostPortNumber;
            final /* synthetic */ ServerSocket $socket;
            private static final String[] a;
            private static final String[] b;
            {
                this.this$0 = $receiver;
                this.$hostPortNumber = $hostPortNumber;
                this.$socket = $socket;
                super(0);
            }

            /*
             * Unable to fully structure code
             */
            public final void invoke() {
                block21: {
                    var1_1 = 106817944694398L;
                    v0 = ServerSocketPortState.C();
                    ServerSocketWrapper.Companion.getLogger().info(createListeningThread.1.a(-2107998810 + -32190, 2107998810 + (char)-19543, (int)var1_1) + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.this$0.getRdPort().getRdPortState()))) + createListeningThread.1.a(-2107998810 + -32189, 2107998810 + (char)-14492, (int)var1_1) + this.$hostPortNumber);
                    var3_2 = v0;
                    while (RLifetimeKt.isAlive((Lifetime)ServerSocketWrapper.access$getLifetime$p(this.this$0))) {
                        try {
                            block20: {
                                block17: {
                                    block18: {
                                        block19: {
                                            var4_3 = this.$socket.accept();
                                            try {
                                                v1 = RLifetimeKt.isAlive((Lifetime)ServerSocketWrapper.access$getLifetime$p(this.this$0));
                                                if (var3_2 == null) {
                                                    if (!v1) break block17;
                                                }
                                                ** GOTO lbl72
                                            }
                                            catch (SocketTimeoutException v2) {
                                                throw createListeningThread.1.a(v2);
                                            }
                                            var5_8 = ServerSocketWrapper.Companion.getLogger();
                                            var6_9 = this.this$0;
                                            var7_11 = this.$hostPortNumber;
                                            var8_12 = false;
                                            try {
                                                if (var3_2 != null) break block18;
                                                if (!var5_8.isTraceEnabled()) break block19;
                                            }
                                            catch (SocketTimeoutException v3) {
                                                throw createListeningThread.1.a(v3);
                                            }
                                            var10_14 = var5_8;
                                            var9_13 = false;
                                            var11_15 = var7_11;
                                            var12_16 = PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)var6_9.getRdPort().getRdPortState())));
                                            var13_17 = var4_3.getPort();
                                            var10_14.trace(createListeningThread.1.a(-2107998810 + -32188, -2107998810 + -((char)-11927), (int)var1_1) + var13_17 + createListeningThread.1.a(-2107998810 + -32187, -2107998810 + -((char)-9062), (int)var1_1) + var12_16 + createListeningThread.1.a(-2107998810 + -32187, -2107998810 + -((char)-9062), (int)var1_1) + var11_15);
                                        }
                                        Intrinsics.checkNotNull((Object)var4_3);
                                        ServerSocketWrapper.access$monitorOneConnection(this.this$0, var4_3);
                                    }
                                    if (var3_2 == null) continue;
                                }
                                var5_8 = ServerSocketWrapper.Companion.getLogger();
                                var6_10 = false;
                                try {
                                    if (var3_2 != null) continue;
                                    if (!var5_8.isTraceEnabled()) break block20;
                                }
                                catch (SocketTimeoutException v4) {
                                    throw createListeningThread.1.a(v4);
                                }
                                var10_14 = var5_8;
                                var7_11 = 0;
                                var10_14.trace(createListeningThread.1.a(-2107998810 + -32186, 2107998810 + (char)-4675, (int)var1_1));
                            }
                            var4_3.close();
                        }
                        catch (SocketTimeoutException var4_4) {
                        }
                        catch (SocketException var4_5) {
                            ServerSocketWrapper.Companion.getLogger().warn(createListeningThread.1.a(-2107998810 + -32185, -2107998810 + -((char)-28947), (int)var1_1), (Throwable)var4_5);
                            break;
                        }
                        catch (Throwable var4_6) {
                            ServerSocketWrapper.Companion.getLogger().error(var4_6);
                            break;
                        }
                    }
                    try {
                        try {
                            if (var3_2 != null) break block21;
                            v1 = this.$socket.isClosed();
                        }
                        catch (SocketTimeoutException v5) {
                            throw createListeningThread.1.a(v5);
                        }
lbl72:
                        // 2 sources

                        if (!v1) {
                            this.$socket.close();
                        }
                    }
                    catch (Throwable var4_7) {
                        ServerSocketWrapper.Companion.getLogger().warn(var4_7);
                    }
                    ServerSocketWrapper.Companion.getLogger().info(createListeningThread.1.a(-2107998810 + -32184, 2107998810 + (char)-22738, (int)var1_1) + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.this$0.getRdPort().getRdPortState()))) + createListeningThread.1.a(-2107998810 + -32187, -2107998810 + -((char)-9062), (int)var1_1) + this.$hostPortNumber);
                }
            }

            private static SocketTimeoutException a(SocketTimeoutException socketTimeoutException) {
                return socketTimeoutException;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block20: {
                    block19: {
                        var5 = new String[7];
                        var3_1 = 0;
                        var2_2 = "\u00b1fr\u0082C6H\u0017\u00be\u0005Z\u0098\u008e\u00bb\u00bf\b32\u000f\u009e|t=\u00b1\u00f8\u00a9\u0004\u0000\u00e5\u0006\u00d2\u0015*\u0086S|!\u0001\u008bL\u00ac\u001e\u0018\u0096\u00dc\u00a0\u00a9\u009dO\u00e0\u00f7\u0097\u00c9\u0004\u0019t%\u00e0:\u00b7\u00a7\u00e0XW\u0085E\u00dcu\f#\u00d4\u00bb\u00e8E\u0094\u00d2\u00c1D\u00a9\u00fd\u0096\u00d15b\u00c4\u00f8`\u001f#\u00e5K\t\n\u00ffil|\u00e8\u009a\u00f0G{\u00fd\u0093\u00d9\u0011l\u00ff>C\u007f\u00fbui\u00cd\u00f7\u0013";
                        var4_3 = "\u00b1fr\u0082C6H\u0017\u00be\u0005Z\u0098\u008e\u00bb\u00bf\b32\u000f\u009e|t=\u00b1\u00f8\u00a9\u0004\u0000\u00e5\u0006\u00d2\u0015*\u0086S|!\u0001\u008bL\u00ac\u001e\u0018\u0096\u00dc\u00a0\u00a9\u009dO\u00e0\u00f7\u0097\u00c9\u0004\u0019t%\u00e0:\u00b7\u00a7\u00e0XW\u0085E\u00dcu\f#\u00d4\u00bb\u00e8E\u0094\u00d2\u00c1D\u00a9\u00fd\u0096\u00d15b\u00c4\u00f8`\u001f#\u00e5K\t\n\u00ffil|\u00e8\u009a\u00f0G{\u00fd\u0093\u00d9\u0011l\u00ff>C\u007f\u00fbui\u00cd\u00f7\u0013".length();
                        var1_4 = 26;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            v0 = 73;
                            v1 = ++var0_5;
                            v2 = var2_2.substring(v1, v1 + var1_4);
                            v3 = -1;
                            break block19;
                            break;
                        }
lbl13:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = v4.intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            var2_2 = "j\u001e\u00cd*!\u00c2\u00bf\u00f3Y\u000e9Lo\u00ecLE\u0017\u009f\u00ea\u00a0\u009bjo\u00a7\u0092\n~]\u00a1\u0015\u009ec|]\u00a6\f\u00a7\u00d0YC";
                            var4_3 = "j\u001e\u00cd*!\u00c2\u00bf\u00f3Y\u000e9Lo\u00ecLE\u0017\u009f\u00ea\u00a0\u009bjo\u00a7\u0092\n~]\u00a1\u0015\u009ec|]\u00a6\f\u00a7\u00d0YC".length();
                            var1_4 = 16;
                            var0_5 = -1;
lbl22:
                            // 2 sources

                            while (true) {
                                v0 = 79;
                                v5 = ++var0_5;
                                v2 = var2_2.substring(v5, v5 + var1_4);
                                v3 = 0;
                                break block19;
                                break;
                            }
                            break;
                        }
lbl28:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = v4.intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block20;
                            break;
                        }
                    }
                    v6 = v2.toCharArray();
                    v7 = v6.length;
                    var6_6 = 0;
                    v8 = v0;
                    v9 = v6;
                    v10 = v7;
                    if (v7 > 1) ** GOTO lbl85
                    do {
                        v11 = v8;
                        v9 = v9;
                        v12 = v9;
                        v13 = v8;
                        v14 = var6_6;
                        while (true) {
                            switch (var6_6 % 7) {
                                case 0: {
                                    v15 = 121;
                                    break;
                                }
                                case 1: {
                                    v15 = 54;
                                    break;
                                }
                                case 2: {
                                    v15 = 83;
                                    break;
                                }
                                case 3: {
                                    v15 = 96;
                                    break;
                                }
                                case 4: {
                                    v15 = 62;
                                    break;
                                }
                                case 5: {
                                    v15 = 95;
                                    break;
                                }
                                default: {
                                    v15 = 19;
                                }
                            }
                            v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                            ++var6_6;
                            v8 = v11;
                            if (v11 != 0) break;
                            v11 = v8;
                            v9 = v9;
                            v14 = v8;
                            v12 = v9;
                            v13 = v8;
                        }
lbl85:
                        // 2 sources

                        v16 = v9;
                        v10 = v10;
                    } while (v10 > var6_6);
                    v4 = new String(v16);
                    switch (v3) {
                        default: {
                            ** continue;
                        }
                        ** case 0:
lbl95:
                        // 1 sources

                        ** continue;
                    }
                }
                createListeningThread.1.a = var5;
                createListeningThread.1.b = new String[7];
            }

            private static String a(int n2, int n3, int n4) {
                int n5 = (n2 ^ n4 ^ 0xFFFFD196) & 0xFFFF;
                if (b[n5] == null) {
                    int n6;
                    char[] cArray = a[n5].toCharArray();
                    int n7 = switch (cArray[0] & 0xFF) {
                        case 0 -> 219;
                        case 1 -> 6;
                        case 2 -> 75;
                        case 3 -> 211;
                        case 4 -> 65;
                        case 5 -> 175;
                        case 6 -> 248;
                        case 7 -> 100;
                        case 8 -> 8;
                        case 9 -> 210;
                        case 10 -> 168;
                        case 11 -> 201;
                        case 12 -> 0;
                        case 13 -> 57;
                        case 14 -> 81;
                        case 15 -> 192;
                        case 16 -> 253;
                        case 17 -> 82;
                        case 18 -> 112;
                        case 19 -> 218;
                        case 20 -> 195;
                        case 21 -> 71;
                        case 22 -> 62;
                        case 23 -> 217;
                        case 24 -> 180;
                        case 25 -> 9;
                        case 26 -> 232;
                        case 27 -> 21;
                        case 28 -> 244;
                        case 29 -> 136;
                        case 30 -> 161;
                        case 31 -> 126;
                        case 32 -> 114;
                        case 33 -> 160;
                        case 34 -> 79;
                        case 35 -> 53;
                        case 36 -> 153;
                        case 37 -> 25;
                        case 38 -> 95;
                        case 39 -> 90;
                        case 40 -> 92;
                        case 41 -> 105;
                        case 42 -> 19;
                        case 43 -> 134;
                        case 44 -> 215;
                        case 45 -> 54;
                        case 46 -> 220;
                        case 47 -> 61;
                        case 48 -> 176;
                        case 49 -> 122;
                        case 50 -> 73;
                        case 51 -> 245;
                        case 52 -> 194;
                        case 53 -> 102;
                        case 54 -> 5;
                        case 55 -> 196;
                        case 56 -> 206;
                        case 57 -> 202;
                        case 58 -> 26;
                        case 59 -> 36;
                        case 60 -> 135;
                        case 61 -> 63;
                        case 62 -> 139;
                        case 63 -> 183;
                        case 64 -> 37;
                        case 65 -> 151;
                        case 66 -> 70;
                        case 67 -> 49;
                        case 68 -> 91;
                        case 69 -> 97;
                        case 70 -> 118;
                        case 71 -> 228;
                        case 72 -> 103;
                        case 73 -> 133;
                        case 74 -> 152;
                        case 75 -> 240;
                        case 76 -> 72;
                        case 77 -> 170;
                        case 78 -> 241;
                        case 79 -> 238;
                        case 80 -> 115;
                        case 81 -> 177;
                        case 82 -> 141;
                        case 83 -> 35;
                        case 84 -> 223;
                        case 85 -> 186;
                        case 86 -> 1;
                        case 87 -> 123;
                        case 88 -> 162;
                        case 89 -> 24;
                        case 90 -> 213;
                        case 91 -> 193;
                        case 92 -> 184;
                        case 93 -> 80;
                        case 94 -> 74;
                        case 95 -> 47;
                        case 96 -> 56;
                        case 97 -> 33;
                        case 98 -> 148;
                        case 99 -> 41;
                        case 100 -> 119;
                        case 101 -> 132;
                        case 102 -> 99;
                        case 103 -> 11;
                        case 104 -> 106;
                        case 105 -> 205;
                        case 106 -> 4;
                        case 107 -> 230;
                        case 108 -> 143;
                        case 109 -> 16;
                        case 110 -> 251;
                        case 111 -> 113;
                        case 112 -> 83;
                        case 113 -> 69;
                        case 114 -> 85;
                        case 115 -> 169;
                        case 116 -> 216;
                        case 117 -> 38;
                        case 118 -> 40;
                        case 119 -> 145;
                        case 120 -> 43;
                        case 121 -> 77;
                        case 122 -> 165;
                        case 123 -> 179;
                        case 124 -> 64;
                        case 125 -> 190;
                        case 126 -> 13;
                        case 127 -> 138;
                        case 128 -> 246;
                        case 129 -> 171;
                        case 130 -> 130;
                        case 131 -> 58;
                        case 132 -> 46;
                        case 133 -> 18;
                        case 134 -> 191;
                        case 135 -> 163;
                        case 136 -> 48;
                        case 137 -> 198;
                        case 138 -> 109;
                        case 139 -> 182;
                        case 140 -> 104;
                        case 141 -> 166;
                        case 142 -> 3;
                        case 143 -> 234;
                        case 144 -> 96;
                        case 145 -> 45;
                        case 146 -> 15;
                        case 147 -> 137;
                        case 148 -> 164;
                        case 149 -> 233;
                        case 150 -> 89;
                        case 151 -> 34;
                        case 152 -> 237;
                        case 153 -> 20;
                        case 154 -> 214;
                        case 155 -> 174;
                        case 156 -> 255;
                        case 157 -> 12;
                        case 158 -> 101;
                        case 159 -> 44;
                        case 160 -> 189;
                        case 161 -> 30;
                        case 162 -> 243;
                        case 163 -> 78;
                        case 164 -> 222;
                        case 165 -> 17;
                        case 166 -> 155;
                        case 167 -> 27;
                        case 168 -> 249;
                        case 169 -> 10;
                        case 170 -> 128;
                        case 171 -> 22;
                        case 172 -> 172;
                        case 173 -> 185;
                        case 174 -> 157;
                        case 175 -> 187;
                        case 176 -> 140;
                        case 177 -> 14;
                        case 178 -> 227;
                        case 179 -> 239;
                        case 180 -> 94;
                        case 181 -> 197;
                        case 182 -> 42;
                        case 183 -> 200;
                        case 184 -> 59;
                        case 185 -> 236;
                        case 186 -> 2;
                        case 187 -> 60;
                        case 188 -> 154;
                        case 189 -> 252;
                        case 190 -> 111;
                        case 191 -> 178;
                        case 192 -> 98;
                        case 193 -> 242;
                        case 194 -> 23;
                        case 195 -> 147;
                        case 196 -> 144;
                        case 197 -> 50;
                        case 198 -> 51;
                        case 199 -> 117;
                        case 200 -> 235;
                        case 201 -> 7;
                        case 202 -> 29;
                        case 203 -> 208;
                        case 204 -> 181;
                        case 205 -> 66;
                        case 206 -> 110;
                        case 207 -> 68;
                        case 208 -> 207;
                        case 209 -> 149;
                        case 210 -> 209;
                        case 211 -> 131;
                        case 212 -> 188;
                        case 213 -> 84;
                        case 214 -> 158;
                        case 215 -> 221;
                        case 216 -> 250;
                        case 217 -> 167;
                        case 218 -> 173;
                        case 219 -> 142;
                        case 220 -> 231;
                        case 221 -> 93;
                        case 222 -> 87;
                        case 223 -> 67;
                        case 224 -> 39;
                        case 225 -> 116;
                        case 226 -> 108;
                        case 227 -> 55;
                        case 228 -> 125;
                        case 229 -> 226;
                        case 230 -> 31;
                        case 231 -> 121;
                        case 232 -> 247;
                        case 233 -> 150;
                        case 234 -> 32;
                        case 235 -> 86;
                        case 236 -> 199;
                        case 237 -> 224;
                        case 238 -> 107;
                        case 239 -> 52;
                        case 240 -> 76;
                        case 241 -> 254;
                        case 242 -> 225;
                        case 243 -> 146;
                        case 244 -> 229;
                        case 245 -> 127;
                        case 246 -> 28;
                        case 247 -> 204;
                        case 248 -> 203;
                        case 249 -> 129;
                        case 250 -> 212;
                        case 251 -> 120;
                        case 252 -> 88;
                        case 253 -> 159;
                        case 254 -> 156;
                        default -> 124;
                    };
                    int n8 = ((n3 ^= n4) & 0xFF) - n7;
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                        n6 += 256;
                    }
                    int n9 = 0;
                    while (n9 < cArray.length) {
                        int n10 = n9 % 2;
                        int n11 = n9;
                        char[] cArray2 = cArray;
                        char c2 = cArray[n11];
                        if (n10 == 0) {
                            cArray2[n11] = (char)(c2 ^ n8);
                            n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                        } else {
                            cArray2[n11] = (char)(c2 ^ n6);
                            n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                        }
                        ++n9;
                    }
                    createListeningThread.1.b[n5] = new String(cArray).intern();
                }
                return b[n5];
            }
        }), (int)20, null);
    }

    private static final void changeListeningSocket$lambda$0(ServerSocketWrapper this$0) {
        long l2 = 67925434590466L;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)ServerSocketWrapper.a(-526770330 + -32057, -526770330 + -19464, (int)l2));
        IOptProperty iOptProperty = this$0.rdPort.getRdPortState();
        SocketAddress socketAddress = this$0.getServerSocket().getLocalSocketAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)ServerSocketWrapper.a(-526770330 + -32058, -526770330 + -11020, (int)l2));
        iOptProperty.set((Object)new RdPortState(SocketState.LISTENING, PortForwardingUtilsKt.toRdSocketAddress((InetSocketAddress)socketAddress), null));
    }

    private static final void monitorOneConnection$lambda$4(ServerSocketWrapper this$0, RdConnection $rdConnection) {
        long l2 = 137948408727324L;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)ServerSocketWrapper.a(1645845990 - 7601, -1645845990 + -6918, (int)l2));
        Intrinsics.checkNotNullParameter((Object)$rdConnection, (String)ServerSocketWrapper.a(1645845990 - 7602, -1645845990 + -13003, (int)l2));
        this$0.rdPort.getConnections().add((Object)$rdConnection);
    }

    public static final /* synthetic */ LongCounter access$getReceivedBytesCounter$p(ServerSocketWrapper $this) {
        return $this.receivedBytesCounter;
    }

    public static final /* synthetic */ LongCounter access$getSentBytesCounter$p(ServerSocketWrapper $this) {
        return $this.sentBytesCounter;
    }

    public static final /* synthetic */ Lifetime access$getLifetime$p(ServerSocketWrapper $this) {
        return $this.lifetime;
    }

    public static final /* synthetic */ void access$monitorOneConnection(ServerSocketWrapper $this, Socket clientSocket) {
        $this.monitorOneConnection(clientSocket);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var7 = 26593781642637L;
                var5_1 = new String[31];
                var3_2 = 0;
                var2_3 = "\u0017\u0095w\u00a77\u00e2|\u00c7\u0006\u00b59\u00c8\u00946\u00d2\b\u00ea\u00b1\u00fd\u00d0\u0089\u0096\u00ae\u00c5#\u00f2\u0015\u0013\nD^\u000b:\u00b0\f\u00e8\u001c\u00f8\u00d4L\u009e\u00e9y\u00b2E\u0017/\u0097\u00fb!7\u001c\u0098\u0084\u009c\u0001\u00d9\u0014\u0004h\u0005\u00f90w\u0001`'\u001c\u0019\u00ce\u008b\u00ffn|<^\u00cc5\u0004C\u00d7;\u00fe\u0007uo\u00c4\u00ac\u001f\u00e0\u00fd\u00cf\u00f6\u00c1\u008c.\u0099h&\u00d6\u00f9F\u00fb\u0095\u00e4a\u0005\f\u0099\u00c94\u00b7-\u00b0+o\u00b6U\u00c0n\u008e\u0014\u00c3|\u00c6\u00bd\u00d9\u00fb/\u00f8-\u00edN[ZP\u00df\u001dq\u00ed\u00a7ysW(e*\u00ab\u0095d\u001d\u00927W\u00ca\u00ff\u008b\u001b16\u0005\u00bfsOx-\u0099|!q\u009a\u001cR\u00cf^~\u0003=\u008bA\u00e2\u0013\u00c8u\u0093\u00f0\u00f8\u00c2\u00f5`7\u00eb\u00c55\u00ee\u000e\u000fH\u0080*7)B\u0084]8\u00a1\u00fcF)\u00a3|\u00ff\u00d1\u0083\u00de\u0085\u00fe\u00dc\u0002\u00f6\u0084:\u00b9~A\u0088dp#*K\u00d9\u00fd\u00f8(\u00d5X\u001c\u00a2\u00ffl\u00c9:\u00ab\u0014\u00c3\u00f3\u00d4\u00e0\u00b1\u001c\t\u00fe\u00ab\u00c4s\u00de\u00f7\u0017^\u009c\u00e1\u00f2Um\u0085\u00d0;D\u001bl\u0096\u00a8\u00be\u00c8\u00ba\u00dd\u00bdG\u00cb\u00a5\u00d4\u00da\u00b6.\u0012\u001bW=V\u00a0!\u00b4\u00f3y;\u007f\u0013\u0012\u00b8Z\u00e7\u0018F\u00a4\u00ba\u00b8*\u009e\u009f\\\u00bc\u0002\u001a@\u0005'0\u00a6\u001b\u00f1\u00ff\u00ea\u00bc\u0006.jx\u00bcB'\u00ce\u00a9B\u00ef\u0096\u001a\u0081\u0018\u0088\u00ec\u00d6\u00ce\u00fb\u00805\u00fez\u00a0\u0012!\u00b7/\u00bcY\u00a9\u00c4\u00a6\u00cb\" |\u00f5%/USM\u0003E\u00ff\u00f0\u00c3S\u00e9\u00a6{\f\u00d8O\u0007\u00d1l\u00be\u0004\u0094y\u009a\u00b3\t:\u00a5u\u00daH(\u0002z)\t\n\u00fes\u00b1\u0088E\u001a\u00d7*\u0013\u00d7\u0004\u00175p\"\u00f5\u00a2NKg\u00e3\u0015\u00cb-$\u00b4uS?\u00e38\u00a1\u0084\u00f2\u00a4\u0016O\u008f7\u0012Cl$9@p@0\u0083\u0085\u0081\u0004\u00ce\u00ff\u0013\u00e6\u00a2\u009b\u00f5\u00d6KH\u0082\u008e\u00d9\u00e1\u008aM\u00073{\u00ff\u008f:\"\u00f3wv\u0083:\u00f7)\u0010\u00f9}\r_\u00beE]Q\u001c\rwWU(\u00e6 \u0083\u009d\u0095\u0004\u0085B\u00c4\u0015\u00a4\u0018\u00c8j\u00a3\u00df\u00edbP\u00b6u\u00b0\u00f4\u00dd\u00e4h\u00e8\u00ac0\u009b\u0088\u0004\u0083\u00d1x\u00a6\u0006I\u00d0\u00fbn\u0006\u00b3\u001e\u00dd\u0097\u00f8\u00ac\u0019\u009f\u00aa\u00f7\u00a8\u0005{\u00ec\u00012\u00d6c\u00c4\u00ae\u0083\u00ff6\u009d]\u00fct\u00b1m\u00bd4Z'm\u0004\u0097B\u00e9B{\u000e\u00f4\u008eA\u00ff\u00cbt\u00e0c\u00e6\u0013\u00ba8\u009c}@\u00db\u00a9V!\u0010\u00d2\u00e4H\u00f5\u00a3i\u00b1W\u0018\u0086\u00ff\u0013u\u0016\u00b1w\u00b7{x=*\u00d4\u009d[\u00c5\u00dbd\u0080\u00b4\u009c\u0012\u0006\u0090\u0001\u00c0Ta\u00f4\u000f\u009dG\u0089*Lfx\u0083<\u0089\u009ao\u007f\u0013I\u0006\u00d3;\u00fbE\u00183?\u0084\u0012M\u00c1o\f\u00a5Z\u00f9\u0095\u00dc\u0017\u00b5\u00ae\u0002\u0011\u0017j\u00dc\u00c6\u0018)\u00b7\u00db\u0089\u00b1(\u00f6B\u007f\u00ed\u001a/\u00a8b\u009c|\"\u00fe\u0012E\u00d91\u00db\u00e3\u00a8\u00c8&\u0011\u00a9\u00d6\u00b2\u00b4\u00b8Jh{\u00fdp\u0011\u0084\u00db'\u0006\u00de\u0088Z3,\u00fd";
                var4_4 = "\u0017\u0095w\u00a77\u00e2|\u00c7\u0006\u00b59\u00c8\u00946\u00d2\b\u00ea\u00b1\u00fd\u00d0\u0089\u0096\u00ae\u00c5#\u00f2\u0015\u0013\nD^\u000b:\u00b0\f\u00e8\u001c\u00f8\u00d4L\u009e\u00e9y\u00b2E\u0017/\u0097\u00fb!7\u001c\u0098\u0084\u009c\u0001\u00d9\u0014\u0004h\u0005\u00f90w\u0001`'\u001c\u0019\u00ce\u008b\u00ffn|<^\u00cc5\u0004C\u00d7;\u00fe\u0007uo\u00c4\u00ac\u001f\u00e0\u00fd\u00cf\u00f6\u00c1\u008c.\u0099h&\u00d6\u00f9F\u00fb\u0095\u00e4a\u0005\f\u0099\u00c94\u00b7-\u00b0+o\u00b6U\u00c0n\u008e\u0014\u00c3|\u00c6\u00bd\u00d9\u00fb/\u00f8-\u00edN[ZP\u00df\u001dq\u00ed\u00a7ysW(e*\u00ab\u0095d\u001d\u00927W\u00ca\u00ff\u008b\u001b16\u0005\u00bfsOx-\u0099|!q\u009a\u001cR\u00cf^~\u0003=\u008bA\u00e2\u0013\u00c8u\u0093\u00f0\u00f8\u00c2\u00f5`7\u00eb\u00c55\u00ee\u000e\u000fH\u0080*7)B\u0084]8\u00a1\u00fcF)\u00a3|\u00ff\u00d1\u0083\u00de\u0085\u00fe\u00dc\u0002\u00f6\u0084:\u00b9~A\u0088dp#*K\u00d9\u00fd\u00f8(\u00d5X\u001c\u00a2\u00ffl\u00c9:\u00ab\u0014\u00c3\u00f3\u00d4\u00e0\u00b1\u001c\t\u00fe\u00ab\u00c4s\u00de\u00f7\u0017^\u009c\u00e1\u00f2Um\u0085\u00d0;D\u001bl\u0096\u00a8\u00be\u00c8\u00ba\u00dd\u00bdG\u00cb\u00a5\u00d4\u00da\u00b6.\u0012\u001bW=V\u00a0!\u00b4\u00f3y;\u007f\u0013\u0012\u00b8Z\u00e7\u0018F\u00a4\u00ba\u00b8*\u009e\u009f\\\u00bc\u0002\u001a@\u0005'0\u00a6\u001b\u00f1\u00ff\u00ea\u00bc\u0006.jx\u00bcB'\u00ce\u00a9B\u00ef\u0096\u001a\u0081\u0018\u0088\u00ec\u00d6\u00ce\u00fb\u00805\u00fez\u00a0\u0012!\u00b7/\u00bcY\u00a9\u00c4\u00a6\u00cb\" |\u00f5%/USM\u0003E\u00ff\u00f0\u00c3S\u00e9\u00a6{\f\u00d8O\u0007\u00d1l\u00be\u0004\u0094y\u009a\u00b3\t:\u00a5u\u00daH(\u0002z)\t\n\u00fes\u00b1\u0088E\u001a\u00d7*\u0013\u00d7\u0004\u00175p\"\u00f5\u00a2NKg\u00e3\u0015\u00cb-$\u00b4uS?\u00e38\u00a1\u0084\u00f2\u00a4\u0016O\u008f7\u0012Cl$9@p@0\u0083\u0085\u0081\u0004\u00ce\u00ff\u0013\u00e6\u00a2\u009b\u00f5\u00d6KH\u0082\u008e\u00d9\u00e1\u008aM\u00073{\u00ff\u008f:\"\u00f3wv\u0083:\u00f7)\u0010\u00f9}\r_\u00beE]Q\u001c\rwWU(\u00e6 \u0083\u009d\u0095\u0004\u0085B\u00c4\u0015\u00a4\u0018\u00c8j\u00a3\u00df\u00edbP\u00b6u\u00b0\u00f4\u00dd\u00e4h\u00e8\u00ac0\u009b\u0088\u0004\u0083\u00d1x\u00a6\u0006I\u00d0\u00fbn\u0006\u00b3\u001e\u00dd\u0097\u00f8\u00ac\u0019\u009f\u00aa\u00f7\u00a8\u0005{\u00ec\u00012\u00d6c\u00c4\u00ae\u0083\u00ff6\u009d]\u00fct\u00b1m\u00bd4Z'm\u0004\u0097B\u00e9B{\u000e\u00f4\u008eA\u00ff\u00cbt\u00e0c\u00e6\u0013\u00ba8\u009c}@\u00db\u00a9V!\u0010\u00d2\u00e4H\u00f5\u00a3i\u00b1W\u0018\u0086\u00ff\u0013u\u0016\u00b1w\u00b7{x=*\u00d4\u009d[\u00c5\u00dbd\u0080\u00b4\u009c\u0012\u0006\u0090\u0001\u00c0Ta\u00f4\u000f\u009dG\u0089*Lfx\u0083<\u0089\u009ao\u007f\u0013I\u0006\u00d3;\u00fbE\u00183?\u0084\u0012M\u00c1o\f\u00a5Z\u00f9\u0095\u00dc\u0017\u00b5\u00ae\u0002\u0011\u0017j\u00dc\u00c6\u0018)\u00b7\u00db\u0089\u00b1(\u00f6B\u007f\u00ed\u001a/\u00a8b\u009c|\"\u00fe\u0012E\u00d91\u00db\u00e3\u00a8\u00c8&\u0011\u00a9\u00d6\u00b2\u00b4\u00b8Jh{\u00fdp\u0011\u0084\u00db'\u0006\u00de\u0088Z3,\u00fd".length();
                var1_5 = 8;
                var0_6 = -1;
lbl8:
                // 2 sources

                while (true) {
                    v0 = 125;
                    v1 = ++var0_6;
                    v2 = var2_3.substring(v1, v1 + var1_5);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl14:
                // 1 sources

                while (true) {
                    var5_1[var3_2++] = v4.intern();
                    if ((var0_6 += var1_5) < var4_4) {
                        var1_5 = var2_3.charAt(var0_6);
                        ** continue;
                    }
                    var2_3 = "+\u00c2\u009445R`\u0011\u0085\u00aa\u00c5\u00e0\u0003\u0010\u0006\u00a1\n\u00a7\u00f5vC/\u00b5\u00fec\u00d8\u001a2\u001b\u00cd";
                    var4_4 = "+\u00c2\u009445R`\u0011\u0085\u00aa\u00c5\u00e0\u0003\u0010\u0006\u00a1\n\u00a7\u00f5vC/\u00b5\u00fec\u00d8\u001a2\u001b\u00cd".length();
                    var1_5 = 13;
                    var0_6 = -1;
lbl23:
                    // 2 sources

                    while (true) {
                        v0 = 23;
                        v5 = ++var0_6;
                        v2 = var2_3.substring(v5, v5 + var1_5);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl29:
                // 1 sources

                while (true) {
                    var5_1[var3_2++] = v4.intern();
                    if ((var0_6 += var1_5) < var4_4) {
                        var1_5 = var2_3.charAt(var0_6);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_7 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl86
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_7;
                while (true) {
                    switch (var6_7 % 7) {
                        case 0: {
                            v15 = 100;
                            break;
                        }
                        case 1: {
                            v15 = 54;
                            break;
                        }
                        case 2: {
                            v15 = 76;
                            break;
                        }
                        case 3: {
                            v15 = 32;
                            break;
                        }
                        case 4: {
                            v15 = 92;
                            break;
                        }
                        case 5: {
                            v15 = 96;
                            break;
                        }
                        default: {
                            v15 = 84;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_7;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl86:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_7);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl96:
                // 1 sources

                ** continue;
            }
        }
        ServerSocketWrapper.a = var5_1;
        ServerSocketWrapper.b = new String[31];
        ServerSocketWrapper.Companion = new Companion(null);
        var9_8 = false;
        var10_9 = false;
        v17 = Logger.getInstance(ServerSocketWrapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)v17, (String)ServerSocketWrapper.a(655874280 - 9794, -655874280 - -13502, (int)var7));
        ServerSocketWrapper.logger = v17;
    }

    private static Exception a(Exception exception) {
        return exception;
    }

    private static String a(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFC735) & 0xFFFF;
        if (b[n5] == null) {
            int n6;
            char[] cArray = a[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 111;
                case 1 -> 66;
                case 2 -> 223;
                case 3 -> 151;
                case 4 -> 138;
                case 5 -> 207;
                case 6 -> 198;
                case 7 -> 244;
                case 8 -> 124;
                case 9 -> 92;
                case 10 -> 213;
                case 11 -> 80;
                case 12 -> 161;
                case 13 -> 246;
                case 14 -> 163;
                case 15 -> 192;
                case 16 -> 16;
                case 17 -> 33;
                case 18 -> 125;
                case 19 -> 199;
                case 20 -> 89;
                case 21 -> 253;
                case 22 -> 3;
                case 23 -> 94;
                case 24 -> 197;
                case 25 -> 42;
                case 26 -> 154;
                case 27 -> 247;
                case 28 -> 126;
                case 29 -> 31;
                case 30 -> 20;
                case 31 -> 6;
                case 32 -> 52;
                case 33 -> 41;
                case 34 -> 140;
                case 35 -> 96;
                case 36 -> 78;
                case 37 -> 115;
                case 38 -> 43;
                case 39 -> 190;
                case 40 -> 157;
                case 41 -> 76;
                case 42 -> 38;
                case 43 -> 219;
                case 44 -> 152;
                case 45 -> 164;
                case 46 -> 7;
                case 47 -> 104;
                case 48 -> 130;
                case 49 -> 116;
                case 50 -> 189;
                case 51 -> 181;
                case 52 -> 97;
                case 53 -> 50;
                case 54 -> 211;
                case 55 -> 65;
                case 56 -> 28;
                case 57 -> 172;
                case 58 -> 0;
                case 59 -> 122;
                case 60 -> 87;
                case 61 -> 209;
                case 62 -> 133;
                case 63 -> 188;
                case 64 -> 46;
                case 65 -> 70;
                case 66 -> 184;
                case 67 -> 121;
                case 68 -> 237;
                case 69 -> 176;
                case 70 -> 142;
                case 71 -> 19;
                case 72 -> 95;
                case 73 -> 224;
                case 74 -> 144;
                case 75 -> 132;
                case 76 -> 251;
                case 77 -> 137;
                case 78 -> 15;
                case 79 -> 243;
                case 80 -> 13;
                case 81 -> 118;
                case 82 -> 112;
                case 83 -> 241;
                case 84 -> 226;
                case 85 -> 86;
                case 86 -> 217;
                case 87 -> 53;
                case 88 -> 215;
                case 89 -> 196;
                case 90 -> 105;
                case 91 -> 1;
                case 92 -> 63;
                case 93 -> 204;
                case 94 -> 248;
                case 95 -> 174;
                case 96 -> 27;
                case 97 -> 123;
                case 98 -> 234;
                case 99 -> 231;
                case 100 -> 69;
                case 101 -> 220;
                case 102 -> 90;
                case 103 -> 114;
                case 104 -> 61;
                case 105 -> 75;
                case 106 -> 250;
                case 107 -> 210;
                case 108 -> 185;
                case 109 -> 173;
                case 110 -> 193;
                case 111 -> 159;
                case 112 -> 12;
                case 113 -> 179;
                case 114 -> 60;
                case 115 -> 239;
                case 116 -> 135;
                case 117 -> 73;
                case 118 -> 240;
                case 119 -> 171;
                case 120 -> 168;
                case 121 -> 238;
                case 122 -> 22;
                case 123 -> 71;
                case 124 -> 162;
                case 125 -> 165;
                case 126 -> 249;
                case 127 -> 2;
                case 128 -> 212;
                case 129 -> 194;
                case 130 -> 182;
                case 131 -> 145;
                case 132 -> 201;
                case 133 -> 166;
                case 134 -> 49;
                case 135 -> 35;
                case 136 -> 11;
                case 137 -> 252;
                case 138 -> 79;
                case 139 -> 14;
                case 140 -> 59;
                case 141 -> 149;
                case 142 -> 221;
                case 143 -> 56;
                case 144 -> 100;
                case 145 -> 117;
                case 146 -> 18;
                case 147 -> 9;
                case 148 -> 205;
                case 149 -> 245;
                case 150 -> 167;
                case 151 -> 99;
                case 152 -> 242;
                case 153 -> 227;
                case 154 -> 208;
                case 155 -> 37;
                case 156 -> 54;
                case 157 -> 101;
                case 158 -> 32;
                case 159 -> 48;
                case 160 -> 131;
                case 161 -> 235;
                case 162 -> 170;
                case 163 -> 109;
                case 164 -> 146;
                case 165 -> 200;
                case 166 -> 23;
                case 167 -> 21;
                case 168 -> 195;
                case 169 -> 17;
                case 170 -> 106;
                case 171 -> 110;
                case 172 -> 84;
                case 173 -> 26;
                case 174 -> 81;
                case 175 -> 74;
                case 176 -> 120;
                case 177 -> 222;
                case 178 -> 51;
                case 179 -> 150;
                case 180 -> 58;
                case 181 -> 148;
                case 182 -> 108;
                case 183 -> 206;
                case 184 -> 160;
                case 185 -> 214;
                case 186 -> 88;
                case 187 -> 91;
                case 188 -> 40;
                case 189 -> 64;
                case 190 -> 143;
                case 191 -> 29;
                case 192 -> 180;
                case 193 -> 236;
                case 194 -> 67;
                case 195 -> 230;
                case 196 -> 128;
                case 197 -> 77;
                case 198 -> 25;
                case 199 -> 85;
                case 200 -> 72;
                case 201 -> 139;
                case 202 -> 158;
                case 203 -> 5;
                case 204 -> 10;
                case 205 -> 228;
                case 206 -> 136;
                case 207 -> 232;
                case 208 -> 127;
                case 209 -> 119;
                case 210 -> 39;
                case 211 -> 216;
                case 212 -> 82;
                case 213 -> 47;
                case 214 -> 103;
                case 215 -> 98;
                case 216 -> 156;
                case 217 -> 202;
                case 218 -> 186;
                case 219 -> 177;
                case 220 -> 169;
                case 221 -> 218;
                case 222 -> 34;
                case 223 -> 45;
                case 224 -> 225;
                case 225 -> 30;
                case 226 -> 175;
                case 227 -> 4;
                case 228 -> 134;
                case 229 -> 255;
                case 230 -> 254;
                case 231 -> 191;
                case 232 -> 129;
                case 233 -> 203;
                case 234 -> 233;
                case 235 -> 113;
                case 236 -> 183;
                case 237 -> 107;
                case 238 -> 141;
                case 239 -> 153;
                case 240 -> 229;
                case 241 -> 68;
                case 242 -> 62;
                case 243 -> 155;
                case 244 -> 102;
                case 245 -> 55;
                case 246 -> 44;
                case 247 -> 36;
                case 248 -> 83;
                case 249 -> 57;
                case 250 -> 178;
                case 251 -> 187;
                case 252 -> 24;
                case 253 -> 8;
                case 254 -> 147;
                default -> 93;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            ServerSocketWrapper.b[n5] = new String(cArray).intern();
        }
        return b[n5];
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketWrapper$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PortStrategy.values().length];
            try {
                nArray[PortStrategy.REASSIGN_WHEN_BUSY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortStrategy.ERROR_WHEN_BUSY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

