/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentCategorizer;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.settingsSync.SettingsSyncSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\"\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00060\u00052\u0006\u0010\t\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0002\u001a\"\u0010\n\u001a\u00020\u00032\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00060\u0005H\u0002\u001a\u000e\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0002H\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"categoryCache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lcom/intellij/openapi/components/SettingsCategory;", "findComponentClasses", "", "Ljava/lang/Class;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "", "fileSpec", "getCategory", "fileName", "componentClasses", "getFileSpec", "path", "getSchemeCategory", "getSubCategory", "isSyncCategoryEnabled", "", "removeOsPrefix", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nSettingsSyncFiltering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncFiltering.kt\ncom/intellij/settingsSync/SettingsSyncFilteringKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1855#2,2:114\n*S KotlinDebug\n*F\n+ 1 SettingsSyncFiltering.kt\ncom/intellij/settingsSync/SettingsSyncFilteringKt\n*L\n42#1:114,2\n*E\n"})
public final class SettingsSyncFilteringKt {
    @NotNull
    private static final ConcurrentMap<String, SettingsCategory> categoryCache = new ConcurrentHashMap();

    public static final boolean isSyncCategoryEnabled(@NotNull String fileSpec) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        String rawFileSpec = SettingsSyncFilteringKt.removeOsPrefix(fileSpec);
        if (Intrinsics.areEqual((Object)rawFileSpec, (Object)"settingsSync.xml")) {
            return true;
        }
        SettingsCategory settingsCategory = SettingsSyncFilteringKt.getSchemeCategory(rawFileSpec);
        if (settingsCategory == null && (settingsCategory = SettingsSyncFilteringKt.getCategory(rawFileSpec)) == null) {
            return false;
        }
        SettingsCategory category = settingsCategory;
        if (category != SettingsCategory.OTHER && SettingsSyncSettings.Companion.getInstance().isCategoryEnabled(category)) {
            String subCategory = SettingsSyncFilteringKt.getSubCategory(fileSpec);
            if (subCategory != null) {
                return SettingsSyncSettings.Companion.getInstance().isSubcategoryEnabled(category, subCategory);
            }
            return true;
        }
        return false;
    }

    private static final String removeOsPrefix(String fileSpec) {
        String string;
        String osPrefix = StoreUtilKt.getPerOsSettingsStorageFolderName() + "/";
        if (StringsKt.startsWith$default((String)fileSpec, (String)osPrefix, (boolean)false, (int)2, null)) {
            String string2 = StringUtil.trimStart((String)fileSpec, (String)osPrefix);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trimStart(...)");
        } else {
            string = fileSpec;
        }
        return string;
    }

    private static final SettingsCategory getCategory(List<Class<PersistentStateComponent<Object>>> componentClasses) {
        if (componentClasses.isEmpty()) {
            return SettingsCategory.OTHER;
        }
        if (componentClasses.size() == 1) {
            SettingsCategory settingsCategory = ComponentCategorizer.getCategory(componentClasses.get(0));
            Intrinsics.checkNotNullExpressionValue((Object)settingsCategory, (String)"getCategory(...)");
            return settingsCategory;
        }
        Iterable $this$forEach$iv = componentClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SettingsCategory category;
            Class it = (Class)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)ComponentCategorizer.getCategory((Class)it), (String)"getCategory(...)");
            if (category == SettingsCategory.OTHER) continue;
            return category;
        }
        return SettingsCategory.OTHER;
    }

    @Nullable
    public static final SettingsCategory getCategory(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        SettingsCategory settingsCategory = (SettingsCategory)categoryCache.get(fileName);
        if (settingsCategory != null) {
            SettingsCategory cachedCategory = settingsCategory;
            boolean bl = false;
            return cachedCategory;
        }
        List<Class<PersistentStateComponent<Object>>> componentClasses = SettingsSyncFilteringKt.findComponentClasses(fileName);
        if (componentClasses.isEmpty()) {
            return null;
        }
        SettingsCategory settingsCategory2 = SettingsSyncFilteringKt.getSchemeCategory(fileName);
        if (settingsCategory2 == null) {
            settingsCategory2 = SettingsSyncFilteringKt.getCategory(componentClasses);
        }
        SettingsCategory category = settingsCategory2;
        ((Map)categoryCache).put(fileName, category);
        return category;
    }

    private static final SettingsCategory getSchemeCategory(String fileSpec) {
        String string;
        int separatorIndex = StringsKt.indexOf$default((CharSequence)fileSpec, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (separatorIndex >= 0) {
            String string2 = fileSpec.substring(0, separatorIndex);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = fileSpec;
        }
        String directoryName = string;
        Ref.ObjectRef settingsCategory = new Ref.ObjectRef();
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        Intrinsics.checkNotNull((Object)schemeManagerFactory, (String)"null cannot be cast to non-null type com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase");
        ((SchemeManagerFactoryBase)schemeManagerFactory).process((Function1)new Function1<SchemeManagerImpl<Scheme, Scheme>, Unit>(directoryName, (Ref.ObjectRef<SettingsCategory>)settingsCategory){
            final /* synthetic */ String $directoryName;
            final /* synthetic */ Ref.ObjectRef<SettingsCategory> $settingsCategory;
            {
                this.$directoryName = $directoryName;
                this.$settingsCategory = $settingsCategory;
                super(1);
            }

            public final void invoke(@NotNull SchemeManagerImpl<Scheme, Scheme> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (Intrinsics.areEqual((Object)it.getFileSpec(), (Object)this.$directoryName)) {
                    this.$settingsCategory.element = it.getSettingsCategory();
                }
            }
        });
        return (SettingsCategory)settingsCategory.element;
    }

    @NotNull
    public static final String getFileSpec(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return SettingsSyncFilteringKt.removeOsPrefix(path);
    }

    private static final String getSubCategory(String fileSpec) {
        if (Intrinsics.areEqual((Object)fileSpec, (Object)"editor-font.xml")) {
            return "editorFont";
        }
        return null;
    }

    private static final List<Class<PersistentStateComponent<Object>>> findComponentClasses(String fileSpec) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
        ComponentManagerImpl componentManager = (ComponentManagerImpl)application;
        ArrayList<Class<PersistentStateComponent<Object>>> componentClasses = new ArrayList<Class<PersistentStateComponent<Object>>>();
        componentManager.processAllImplementationClasses(new Function2<Class<?>, PluginDescriptor, Unit>(fileSpec, componentClasses){
            final /* synthetic */ String $fileSpec;
            final /* synthetic */ ArrayList<Class<PersistentStateComponent<Object>>> $componentClasses;
            {
                this.$fileSpec = $fileSpec;
                this.$componentClasses = $componentClasses;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Class<?> aClass, @Nullable PluginDescriptor pluginDescriptor) {
                block6: {
                    block7: {
                        boolean bl;
                        block5: {
                            void $this$any$iv;
                            Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
                            if (!PersistentStateComponent.class.isAssignableFrom(aClass)) break block6;
                            State state = aClass.getAnnotation(State.class);
                            if (state == null) {
                                return;
                            }
                            State state2 = state;
                            if (((CharSequence)state2.additionalExportDirectory()).length() > 0 && (Intrinsics.areEqual((Object)this.$fileSpec, (Object)state2.additionalExportDirectory()) || StringsKt.startsWith$default((String)this.$fileSpec, (String)(state2.additionalExportDirectory() + "/"), (boolean)false, (int)2, null))) break block7;
                            Storage[] storageArray = state2.storages();
                            String string = this.$fileSpec;
                            boolean $i$f$any = false;
                            int n = ((void)$this$any$iv).length;
                            for (int i = 0; i < n; ++i) {
                                void element$iv;
                                void storage = element$iv = $this$any$iv[i];
                                boolean bl2 = false;
                                if (!(!storage.deprecated() && Intrinsics.areEqual((Object)storage.value(), (Object)string))) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                        if (!bl) break block6;
                    }
                    this.$componentClasses.add(aClass);
                }
            }
        });
        return componentClasses;
    }
}

