/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReadonlyStatusHandler {
    public static ReadonlyStatusHandler getInstance(@NotNull Project project) {
        if (project == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(0);
        }
        return (ReadonlyStatusHandler)project.getService(ReadonlyStatusHandler.class);
    }

    public static boolean ensureFilesWritable(@NotNull Project project, VirtualFile ... files2) {
        if (project == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(2);
        }
        return !ReadonlyStatusHandler.getInstance(project).ensureFilesWritable(Arrays.asList(files2)).hasReadonlyFiles();
    }

    public static boolean ensureDocumentWritable(@NotNull Project project, @NotNull Document document) {
        VirtualFile virtualFile;
        PsiFile psiFile;
        if (project == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(3);
        }
        if (document == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(4);
        }
        boolean okWritable = (psiFile = PsiDocumentManager.getInstance(project).getPsiFile(document)) == null ? document.isWritable() : ((virtualFile = psiFile.getVirtualFile()) != null ? ReadonlyStatusHandler.ensureFilesWritable(project, virtualFile) : psiFile.isWritable());
        return okWritable;
    }

    @Deprecated
    @NotNull
    public OperationStatus ensureFilesWritable(VirtualFile ... files2) {
        if (files2 == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(5);
        }
        OperationStatus operationStatus = this.ensureFilesWritable(Arrays.asList(files2));
        if (operationStatus == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(6);
        }
        return operationStatus;
    }

    @NotNull
    public abstract OperationStatus ensureFilesWritable(@NotNull Collection<? extends VirtualFile> var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/ReadonlyStatusHandler";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/ReadonlyStatusHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureFilesWritable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ensureDocumentWritable";
                break;
            }
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class OperationStatus {
        public abstract VirtualFile @NotNull [] getReadonlyFiles();

        public abstract boolean hasReadonlyFiles();

        @NotNull
        @NlsContexts.DialogMessage
        public abstract String getReadonlyFilesMessage();

        @Nullable
        public HyperlinkListener getHyperlinkListener() {
            return null;
        }
    }
}

