/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.clones;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.inspections.clones.CssDuplicateScope;
import com.intellij.psi.css.inspections.clones.CssDuplicatesConfigurable;
import com.intellij.psi.css.inspections.clones.CssDuplicatesIndexConfiguration;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.clones.configuration.DuplicateInspectionConfiguration;
import com.jetbrains.clones.core.CommonUtilsKt;
import com.jetbrains.clones.core.LighterAstNodeHashCache;
import com.jetbrains.clones.core.NodeHash;
import com.jetbrains.clones.languagescope.DuplicateScope;
import com.jetbrains.clones.languagescope.common.CommonDuplicateInspectionConfiguration;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.structures.TextFragment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u0018\u0010\u0015\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J.\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0016J\u0018\u00102\u001a\u0002032\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u000204H\u0016J\u0018\u00105\u001a\u0002032\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u00106\u001a\u0002032\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u001a\u00107\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0018\u00108\u001a\u0002032\u0006\u0010+\u001a\u00020,2\u0006\u00109\u001a\u00020.H\u0016J\u0018\u0010:\u001a\u00020&2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0012\u001a\u00070\f\u00a2\u0006\u0002\b\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006;"}, d2={"Lcom/intellij/psi/css/inspections/clones/CssDuplicateScope;", "Lcom/jetbrains/clones/languagescope/DuplicateScope;", "()V", "indexConfiguration", "Lcom/intellij/psi/css/inspections/clones/CssDuplicatesIndexConfiguration;", "getIndexConfiguration", "()Lcom/intellij/psi/css/inspections/clones/CssDuplicatesIndexConfiguration;", "languageName", "", "getLanguageName", "()Ljava/lang/String;", "noiseTokens", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getNoiseTokens", "()Lcom/intellij/psi/tree/TokenSet;", "noiseTokens$delegate", "Lkotlin/Lazy;", "valueTokens", "getValueTokens", "valueTokens$delegate", "addSemicolonIfPossible", "Lcom/jetbrains/clones/structures/TextClone;", "project", "Lcom/intellij/openapi/project/Project;", "textClone", "Lcom/jetbrains/clones/structures/TextFragment;", "fragment", "createDefaultConfiguration", "Lcom/jetbrains/clones/configuration/DuplicateInspectionConfiguration;", "createIndexConfigurable", "Lcom/intellij/openapi/options/Configurable;", "createOptionController", "Lcom/intellij/codeInspection/options/OptionController;", "state", "createOptions", "Lcom/intellij/codeInspection/options/OptPane;", "getIndexVersion", "", "hashOf", "", "cache", "Lcom/jetbrains/clones/core/LighterAstNodeHashCache;", "ast", "Lcom/intellij/lang/LighterAST;", "node", "Lcom/intellij/lang/LighterASTNode;", "children", "", "Lcom/jetbrains/clones/core/NodeHash;", "isAnonymized", "", "Lcom/intellij/lang/LighterASTTokenNode;", "isIgnoredAsDuplicate", "isNoise", "processDuplicate", "shouldAnalyzeChildSubsequences", "parent", "weightOf", "intellij.css.impl"})
@SourceDebugExtension(value={"SMAP\nCssDuplicateScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CssDuplicateScope.kt\ncom/intellij/psi/css/inspections/clones/CssDuplicateScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n766#2:134\n857#2,2:135\n1045#2:137\n819#2:138\n847#2,2:139\n766#2:141\n857#2,2:142\n1549#2:144\n1620#2,3:145\n1#3:148\n*S KotlinDebug\n*F\n+ 1 CssDuplicateScope.kt\ncom/intellij/psi/css/inspections/clones/CssDuplicateScope\n*L\n76#1:134\n76#1:135,2\n76#1:137\n77#1:138\n77#1:139,2\n105#1:141\n105#1:142,2\n115#1:144\n115#1:145,3\n*E\n"})
public final class CssDuplicateScope
implements DuplicateScope {
    @NotNull
    private final String languageName;
    @NotNull
    private final CssDuplicatesIndexConfiguration indexConfiguration = new CssDuplicatesIndexConfiguration(this.getLanguageName());
    @NotNull
    private final Lazy noiseTokens$delegate = LazyKt.lazy((Function0)noiseTokens.2.INSTANCE);
    @NotNull
    private final Lazy valueTokens$delegate = LazyKt.lazy((Function0)valueTokens.2.INSTANCE);

    public CssDuplicateScope() {
        this.languageName = "Style Sheets";
    }

    @NotNull
    public String getLanguageName() {
        return this.languageName;
    }

    @NotNull
    public CssDuplicatesIndexConfiguration getIndexConfiguration() {
        return this.indexConfiguration;
    }

    private final TokenSet getNoiseTokens() {
        Lazy lazy = this.noiseTokens$delegate;
        return (TokenSet)lazy.getValue();
    }

    public boolean isNoise(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getNoiseTokens().contains(node.getTokenType());
    }

    private final TokenSet getValueTokens() {
        Lazy lazy = this.valueTokens$delegate;
        return (TokenSet)lazy.getValue();
    }

    public int getIndexVersion() {
        return 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAnonymized(@NotNull LighterAST ast, @NotNull LighterASTTokenNode node) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LighterASTNode parent = ast.getParent((LighterASTNode)node);
        LighterASTNode lighterASTNode = parent;
        if (this.getValueTokens().contains((IElementType)(lighterASTNode != null ? lighterASTNode.getTokenType() : null))) {
            bl = this.getIndexConfiguration().getAnonymizeValues();
            return bl;
        } else {
            if (!Intrinsics.areEqual((Object)node.getTokenType(), (Object)CssElementTypes.CSS_IDENT)) return true;
            LighterASTNode lighterASTNode2 = parent;
            if (Intrinsics.areEqual((Object)(lighterASTNode2 != null ? lighterASTNode2.getTokenType() : null), (Object)CssElementTypes.CSS_DECLARATION_BLOCK)) return true;
            bl = this.getIndexConfiguration().getAnonymizeNames();
        }
        return bl;
    }

    public boolean shouldAnalyzeChildSubsequences(@NotNull LighterAST ast, @NotNull LighterASTNode parent) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return Intrinsics.areEqual((Object)parent.getTokenType(), (Object)CssElementTypes.CSS_DECLARATION_BLOCK);
    }

    public boolean isIgnoredAsDuplicate(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return false;
    }

    public int weightOf(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return Intrinsics.areEqual((Object)node.getTokenType(), (Object)((Object)CssElementTypes.CSS_DECLARATION)) ? 1 : 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public long hashOf(@NotNull LighterAstNodeHashCache cache, @NotNull LighterAST ast, @NotNull LighterASTNode node, @NotNull List<? extends NodeHash> children) {
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        long l;
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        if (node instanceof LighterASTTokenNode) {
            l = CommonUtilsKt.hashOf((LighterASTTokenNode)((LighterASTTokenNode)node), (boolean)this.isAnonymized(ast, (LighterASTTokenNode)node));
            return l;
        }
        if (!this.getIndexConfiguration().getAnonymizeValues() && this.getValueTokens().contains(node.getTokenType())) {
            NodeHash nodeHash = (NodeHash)CollectionsKt.firstOrNull(children);
            if ((nodeHash != null ? nodeHash.getNode() : null) instanceof LighterASTTokenNode) {
                String string = LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)node, null);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toFilteredString(...)");
                String string2 = string.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                l = string2.hashCode();
                return l;
            }
        }
        if (!Intrinsics.areEqual((Object)node.getTokenType(), (Object)CssElementTypes.CSS_DECLARATION_BLOCK)) {
            l = super.hashOf(cache, ast, node, children);
            return l;
        }
        Iterable $this$filter$iv = children;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NodeHash it = (NodeHash)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getNode().getTokenType(), (Object)((Object)CssElementTypes.CSS_DECLARATION))) continue;
            collection.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection;
        boolean $i$f$sortedBy = false;
        List declarationNodes = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                NodeHash it = (NodeHash)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getHash());
                it = (NodeHash)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getHash()));
            }
        });
        Iterable $this$filterNot$iv = children;
        boolean $i$f$filterNot = false;
        Iterable iterable2 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = iterable2.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                List otherNodes = (List)destination$iv$iv;
                return (long)37 * CommonUtilsKt.nodeListHash((List)declarationNodes) + CommonUtilsKt.nodeListHash((List)otherNodes);
            }
            Object element$iv$iv = iterator.next();
            NodeHash it = (NodeHash)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getNode().getTokenType(), (Object)((Object)CssElementTypes.CSS_DECLARATION))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
    }

    @NotNull
    public OptPane createOptions() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.number((String)"minSize", (String)CssBundle.message("duplicate.settings.inspection.css.length", new Object[0]), (int)this.getIndexConfiguration().getWindowSize(), (int)10000)};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    public OptionController createOptionController(@NotNull DuplicateInspectionConfiguration state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        OptionController optionController = OptionController.empty().onValue("minSize", (KMutableProperty0)new MutablePropertyReference0Impl(state){

            @Nullable
            public Object get() {
                return ((DuplicateInspectionConfiguration)this.receiver).getMinSize();
            }

            public void set(@Nullable Object value) {
                ((DuplicateInspectionConfiguration)this.receiver).setMinSize(((Number)value).intValue());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)optionController, (String)"onValue(...)");
        return optionController;
    }

    @NotNull
    public Configurable createIndexConfigurable() {
        return new CssDuplicatesConfigurable(this.getIndexConfiguration());
    }

    @NotNull
    public DuplicateInspectionConfiguration createDefaultConfiguration() {
        return (DuplicateInspectionConfiguration)new CommonDuplicateInspectionConfiguration(10, true);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public TextClone processDuplicate(@NotNull Project project, @NotNull TextClone textClone) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)textClone, (String)"textClone");
        Iterable iterable = textClone.getDuplicates();
        TextFragment textFragment = textClone.getMain();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextFragment it = (TextFragment)element$iv$iv;
            boolean bl = false;
            if (!FileTypeRegistry.getInstance().isFileOfType(it.getFile(), textClone.getMain().getFile().getFileType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        TextFragment textFragment2 = textFragment;
        List list = (List)destination$iv$iv;
        TextClone filteredTextClone = new TextClone(textFragment2, list);
        return filteredTextClone.getDuplicates().isEmpty() ? null : this.addSemicolonIfPossible(project, filteredTextClone);
    }

    /*
     * WARNING - void declaration
     */
    private final TextClone addSemicolonIfPossible(Project project, TextClone textClone) {
        void $this$mapTo$iv$iv;
        TextFragment main = this.addSemicolonIfPossible(project, textClone.getMain());
        if (Intrinsics.areEqual((Object)main, (Object)textClone.getMain())) {
            return textClone;
        }
        Iterable $this$map$iv = textClone.getDuplicates();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextFragment textFragment = (TextFragment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.addSemicolonIfPossible(project, (TextFragment)it));
        }
        List duplicates = (List)destination$iv$iv;
        return new TextClone(main, duplicates);
    }

    private final TextFragment addSemicolonIfPossible(Project project, TextFragment fragment) {
        Object v1;
        block1: {
            PsiFile file;
            PsiFile psiFile = file = PsiManager.getInstance((Project)project).findFile(fragment.getFile());
            PsiElement endElement = psiFile != null ? psiFile.findElementAt(fragment.getRange().getEndOffset() - 1) : null;
            PsiElement declarationElement2 = PsiTreeUtil.findFirstParent((PsiElement)endElement, arg_0 -> CssDuplicateScope.addSemicolonIfPossible$lambda$5(addSemicolonIfPossible.declarationElement.1.INSTANCE, arg_0));
            Sequence sequence = SequencesKt.generateSequence((Object)declarationElement2, (Function1)addSemicolonIfPossible.semicolon.1.INSTANCE);
            for (Object e : sequence) {
                PsiElement it = (PsiElement)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)CssElementTypes.CSS_SEMICOLON)) continue;
                v1 = e;
                break block1;
            }
            v1 = null;
        }
        PsiElement semicolon2 = v1;
        return semicolon2 != null ? new TextFragment(fragment.getFile(), new TextRange(fragment.getRange().getStartOffset(), semicolon2.getTextRange().getEndOffset())) : fragment;
    }

    private static final boolean addSemicolonIfPossible$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

