/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.actions.CssBaseElementAtCaretIntentionAction;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class CssExpandShorthandPropertyAction
extends CssBaseElementAtCaretIntentionAction {
    @NotNull
    public String getText() {
        String string = CssBundle.message("expand.shorthand.action", new Object[0]);
        if (string == null) {
            CssExpandShorthandPropertyAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            CssExpandShorthandPropertyAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            CssExpandShorthandPropertyAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            CssExpandShorthandPropertyAction.$$$reportNull$$$0(3);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        CssDeclaration cssDeclaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class);
        if (cssDeclaration == null || !cssDeclaration.isShorthandProperty()) {
            return false;
        }
        CssTermList termList = cssDeclaration.getValue();
        if (termList == null) {
            return false;
        }
        for (PsiElement child : termList.getChildren()) {
            if (child instanceof PsiErrorElement) {
                return false;
            }
            if (!(child instanceof CssTerm) || ((CssTerm)child).getTermType() != CssTermTypes.IDENT) continue;
            PsiElement identChild = child.getFirstChild();
            if (identChild == null) {
                return false;
            }
            IElementType elementType = identChild.getNode().getElementType();
            if (elementType == CssElementTypes.CSS_IDENT) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message("expand.shorthand.family", new Object[0]);
        if (string == null) {
            CssExpandShorthandPropertyAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        CssDeclaration declaration;
        if (project == null) {
            CssExpandShorthandPropertyAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            CssExpandShorthandPropertyAction.$$$reportNull$$$0(6);
        }
        if (element == null) {
            CssExpandShorthandPropertyAction.$$$reportNull$$$0(7);
        }
        if ((declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class)) != null && declaration.isShorthandProperty()) {
            String[] properties2 = declaration.expandShorthandProperty();
            Map<String, String> name2value = CssPropertyUtil.getExpandedShorthandValues(declaration, properties2);
            PsiElement parent1 = declaration.getParent();
            if (parent1 instanceof CssBlock) {
                if (!name2value.isEmpty()) {
                    CssBlock block = (CssBlock)parent1;
                    for (String name : name2value.keySet()) {
                        block.addDeclaration(name, name2value.get(name), declaration);
                    }
                    block.removeDeclaration(declaration);
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                } else {
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CssBundle.message("expand.shorthand.error", new Object[0]), (String)"", null);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/CssExpandShorthandPropertyAction";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/CssExpandShorthandPropertyAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

