/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway;

import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PlatformUtils;
import com.jetbrains.gateway.GatewayBuildDateExpirationListener;
import com.jetbrains.gateway.GatewayBuildDateExpirationListenerKt;
import com.jetbrains.gateway.GatewayBundle;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/gateway/GatewayBuildDateExpirationListener;", "Lcom/intellij/ide/ApplicationInitializedListener;", "()V", "execute", "", "asyncScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.gateway"})
@SourceDebugExtension(value={"SMAP\nGatewayBuildDateExpirationListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GatewayBuildDateExpirationListener.kt\ncom/jetbrains/gateway/GatewayBuildDateExpirationListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,70:1\n23#2:71\n23#2:72\n*S KotlinDebug\n*F\n+ 1 GatewayBuildDateExpirationListener.kt\ncom/jetbrains/gateway/GatewayBuildDateExpirationListener\n*L\n24#1:71\n41#1:72\n*E\n"})
public final class GatewayBuildDateExpirationListener
implements ApplicationInitializedListener {
    @Nullable
    public Object execute(@NotNull CoroutineScope asyncScope, @NotNull Continuation<? super Unit> $completion) {
        boolean isExpired;
        long buildTimeMs;
        boolean isRelease;
        if (Intrinsics.areEqual((Object)System.getProperty("com.jetbrains.gateway.disable.expiration", "false"), (Object)"true")) {
            GatewayBuildDateExpirationListener $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GatewayBuildDateExpirationListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Expiration listener is explicitly disabled via com.jetbrains.gateway.disable.expiration, will not trigger");
            return Unit.INSTANCE;
        }
        boolean isGatewayStandalone = PlatformUtils.isGateway();
        boolean bl = isRelease = !ApplicationKt.getApplication().isEAP();
        if (!isGatewayStandalone || isRelease || ApplicationKt.getApplication().isUnitTestMode() || PluginManagerCore.isRunningFromSources()) {
            return Unit.INSTANCE;
        }
        long currentTimeMs = System.currentTimeMillis();
        Duration elapsed = Duration.ofMillis(currentTimeMs - (buildTimeMs = ApplicationInfoImpl.getShadowInstance().getBuildDate().getTimeInMillis()));
        boolean isTooFarInThePast = elapsed.compareTo(Duration.ZERO) < 0 && elapsed.negated().compareTo(GatewayBuildDateExpirationListenerKt.access$getPastTimeTravelAllowance$p()) > 0;
        boolean bl2 = isExpired = isTooFarInThePast || elapsed.compareTo(GatewayBuildDateExpirationListenerKt.access$getBestBefore$p()) > 0;
        if (!isExpired) {
            return Unit.INSTANCE;
        }
        GatewayBuildDateExpirationListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GatewayBuildDateExpirationListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Gateway build date is too old, elapsedMs=" + elapsed.toMillis());
        String string = PlatformUtils.getPlatformPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlatformPrefix(...)");
        String platformPrefix = string;
        RdCoroutinesUtilKt.launchChildOnUi$default((CoroutineScope)asyncScope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(platformPrefix, null){
            int label;
            final /* synthetic */ String $platformPrefix;
            {
                this.$platformPrefix = $platformPrefix;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            Object[] objectArray = new Object[]{this.$platformPrefix, "https://www.jetbrains.com/remote-development/gateway/"};
                            String string = GatewayBundle.INSTANCE.message("gateway.eap.build.expired.dialog.message", objectArray);
                            objectArray = new Object[]{this.$platformPrefix};
                            String string2 = GatewayBundle.INSTANCE.message("gateway.eap.build.expired.dialog.title", objectArray);
                            objectArray = new String[]{GatewayBundle.INSTANCE.message("gateway.eap.build.expired.dialog.button.download", new Object[0]), GatewayBundle.INSTANCE.message("gateway.eap.build.expired.dialog.button.shutdown", new Object[0])};
                            int result = Messages.showDialog((String)string, (String)string2, (String[])objectArray, (int)0, null);
                            if (result == 0) {
                                BrowserUtil.browse((String)"https://www.jetbrains.com/remote-development/gateway/");
                            }
                        }
                        finally {
                            ApplicationKt.getApplication().invokeLater(execute.2::invokeSuspend$lambda$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0() {
                ApplicationKt.getApplication().exit(true, true, false);
            }
        }), (int)1, null);
        return Unit.INSTANCE;
    }
}

