/*
 * Decompiled with CFR 0.152.
 */
package reactor.util.context;

import java.util.AbstractMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import reactor.util.context.Context;
import reactor.util.context.Context2;
import reactor.util.context.ContextN;
import reactor.util.context.CoreContext;

final class Context1
implements CoreContext {
    final Object key;
    final Object value;

    Context1(Object key2, Object value2) {
        this.key = Objects.requireNonNull(key2, "key");
        this.value = Objects.requireNonNull(value2, "value");
    }

    @Override
    public Context put(Object key2, Object value2) {
        Objects.requireNonNull(key2, "key");
        Objects.requireNonNull(value2, "value");
        if (this.key.equals(key2)) {
            return new Context1(key2, value2);
        }
        return new Context2(this.key, this.value, key2, value2);
    }

    @Override
    public Context delete(Object key2) {
        Objects.requireNonNull(key2, "key");
        if (this.key.equals(key2)) {
            return Context.empty();
        }
        return this;
    }

    @Override
    public boolean hasKey(Object key2) {
        return this.key.equals(key2);
    }

    @Override
    public <T> T get(Object key2) {
        if (this.hasKey(key2)) {
            return (T)this.value;
        }
        throw new NoSuchElementException("Context does not contain key: " + key2);
    }

    @Override
    public Stream<Map.Entry<Object, Object>> stream() {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<Object, Object>(this.key, this.value));
    }

    @Override
    public void forEach(BiConsumer<Object, Object> action2) {
        action2.accept(this.key, this.value);
    }

    @Override
    public Context putAllInto(Context base) {
        return base.put(this.key, this.value);
    }

    @Override
    public void unsafePutAllInto(ContextN other) {
        other.accept(this.key, this.value);
    }

    @Override
    public int size() {
        return 1;
    }

    public String toString() {
        return "Context1{" + this.key + '=' + this.value + '}';
    }
}

