/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.DebuggerTags;
import com.oracle.truffle.api.debug.SourceElement;
import com.oracle.truffle.api.debug.SuspendAnchor;
import com.oracle.truffle.api.debug.SuspensionFilter;
import com.oracle.truffle.api.instrumentation.NearestSectionFilter;
import com.oracle.truffle.api.instrumentation.SourceFilter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.util.function.Predicate;

abstract class BreakpointLocation {
    protected final SourceElement[] sourceElements;
    static final BreakpointLocation ANY = new BreakpointSourceLocation();
    static final URI ANY_SOURCE = URI.create("");

    protected BreakpointLocation(SourceElement[] sourceElements) {
        this.sourceElements = sourceElements;
    }

    static BreakpointLocation create(Object key2, SourceElement[] sourceElements, SourceSection sourceSection) {
        return new BreakpointSourceLocation(key2, sourceElements, sourceSection);
    }

    static BreakpointLocation create(Object key2, SourceElement[] sourceElements, int line, int column) {
        return new BreakpointSourceLocation(key2, sourceElements, line, column);
    }

    static BreakpointLocation create(SourceElement[] sourceElements, SuspensionFilter filter2) {
        return new BreakpointFilteredLocation(sourceElements, filter2);
    }

    final boolean containsRoot() {
        if (this.sourceElements == null) {
            return true;
        }
        for (SourceElement elem : this.sourceElements) {
            if (SourceElement.ROOT != elem) continue;
            return true;
        }
        return false;
    }

    abstract boolean isLoadBindingNeeded();

    abstract LocationFilters createLocationFilters(SuspendAnchor var1);

    abstract SourceSectionFilter createExecLocationFilter(SourceSection var1, SuspendAnchor var2);

    private static Class<?>[] getTags(SourceElement[] sourceElements) {
        Class[] elementTags = new Class[sourceElements.length];
        for (int i = 0; i < elementTags.length; ++i) {
            elementTags[i] = sourceElements[i].getTag();
        }
        return elementTags;
    }

    private static void setTags(SourceSectionFilter.Builder f, SourceElement[] sourceElements) {
        f.tagIs(BreakpointLocation.getTags(sourceElements));
    }

    private static void setTags(NearestSectionFilter.Builder f, SourceElement[] sourceElements) {
        f.tagIs(BreakpointLocation.getTags(sourceElements));
    }

    private static final class BreakpointSourceLocation
    extends BreakpointLocation {
        private final Object key;
        private final SourceSection sourceSection;
        private final int line;
        private final int column;

        BreakpointSourceLocation(Object key2, SourceElement[] sourceElements, SourceSection sourceSection) {
            super(sourceElements);
            assert (key2 instanceof Source || key2 instanceof URI);
            this.key = key2;
            this.sourceSection = sourceSection;
            this.line = -1;
            this.column = -1;
        }

        BreakpointSourceLocation(Object key2, SourceElement[] sourceElements, int line, int column) {
            super(sourceElements);
            assert (key2 instanceof Source || key2 instanceof URI);
            assert (line > 0 || line == -1);
            assert (column > 0 || column == -1);
            this.key = key2;
            this.line = line;
            this.column = column;
            this.sourceSection = null;
        }

        private BreakpointSourceLocation() {
            super(null);
            this.key = null;
            this.line = -1;
            this.column = -1;
            this.sourceSection = null;
        }

        private SourceFilter createSourceFilter() {
            if (this.key == null) {
                return null;
            }
            SourceFilter.Builder f = SourceFilter.newBuilder();
            if (this.key instanceof URI) {
                f.sourceIs(this.createSourcePredicate());
            } else {
                assert (this.key instanceof Source);
                Source s = (Source)this.key;
                f.sourceIs(s);
            }
            return f.build();
        }

        private Predicate<Source> createSourcePredicate() {
            if (this.key == null) {
                return null;
            }
            if (this.key instanceof URI) {
                if (this.key == ANY_SOURCE) {
                    return new Predicate<Source>(){

                        @Override
                        public boolean test(Source s) {
                            return true;
                        }
                    };
                }
                final URI sourceUri = (URI)this.key;
                final String sourceRawPath = sourceUri.getRawPath() != null ? sourceUri.getRawPath() : sourceUri.getRawSchemeSpecificPart();
                return new Predicate<Source>(){

                    @Override
                    public boolean test(Source s) {
                        URI uri = s.getURI();
                        if (uri.isAbsolute()) {
                            return sourceUri.equals(uri);
                        }
                        return sourceRawPath != null && sourceRawPath.endsWith(uri.getRawPath());
                    }

                    public String toString() {
                        return "URI equals " + sourceUri;
                    }
                };
            }
            assert (this.key instanceof Source);
            final Source source = (Source)this.key;
            return new Predicate<Source>(){

                @Override
                public boolean test(Source s) {
                    return source.equals(s);
                }
            };
        }

        @Override
        boolean isLoadBindingNeeded() {
            return this.line != -1;
        }

        @Override
        LocationFilters createLocationFilters(SuspendAnchor suspendAnchor) {
            SourceSectionFilter.Builder f = SourceSectionFilter.newBuilder();
            NearestSectionFilter nearestFilter = null;
            if (this.key == null) {
                f.tagIs(DebuggerTags.AlwaysHalt.class);
            } else {
                if (this.key != ANY_SOURCE) {
                    f.sourceFilter(this.createSourceFilter());
                }
                if (this.line != -1) {
                    assert (this.sourceSection == null);
                    NearestSectionFilter.Builder nearestBuilder = NearestSectionFilter.newBuilder(this.line, this.column);
                    nearestBuilder.anchorStart(SuspendAnchor.BEFORE == suspendAnchor);
                    BreakpointLocation.setTags(nearestBuilder, this.sourceElements);
                    nearestFilter = nearestBuilder.build();
                } else {
                    if (this.sourceSection != null) {
                        f.sourceSectionEquals(this.sourceSection);
                    }
                    BreakpointLocation.setTags(f, this.sourceElements);
                }
            }
            return new LocationFilters(f.build(), nearestFilter);
        }

        @Override
        SourceSectionFilter createExecLocationFilter(SourceSection location, SuspendAnchor suspendAnchor) {
            SourceSectionFilter.Builder f = SourceSectionFilter.newBuilder();
            if (this.key == null) {
                return f.tagIs(DebuggerTags.AlwaysHalt.class).build();
            }
            if (this.column > 0) {
                f.sourceSectionEquals(location);
            } else {
                switch (suspendAnchor) {
                    case BEFORE: {
                        f.lineStartsIn(SourceSectionFilter.IndexRange.byLength(location.getStartLine(), 1));
                        break;
                    }
                    case AFTER: {
                        f.lineEndsIn(SourceSectionFilter.IndexRange.byLength(location.getEndLine(), 1));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(suspendAnchor.name());
                    }
                }
                f.sourceIs(location.getSource());
            }
            BreakpointLocation.setTags(f, this.sourceElements);
            return f.build();
        }

        public String toString() {
            Object keyDescription = this.key == null ? "AlwaysHalt" : (this.key instanceof Source ? "sourceName=" + ((Source)this.key).getName() : (this.key instanceof URI ? "uri=" + ((URI)this.key).toString() : this.key.toString()));
            return (String)keyDescription + ", line=" + this.line + ", column=" + this.column;
        }
    }

    private static final class BreakpointFilteredLocation
    extends BreakpointLocation {
        private final SuspensionFilter filter;

        BreakpointFilteredLocation(SourceElement[] sourceElements, SuspensionFilter filter2) {
            super(sourceElements);
            this.filter = filter2;
        }

        @Override
        boolean isLoadBindingNeeded() {
            return false;
        }

        @Override
        LocationFilters createLocationFilters(SuspendAnchor suspendAnchor) {
            SourceSectionFilter.Builder f = SourceSectionFilter.newBuilder();
            SourceFilter.Builder sourceFilterBuilder = SourceFilter.newBuilder();
            if (this.filter != null) {
                Predicate<Source> sourcePredicate = this.filter.getSourcePredicate();
                if (sourcePredicate != null) {
                    sourceFilterBuilder.sourceIs(sourcePredicate);
                }
                sourceFilterBuilder.includeInternal(this.filter.isInternalIncluded());
            }
            SourceFilter sourceFilter = sourceFilterBuilder.build();
            f.sourceFilter(sourceFilter);
            BreakpointLocation.setTags(f, this.sourceElements);
            return new LocationFilters(f.build(), null);
        }

        @Override
        SourceSectionFilter createExecLocationFilter(SourceSection location, SuspendAnchor suspendAnchor) {
            return null;
        }
    }

    static final class LocationFilters {
        final SourceSectionFilter sectionFilter;
        final NearestSectionFilter nearestFilter;

        private LocationFilters(SourceSectionFilter sectionFilter, NearestSectionFilter nearestFilter) {
            this.sectionFilter = sectionFilter;
            this.nearestFilter = nearestFilter;
        }
    }
}

