/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.test;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.impl.HttpRequestHandlerUtil;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.HttpRequestPsiConverter;
import com.intellij.httpClient.http.request.authentication.AuthFlowLogEntry;
import com.intellij.httpClient.http.request.authentication.ReferencedSecret;
import com.intellij.httpClient.http.request.run.HttpRequestResponsePresentationHelper;
import com.intellij.httpClient.http.request.run.console.HttpResponseOutputAdapter;
import com.intellij.httpClient.http.request.run.test.HttpClientTestUtil;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u001a\u0014\u0010\u000f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\"+\u0010\u0000\u001a\u001f\u0012\u0016\u0012\u0014 \u0004*\t\u0018\u00010\u0002\u00a2\u0006\u0002\b\u00030\u0002\u00a2\u0006\u0002\b\u00030\u0001\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"authSuite", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "printAuthLogAsTests", "", "project", "Lcom/intellij/openapi/project/Project;", "printer", "Lcom/intellij/httpClient/http/request/run/console/HttpResponseOutputAdapter;", "log", "", "Lcom/intellij/httpClient/http/request/authentication/AuthFlowLogEntry;", "hideSecrets", "entry", "intellij.restClient"})
public final class HttpMultipleResponseAuthPrintingKt {
    @NotNull
    private static final Supplier<String> authSuite;

    public static final void printAuthLogAsTests(@NotNull Project project, @NotNull HttpResponseOutputAdapter printer2, @NotNull List<? extends AuthFlowLogEntry> log) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)printer2, (String)"printer");
        Intrinsics.checkNotNullParameter(log, (String)"log");
        HttpClientTestUtil.printSuiteStart(printer2, authSuite.get(), log.size());
        for (AuthFlowLogEntry authFlowLogEntry : log) {
            String id = null;
            id = "";
            AuthFlowLogEntry authFlowLogEntry2 = authFlowLogEntry;
            if (authFlowLogEntry2 instanceof AuthFlowLogEntry.Browser.BrowserDeclined) {
                String string = RestClientBundle.message("http.client.auth.log.browser.closed.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                id = string;
                printer2.printStart(id);
                printer2.print(id, ((AuthFlowLogEntry.Browser.BrowserDeclined)authFlowLogEntry).getConsiderError() ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT);
            } else if (authFlowLogEntry2 instanceof AuthFlowLogEntry.Browser.PageLoaded) {
                String string = RestClientBundle.message("http.client.auth.log.page.loaded.header", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                id = string;
                var8_8 = new Object[]{((AuthFlowLogEntry.Browser.PageLoaded)authFlowLogEntry).getCode(), ((AuthFlowLogEntry.Browser.PageLoaded)authFlowLogEntry).getUrl()};
                text = id + "\n" + RestClientBundle.message("http.client.auth.log.page.loaded.message", var8_8);
                printer2.printStart(id);
                printer2.print(HttpMultipleResponseAuthPrintingKt.hideSecrets((String)text, authFlowLogEntry), ConsoleViewContentType.NORMAL_OUTPUT);
            } else if (authFlowLogEntry2 instanceof AuthFlowLogEntry.Browser.PageLoading) {
                Object[] objectArray;
                if (((AuthFlowLogEntry.Browser.PageLoading)authFlowLogEntry).getRedirect()) {
                    text = RestClientBundle.message("http.client.auth.log.redirecting.header", new Object[0]);
                    Intrinsics.checkNotNull((Object)text);
                    objectArray = text;
                } else {
                    text = RestClientBundle.message("http.client.auth.log.opening.header", new Object[0]);
                    Intrinsics.checkNotNull((Object)text);
                    objectArray = text;
                }
                id = objectArray;
                var8_8 = new Object[]{((AuthFlowLogEntry.Browser.PageLoading)authFlowLogEntry).getUrl()};
                text = id + "\n" + RestClientBundle.message("http.client.auth.log.url.message", var8_8);
                printer2.printStart(id);
                printer2.print(HttpMultipleResponseAuthPrintingKt.hideSecrets((String)text, authFlowLogEntry), ConsoleViewContentType.NORMAL_OUTPUT);
            } else if (authFlowLogEntry2 instanceof AuthFlowLogEntry.Browser.PageLoadingFailed) {
                String string = RestClientBundle.message("http.client.auth.log.page.loading.error.header", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                id = string;
                Object[] $this$printAuthLogAsTests_u24lambda_u240 = var8_8 = new StringBuilder();
                boolean bl = false;
                String[] stringArray = new String[3];
                stringArray[0] = id;
                stringArray[1] = "\n";
                Object[] objectArray = new Object[]{((AuthFlowLogEntry.Browser.PageLoadingFailed)authFlowLogEntry).getUrl()};
                stringArray[2] = RestClientBundle.message("http.client.auth.log.url.message", objectArray);
                StringsKt.append((StringBuilder)$this$printAuthLogAsTests_u24lambda_u240, (String[])stringArray);
                if (((AuthFlowLogEntry.Browser.PageLoadingFailed)authFlowLogEntry).getCause() != null) {
                    stringArray = new String[2];
                    stringArray[0] = "\n";
                    objectArray = new Object[]{((AuthFlowLogEntry.Browser.PageLoadingFailed)authFlowLogEntry).getCause()};
                    stringArray[1] = RestClientBundle.message("http.client.auth.log.error", objectArray);
                    StringsKt.append((StringBuilder)$this$printAuthLogAsTests_u24lambda_u240, (String[])stringArray);
                }
                Intrinsics.checkNotNullExpressionValue((Object)var8_8.toString(), (String)"toString(...)");
                printer2.printStart(id);
                printer2.print(HttpMultipleResponseAuthPrintingKt.hideSecrets((String)text, authFlowLogEntry), ConsoleViewContentType.ERROR_OUTPUT);
            } else if (authFlowLogEntry2 instanceof AuthFlowLogEntry.Browser.RedirectHandled) {
                String string = RestClientBundle.message("http.client.auth.log.redirect.header", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                id = string;
                var8_8 = new Object[]{((AuthFlowLogEntry.Browser.RedirectHandled)authFlowLogEntry).getRedirectUrl()};
                text = id + "\n" + RestClientBundle.message("http.client.auth.log.url.message", var8_8);
                printer2.printStart(id);
                printer2.print(HttpMultipleResponseAuthPrintingKt.hideSecrets((String)text, authFlowLogEntry), ConsoleViewContentType.NORMAL_OUTPUT);
            } else if (authFlowLogEntry2 instanceof AuthFlowLogEntry.Log.Error) {
                String string = RestClientBundle.message("http.client.auth.log.just.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                id = string;
                printer2.printStart(id);
                text = new Object[]{((AuthFlowLogEntry.Log.Error)authFlowLogEntry).getText()};
                printer2.print(RestClientBundle.message("http.client.auth.log.error", text), ConsoleViewContentType.ERROR_OUTPUT);
            } else if (authFlowLogEntry2 instanceof AuthFlowLogEntry.Log.Stage) {
                id = ((AuthFlowLogEntry.Log.Stage)authFlowLogEntry).getTitle();
                printer2.printStart(id);
                printer2.print(id, ConsoleViewContentType.NORMAL_OUTPUT);
            } else if (authFlowLogEntry2 instanceof AuthFlowLogEntry.Request.RequestSent) {
                String string = RestClientBundle.message("http.client.auth.log.request.sent.header", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                id = string;
                Intrinsics.checkNotNullExpressionValue((Object)HttpRequestPsiConverter.toPsiHttpRequest(((AuthFlowLogEntry.Request.RequestSent)authFlowLogEntry).getRequest()), (String)"toPsiHttpRequest(...)");
                HttpRequestFileType httpRequestFileType = HttpRequestFileType.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)httpRequestFileType), (String)"INSTANCE");
                String formattedRequest = HttpRequestResponsePresentationHelper.getFormattedFileSync(project, (FileType)httpRequestFileType, (String)requestText).getText();
                printer2.printStart(id);
                Intrinsics.checkNotNull((Object)formattedRequest);
                printer2.print(HttpMultipleResponseAuthPrintingKt.hideSecrets(formattedRequest, authFlowLogEntry), ConsoleViewContentType.SYSTEM_OUTPUT);
            } else if (authFlowLogEntry2 instanceof AuthFlowLogEntry.Request.ResponseReceived) {
                String string = RestClientBundle.message("http.client.auth.log.response.received.short.header", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                id = string;
                printer2.printStart(id);
                requestText = new Object[]{((AuthFlowLogEntry.Request.ResponseReceived)authFlowLogEntry).getStatus()};
                printer2.print(RestClientBundle.message("http.client.auth.log.response.received.long.header", requestText) + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
                if (HttpRequestHandlerUtil.isJsonMimeType(((AuthFlowLogEntry.Request.ResponseReceived)authFlowLogEntry).getMimeType())) {
                    JsonFileType jsonFileType = JsonFileType.INSTANCE;
                    Intrinsics.checkNotNullExpressionValue((Object)jsonFileType, (String)"INSTANCE");
                    text = HttpRequestResponsePresentationHelper.getFormattedFileSync(project, (FileType)jsonFileType, ((AuthFlowLogEntry.Request.ResponseReceived)authFlowLogEntry).getResponse()).getText();
                    Intrinsics.checkNotNull((Object)text);
                    printer2.print(HttpMultipleResponseAuthPrintingKt.hideSecrets((String)text, authFlowLogEntry), ConsoleViewContentType.SYSTEM_OUTPUT);
                } else {
                    printer2.print(HttpMultipleResponseAuthPrintingKt.hideSecrets(((AuthFlowLogEntry.Request.ResponseReceived)authFlowLogEntry).getResponse(), authFlowLogEntry), ConsoleViewContentType.SYSTEM_OUTPUT);
                }
            }
            printer2.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            printer2.printEnd(id, 0L);
        }
        HttpClientTestUtil.printSuiteEnd(printer2, authSuite.get());
    }

    private static final String hideSecrets(String $this$hideSecrets, AuthFlowLogEntry entry) {
        if (entry.getSecrets().isEmpty()) {
            return $this$hideSecrets;
        }
        StringBuilder buffer = new StringBuilder($this$hideSecrets);
        for (ReferencedSecret referencedSecret : entry.getSecrets()) {
            String name = referencedSecret.component1();
            String value2 = referencedSecret.component2();
            if (((CharSequence)value2).length() == 0) continue;
            int index = 0;
            do {
                if ((index = buffer.indexOf(value2, index)) == -1) continue;
                String replacement = "**" + name + "**";
                buffer.replace(index, index + value2.length(), replacement);
                index += replacement.length();
            } while (index != -1);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        Supplier<String> supplier = RestClientBundle.messagePointer("http.client.auth.auth.tests.section.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        authSuite = supplier;
    }
}

