/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.console;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.httpClient.execution.common.CommonClientResponseBody;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpRequestResponseFileResult;
import com.intellij.httpClient.http.request.run.console.HttpClientMessagePrinter;
import com.intellij.httpClient.http.request.run.console.HttpResponseConsoleBottomComponent;
import com.intellij.httpClient.http.request.run.console.HttpSucceedResponsePresentation;
import com.intellij.httpClient.http.request.run.console.presentations.inPlace.HttpInplaceImageResponsePresentation;
import com.intellij.httpClient.http.request.run.console.presentations.inPlace.HttpInplacePdfResponsePresentation;
import com.intellij.httpClient.http.request.run.console.presentations.inPlace.HttpInplacePdfResponsePresentationKt;
import com.intellij.httpClient.http.request.run.console.presentations.inPlace.HttpInplaceStreamingResponsePresentation;
import com.intellij.httpClient.http.request.run.console.presentations.inPlace.HttpInplaceSucceedResponsePresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpResponsePresentation {
    protected static final Logger LOG = Logger.getInstance(HttpResponsePresentation.class);
    public static final HttpResponseFoldingModelFactory.PlainFoldingModel.Id HEADERS_ID = new HttpResponseFoldingModelFactory.PlainFoldingModel.Id();

    public abstract boolean canBeReformatted();

    public boolean previewCanBeOpened() {
        return false;
    }

    public boolean canBeCopied() {
        return false;
    }

    public abstract long getExecutionTime();

    @Nullable
    public String getStringToCopy(@NotNull Project project, @Nullable FileType fileType) {
        if (project == null) {
            HttpResponsePresentation.$$$reportNull$$$0(0);
        }
        return null;
    }

    public boolean isEmpty() {
        return false;
    }

    public abstract void print(@NotNull Project var1, @NotNull HttpClientMessagePrinter var2, @Nullable HttpRequestResponseFileResult var3, @NotNull FileType var4, @NotNull Predicate<? super FileType> var5, @Nullable HttpResponseFoldingModelFactory var6, @Nullable Runnable var7);

    @RequiresEdt
    @Nullable
    public HttpResponseConsoleBottomComponent provideResponseViewBottomComponent(@NotNull Project project) {
        if (project == null) {
            HttpResponsePresentation.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.assertEventDispatchThread();
        return null;
    }

    @NotNull
    public static HttpResponsePresentation createErrorResponse(@NotNull String text2) {
        if (text2 == null) {
            HttpResponsePresentation.$$$reportNull$$$0(2);
        }
        return new HttpErrorResponsePresentation(text2);
    }

    @NotNull
    public static HttpResponsePresentation createResponse(@NotNull CommonClientResponse response2, @NotNull SmartPsiElementPointer<HttpRequest> request2, boolean inplace, boolean withCookieJar) {
        if (response2 == null) {
            HttpResponsePresentation.$$$reportNull$$$0(3);
        }
        if (request2 == null) {
            HttpResponsePresentation.$$$reportNull$$$0(4);
        }
        if (inplace) {
            if (HttpInplaceImageResponsePresentation.isImage(response2.getBody())) {
                return new HttpInplaceImageResponsePresentation(response2, request2, withCookieJar);
            }
            if (HttpInplacePdfResponsePresentationKt.isPdf(response2.getBody())) {
                return new HttpInplacePdfResponsePresentation(response2, request2, withCookieJar);
            }
            if (response2.getBody() instanceof CommonClientResponseBody.Text) {
                return new HttpInplaceSucceedResponsePresentation(response2, request2, withCookieJar);
            }
            if (response2.getBody() instanceof CommonClientResponseBody.TextStream) {
                return new HttpInplaceStreamingResponsePresentation(response2, request2, withCookieJar);
            }
        }
        return new HttpSucceedResponsePresentation(response2, request2, withCookieJar);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpResponsePresentation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStringToCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "provideResponseViewBottomComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createErrorResponse";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createResponse";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class HttpErrorResponsePresentation
    extends HttpResponsePresentation {
        private final String myText;

        private HttpErrorResponsePresentation(@NotNull String text2) {
            if (text2 == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(0);
            }
            this.myText = text2;
        }

        @Override
        public boolean canBeReformatted() {
            return false;
        }

        @Override
        public long getExecutionTime() {
            return 0L;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void print(@NotNull Project project, @NotNull HttpClientMessagePrinter printer2, @Nullable HttpRequestResponseFileResult pathToResponse, @NotNull FileType fileType, @NotNull Predicate<? super FileType> isValid, @Nullable HttpResponseFoldingModelFactory responseFoldingModelProvider, @Nullable Runnable onFinishPrinting) {
            if (project == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(1);
            }
            if (printer2 == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(2);
            }
            if (fileType == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(3);
            }
            if (isValid == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(4);
            }
            printer2.print(this.myText, ConsoleViewContentType.ERROR_OUTPUT);
            if (onFinishPrinting != null) {
                onFinishPrinting.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isValid";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpResponsePresentation$HttpErrorResponsePresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface HttpResponseFoldingModelFactory {
        public FileFoldingModel createFileModel();

        public PlainFoldingModel createPlainModel();

        public static interface PlainFoldingModel {
            public static final Key<Id> ID_KEY = Key.create((String)"http.response.presentation.folding.id");

            public void addFoldingForRelativeRange(@NotNull TextRange var1, @NotNull String var2, @Nullable Id var3, boolean var4);

            public static class Id {
            }
        }

        public static interface FileFoldingModel {
            public void addFoldingsForFile(@NotNull PsiFile var1);
        }
    }
}

