/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.config;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.httpClient.http.request.HttpRequestNameSupport;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunType;
import com.intellij.httpClient.http.request.run.config.RequestPresentation;
import com.intellij.httpClient.http.request.run.config.RunConfigurationRequestService;
import com.intellij.httpClient.http.request.structure.StructureHelperKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0002\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"REQUEST_PRESENTATION", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/httpClient/http/request/run/config/RequestPresentation;", "addRequestPresentationToNode", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "configurationSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "content", "Lcom/intellij/ui/content/Content;", "requestPresentation", "findRequest", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "node", "Lcom/intellij/execution/dashboard/RunDashboardRunConfigurationNode;", "getRequestName", "", "request", "getRequestPresentation", "configuration", "Lcom/intellij/httpClient/http/request/run/config/HttpRequestRunConfiguration;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpRequestRunDashboardCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestRunDashboardCustomizer.kt\ncom/intellij/httpClient/http/request/run/config/HttpRequestRunDashboardCustomizerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
public final class HttpRequestRunDashboardCustomizerKt {
    @NotNull
    private static final Key<RequestPresentation> REQUEST_PRESENTATION;

    private static final HttpRequest findRequest(RunDashboardRunConfigurationNode node) {
        Object object = node.getConfigurationSettings().getConfiguration();
        HttpRequestRunConfiguration httpRequestRunConfiguration = object instanceof HttpRequestRunConfiguration ? (HttpRequestRunConfiguration)((Object)object) : null;
        if (httpRequestRunConfiguration == null) {
            return null;
        }
        HttpRequestRunConfiguration configuration = httpRequestRunConfiguration;
        if (configuration.getSettings().getRunType() != HttpRequestRunType.SINGLE_REQUEST) {
            return null;
        }
        PsiFile psiFile = HttpRequestRunConfiguration.findFileByPath(node.getProject(), configuration.getSettings().getFilePath());
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)HttpRequestRunConfiguration.findRequestInFile(file, configuration.getSettings()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (HttpRequest)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static final void addRequestPresentationToNode(PresentationData presentation2, RunnerAndConfigurationSettings configurationSettings, Content content2, RequestPresentation requestPresentation) {
        Project project = configurationSettings.getConfiguration().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        SimpleTextAttributes attributes = !RunManager.Companion.getInstance(project).hasSettings(configurationSettings) ? SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES : (content2 != null ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation2.clearText();
        presentation2.addText(requestPresentation.getName(), attributes);
        presentation2.setIcon(requestPresentation.getIcon());
    }

    private static final RequestPresentation getRequestPresentation(HttpRequestRunConfiguration configuration) {
        Object[] objectArray = new Object[]{RunConfigurationRequestService.class, configuration};
        NonBlockingReadAction nonBlockingReadAction = ReadAction.nonBlocking(() -> HttpRequestRunDashboardCustomizerKt.getRequestPresentation$lambda$2(configuration)).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> HttpRequestRunDashboardCustomizerKt.getRequestPresentation$lambda$3(configuration, arg_0)).coalesceBy(objectArray);
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        nonBlockingReadAction.expireWith((Disposable)RunConfigurationRequestService.Companion.getInstance(project)).submit((Executor)NonUrgentExecutor.getInstance());
        return (RequestPresentation)configuration.getUserData(REQUEST_PRESENTATION);
    }

    private static final String getRequestName(HttpRequest request2) {
        return FileUtil.getNameWithoutExtension((String)request2.getContainingFile().getName()) + "  |  " + HttpRequestNameSupport.getUniqueName(request2);
    }

    private static final RequestPresentation getRequestPresentation$lambda$2(HttpRequestRunConfiguration $configuration) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)$configuration), (String)"$configuration");
        PsiFile psiFile = HttpRequestRunConfiguration.findFileByPath($configuration.getProject(), $configuration.getSettings().getFilePath());
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)HttpRequestRunConfiguration.findRequestInFile(file, $configuration.getSettings()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        HttpRequest httpRequest = (HttpRequest)(Result.isFailure-impl((Object)object) ? null : object);
        if (httpRequest == null) {
            return null;
        }
        HttpRequest request2 = httpRequest;
        String name = HttpRequestRunDashboardCustomizerKt.getRequestName(request2);
        Icon icon = StructureHelperKt.provideIcon(request2);
        return new RequestPresentation(name, icon);
    }

    private static final void getRequestPresentation$lambda$3(HttpRequestRunConfiguration $configuration, RequestPresentation it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$configuration), (String)"$configuration");
        RequestPresentation oldName = (RequestPresentation)$configuration.getUserData(REQUEST_PRESENTATION);
        if (!Intrinsics.areEqual((Object)oldName, (Object)it)) {
            $configuration.putUserData(REQUEST_PRESENTATION, it);
            MessageBus messageBus = $configuration.getProject().getMessageBus();
            Topic topic = RunDashboardManager.DASHBOARD_TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DASHBOARD_TOPIC");
            ((RunDashboardListener)messageBus.syncPublisher(topic)).configurationChanged((RunConfiguration)$configuration, false);
        }
    }

    public static final /* synthetic */ RequestPresentation access$getRequestPresentation(HttpRequestRunConfiguration configuration) {
        return HttpRequestRunDashboardCustomizerKt.getRequestPresentation(configuration);
    }

    public static final /* synthetic */ void access$addRequestPresentationToNode(PresentationData presentation2, RunnerAndConfigurationSettings configurationSettings, Content content2, RequestPresentation requestPresentation) {
        HttpRequestRunDashboardCustomizerKt.addRequestPresentationToNode(presentation2, configurationSettings, content2, requestPresentation);
    }

    public static final /* synthetic */ HttpRequest access$findRequest(RunDashboardRunConfigurationNode node) {
        return HttpRequestRunDashboardCustomizerKt.findRequest(node);
    }

    static {
        Key key2 = Key.create((String)"HttpRequestPresentation");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        REQUEST_PRESENTATION = key2;
    }
}

