/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.psi.references;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironmentFileNames;
import com.intellij.httpClient.http.request.psi.references.JsonConverter;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\"\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u00052\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\f"}, d2={"convertToJson", "Lcom/fasterxml/jackson/databind/JsonNode;", "jsonObject", "Lcom/intellij/json/psi/JsonObject;", "getHttpClientVariablesFromFile", "", "", "", "file", "Lcom/intellij/psi/PsiFile;", "readTreeSafe", "value", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientJsonPsiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientJsonPsiUtil.kt\ncom/intellij/httpClient/http/request/psi/references/HttpClientJsonPsiUtilKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n14#2:107\n14#2:108\n14#2:119\n1603#3,9:109\n1855#3:118\n1856#3:121\n1612#3:122\n1#4:120\n*S KotlinDebug\n*F\n+ 1 HttpClientJsonPsiUtil.kt\ncom/intellij/httpClient/http/request/psi/references/HttpClientJsonPsiUtilKt\n*L\n80#1:107\n82#1:108\n88#1:119\n84#1:109,9\n84#1:118\n84#1:121\n84#1:122\n84#1:120\n*E\n"})
public final class HttpClientJsonPsiUtilKt {
    @NotNull
    public static final JsonNode convertToJson(@NotNull JsonObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        JsonNode tree = HttpClientJsonPsiUtilKt.readTreeSafe(jsonObject.getText());
        if (tree != null) {
            return tree;
        }
        return new JsonConverter(jsonObject).convert();
    }

    private static final JsonNode readTreeSafe(String value2) {
        JsonNode jsonNode;
        if (value2 == null) {
            return null;
        }
        try {
            jsonNode = new ObjectMapper().readTree(value2);
        }
        catch (Exception e) {
            jsonNode = null;
        }
        return jsonNode;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Set<String>> getHttpClientVariablesFromFile(@NotNull PsiFile file) {
        void $this$mapNotNullTo$iv$iv;
        JsonFile jsonFile;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiFile $this$asSafely$iv = file;
        boolean $i$f$asSafely = false;
        PsiFile psiFile = $this$asSafely$iv;
        if (!(psiFile instanceof JsonFile)) {
            psiFile = null;
        }
        JsonFile jsonFile2 = jsonFile = (JsonFile)psiFile;
        JsonValue $this$asSafely$iv2 = jsonFile2 != null ? jsonFile2.getTopLevelValue() : null;
        boolean $i$f$asSafely22 = false;
        JsonValue jsonValue = $this$asSafely$iv2;
        if (!(jsonValue instanceof JsonObject)) {
            jsonValue = null;
        }
        JsonObject jsonObject = (JsonObject)jsonValue;
        if (jsonObject == null) {
            return MapsKt.emptyMap();
        }
        JsonObject root = jsonObject;
        List list2 = root.getPropertyList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPropertyList(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$asSafely22 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JsonProperty jsonProperty = (JsonProperty)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)jsonProperty.getName(), (String)"getName(...)");
            Set completions = new LinkedHashSet();
            JsonValue $this$asSafely$iv3 = jsonProperty.getValue();
            boolean $i$f$asSafely3 = false;
            JsonValue jsonValue2 = $this$asSafely$iv3;
            if (!(jsonValue2 instanceof JsonObject)) {
                jsonValue2 = null;
            }
            if ((JsonObject)jsonValue2 == null) {
                pair = null;
            } else {
                String envName;
                JsonObject value2;
                value2.accept((PsiElementVisitor)new JsonRecursiveElementVisitor(file, completions){
                    final /* synthetic */ PsiFile $file;
                    final /* synthetic */ Set<String> $completions;
                    {
                        this.$file = $file;
                        this.$completions = $completions;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public void visitProperty(@NotNull JsonProperty o) {
                        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                        super.visitProperty(o);
                        v0 = o.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getName(...)");
                        propertyName = v0;
                        if (!Intrinsics.areEqual((Object)"SSLConfiguration", (Object)propertyName)) ** GOTO lbl-1000
                        Intrinsics.checkNotNullExpressionValue((Object)HttpRequestEnvironmentFileNames.ENV_PRIVATE_FILE_NAMES, (String)"ENV_PRIVATE_FILE_NAMES");
                        if (ArraysKt.contains((Object[])HttpRequestEnvironmentFileNames.ENV_PRIVATE_FILE_NAMES, (Object)this.$file.getName())) {
                            v1 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = isSSL = false;
                        }
                        if (!StringsKt.isBlank((CharSequence)propertyName) && !isSSL) {
                            this.$completions.add(propertyName);
                        }
                    }
                });
                pair = TuplesKt.to((Object)envName, (Object)completions);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }
}

