/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.httpClient.http.request.HttpRequestExecutionEnvironment;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutionKey;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutorImpl;
import com.intellij.httpClient.http.request.SubstitutionVariableInfo;
import com.intellij.httpClient.http.request.SubstitutionVariableValue;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestCompositeElement;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.httpClient.http.request.variables.HttpVariableOrigin;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00150\u0017H\u0016J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J0\u0010\u001c\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0016\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020\bH\u0002J\r\u0010$\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010%J \u0010&\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00150\u0017H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010#\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/httpClient/http/request/HttpRequestListVariableSubstitutor;", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;", "parentSubstitutor", "plainValuesMap", "", "", "Lcom/intellij/httpClient/http/request/SubstitutionVariableInfo;", "iterationNumber", "", "(Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;Ljava/util/Map;I)V", "getParentSubstitutor", "()Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;", "copyWithNewParent", "getAllEnvVariables", "", "Lcom/intellij/httpClient/http/request/HttpRequestExecutionEnvironment$VariableInfo;", "getListSubstitutors", "request", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "getValue", "element", "Lcom/intellij/psi/PsiElement;", "filter", "Lcom/intellij/openapi/util/Condition;", "getVariable", "name", "project", "Lcom/intellij/openapi/project/Project;", "getVariableValue", "defaultValue", "key", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutionKey;", "getVariableValueWithIndex", "Lcom/intellij/httpClient/http/request/SubstitutionVariableValue;", "httpVariableValue", "number", "iteration", "()Ljava/lang/Integer;", "processComposite", "templateValue", "", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nHttpRequestListVariableSubstitutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestListVariableSubstitutor.kt\ncom/intellij/httpClient/http/request/HttpRequestListVariableSubstitutor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n14#2:119\n766#3:120\n857#3,2:121\n1603#3,9:123\n1855#3:132\n1856#3:134\n1612#3:135\n288#3,2:136\n1#4:133\n1#4:138\n*S KotlinDebug\n*F\n+ 1 HttpRequestListVariableSubstitutor.kt\ncom/intellij/httpClient/http/request/HttpRequestListVariableSubstitutor\n*L\n41#1:119\n43#1:120\n43#1:121,2\n44#1:123,9\n44#1:132\n44#1:134\n44#1:135\n68#1:136,2\n44#1:133\n*E\n"})
public final class HttpRequestListVariableSubstitutor
implements HttpRequestVariableSubstitutor {
    @NotNull
    private final HttpRequestVariableSubstitutor parentSubstitutor;
    @NotNull
    private final Map<String, SubstitutionVariableInfo> plainValuesMap;
    private final int iterationNumber;

    public HttpRequestListVariableSubstitutor(@NotNull HttpRequestVariableSubstitutor parentSubstitutor, @NotNull Map<String, SubstitutionVariableInfo> plainValuesMap, int iterationNumber) {
        Intrinsics.checkNotNullParameter((Object)parentSubstitutor, (String)"parentSubstitutor");
        Intrinsics.checkNotNullParameter(plainValuesMap, (String)"plainValuesMap");
        this.parentSubstitutor = parentSubstitutor;
        this.plainValuesMap = plainValuesMap;
        this.iterationNumber = iterationNumber;
    }

    @NotNull
    public final HttpRequestVariableSubstitutor getParentSubstitutor() {
        return this.parentSubstitutor;
    }

    @Override
    @NotNull
    public String getValue(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Condition condition = Conditions.alwaysTrue();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"alwaysTrue(...)");
        return this.getValue(element, (Condition<? super PsiElement>)condition);
    }

    @Override
    @NotNull
    public String getValue(@NotNull PsiElement element, @NotNull Condition<? super PsiElement> filter2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        if (element instanceof HttpVariable) {
            String string = ((HttpVariable)element).getName();
            Project project = ((HttpVariable)element).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            String variable2 = this.getVariableValue(string, null, project, null);
            String string2 = variable2;
            if (string2 == null) {
                String string3 = this.parentSubstitutor.getValue(element, filter2);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
            }
            return string2;
        }
        if (element instanceof HttpRequestCompositeElement) {
            return this.processComposite(element, filter2);
        }
        String string = this.parentSubstitutor.getValue(element, filter2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        return string;
    }

    @NotNull
    public final HttpRequestListVariableSubstitutor copyWithNewParent(@NotNull HttpRequestVariableSubstitutor parentSubstitutor) {
        Intrinsics.checkNotNullParameter((Object)parentSubstitutor, (String)"parentSubstitutor");
        return new HttpRequestListVariableSubstitutor(parentSubstitutor, this.plainValuesMap, this.iterationNumber);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<HttpRequestExecutionEnvironment.VariableInfo> getAllEnvVariables() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        List list2;
        Object object;
        HttpRequestVariableSubstitutor $this$asSafely$iv = this.parentSubstitutor;
        boolean $i$f$asSafely22 = false;
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = $this$asSafely$iv;
        if (!(httpRequestVariableSubstitutor instanceof HttpRequestVariableSubstitutorImpl)) {
            httpRequestVariableSubstitutor = null;
        }
        if (((object = (HttpRequestVariableSubstitutorImpl)httpRequestVariableSubstitutor) != null && (object = ((HttpRequestVariableSubstitutorImpl)object).getEnvironment()) != null ? ((HttpRequestEnvironment)object).getAllVariables() : (list2 = null)) == null) {
            list2 = CollectionsKt.emptyList();
        }
        List parentVars = list2;
        Iterable $this$filter$iv = this.plainValuesMap.entrySet();
        boolean $i$f$filter = false;
        Iterable $i$f$asSafely22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(((SubstitutionVariableInfo)it.getValue()).getVariableOrigin() == HttpVariableOrigin.PRIVATE_ENV)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            HttpRequestExecutionEnvironment.VariableInfo it$iv$iv;
            String value2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            if ((((SubstitutionVariableInfo)entry.getValue()).getVariableValue() == null ? null : new HttpRequestExecutionEnvironment.VariableInfo((String)entry.getKey(), value2, true)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List privateVars = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)parentVars, (Iterable)privateVars);
    }

    @Override
    @NotNull
    public Integer iteration() {
        return this.iterationNumber;
    }

    @Override
    @Nullable
    public Object templateValue(int number) {
        String string = this.httpVariableValue(number);
        if (string == null) {
            return null;
        }
        String current = string;
        Integer asInt = StringsKt.toIntOrNull((String)current);
        if (asInt != null) {
            return asInt;
        }
        Boolean asBoolean = StringsKt.toBooleanStrictOrNull((String)current);
        if (asBoolean != null) {
            return asBoolean;
        }
        return current;
    }

    private final String httpVariableValue(int number) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.plainValuesMap.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SubstitutionVariableInfo it = (SubstitutionVariableInfo)element$iv;
                boolean bl = false;
                if (!(it.getVariableNameInfo().getGapNumber() == number)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        SubstitutionVariableInfo substitutionVariableInfo = v0;
        return substitutionVariableInfo != null ? substitutionVariableInfo.getVariableValue() : null;
    }

    private final String processComposite(PsiElement element, Condition<? super PsiElement> filter2) {
        StringBuilder builder2 = new StringBuilder();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof HttpVariable) {
                String string = ((HttpVariable)child).getName();
                Project project = ((HttpVariable)child).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                builder2.append(this.getVariable(string, project));
                continue;
            }
            if (!filter2.value((Object)child)) continue;
            builder2.append(child.getText());
        }
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getVariable(String name, Project project) {
        String string;
        String string2 = name;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = "{{" + name + "}}";
        } else {
            string = null;
        }
        String defaultValue = string;
        return this.getVariableValue(name, defaultValue, project, null);
    }

    @Override
    @Nullable
    public String getVariableValue(@Nullable String name, @Nullable String defaultValue, @NotNull Project project, @Nullable HttpRequestVariableSubstitutionKey key2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (name == null) {
            return null;
        }
        SubstitutionVariableValue variable2 = this.getVariableValueWithIndex(name, project);
        String string = variable2.getValue();
        if (string == null) {
            string = defaultValue;
        }
        return string;
    }

    @NotNull
    public final SubstitutionVariableValue getVariableValueWithIndex(@NotNull String name, @NotNull Project project) {
        SubstitutionVariableValue substitutionVariableValue;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!this.plainValuesMap.containsKey(name)) {
            String value2 = this.parentSubstitutor.getVariableValue(name, null, project, null);
            substitutionVariableValue = new SubstitutionVariableValue(value2, null);
        } else {
            SubstitutionVariableInfo substitutionVariableInfo = this.plainValuesMap.get(name);
            substitutionVariableValue = new SubstitutionVariableValue(substitutionVariableInfo != null ? substitutionVariableInfo.getVariableValue() : null, this.iterationNumber);
        }
        return substitutionVariableValue;
    }

    @Override
    @NotNull
    public List<HttpRequestVariableSubstitutor> getListSubstitutors(@NotNull HttpRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return CollectionsKt.listOf((Object)this);
    }
}

