/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.generation;

import com.intellij.httpClient.actions.generation.RequestBody;
import com.intellij.microservices.oas.OasComponents;
import com.intellij.microservices.oas.OasEndpointPath;
import com.intellij.microservices.oas.OasOperation;
import com.intellij.microservices.oas.OasSchema;
import com.intellij.microservices.oas.OasSchemaType;
import com.intellij.microservices.oas.OasSpecificationProvider;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.microservices.oas.serialization.OasSerializationUtilsKt;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathContextKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a$\u0010\u0010\u001a\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u001a$\u0010\u0013\u001a\u00020\u00012\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0002\u001a$\u0010\u0016\u001a\u0004\u0018\u00010\b*\u00020\b2\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b\u0018\u00010\u0018H\u0002\u001a$\u0010\u0019\u001a\u0004\u0018\u00010\b*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u001b"}, d2={"computeContextFromOas", "Lcom/intellij/httpClient/actions/generation/RequestBody;", "urlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "knownContentTypes", "", "", "computeJsonBodySchemaOrNull", "Lcom/intellij/microservices/oas/OasSchema;", "oas", "Lcom/intellij/microservices/oas/OpenApiSpecification;", "computeRequestBodyFor", "project", "Lcom/intellij/openapi/project/Project;", "urlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "computeRequestContextForUrlTargetInfos", "resolvedTargets", "contentTypesFromOas", "requestContextData", "contentTypes", "jsonBody", "getIndependentBodySchema", "components", "", "getSchemaByReference", "reference", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nRequestBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestBody.kt\ncom/intellij/httpClient/actions/generation/RequestBodyKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n179#2,2:106\n1747#3,3:108\n*S KotlinDebug\n*F\n+ 1 RequestBody.kt\ncom/intellij/httpClient/actions/generation/RequestBodyKt\n*L\n39#1:106,2\n60#1:108,3\n*E\n"})
public final class RequestBodyKt {
    @RequiresReadLock
    @NotNull
    public static final RequestBody computeRequestBodyFor(@NotNull UrlTargetInfo urlTargetInfo) {
        Intrinsics.checkNotNullParameter((Object)urlTargetInfo, (String)"urlTargetInfo");
        return RequestBodyKt.computeContextFromOas$default(urlTargetInfo, null, 2, null);
    }

    @RequiresReadLock
    @NotNull
    public static final RequestBody computeRequestBodyFor(@NotNull Project project, @NotNull UrlPathContext urlPathContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)urlPathContext, (String)"urlPathContext");
        Set resolvedTargets2 = UrlPathContextKt.resolveTargets((UrlPathContext)urlPathContext, (Project)project);
        return RequestBodyKt.computeRequestContextForUrlTargetInfos(resolvedTargets2, urlPathContext.getContentTypes());
    }

    private static final RequestBody computeRequestContextForUrlTargetInfos(Set<? extends UrlTargetInfo> resolvedTargets2, Set<String> knownContentTypes) {
        RequestBody requestBody;
        Object v0;
        block2: {
            Sequence requestContextData2;
            Sequence $this$firstOrNull$iv = requestContextData2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)resolvedTargets2), (Function1)((Function1)new Function1<UrlTargetInfo, RequestBody>(knownContentTypes){
                final /* synthetic */ Set<String> $knownContentTypes;
                {
                    this.$knownContentTypes = $knownContentTypes;
                    super(1);
                }

                @NotNull
                public final RequestBody invoke(@NotNull UrlTargetInfo it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return RequestBodyKt.access$computeContextFromOas(it, this.$knownContentTypes);
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RequestBody it = (RequestBody)element$iv;
                boolean bl = false;
                if (!(!(it instanceof RequestBody.Empty))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((requestBody = (RequestBody)v0) == null) {
            requestBody = RequestBodyKt.requestContextData$default(knownContentTypes, null, 2, null);
        }
        return requestBody;
    }

    private static final RequestBody computeContextFromOas(UrlTargetInfo urlTargetInfo, Set<String> knownContentTypes) {
        Set set2;
        OpenApiSpecification openApiSpecification = OasSpecificationProvider.Companion.getOasSpecification(urlTargetInfo);
        if (openApiSpecification == null) {
            return RequestBodyKt.requestContextData$default(knownContentTypes, null, 2, null);
        }
        OpenApiSpecification oas = openApiSpecification;
        OasSchema jsonBody = RequestBodyKt.computeJsonBodySchemaOrNull(oas);
        Set $this$computeContextFromOas_u24lambda_u241 = set2 = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$computeContextFromOas_u24lambda_u241.addAll(urlTargetInfo.getContentTypes());
        $this$computeContextFromOas_u24lambda_u241.addAll((Collection)knownContentTypes);
        $this$computeContextFromOas_u24lambda_u241.addAll((Collection)RequestBodyKt.contentTypesFromOas(oas));
        Set contentTypes = SetsKt.build((Set)set2);
        return RequestBodyKt.requestContextData(contentTypes, jsonBody);
    }

    static /* synthetic */ RequestBody computeContextFromOas$default(UrlTargetInfo urlTargetInfo, Set set2, int n, Object object) {
        if ((n & 2) != 0) {
            set2 = SetsKt.emptySet();
        }
        return RequestBodyKt.computeContextFromOas(urlTargetInfo, set2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final RequestBody requestContextData(Set<String> contentTypes, OasSchema jsonBody) {
        RequestBody requestBody;
        if (!((Collection)contentTypes).isEmpty() && jsonBody != null) {
            requestBody = new RequestBody.ContentTypesAndJsonRequestBody(contentTypes, jsonBody);
            return requestBody;
        }
        if (!((Collection)contentTypes).isEmpty()) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = contentTypes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)it, (Object)"*/*"))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                requestBody = new RequestBody.OnlyContentTypes(contentTypes);
                return requestBody;
            }
        }
        requestBody = RequestBody.Empty.INSTANCE;
        return requestBody;
    }

    static /* synthetic */ RequestBody requestContextData$default(Set set2, OasSchema oasSchema, int n, Object object) {
        if ((n & 1) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            oasSchema = null;
        }
        return RequestBodyKt.requestContextData(set2, oasSchema);
    }

    private static final Set<String> contentTypesFromOas(OpenApiSpecification oas) {
        Set contentTypes = new LinkedHashSet();
        for (OasEndpointPath path2 : oas.getPaths()) {
            for (OasOperation operation : path2.getOperations()) {
                Object object = operation.getRequestBody();
                if (object == null || (object = object.getContent()) == null || (object = object.keySet()) == null) continue;
                Object requestBodyContentTypes = object;
                contentTypes.addAll((Collection)requestBodyContentTypes);
            }
        }
        return contentTypes;
    }

    private static final OasSchema computeJsonBodySchemaOrNull(OpenApiSpecification oas) {
        String jsonContentType = "application/json";
        OasSchema oasSchema = OasSerializationUtilsKt.findSinglePathRequestBodyData((OpenApiSpecification)oas, (String)jsonContentType);
        if (oasSchema == null) {
            return null;
        }
        OasSchema requestBody = oasSchema;
        OasComponents oasComponents = oas.getComponents();
        return RequestBodyKt.getIndependentBodySchema(requestBody, oasComponents != null ? oasComponents.getSchemas() : null);
    }

    private static final OasSchema getIndependentBodySchema(OasSchema $this$getIndependentBodySchema, Map<String, OasSchema> components) {
        OasSchema oasSchema;
        OasSchemaType oasSchemaType = $this$getIndependentBodySchema.getType();
        switch (oasSchemaType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oasSchemaType.ordinal()]) {
            case 1: {
                OasSchema oasSchema2 = $this$getIndependentBodySchema.getItems();
                OasSchema itemSchema = oasSchema2 != null ? RequestBodyKt.getIndependentBodySchema(oasSchema2, components) : null;
                return new OasSchema($this$getIndependentBodySchema.getType(), $this$getIndependentBodySchema.getFormat(), $this$getIndependentBodySchema.getDefault(), itemSchema, null, null, null, $this$getIndependentBodySchema.getRequired(), false, 368, null);
            }
            case -1: {
                Map<String, OasSchema> map2 = components;
                if (map2 != null) {
                    oasSchema = RequestBodyKt.getSchemaByReference(map2, $this$getIndependentBodySchema.getReference());
                    break;
                }
                oasSchema = null;
                break;
            }
            default: {
                oasSchema = $this$getIndependentBodySchema;
            }
        }
        return oasSchema;
    }

    private static final OasSchema getSchemaByReference(Map<String, OasSchema> $this$getSchemaByReference, String reference) {
        String string = reference;
        if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null)) == null) {
            return null;
        }
        String schemaReference = string;
        return $this$getSchemaByReference.get(schemaReference);
    }

    public static final /* synthetic */ RequestBody access$computeContextFromOas(UrlTargetInfo urlTargetInfo, Set knownContentTypes) {
        return RequestBodyKt.computeContextFromOas(urlTargetInfo, knownContentTypes);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OasSchemaType.values().length];
            try {
                nArray[OasSchemaType.ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

