/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc.restClient.execution;

import com.intellij.grpc.GrpcBundle;
import com.intellij.grpc.requests.GrpcRequestManager;
import com.intellij.grpc.requests.RejectedRPCException;
import com.intellij.grpc.restClient.execution.GrpcRequest;
import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.httpClient.execution.common.RequestHandler;
import com.intellij.httpClient.execution.common.RunContext;
import java.net.ConnectException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/grpc/restClient/execution/GrpcRequestHandler;", "Lcom/intellij/httpClient/execution/common/RequestHandler;", "Lcom/intellij/grpc/restClient/execution/GrpcRequest;", "()V", "execute", "Lcom/intellij/httpClient/execution/common/CommonClientResponse;", "request", "runContext", "Lcom/intellij/httpClient/execution/common/RunContext;", "prepareExecutionEnvironment", "", "intellij.grpc"})
public final class GrpcRequestHandler
implements RequestHandler<GrpcRequest> {
    public void prepareExecutionEnvironment(@NotNull GrpcRequest request, @NotNull RunContext runContext) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
    }

    @NotNull
    public CommonClientResponse execute(@NotNull GrpcRequest request, @NotNull RunContext runContext) {
        CommonClientResponse commonClientResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
        try {
            Object object = runContext.getProject().getService(GrpcRequestManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            commonClientResponse = GrpcRequestManager.executeCallSynchronously$default((GrpcRequestManager)object, request, false, 2, null);
        }
        catch (Exception exception) {
            RejectedRPCException rejectedRPCException;
            Throwable cause = exception.getCause();
            if (exception instanceof RejectedRPCException) {
                rejectedRPCException = (RejectedRPCException)exception;
            } else if (exception instanceof ConnectException) {
                var7_6 = new Object[]{request.getAuthority()};
                RejectedRPCException rejectedRPCException2 = new RejectedRPCException(GrpcBundle.INSTANCE.message("connection.refused.0", var7_6), exception);
                rejectedRPCException = rejectedRPCException2;
            } else if (cause instanceof ConnectException) {
                var7_6 = new Object[]{request.getAuthority()};
                RejectedRPCException rejectedRPCException3 = new RejectedRPCException(GrpcBundle.INSTANCE.message("connection.refused.0", var7_6), cause);
                rejectedRPCException = rejectedRPCException3;
            } else if (cause != null) {
                var7_6 = new Object[1];
                String string = cause.getMessage();
                if (string == null) {
                    string = "";
                }
                var7_6[0] = string;
                RejectedRPCException rejectedRPCException4 = new RejectedRPCException(GrpcBundle.INSTANCE.message("request.ended.with.exception.0", var7_6), cause);
                rejectedRPCException = rejectedRPCException4;
            } else {
                var7_6 = new Object[1];
                String string = exception.getMessage();
                if (string == null) {
                    string = "";
                }
                var7_6[0] = string;
                RejectedRPCException rejectedRPCException5 = new RejectedRPCException(GrpcBundle.INSTANCE.message("request.ended.with.exception.0", var7_6), exception);
                rejectedRPCException = rejectedRPCException5;
            }
            RejectedRPCException effectiveExceptionToRethrow = rejectedRPCException;
            throw effectiveExceptionToRethrow;
        }
        return commonClientResponse;
    }
}

