/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.grpc.json.GrpcResolveUtils;
import com.intellij.grpc.json.mappings.GrpcArrayOf;
import com.intellij.grpc.json.mappings.GrpcEnum;
import com.intellij.grpc.json.mappings.GrpcJsonObject;
import com.intellij.grpc.json.mappings.GrpcJsonSchema;
import com.intellij.grpc.json.mappings.GrpcMapField;
import com.intellij.grpc.json.mappings.GrpcMessage;
import com.intellij.grpc.json.mappings.GrpcMessageBeingEvaluated;
import com.intellij.grpc.json.mappings.GrpcOneOf;
import com.intellij.grpc.json.mappings.GrpcOneOfCondition;
import com.intellij.grpc.json.mappings.GrpcPrimitive;
import com.intellij.grpc.json.mappings.GrpcReference;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.protobuf.lang.psi.PbEnumDefinition;
import com.intellij.protobuf.lang.psi.PbEnumValue;
import com.intellij.protobuf.lang.psi.PbFieldLabel;
import com.intellij.protobuf.lang.psi.PbMapField;
import com.intellij.protobuf.lang.psi.PbMessageBody;
import com.intellij.protobuf.lang.psi.PbMessageDefinition;
import com.intellij.protobuf.lang.psi.PbNumberValue;
import com.intellij.protobuf.lang.psi.PbOneofDefinition;
import com.intellij.protobuf.lang.psi.PbSimpleField;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 22\u00020\u0001:\u00012B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0003J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010(\u001a\u00020\u00162\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0*H\u0002J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000fH\u0002J\n\u0010/\u001a\u0004\u0018\u00010\u0003H\u0002J\f\u00100\u001a\u00020\u0003*\u000201H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/grpc/json/GrpcJsonSchemaBuilder;", "", "rootMessageFqn", "", "givenTopLevelBuilder", "(Ljava/lang/String;Lcom/intellij/grpc/json/GrpcJsonSchemaBuilder;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "schema", "Lcom/intellij/grpc/json/mappings/GrpcJsonSchema;", "topLevelBuilder", "addField", "field", "Lcom/intellij/protobuf/lang/psi/PbSimpleField;", "addMapField", "Lcom/intellij/protobuf/lang/psi/PbMapField;", "addOneOfField", "Lcom/intellij/protobuf/lang/psi/PbOneofDefinition;", "assembleSchema", "Lcom/intellij/grpc/json/mappings/GrpcMessage;", "build", "handleCyclicImports", "", "definitionFqn", "newMappingAction", "Lkotlin/Function0;", "handleTopLevelSchemaReference", "", "fieldMeta", "Lcom/intellij/grpc/json/GrpcJsonSchemaBuilder$Companion$ProtoFieldMeta;", "isPrimitive", "typeName", "isRepeated", "mapEnum", "enumDefinition", "Lcom/intellij/protobuf/lang/psi/PbEnumDefinition;", "mapMessage", "resolvedMessage", "Lcom/intellij/protobuf/lang/psi/PbMessageDefinition;", "mapMessageOrEnum", "mapOneOfField", "oneOfFields", "", "mapPrimitiveField", "processMapField", "valueFqn", "fieldName", "schemaTypeDependingOnLevel", "fqn", "Lcom/intellij/protobuf/lang/psi/PbTypeName;", "Companion", "intellij.grpc"})
@SourceDebugExtension(value={"SMAP\nGrpcJsonSchemaBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcJsonSchemaBuilder.kt\ncom/intellij/grpc/json/GrpcJsonSchemaBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 6 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,227:1\n1855#2,2:228\n1603#2,9:230\n1855#2:239\n1856#2:241\n1612#2:242\n1549#2:249\n1620#2,3:250\n1603#2,9:253\n1855#2:262\n1856#2:264\n1612#2:265\n1#3:240\n1#3:263\n37#4,2:243\n18#4:245\n37#4,2:266\n26#5:246\n14#6:247\n14#6:268\n23#7:248\n*S KotlinDebug\n*F\n+ 1 GrpcJsonSchemaBuilder.kt\ncom/intellij/grpc/json/GrpcJsonSchemaBuilder\n*L\n51#1:228,2\n58#1:230,9\n58#1:239\n58#1:241\n58#1:242\n149#1:249\n149#1:250,3\n149#1:253,9\n149#1:262\n149#1:264\n149#1:265\n58#1:240\n149#1:263\n59#1:243,2\n59#1:245\n149#1:266,2\n59#1:246\n83#1:247\n162#1:268\n107#1:248\n*E\n"})
public final class GrpcJsonSchemaBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rootMessageFqn;
    @NotNull
    private final GrpcJsonSchemaBuilder topLevelBuilder;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final GrpcJsonSchema schema;
    @NotNull
    private static final Map<String, String> primitiveTypeMappings;

    private GrpcJsonSchemaBuilder(String rootMessageFqn, GrpcJsonSchemaBuilder givenTopLevelBuilder) {
        this.rootMessageFqn = rootMessageFqn;
        GrpcJsonSchemaBuilder grpcJsonSchemaBuilder = givenTopLevelBuilder;
        if (grpcJsonSchemaBuilder == null) {
            grpcJsonSchemaBuilder = this;
        }
        this.topLevelBuilder = grpcJsonSchemaBuilder;
        this.objectMapper = new ObjectMapper(new JsonFactory());
        this.schema = new GrpcJsonSchema(this.schemaTypeDependingOnLevel());
    }

    private final String schemaTypeDependingOnLevel() {
        return Intrinsics.areEqual((Object)this.topLevelBuilder, (Object)this) ? null : "object";
    }

    private final GrpcMessage assembleSchema() {
        return this.schema;
    }

    @NotNull
    public final String build() {
        String string = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.schema);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final GrpcJsonSchemaBuilder addField(@NotNull PbSimpleField field) {
        GrpcJsonSchemaBuilder grpcJsonSchemaBuilder;
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        GrpcJsonSchemaBuilder it = grpcJsonSchemaBuilder = this;
        boolean bl = false;
        PbTypeName pbTypeName = field.getTypeName();
        Intrinsics.checkNotNullExpressionValue((Object)pbTypeName, (String)"getTypeName(...)");
        String typeFqn = this.fqn(pbTypeName);
        boolean repeated = this.isRepeated(field);
        String string = field.getName();
        if (string != null) {
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            String fieldName = string2;
            Companion.ProtoFieldMeta fieldMeta = new Companion.ProtoFieldMeta(field, fieldName, typeFqn, repeated);
            if (this.isPrimitive(typeFqn)) {
                this.mapPrimitiveField(fieldMeta);
            } else {
                this.mapMessageOrEnum(fieldMeta);
            }
        }
        return grpcJsonSchemaBuilder;
    }

    private final GrpcJsonSchemaBuilder addOneOfField(PbOneofDefinition field) {
        GrpcJsonSchemaBuilder grpcJsonSchemaBuilder;
        block1: {
            GrpcJsonSchemaBuilder it = grpcJsonSchemaBuilder = this;
            boolean bl = false;
            Object object = field.getBody();
            if (object == null || (object = object.getSimpleFieldList()) == null) break block1;
            Object $this$addOneOfField_u24lambda_u242_u24lambda_u241 = object;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)$this$addOneOfField_u24lambda_u242_u24lambda_u241);
            Iterable $this$forEach$iv = (Iterable)$this$addOneOfField_u24lambda_u242_u24lambda_u241;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PbSimpleField p0 = (PbSimpleField)element$iv;
                boolean bl3 = false;
                this.addField(p0);
            }
            this.mapOneOfField((List<? extends PbSimpleField>)$this$addOneOfField_u24lambda_u242_u24lambda_u241);
        }
        return grpcJsonSchemaBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private final void mapOneOfField(List<? extends PbSimpleField> oneOfFields) {
        GrpcOneOfCondition[] grpcOneOfConditionArray;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = oneOfFields;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PbSimpleField it = (PbSimpleField)element$iv$iv;
            boolean bl2 = false;
            if (it.getName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List variants = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        List<GrpcOneOfCondition> list = this.schema.getAllOf();
        if (list != null) {
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            grpcOneOfConditionArray = thisCollection$iv.toArray(new GrpcOneOfCondition[0]);
        } else {
            grpcOneOfConditionArray = null;
        }
        GrpcOneOfCondition[] $this$orEmpty$iv = grpcOneOfConditionArray;
        boolean $i$f$orEmpty = false;
        GrpcOneOfCondition[] grpcOneOfConditionArray2 = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            boolean $i$f$emptyArray = false;
            grpcOneOfConditionArray2 = new GrpcOneOfCondition[]{};
        }
        spreadBuilder.addSpread(grpcOneOfConditionArray2);
        spreadBuilder.add((Object)new GrpcOneOfCondition(variants));
        this.schema.setAllOf(CollectionsKt.mutableListOf((Object[])spreadBuilder.toArray((Object[])new GrpcOneOfCondition[spreadBuilder.size()])));
    }

    private final GrpcJsonSchemaBuilder addMapField(PbMapField field) {
        GrpcJsonSchemaBuilder grpcJsonSchemaBuilder;
        GrpcJsonSchemaBuilder it = grpcJsonSchemaBuilder = this;
        boolean bl = false;
        PbTypeName pbTypeName = field.getValueType();
        Object object = pbTypeName;
        if (object != null) {
            Intrinsics.checkNotNull((Object)object);
            object = this.fqn(pbTypeName);
            if (object == null) {
            } else {
                Object valueFqn = object;
                String string = field.getName();
                if (string != null) {
                    String string2 = string;
                    Intrinsics.checkNotNull((Object)string2);
                    String fieldName = string2;
                    this.processMapField((String)valueFqn, fieldName, field);
                }
            }
        }
        return grpcJsonSchemaBuilder;
    }

    private final void processMapField(String valueFqn, String fieldName, PbMapField field) {
        PbMessageDefinition resolveMessageOrNull;
        String id = this.rootMessageFqn + "/" + fieldName;
        this.schema.getProperties().put(fieldName, new GrpcReference(fieldName, null, id, 2, null));
        if (this.isPrimitive(valueFqn)) {
            String substitutedType = primitiveTypeMappings.get(valueFqn);
            this.topLevelBuilder.schema.getDefinitions().put(fieldName, new GrpcMapField(new GrpcJsonObject(null, substitutedType, 1, null), id));
        } else {
            this.topLevelBuilder.schema.getDefinitions().put(fieldName, new GrpcMapField(new GrpcReference(valueFqn, null, null, 6, null), id));
        }
        PsiElement psiElement = GrpcResolveUtils.INSTANCE.resolveMessageOrEnum$intellij_grpc(field.getValueType());
        if (psiElement != null) {
            PsiElement $this$asSafely$iv = psiElement;
            boolean $i$f$asSafely = false;
            PsiElement psiElement2 = $this$asSafely$iv;
            if (!(psiElement2 instanceof PbMessageDefinition)) {
                psiElement2 = null;
            }
            v2 = (PbMessageDefinition)psiElement2;
        } else {
            v2 = resolveMessageOrNull = null;
        }
        if (resolveMessageOrNull != null) {
            this.handleCyclicImports(valueFqn, (Function0<Unit>)((Function0)new Function0<Unit>(resolveMessageOrNull, this, valueFqn){
                final /* synthetic */ PbMessageDefinition $resolveMessageOrNull;
                final /* synthetic */ GrpcJsonSchemaBuilder this$0;
                final /* synthetic */ String $valueFqn;
                {
                    this.$resolveMessageOrNull = $resolveMessageOrNull;
                    this.this$0 = $receiver;
                    this.$valueFqn = $valueFqn;
                    super(0);
                }

                public final void invoke() {
                    Object object = GrpcJsonSchemaBuilder.Companion.messageToSchema$intellij_grpc(this.$resolveMessageOrNull, GrpcJsonSchemaBuilder.access$getTopLevelBuilder$p(this.this$0));
                    if (object == null || (object = GrpcJsonSchemaBuilder.access$assembleSchema((GrpcJsonSchemaBuilder)object)) == null) {
                        return;
                    }
                    Object messageSchema = object;
                    GrpcJsonSchemaBuilder.access$getSchema$p(GrpcJsonSchemaBuilder.access$getTopLevelBuilder$p(this.this$0)).getDefinitions().put(this.$valueFqn, (GrpcMessage)messageSchema);
                }
            }));
        }
    }

    private final void mapPrimitiveField(Companion.ProtoFieldMeta fieldMeta) {
        String substitutedType = primitiveTypeMappings.get(fieldMeta.getTypeFqn());
        String id = this.rootMessageFqn + "/" + fieldMeta.getFieldName();
        if (fieldMeta.getRepeated()) {
            this.schema.getProperties().put(fieldMeta.getFieldName(), new GrpcArrayOf(new GrpcPrimitive(substitutedType, id), null, 2, null));
        } else {
            this.schema.getProperties().put(fieldMeta.getFieldName(), new GrpcPrimitive(substitutedType, id));
        }
    }

    private final void mapMessageOrEnum(Companion.ProtoFieldMeta fieldMeta) {
        PsiElement messageOrEnum = GrpcResolveUtils.INSTANCE.resolveMessageOrEnum$intellij_grpc(fieldMeta.getFieldPsi().getTypeName());
        if (messageOrEnum instanceof PbMessageDefinition) {
            this.mapMessage(fieldMeta, (PbMessageDefinition)messageOrEnum);
        } else if (messageOrEnum instanceof PbEnumDefinition) {
            this.mapEnum(fieldMeta, (PbEnumDefinition)messageOrEnum);
        } else {
            GrpcJsonSchemaBuilder $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GrpcJsonSchemaBuilder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            PsiElement psiElement = messageOrEnum;
            logger.warn("Field type resolved to " + (psiElement != null ? psiElement.getClass() : null) + " object, mapping skipped");
        }
    }

    private final void mapMessage(Companion.ProtoFieldMeta fieldMeta, PbMessageDefinition resolvedMessage) {
        if (this.handleTopLevelSchemaReference(fieldMeta)) {
            return;
        }
        String id = this.rootMessageFqn + "/" + fieldMeta.getFieldName();
        if (fieldMeta.getRepeated()) {
            this.schema.getProperties().put(fieldMeta.getFieldName(), new GrpcArrayOf(new GrpcReference(fieldMeta.getTypeFqn(), null, id, 2, null), null, 2, null));
        } else {
            Map<String, GrpcJsonObject> map = this.schema.getProperties();
            String string = fieldMeta.getFieldName();
            Object object = new GrpcJsonObject[]{new GrpcReference(fieldMeta.getTypeFqn(), null, id, 2, null), new GrpcPrimitive("object", id)};
            object = new GrpcOneOf((GrpcJsonObject[])object, null, 2, null);
            map.put(string, (GrpcJsonObject)object);
        }
        this.handleCyclicImports(fieldMeta.getTypeFqn(), (Function0<Unit>)((Function0)new Function0<Unit>(resolvedMessage, this, fieldMeta){
            final /* synthetic */ PbMessageDefinition $resolvedMessage;
            final /* synthetic */ GrpcJsonSchemaBuilder this$0;
            final /* synthetic */ Companion.ProtoFieldMeta $fieldMeta;
            {
                this.$resolvedMessage = $resolvedMessage;
                this.this$0 = $receiver;
                this.$fieldMeta = $fieldMeta;
                super(0);
            }

            public final void invoke() {
                Object object = GrpcJsonSchemaBuilder.Companion.messageToSchema$intellij_grpc(this.$resolvedMessage, GrpcJsonSchemaBuilder.access$getTopLevelBuilder$p(this.this$0));
                if (object == null || (object = GrpcJsonSchemaBuilder.access$assembleSchema((GrpcJsonSchemaBuilder)object)) == null) {
                    return;
                }
                Object messageSchema = object;
                GrpcJsonSchemaBuilder.access$getSchema$p(GrpcJsonSchemaBuilder.access$getTopLevelBuilder$p(this.this$0)).getDefinitions().put(this.$fieldMeta.getTypeFqn(), (GrpcMessage)messageSchema);
            }
        }));
    }

    private final boolean handleTopLevelSchemaReference(Companion.ProtoFieldMeta fieldMeta) {
        if (StringsKt.isBlank((CharSequence)this.topLevelBuilder.rootMessageFqn) || !Intrinsics.areEqual((Object)fieldMeta.getTypeFqn(), (Object)this.topLevelBuilder.rootMessageFqn)) {
            return false;
        }
        String id = this.rootMessageFqn + "/" + fieldMeta.getFieldName();
        if (fieldMeta.getRepeated()) {
            this.schema.getProperties().put(fieldMeta.getFieldName(), new GrpcArrayOf(new GrpcReference("", "#/", id), null, 2, null));
        } else {
            Map<String, GrpcJsonObject> map = this.schema.getProperties();
            String string = fieldMeta.getFieldName();
            Object object = new GrpcJsonObject[]{new GrpcReference("", "#/", id), new GrpcPrimitive("object", id)};
            object = new GrpcOneOf((GrpcJsonObject[])object, null, 2, null);
            map.put(string, (GrpcJsonObject)object);
        }
        return true;
    }

    private final void handleCyclicImports(String definitionFqn, Function0<Unit> newMappingAction) {
        if (this.topLevelBuilder.schema.getDefinitions().get(definitionFqn) != null) {
            return;
        }
        this.topLevelBuilder.schema.getDefinitions().put(definitionFqn, GrpcMessageBeingEvaluated.INSTANCE);
        newMappingAction.invoke();
    }

    /*
     * WARNING - void declaration
     */
    private final void mapEnum(Companion.ProtoFieldMeta fieldMeta, PbEnumDefinition enumDefinition) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Collection collection;
        Object object;
        void $this$mapTo$iv$iv;
        Collection entries = enumDefinition.getEnumValueMap().entries();
        Intrinsics.checkNotNull((Object)entries);
        Iterable $this$map$iv = entries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        $this$map$iv = entries;
        collection = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Number it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            PbNumberValue pbNumberValue = ((PbEnumValue)it.getValue()).getNumberValue();
            if ((pbNumberValue != null ? pbNumberValue.getNumber() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Serializable[] enumValuesAndNumbers = thisCollection$iv.toArray(new Serializable[0]);
        String id = this.rootMessageFqn + "/" + fieldMeta.getFieldName();
        if (fieldMeta.getRepeated()) {
            this.schema.getProperties().put(fieldMeta.getFieldName(), new GrpcArrayOf(new GrpcEnum(id, (Object[])Arrays.copyOf(enumValuesAndNumbers, enumValuesAndNumbers.length)), null, 2, null));
        } else {
            this.schema.getProperties().put(fieldMeta.getFieldName(), new GrpcEnum(id, (Object[])Arrays.copyOf(enumValuesAndNumbers, enumValuesAndNumbers.length)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String fqn(PbTypeName $this$fqn) {
        PbSymbol pbSymbol;
        String resolvedFqn;
        String string;
        void $this$asSafely$iv;
        PsiElement psiElement = GrpcResolveUtils.INSTANCE.resolveMessageOrEnum$intellij_grpc($this$fqn);
        boolean $i$f$asSafely = false;
        Object v0 = $this$asSafely$iv;
        if (!(v0 instanceof PbSymbol)) {
            v0 = null;
        }
        if ((string = (resolvedFqn = (pbSymbol = (PbSymbol)v0) != null && (psiElement = pbSymbol.getQualifiedName()) != null ? psiElement.toString() : null)) == null) {
            String string2 = $this$fqn.getSymbolPath().getQualifiedName().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        return string;
    }

    private final boolean isPrimitive(String typeName) {
        return primitiveTypeMappings.keySet().contains(typeName);
    }

    private final boolean isRepeated(PbSimpleField field) {
        PbFieldLabel pbFieldLabel = field.getDeclaredLabel();
        return Intrinsics.areEqual((Object)(pbFieldLabel != null ? pbFieldLabel.getText() : null), (Object)"repeated");
    }

    public static final /* synthetic */ GrpcJsonSchemaBuilder access$getTopLevelBuilder$p(GrpcJsonSchemaBuilder $this) {
        return $this.topLevelBuilder;
    }

    public static final /* synthetic */ GrpcMessage access$assembleSchema(GrpcJsonSchemaBuilder $this) {
        return $this.assembleSchema();
    }

    public static final /* synthetic */ GrpcJsonSchema access$getSchema$p(GrpcJsonSchemaBuilder $this) {
        return $this.schema;
    }

    public /* synthetic */ GrpcJsonSchemaBuilder(String rootMessageFqn, GrpcJsonSchemaBuilder givenTopLevelBuilder, DefaultConstructorMarker $constructor_marker) {
        this(rootMessageFqn, givenTopLevelBuilder);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"bool", (Object)"boolean"), TuplesKt.to((Object)"int32", (Object)"integer"), TuplesKt.to((Object)"fixed32", (Object)"integer"), TuplesKt.to((Object)"uint32", (Object)"integer"), TuplesKt.to((Object)"sint32", (Object)"integer"), TuplesKt.to((Object)"int64", (Object)"string"), TuplesKt.to((Object)"fixed64", (Object)"string"), TuplesKt.to((Object)"uint64", (Object)"string"), TuplesKt.to((Object)"sint64", (Object)"string"), TuplesKt.to((Object)"float", (Object)"number"), TuplesKt.to((Object)"double", (Object)"number"), TuplesKt.to((Object)"Any", (Object)"object"), TuplesKt.to((Object)"Struct", (Object)"object"), TuplesKt.to((Object)"Empty", (Object)"object"), TuplesKt.to((Object)"FieldMask", (Object)"string"), TuplesKt.to((Object)"Timestamp", (Object)"string"), TuplesKt.to((Object)"Duration", (Object)"string"), TuplesKt.to((Object)"bytes", (Object)"string"), TuplesKt.to((Object)"string", (Object)"string"), TuplesKt.to((Object)"NullValue", (Object)"null")};
        primitiveTypeMappings = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u000bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/grpc/json/GrpcJsonSchemaBuilder$Companion;", "", "()V", "primitiveTypeMappings", "", "", "messageToSchema", "Lcom/intellij/grpc/json/GrpcJsonSchemaBuilder;", "messageDefinition", "Lcom/intellij/protobuf/lang/psi/PbMessageDefinition;", "parentBuilder", "messageToSchema$intellij_grpc", "ProtoFieldMeta", "intellij.grpc"})
    @SourceDebugExtension(value={"SMAP\nGrpcJsonSchemaBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcJsonSchemaBuilder.kt\ncom/intellij/grpc/json/GrpcJsonSchemaBuilder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,227:1\n1855#2,2:228\n1855#2,2:230\n1855#2,2:232\n*S KotlinDebug\n*F\n+ 1 GrpcJsonSchemaBuilder.kt\ncom/intellij/grpc/json/GrpcJsonSchemaBuilder$Companion\n*L\n183#1:228,2\n184#1:230,2\n185#1:232,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final GrpcJsonSchemaBuilder messageToSchema$intellij_grpc(@NotNull PbMessageDefinition messageDefinition, @Nullable GrpcJsonSchemaBuilder parentBuilder) {
            PbSimpleField p0;
            Intrinsics.checkNotNullParameter((Object)messageDefinition, (String)"messageDefinition");
            PbMessageBody pbMessageBody = messageDefinition.getBody();
            if (pbMessageBody == null) {
                return null;
            }
            PbMessageBody messageBody = pbMessageBody;
            QualifiedName qualifiedName = messageDefinition.getQualifiedName();
            String string = qualifiedName != null ? qualifiedName.toString() : null;
            if (string == null) {
                string = "";
            }
            String messageFqn = string;
            GrpcJsonSchemaBuilder schemaBuilder = new GrpcJsonSchemaBuilder(messageFqn, parentBuilder, null);
            List list = messageBody.getSimpleFieldList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSimpleFieldList(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (PbSimpleField)element$iv;
                boolean bl = false;
                schemaBuilder.addField(p0);
            }
            List list2 = messageBody.getMapFieldList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getMapFieldList(...)");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (PbMapField)element$iv;
                boolean bl = false;
                schemaBuilder.addMapField((PbMapField)p0);
            }
            List list3 = messageBody.getOneofDefinitionList();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getOneofDefinitionList(...)");
            $this$forEach$iv = list3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (PbOneofDefinition)element$iv;
                boolean bl = false;
                schemaBuilder.addOneOfField((PbOneofDefinition)p0);
            }
            return schemaBuilder;
        }

        public static /* synthetic */ GrpcJsonSchemaBuilder messageToSchema$intellij_grpc$default(Companion companion, PbMessageDefinition pbMessageDefinition, GrpcJsonSchemaBuilder grpcJsonSchemaBuilder, int n, Object object) {
            if ((n & 2) != 0) {
                grpcJsonSchemaBuilder = null;
            }
            return companion.messageToSchema$intellij_grpc(pbMessageDefinition, grpcJsonSchemaBuilder);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/grpc/json/GrpcJsonSchemaBuilder$Companion$ProtoFieldMeta;", "", "fieldPsi", "Lcom/intellij/protobuf/lang/psi/PbSimpleField;", "fieldName", "", "typeFqn", "repeated", "", "(Lcom/intellij/protobuf/lang/psi/PbSimpleField;Ljava/lang/String;Ljava/lang/String;Z)V", "getFieldName", "()Ljava/lang/String;", "getFieldPsi", "()Lcom/intellij/protobuf/lang/psi/PbSimpleField;", "getRepeated", "()Z", "getTypeFqn", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "intellij.grpc"})
        private static final class ProtoFieldMeta {
            @NotNull
            private final PbSimpleField fieldPsi;
            @NotNull
            private final String fieldName;
            @NotNull
            private final String typeFqn;
            private final boolean repeated;

            public ProtoFieldMeta(@NotNull PbSimpleField fieldPsi, @NotNull String fieldName, @NotNull String typeFqn, boolean repeated) {
                Intrinsics.checkNotNullParameter((Object)fieldPsi, (String)"fieldPsi");
                Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
                Intrinsics.checkNotNullParameter((Object)typeFqn, (String)"typeFqn");
                this.fieldPsi = fieldPsi;
                this.fieldName = fieldName;
                this.typeFqn = typeFqn;
                this.repeated = repeated;
            }

            @NotNull
            public final PbSimpleField getFieldPsi() {
                return this.fieldPsi;
            }

            @NotNull
            public final String getFieldName() {
                return this.fieldName;
            }

            @NotNull
            public final String getTypeFqn() {
                return this.typeFqn;
            }

            public final boolean getRepeated() {
                return this.repeated;
            }

            @NotNull
            public final PbSimpleField component1() {
                return this.fieldPsi;
            }

            @NotNull
            public final String component2() {
                return this.fieldName;
            }

            @NotNull
            public final String component3() {
                return this.typeFqn;
            }

            public final boolean component4() {
                return this.repeated;
            }

            @NotNull
            public final ProtoFieldMeta copy(@NotNull PbSimpleField fieldPsi, @NotNull String fieldName, @NotNull String typeFqn, boolean repeated) {
                Intrinsics.checkNotNullParameter((Object)fieldPsi, (String)"fieldPsi");
                Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
                Intrinsics.checkNotNullParameter((Object)typeFqn, (String)"typeFqn");
                return new ProtoFieldMeta(fieldPsi, fieldName, typeFqn, repeated);
            }

            public static /* synthetic */ ProtoFieldMeta copy$default(ProtoFieldMeta protoFieldMeta, PbSimpleField pbSimpleField, String string, String string2, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    pbSimpleField = protoFieldMeta.fieldPsi;
                }
                if ((n & 2) != 0) {
                    string = protoFieldMeta.fieldName;
                }
                if ((n & 4) != 0) {
                    string2 = protoFieldMeta.typeFqn;
                }
                if ((n & 8) != 0) {
                    bl = protoFieldMeta.repeated;
                }
                return protoFieldMeta.copy(pbSimpleField, string, string2, bl);
            }

            @NotNull
            public String toString() {
                return "ProtoFieldMeta(fieldPsi=" + this.fieldPsi + ", fieldName=" + this.fieldName + ", typeFqn=" + this.typeFqn + ", repeated=" + this.repeated + ")";
            }

            public int hashCode() {
                int result = this.fieldPsi.hashCode();
                result = result * 31 + this.fieldName.hashCode();
                result = result * 31 + this.typeFqn.hashCode();
                result = result * 31 + Boolean.hashCode(this.repeated);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ProtoFieldMeta)) {
                    return false;
                }
                ProtoFieldMeta protoFieldMeta = (ProtoFieldMeta)other;
                if (!Intrinsics.areEqual((Object)this.fieldPsi, (Object)protoFieldMeta.fieldPsi)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.fieldName, (Object)protoFieldMeta.fieldName)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.typeFqn, (Object)protoFieldMeta.typeFqn)) {
                    return false;
                }
                return this.repeated == protoFieldMeta.repeated;
            }
        }
    }
}

