/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.text;

import java.awt.Component;
import java.awt.Container;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.text.AbstractButtonTextReader;
import org.assertj.swing.text.JLabelTextReader;
import org.assertj.swing.text.JListTextReader;
import org.assertj.swing.text.JTextComponentTextReader;
import org.assertj.swing.text.TextReader;
import org.assertj.swing.util.Maps;

public class TextReaders {
    private static Logger logger = Logger.getLogger(TextReaders.class.getCanonicalName());
    @VisibleForTesting
    final ConcurrentMap<Class<?>, TextReader<?>> readers = Maps.newConcurrentHashMap();

    @VisibleForTesting
    TextReaders() {
        this.register(new AbstractButtonTextReader());
        this.register(new JLabelTextReader());
        this.register(new JListTextReader());
        this.register(new JTextComponentTextReader());
    }

    public void register(@Nonnull TextReader<?> reader) {
        Preconditions.checkNotNull(reader);
        Class<?> type2 = Preconditions.checkNotNull(reader.supportedComponent());
        TextReader<?> old = this.readers.put(type2, reader);
        if (old != null) {
            logger.info(Strings.concat("Replaced reader for type ", type2.getName()));
        }
    }

    @RunsInEDT
    public boolean containsText(@Nonnull Container container, @Nonnull String text2) {
        Preconditions.checkNotNull(container);
        Preconditions.checkNotNull(text2);
        Boolean result2 = GuiActionRunner.execute(() -> {
            if (this.componentContainsText(container, text2)) {
                return true;
            }
            return this.anyComponentContainsText(container.getComponents(), text2);
        });
        return Preconditions.checkNotNull(result2);
    }

    private boolean anyComponentContainsText(@Nonnull Component[] components, @Nonnull String text2) {
        for (Component c : components) {
            if (c == null) continue;
            if (this.componentContainsText(c, text2)) {
                return true;
            }
            if (!(c instanceof Container)) continue;
            Component[] children = ((Container)c).getComponents();
            return this.anyComponentContainsText(children, text2);
        }
        return false;
    }

    private boolean componentContainsText(@Nonnull Component c, @Nonnull String text2) {
        TextReader<?> reader = this.readerFor(c);
        if (reader == null) {
            return false;
        }
        return reader.containsText(c, text2);
    }

    @Nullable
    private TextReader<?> readerFor(@Nonnull Component c) {
        for (Class<?> type2 = c.getClass(); type2 != null; type2 = type2.getSuperclass()) {
            TextReader reader = (TextReader)this.readers.get(type2);
            if (reader != null) {
                return reader;
            }
            if (type2.equals(Component.class)) break;
        }
        return null;
    }

    @Nonnull
    public static TextReaders instance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        static final TextReaders INSTANCE = new TextReaders();

        private SingletonHolder() {
        }
    }
}

