/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.regex.Pattern;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.description.Description;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JTextComponentEditableQuery;
import org.assertj.swing.driver.JTextComponentSelectAllTask;
import org.assertj.swing.driver.JTextComponentSelectTextTask;
import org.assertj.swing.driver.JTextComponentSetTextTask;
import org.assertj.swing.driver.JTextComponentTextQuery;
import org.assertj.swing.driver.PointAndParentForScrollingJTextFieldQuery;
import org.assertj.swing.driver.TextAssert;
import org.assertj.swing.driver.TextDisplayDriver;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.format.Formatting;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.util.Pair;
import org.assertj.swing.util.Platform;

@InternalApi
public class JTextComponentDriver
extends JComponentDriver
implements TextDisplayDriver<JTextComponent> {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String TEXT_PROPERTY = "text";

    public JTextComponentDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void deleteText(@Nonnull JTextComponent textBox) {
        this.selectAll(textBox);
        this.invokeAction(textBox, "delete-previous");
    }

    @RunsInEDT
    public void replaceText(@Nonnull JTextComponent textBox, @Nonnull String text2) {
        Preconditions.checkNotNull(text2);
        if (text2.isEmpty()) {
            this.deleteText(textBox);
        } else {
            this.selectAll(textBox);
            this.enterText(textBox, text2);
        }
    }

    @RunsInEDT
    public void selectAll(@Nonnull JTextComponent textBox) {
        JTextComponentDriver.checkStateAndScrollToPosition(textBox, 0);
        JTextComponentSelectAllTask.selectAllText(textBox);
    }

    @RunsInEDT
    public void enterText(@Nonnull JTextComponent textBox, @Nonnull String text2) {
        this.focusAndWaitForFocusGain(textBox);
        this.robot.enterText(text2);
    }

    @RunsInEDT
    public void setText(@Nonnull JTextComponent textBox, @Nullable String text2) {
        this.focusAndWaitForFocusGain(textBox);
        JTextComponentSetTextTask.setTextIn(textBox, text2);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void selectText(@Nonnull JTextComponent textBox, @Nonnull String text2) {
        int indexFound = JTextComponentDriver.indexOfText(textBox, text2);
        if (indexFound == -1) {
            throw new IllegalArgumentException(String.format("The text %s was not found", Strings.quote(text2)));
        }
        this.selectText(textBox, indexFound, indexFound + text2.length());
    }

    @RunsInEDT
    private static int indexOfText(@Nonnull JTextComponent textBox, @Nonnull String text2) {
        Integer result2 = GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(textBox);
            String actualText = textBox.getText();
            if (Strings.isNullOrEmpty(actualText)) {
                return -1;
            }
            return actualText.indexOf(text2);
        });
        return Preconditions.checkNotNull(result2);
    }

    @RunsInEDT
    public void selectText(@Nonnull JTextComponent textBox, int start, int end) {
        this.robot.moveMouse(textBox, JTextComponentDriver.checkStateAndScrollToPosition(textBox, start));
        this.robot.moveMouse(textBox, JTextComponentDriver.scrollToPosition(textBox, end));
        JTextComponentDriver.performAndValidateTextSelection(textBox, start, end);
    }

    @Nonnull
    @RunsInEDT
    private static Point checkStateAndScrollToPosition(@Nonnull JTextComponent textBox, int index) {
        Point result2 = GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(textBox);
            return JTextComponentDriver.scrollToVisible(textBox, index);
        });
        return Preconditions.checkNotNull(result2);
    }

    @Nonnull
    @RunsInEDT
    private static Point scrollToPosition(@Nonnull JTextComponent textBox, int index) {
        Point result2 = GuiActionRunner.execute(() -> JTextComponentDriver.scrollToVisible(textBox, index));
        return Preconditions.checkNotNull(result2);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point scrollToVisible(@Nonnull JTextComponent textBox, int index) {
        Rectangle indexLocation = JTextComponentDriver.locationOf(textBox, index);
        if (JTextComponentDriver.isRectangleVisible(textBox, indexLocation)) {
            return JTextComponentDriver.centerOf(indexLocation);
        }
        JTextComponentDriver.scrollToVisible(textBox, indexLocation);
        indexLocation = JTextComponentDriver.locationOf(textBox, index);
        if (JTextComponentDriver.isRectangleVisible(textBox, indexLocation)) {
            return JTextComponentDriver.centerOf(indexLocation);
        }
        String format = "Unable to make visible the location of the index <%d> by scrolling to the point <%s> on %s";
        String msg = String.format(format, index, JTextComponentDriver.formatOriginOf(indexLocation), Formatting.format(textBox));
        throw ActionFailedException.actionFailure(msg);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Rectangle locationOf(@Nonnull JTextComponent textBox, int index) {
        Rectangle r = null;
        try {
            r = textBox.modelToView(index);
        }
        catch (BadLocationException e) {
            throw JTextComponentDriver.cannotGetLocation(textBox, index);
        }
        if (r != null) {
            if (Platform.isMacintosh() && r.y == -1) {
                r.y = 0;
            }
            return r;
        }
        throw JTextComponentDriver.cannotGetLocation(textBox, index);
    }

    private static ActionFailedException cannotGetLocation(@Nonnull JTextComponent textBox, int index) {
        String msg = String.format("Unable to get location for index <%d> in %s", index, Formatting.format(textBox));
        throw ActionFailedException.actionFailure(msg);
    }

    @RunsInCurrentThread
    private static boolean isRectangleVisible(@Nonnull JTextComponent textBox, @Nonnull Rectangle r) {
        Rectangle visible = textBox.getVisibleRect();
        return visible.contains(r.x, r.y);
    }

    private static String formatOriginOf(Rectangle r) {
        return Strings.concat(String.valueOf(r.x), ",", String.valueOf(r.y));
    }

    @RunsInCurrentThread
    private static void scrollToVisible(@Nonnull JTextComponent textBox, @Nonnull Rectangle r) {
        textBox.scrollRectToVisible(r);
        if (JTextComponentDriver.isVisible(textBox, r)) {
            return;
        }
        JTextComponentDriver.scrollToVisibleIfIsTextField(textBox, r);
    }

    @RunsInCurrentThread
    private static void scrollToVisibleIfIsTextField(@Nonnull JTextComponent textBox, @Nonnull Rectangle r) {
        if (!(textBox instanceof JTextField)) {
            return;
        }
        Pair<Point, Container> pointAndParent = PointAndParentForScrollingJTextFieldQuery.pointAndParentForScrolling((JTextField)textBox);
        Container parent = (Container)pointAndParent.second;
        if (parent == null || parent instanceof CellRendererPane || !(parent instanceof JComponent)) {
            return;
        }
        ((JComponent)parent).scrollRectToVisible(JTextComponentDriver.addPointToRectangle((Point)Preconditions.checkNotNull(pointAndParent.first), r));
    }

    @Nonnull
    private static Rectangle addPointToRectangle(@Nonnull Point p, @Nonnull Rectangle r) {
        Rectangle destination = new Rectangle(r);
        destination.x += p.x;
        destination.y += p.y;
        return destination;
    }

    @Nonnull
    private static Point centerOf(@Nonnull Rectangle r) {
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    @RunsInEDT
    private static void performAndValidateTextSelection(@Nonnull JTextComponent textBox, int start, int end) {
        GuiActionRunner.execute(() -> {
            JTextComponentSelectTextTask.selectTextInRange(textBox, start, end);
            JTextComponentDriver.verifyTextWasSelected(textBox, start, end);
        });
    }

    @RunsInCurrentThread
    private static void verifyTextWasSelected(@Nonnull JTextComponent textBox, int start, int end) {
        int actualStart = textBox.getSelectionStart();
        int actualEnd = textBox.getSelectionEnd();
        if (actualStart == Math.min(start, end) && actualEnd == Math.max(start, end)) {
            return;
        }
        String format = "Unable to select text uses indices <%d> and <%d>, current selection starts at <%d> and ends at <%d>";
        String msg = String.format(format, start, end, actualStart, actualEnd);
        throw ActionFailedException.actionFailure(msg);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JTextComponent textBox, @Nullable String expected) {
        ((TextAssert)TextAssert.verifyThat(this.textOf(textBox)).as(JTextComponentDriver.textProperty(textBox))).isEqualOrMatches(expected);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JTextComponent textBox, @Nonnull Pattern pattern) {
        ((TextAssert)TextAssert.verifyThat(this.textOf(textBox)).as(JTextComponentDriver.textProperty(textBox))).matches(pattern);
    }

    @RunsInEDT
    public void requireEmpty(@Nonnull JTextComponent textBox) {
        ((AbstractStringAssert)Assertions.assertThat(this.textOf(textBox)).as(JTextComponentDriver.textProperty(textBox))).isEmpty();
    }

    @Nonnull
    @RunsInEDT
    private static Description textProperty(@Nonnull JTextComponent textBox) {
        return JTextComponentDriver.propertyName(textBox, TEXT_PROPERTY);
    }

    @RunsInEDT
    public void requireEditable(@Nonnull JTextComponent textBox) {
        this.assertEditable(textBox, true);
    }

    @RunsInEDT
    public void requireNotEditable(@Nonnull JTextComponent textBox) {
        this.assertEditable(textBox, false);
    }

    @RunsInEDT
    private void assertEditable(@Nonnull JTextComponent textBox, boolean editable) {
        ((AbstractBooleanAssert)Assertions.assertThat(JTextComponentEditableQuery.isEditable(textBox)).as(JTextComponentDriver.editableProperty(textBox))).isEqualTo(editable);
    }

    @Nonnull
    @RunsInEDT
    private static Description editableProperty(@Nonnull JTextComponent textBox) {
        return JTextComponentDriver.propertyName(textBox, EDITABLE_PROPERTY);
    }

    @Override
    @Nullable
    @RunsInEDT
    public String textOf(@Nonnull JTextComponent textBox) {
        return JTextComponentTextQuery.textOf(textBox);
    }
}

