/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.annotation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.intentions.PbAddImportStatementIntention;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbNamedTypeElement;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.ProtoIdentifierValue;
import com.intellij.protobuf.lang.psi.ProtoNumberValue;
import com.intellij.protobuf.lang.psi.ProtoStringPart;
import com.intellij.protobuf.lang.psi.ProtoSymbolPath;
import com.intellij.protobuf.lang.psi.ProtoSymbolPathContainer;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SharedAnnotations {
    static ReferenceState getReferenceState(PsiReference reference) {
        if (reference == null) {
            return ReferenceState.NULL;
        }
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
            if (results.length == 0) {
                return ReferenceState.UNRESOLVED;
            }
            if (results.length > 1) {
                return ReferenceState.AMBIGUOUS;
            }
            return ReferenceState.VALID;
        }
        if (reference.resolve() == null) {
            return ReferenceState.UNRESOLVED;
        }
        return ReferenceState.VALID;
    }

    static void annotateEnumOptionValue(@NotNull ProtoIdentifierValue identifierValue, @NotNull AnnotationHolder holder) {
        if (identifierValue == null) {
            SharedAnnotations.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SharedAnnotations.$$$reportNull$$$0(1);
        }
        SharedAnnotations.annotateEnumOptionValue((PsiElement)identifierValue, holder);
    }

    static void annotateEnumOptionValue(@NotNull ProtoNumberValue numberValue, @NotNull AnnotationHolder holder) {
        if (numberValue == null) {
            SharedAnnotations.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            SharedAnnotations.$$$reportNull$$$0(3);
        }
        SharedAnnotations.annotateEnumOptionValue((PsiElement)numberValue, holder);
    }

    private static void annotateEnumOptionValue(PsiElement enumElement, AnnotationHolder holder) {
        switch (SharedAnnotations.getReferenceState(enumElement.getReference())) {
            case VALID: 
            case NULL: {
                break;
            }
            default: {
                holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("cannot.resolve.enum.value", enumElement.getText())).range(enumElement.getTextRange()).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
            }
        }
    }

    static void annotateStringPart(ProtoStringPart part, AnnotationHolder holder, TextAttributesKey invalidEscapeAttributes) {
        if (part.isUnterminated()) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("unterminated.string", new Object[0])).range(part.getTextRange()).afterEndOfLine().create();
        }
        for (TextRange range : part.getInvalidEscapeRanges()) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("illegal.escape.sequence", new Object[0])).range(range.shiftRight(part.getTextOffset())).textAttributes(invalidEscapeAttributes).create();
        }
    }

    static boolean annotateSymbolPath(@NotNull ProtoSymbolPath path, @NotNull AnnotationHolder holder) {
        if (path == null) {
            SharedAnnotations.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            SharedAnnotations.$$$reportNull$$$0(5);
        }
        ProtoSymbolPath qualifier = path.getQualifier();
        ProtoSymbolPathContainer container = path.getPathContainer();
        if (container instanceof PbTypeName && ((PbTypeName)container).isBuiltInType()) {
            return false;
        }
        switch (SharedAnnotations.getReferenceState(path.getReference())) {
            case AMBIGUOUS: {
                if (path.getParent() instanceof ProtoSymbolPath) {
                    return false;
                }
                holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("ambiguous.symbol", path.getSymbol().getText())).range(path.getSymbol().getTextRange()).create();
                return true;
            }
            case VALID: 
            case NULL: {
                break;
            }
            default: {
                holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("cannot.resolve.symbol", path.getSymbol().getText())).range(path.getSymbol().getTextRange()).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).withFix((IntentionAction)new PbAddImportStatementIntention()).create();
                return true;
            }
        }
        return false;
    }

    static void annotateExtensionName(@Nullable ProtoSymbolPath symbolPath, @Nullable PsiReference ref, @NotNull String referenceString, @Nullable PbNamedTypeElement qualifierType, @NotNull AnnotationHolder holder, boolean allowMembers) {
        if (referenceString == null) {
            SharedAnnotations.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            SharedAnnotations.$$$reportNull$$$0(7);
        }
        if (symbolPath == null) {
            return;
        }
        if (ref == null) {
            return;
        }
        TextRange symbolRange = symbolPath.getSymbol().getTextRange();
        PsiElement resolved = ref.resolve();
        if (resolved == null) {
            return;
        }
        if (resolved instanceof PbField) {
            if (qualifierType == null) {
                holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("unresolved.parent.type", new Object[0])).range(symbolRange).create();
            } else {
                boolean isExtension;
                PbField field = (PbField)resolved;
                boolean bl = isExtension = allowMembers ? PbPsiUtil.fieldIsExtensionOrMember(field, qualifierType) : PbPsiUtil.fieldIsExtension(field, qualifierType);
                if (!isExtension) {
                    holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("field.does.not.extend.type", field.getName(), qualifierType.getQualifiedName())).range(symbolRange).create();
                }
            }
        } else {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("extension.option.not.a.field", referenceString)).range(symbolRange).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifierValue";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numberValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceString";
                break;
            }
        }
        objectArray2[1] = "com/intellij/protobuf/lang/annotation/SharedAnnotations";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateEnumOptionValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateSymbolPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateExtensionName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum ReferenceState {
        VALID,
        UNRESOLVED,
        AMBIGUOUS,
        NULL;

    }
}

