/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.protobuf.ide.PbIdeBundle;
import com.intellij.protobuf.ide.actions.PbExportSettingsAsCliCommandAction;
import com.intellij.protobuf.ide.settings.PbImportPathsConfiguration;
import com.intellij.protobuf.ide.settings.PbProjectSettings;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/protobuf/ide/actions/PbExportSettingsAsCliCommandAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.protoeditor.core"})
public final class PbExportSettingsAsCliCommandAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String PROTOC_PATH_ARGUMENT = "--proto_path";

    public PbExportSettingsAsCliCommandAction() {
        super(PbIdeBundle.messagePointer("action.export.as.cli.argument.name", new Object[0]), AllIcons.Actions.Copy);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> PbExportSettingsAsCliCommandAction.actionPerformed$lambda$0(project2), PbIdeBundle.message("action.export.as.cli.argument.progress.title", new Object[0]), true, project2);
    }

    private static final void actionPerformed$lambda$0(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(Companion.joinImportPathsIntoCliArgument($project, PROTOC_PATH_ARGUMENT)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/protobuf/ide/actions/PbExportSettingsAsCliCommandAction$Companion;", "", "()V", "PROTOC_PATH_ARGUMENT", "", "joinImportPathsIntoCliArgument", "project", "Lcom/intellij/openapi/project/Project;", "pathArgumentName", "retrieveImportUrls", "Lkotlin/sequences/Sequence;", "retrieveUnescapedImportPaths", "intellij.protoeditor.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String joinImportPathsIntoCliArgument(@NotNull Project project, @NotNull String pathArgumentName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)pathArgumentName, (String)"pathArgumentName");
            String argumentWithWhiteSpaces = " " + pathArgumentName + " ";
            return SequencesKt.joinToString$default(this.retrieveUnescapedImportPaths(project), (CharSequence)argumentWithWhiteSpaces, (CharSequence)argumentWithWhiteSpaces, null, (int)0, null, null, (int)60, null);
        }

        private final Sequence<String> retrieveImportUrls(Project project) {
            PbProjectSettings pbProjectSettings = PbProjectSettings.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)pbProjectSettings, (String)"getInstance(...)");
            return SequencesKt.plus((Sequence)SequencesKt.mapNotNull(PbImportPathsConfiguration.computeDeterministicImportPaths(project, pbProjectSettings), (Function1)retrieveImportUrls.1.INSTANCE), (Iterable)PbImportPathsConfiguration.getOrComputeImportPathsForAllImportStatements(project));
        }

        private final Sequence<String> retrieveUnescapedImportPaths(Project project) {
            return SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map(this.retrieveImportUrls(project), (Function1)retrieveUnescapedImportPaths.1.INSTANCE), (Function1)retrieveUnescapedImportPaths.2.INSTANCE), (Function1)retrieveUnescapedImportPaths.3.INSTANCE), (Function1)retrieveUnescapedImportPaths.4.INSTANCE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

