/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.utils.graph;

import com.intellij.rml.dfa.utils.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BG\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000e0\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0015\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\b\u0010\u0016\u001a\u00020\u0000H\u0016R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/rml/dfa/utils/graph/IntGraph;", "Lcom/intellij/rml/dfa/utils/graph/Graph;", "", "nodes", "", "edges", "", "invertedEdges", "(Ljava/util/Set;Ljava/util/Map;Ljava/util/Map;)V", "edgesCnt", "getEdgesCnt", "()I", "nodesCnt", "getNodesCnt", "Lkotlin/Pair;", "getIdByNode", "node", "getNodeById", "id", "(I)Ljava/lang/Integer;", "incomingNodes", "outgoingNodes", "toIntGraph", "intellij.rml.dfa"})
@SourceDebugExtension(value={"SMAP\nGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Graph.kt\ncom/intellij/rml/dfa/utils/graph/IntGraph\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n76#2:231\n96#2,2:232\n98#2,3:238\n1549#3:234\n1620#3,3:235\n*S KotlinDebug\n*F\n+ 1 Graph.kt\ncom/intellij/rml/dfa/utils/graph/IntGraph\n*L\n87#1:231\n87#1:232,2\n87#1:238,3\n87#1:234\n87#1:235,3\n*E\n"})
public final class IntGraph
implements Graph<Integer> {
    @NotNull
    private final Set<Integer> nodes;
    @NotNull
    private final Map<Integer, Set<Integer>> edges;
    @NotNull
    private final Map<Integer, Set<Integer>> invertedEdges;
    private final int nodesCnt;
    private final int edgesCnt;

    public IntGraph(@NotNull Set<Integer> nodes, @NotNull Map<Integer, ? extends Set<Integer>> edges, @NotNull Map<Integer, ? extends Set<Integer>> invertedEdges) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        Intrinsics.checkNotNullParameter(invertedEdges, (String)"invertedEdges");
        this.nodes = nodes;
        this.edges = edges;
        this.invertedEdges = invertedEdges;
        this.nodesCnt = this.nodes.size();
        this.edgesCnt = this.edges.size();
    }

    @Override
    public int getNodesCnt() {
        return this.nodesCnt;
    }

    @Override
    public int getEdgesCnt() {
        return this.edgesCnt;
    }

    @Override
    @NotNull
    public Set<Integer> nodes() {
        return this.nodes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Pair<Integer, Integer>> edges() {
        void $this$flatMapTo$iv$iv;
        Map<Integer, Set<Integer>> $this$flatMap$iv = this.edges;
        boolean $i$f$flatMap = false;
        Map<Integer, Set<Integer>> map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            int from = ((Number)entry.getKey()).intValue();
            Set tos = (Set)entry.getValue();
            Iterable $this$map$iv = tos;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void to;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new Pair((Object)from, (Object)((int)to)));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public IntGraph toIntGraph() {
        return this;
    }

    @Override
    public int getIdByNode(int node) {
        return node;
    }

    @Override
    @NotNull
    public Integer getNodeById(int id) {
        return id;
    }

    @Override
    @NotNull
    public Set<Integer> incomingNodes(int node) {
        Set set = this.invertedEdges.get(node);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Integer> outgoingNodes(int node) {
        Set set = this.edges.get(node);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }
}

