/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.ir;

import com.intellij.openapi.util.Key;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.ir.IrScope;
import com.intellij.rml.dfa.ir.ast.IrDeclaration;
import com.intellij.rml.dfa.ir.ast.IrIdentifier;
import com.intellij.rml.dfa.ir.ast.IrLocationID;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007B5\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\u0010\rJ.\u0010\u000e\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0010\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u0012J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0016J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0000H\u0086\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\fJ\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001c\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/rml/dfa/ir/IrEnvironment;", "", "()V", "extraLocations", "", "Lcom/intellij/rml/dfa/attributes/Attribute;", "Lcom/intellij/rml/dfa/ir/IrLocation;", "(Ljava/util/Map;)V", "globalScope", "Lcom/intellij/rml/dfa/ir/IrScope;", "localScopes", "", "Lcom/intellij/rml/dfa/ir/ast/IrIdentifier;", "(Lcom/intellij/rml/dfa/ir/IrScope;Ljava/util/Map;Ljava/util/Map;)V", "findIdentifier", "attribute", "context", "irClass", "Lkotlin/reflect/KClass;", "findLocation", "getStatementLocation", "tuple", "Lcom/intellij/rml/dfa/attributes/DfaTuple;", "plusAssign", "", "environment", "resolve", "Lcom/intellij/rml/dfa/ir/ast/IrDeclaration;", "identifier", "resolvedLocation", "Companion", "intellij.rml.dfa"})
@SourceDebugExtension(value={"SMAP\nIrEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrEnvironment.kt\ncom/intellij/rml/dfa/ir/IrEnvironment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class IrEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrScope globalScope;
    @NotNull
    private final Map<IrIdentifier, IrScope> localScopes;
    @NotNull
    private final Map<Attribute, IrLocation> extraLocations;
    @NotNull
    private static final Key<Map<Attribute, IrLocation>> EXTRA_LOCATIONS_MAP;

    public IrEnvironment(@NotNull IrScope globalScope, @NotNull Map<IrIdentifier, IrScope> localScopes, @NotNull Map<Attribute, IrLocation> extraLocations) {
        Intrinsics.checkNotNullParameter((Object)globalScope, (String)"globalScope");
        Intrinsics.checkNotNullParameter(localScopes, (String)"localScopes");
        Intrinsics.checkNotNullParameter(extraLocations, (String)"extraLocations");
        this.globalScope = globalScope;
        this.localScopes = localScopes;
        this.extraLocations = extraLocations;
    }

    public IrEnvironment() {
        this(new IrScope(), new LinkedHashMap(), new LinkedHashMap());
    }

    public IrEnvironment(@NotNull Map<Attribute, IrLocation> extraLocations) {
        Intrinsics.checkNotNullParameter(extraLocations, (String)"extraLocations");
        this(new IrScope(), new LinkedHashMap(), MapsKt.toMutableMap(extraLocations));
    }

    public final void plusAssign(@NotNull IrEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.globalScope.plusAssign(environment.globalScope);
        this.localScopes.putAll(environment.localScopes);
        this.extraLocations.putAll(environment.extraLocations);
    }

    @Nullable
    public final IrDeclaration resolve(@NotNull IrIdentifier identifier, @Nullable IrIdentifier context) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Object object = this.localScopes.get(context);
        if (object != null && (object = ((IrScope)object).resolve(identifier)) != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        return this.globalScope.resolve(identifier);
    }

    @Nullable
    public final IrLocation resolvedLocation(@NotNull IrIdentifier identifier, @Nullable IrIdentifier context) {
        IrLocation irLocation;
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        if (identifier instanceof IrLocationID) {
            irLocation = ((IrLocationID)identifier).getLocation();
        } else {
            IrLocation irLocation2 = this.extraLocations.get(identifier.getAttr());
            if (irLocation2 != null) {
                IrLocation it = irLocation2;
                boolean bl = false;
                return it;
            }
            IrDeclaration irDeclaration = this.resolve(identifier, context);
            irLocation = irDeclaration != null ? irDeclaration.getLocation() : null;
        }
        return irLocation;
    }

    @Nullable
    public final IrIdentifier findIdentifier(@Nullable Attribute attribute, @Nullable Attribute context, @Nullable KClass<? extends IrIdentifier> irClass) {
        Object object = this.localScopes.get(IrScope.findIdentifier$default(this.globalScope, context, null, 2, null));
        if (object != null && (object = ((IrScope)object).findIdentifier(attribute, irClass)) != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        return this.globalScope.findIdentifier(attribute, irClass);
    }

    @Nullable
    public final IrLocation findLocation(@NotNull Attribute attribute, @Nullable Attribute context) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        IrLocation irLocation = this.extraLocations.get(attribute);
        if (irLocation != null) {
            IrLocation it = irLocation;
            boolean bl = false;
            return it;
        }
        Object object = this.localScopes.get(IrScope.findIdentifier$default(this.globalScope, context, null, 2, null));
        if (object != null && (object = ((IrScope)object).findLocation(attribute)) != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        return this.globalScope.findLocation(attribute);
    }

    @Nullable
    public final IrLocation getStatementLocation(@NotNull DfaTuple tuple) {
        Intrinsics.checkNotNullParameter((Object)tuple, (String)"tuple");
        IrIdentifier context = IrScope.findIdentifier$default(this.globalScope, tuple.getFunction(), null, 2, null);
        IrScope irScope = context != null ? this.localScopes.get(context) : this.globalScope;
        return irScope != null ? irScope.getStatementLocation(tuple) : null;
    }

    static {
        Key key = Key.create((String)"EXTRA_LOCATIONS_MAP");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        EXTRA_LOCATIONS_MAP = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R<\u0010\u0003\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007 \b*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/rml/dfa/ir/IrEnvironment$Companion;", "", "()V", "EXTRA_LOCATIONS_MAP", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/rml/dfa/attributes/Attribute;", "Lcom/intellij/rml/dfa/ir/IrLocation;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getEXTRA_LOCATIONS_MAP", "()Lcom/intellij/openapi/util/Key;", "intellij.rml.dfa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Map<Attribute, IrLocation>> getEXTRA_LOCATIONS_MAP() {
            return EXTRA_LOCATIONS_MAP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

