/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.utils.graph;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\r\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B1\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u001c\u0010\u0005\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u001b\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ#\u0010 \u001a\u0004\u0018\u00018\u00002\b\u0010!\u001a\u0004\u0018\u00018\u00002\b\u0010\"\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010#R\u001c\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0005\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000b*\u0004\u0018\u00018\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lcom/intellij/rml/dfa/impl/utils/graph/Forest;", "T", "", "nodes", "", "comparator", "Lkotlin/Function2;", "", "(Ljava/util/Set;Lkotlin/jvm/functions/Function2;)V", "_size", "", "", "ancestor", "child", "getComparator", "()Lkotlin/jvm/functions/Function2;", "label", "getNodes", "()Ljava/util/Set;", "size", "getSize", "(Ljava/lang/Object;)I", "compress", "", "node", "(Ljava/lang/Object;)V", "eval", "(Ljava/lang/Object;)Ljava/lang/Object;", "link", "nodeV", "nodeW", "(Ljava/lang/Object;Ljava/lang/Object;)V", "min", "node1", "node2", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "intellij.rml.dfa.impl"})
public final class Forest<T> {
    @NotNull
    private final Set<T> nodes;
    @NotNull
    private final Function2<T, T, Boolean> comparator;
    @NotNull
    private final Map<T, T> ancestor;
    @NotNull
    private final Map<T, T> label;
    @NotNull
    private final Map<T, T> child;
    @NotNull
    private final Map<T, Integer> _size;

    public Forest(@NotNull Set<? extends T> nodes, @NotNull Function2<? super T, ? super T, Boolean> comparator2) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter(comparator2, (String)"comparator");
        this.nodes = nodes;
        this.comparator = comparator2;
        this.ancestor = new LinkedHashMap();
        this.label = new LinkedHashMap();
        this.child = new LinkedHashMap();
        this._size = new LinkedHashMap();
        this._size.put(null, 0);
        for (T node : this.nodes) {
            this.label.put(node, node);
            this._size.put(node, 1);
        }
    }

    @NotNull
    public final Set<T> getNodes() {
        return this.nodes;
    }

    @NotNull
    public final Function2<T, T, Boolean> getComparator() {
        return this.comparator;
    }

    private final int getSize(T $this$size) {
        Integer n = this._size.get($this$size);
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    private final T min(T node1, T node2) {
        return (Boolean)this.comparator.invoke(node1, node2) != false ? node1 : node2;
    }

    @Nullable
    public final T eval(T node) {
        T t;
        if (this.ancestor.get(node) == null) {
            t = this.label.get(node);
        } else {
            this.compress(node);
            t = this.min(this.label.get(node), this.label.get(this.ancestor.get(node)));
        }
        return t;
    }

    private final void compress(T node) {
        if (this.ancestor.get(this.ancestor.get(node)) != null) {
            this.compress(this.ancestor.get(node));
            this.label.put(node, this.min(this.label.get(node), this.label.get(this.ancestor.get(node))));
            this.ancestor.put(node, this.ancestor.get(this.ancestor.get(node)));
        }
    }

    public final void link(T nodeV, T nodeW) {
        T s = nodeW;
        while (((Boolean)this.comparator.invoke(this.label.get(nodeW), this.label.get(this.child.get(s)))).booleanValue()) {
            if (this.getSize(s) + this.getSize(this.child.get(this.child.get(s))) >= 2 * this.getSize(this.child.get(s))) {
                this.ancestor.put(this.child.get(s), s);
                this.child.put(s, this.child.get(this.child.get(s)));
                continue;
            }
            this._size.put(this.child.get(s), this.getSize(s));
            this.ancestor.put(s, this.child.get(s));
            s = this.child.get(s);
        }
        this.label.put(s, this.label.get(nodeW));
        this._size.put(nodeV, this.getSize(nodeV) + this.getSize(nodeW));
        if (this.getSize(nodeV) < 2 * this.getSize(nodeW)) {
            T temp2 = s;
            s = this.child.get(nodeV);
            this.child.put(nodeV, temp2);
        }
        while (s != null) {
            this.ancestor.put(s, nodeV);
            s = this.child.get(s);
        }
    }
}

