/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.transform;

import com.intellij.rml.dfa.impl.transform.EmptyBlockAfterConditionStage;
import com.intellij.rml.dfa.impl.transform.IrTransformStage;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfg;
import com.intellij.rml.dfa.ir.cfg.IrConditionalJump;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import com.intellij.rml.dfa.ir.cfg.IrUnconditionalJump;
import com.intellij.rml.dfa.utils.RMLOptions;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/rml/dfa/impl/transform/EmptyBlockAfterConditionStage;", "Lcom/intellij/rml/dfa/impl/transform/IrTransformStage;", "()V", "name", "", "getName", "()Ljava/lang/String;", "transform", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "decl", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nEmptyBlockAfterConditionStage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmptyBlockAfterConditionStage.kt\ncom/intellij/rml/dfa/impl/transform/EmptyBlockAfterConditionStage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1747#2,3:54\n*S KotlinDebug\n*F\n+ 1 EmptyBlockAfterConditionStage.kt\ncom/intellij/rml/dfa/impl/transform/EmptyBlockAfterConditionStage\n*L\n31#1:54,3\n*E\n"})
public final class EmptyBlockAfterConditionStage
implements IrTransformStage {
    @NotNull
    private final String name;

    public EmptyBlockAfterConditionStage() {
        this.name = "Empty block after condition";
    }

    @Override
    @NotNull
    public IrTopLevelDecl transform(@NotNull IrTopLevelDecl decl, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter((Object)decl, (String)"decl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!(decl instanceof IrFunctionDecl)) {
            return decl;
        }
        IrCfg cfg2 = ((IrFunctionDecl)decl).getBody();
        Map incomingCount = new LinkedHashMap();
        Iterator<Map.Entry<IrCFGBlock, IrJump>> iterator = cfg2.getJumps().entrySet().iterator();
        while (iterator.hasNext()) {
            IrJump jump = iterator.next().getValue();
            for (IrCFGBlock target : jump.getTargets()) {
                incomingCount.compute(target, (arg_0, arg_1) -> EmptyBlockAfterConditionStage.transform$lambda$0(transform.1.INSTANCE, arg_0, arg_1));
            }
        }
        Set newBlocks = CollectionsKt.toMutableSet((Iterable)cfg2.getBlocks());
        Map newJumps = MapsKt.toMutableMap(cfg2.getJumps());
        for (Map.Entry<IrCFGBlock, IrJump> entry : cfg2.getJumps().entrySet()) {
            boolean bl;
            IrJump jump;
            IrCFGBlock source;
            block9: {
                source = entry.getKey();
                jump = entry.getValue();
                if (!(jump instanceof IrConditionalJump)) continue;
                Iterable $this$any$iv = jump.getTargets();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrCFGBlock it = (IrCFGBlock)element$iv;
                        boolean bl2 = false;
                        Object v = incomingCount.get(it);
                        Intrinsics.checkNotNull(v);
                        if (!(((Number)v).intValue() > 1)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            newJumps.remove(source);
            IrCFGBlock trueBranch = ((IrConditionalJump)jump).getTrueBranch();
            IrCFGBlock falseBranch = ((IrConditionalJump)jump).getFalseBranch();
            for (IrCFGBlock target : jump.getTargets()) {
                Object v = incomingCount.get(target);
                Intrinsics.checkNotNull(v);
                if (((Number)v).intValue() <= 1) continue;
                IrCFGBlock newBlock = IrCFGBlock.Companion.create();
                ((Collection)newBlocks).add(newBlock);
                Map map2 = newJumps;
                Pair pair = TuplesKt.to((Object)newBlock, (Object)new IrUnconditionalJump(target));
                map2.put(pair.getFirst(), pair.getSecond());
                if (Intrinsics.areEqual((Object)trueBranch, (Object)target)) {
                    trueBranch = newBlock;
                }
                if (!Intrinsics.areEqual((Object)falseBranch, (Object)target)) continue;
                falseBranch = newBlock;
            }
            Map map3 = newJumps;
            Pair pair = TuplesKt.to((Object)source, (Object)new IrConditionalJump(((IrConditionalJump)jump).getCondition(), trueBranch, falseBranch));
            map3.put(pair.getFirst(), pair.getSecond());
        }
        return ((IrFunctionDecl)decl).modifyCfg(new IrCfg(newBlocks, newJumps, cfg2.getStartBlock(), cfg2.getExitBlock()));
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    private static final Integer transform$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }
}

