/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.transform;

import com.intellij.rml.dfa.impl.ir.cfg.IrCFGBlockImpl;
import com.intellij.rml.dfa.impl.transform.IrTransformStage;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfg;
import com.intellij.rml.dfa.ir.cfg.IrConditionalJump;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import com.intellij.rml.dfa.ir.cfg.IrUnconditionalJump;
import com.intellij.rml.dfa.utils.RMLOptions;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/rml/dfa/impl/transform/BlocksMergeStage;", "Lcom/intellij/rml/dfa/impl/transform/IrTransformStage;", "()V", "name", "", "getName", "()Ljava/lang/String;", "transform", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "decl", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "mapTargets", "Lcom/intellij/rml/dfa/ir/cfg/IrJump;", "from", "Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "to", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nBlocksMergeStage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlocksMergeStage.kt\ncom/intellij/rml/dfa/impl/transform/BlocksMergeStage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1549#2:91\n1620#2,3:92\n1549#2:95\n1620#2,3:96\n1549#2:99\n1620#2,3:100\n1549#2:103\n1620#2,3:104\n*S KotlinDebug\n*F\n+ 1 BlocksMergeStage.kt\ncom/intellij/rml/dfa/impl/transform/BlocksMergeStage\n*L\n50#1:91\n50#1:92,3\n56#1:95\n56#1:96,3\n60#1:99\n60#1:100,3\n61#1:103\n61#1:104,3\n*E\n"})
public final class BlocksMergeStage
implements IrTransformStage {
    @NotNull
    private final String name;

    public BlocksMergeStage() {
        this.name = "Merge blocks";
    }

    @Override
    @NotNull
    public IrTopLevelDecl transform(@NotNull IrTopLevelDecl decl, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter((Object)decl, (String)"decl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!(decl instanceof IrFunctionDecl)) {
            return decl;
        }
        IrCfg cfg2 = ((IrFunctionDecl)decl).getBody();
        MultiMap incomingNodes = new MultiMap();
        MultiMap outgoingNodes = new MultiMap();
        for (Map.Entry<IrCFGBlock, IrJump> entry : cfg2.getJumps().entrySet()) {
            IrCFGBlock source = entry.getKey();
            IrJump jump = entry.getValue();
            for (IrCFGBlock target : jump.getTargets()) {
                incomingNodes.putValue((Object)target, (Object)source);
                outgoingNodes.putValue((Object)source, (Object)target);
            }
        }
        Set newBlocks = CollectionsKt.toMutableSet((Iterable)cfg2.getBlocks());
        Map newJumps = MapsKt.toMutableMap(cfg2.getJumps());
        IrCFGBlock startBlock = cfg2.getStartBlock();
        IrCFGBlock exitBlock = cfg2.getExitBlock();
        for (IrCFGBlock block : CollectionsKt.toList((Iterable)cfg2.getBlocks())) {
            IrCFGBlock it;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            IrCFGBlock it2;
            Collection<IrCFGBlock> collection;
            Iterable $this$mapTo$iv$iv2;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            Iterable $this$map$iv2;
            boolean $i$f$map;
            MultiMap multiMap;
            IrCFGBlock irCFGBlock;
            Collection collection2 = incomingNodes.get((Object)block);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
            IrCFGBlock prevBlock = (IrCFGBlock)CollectionsKt.firstOrNull((Iterable)collection2);
            if (prevBlock == null || Intrinsics.areEqual((Object)block, (Object)startBlock) || outgoingNodes.get((Object)prevBlock).size() != 1 || incomingNodes.get((Object)block).size() != 1) continue;
            IrCFGBlockImpl mergedBlock = new IrCFGBlockImpl(CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)prevBlock.getInstructions(), (Iterable)block.getInstructions())));
            ((Collection)newBlocks).remove(block);
            ((Collection)newBlocks).remove(prevBlock);
            newJumps.remove(prevBlock);
            IrJump jump = (IrJump)newJumps.remove(block);
            ((Collection)newBlocks).add(mergedBlock);
            if (jump != null) {
                newJumps.put(mergedBlock, jump);
            }
            if (Intrinsics.areEqual((Object)startBlock, (Object)prevBlock)) {
                startBlock = mergedBlock;
            }
            if (Intrinsics.areEqual((Object)exitBlock, (Object)block)) {
                exitBlock = mergedBlock;
            }
            for (IrCFGBlock prePrevBlock : incomingNodes.get((Object)prevBlock)) {
                if (Intrinsics.areEqual((Object)prePrevBlock, (Object)block)) continue;
                Collection collection3 = outgoingNodes.get((Object)prePrevBlock);
                Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"get(...)");
                Iterable iterable = collection3;
                irCFGBlock = prePrevBlock;
                multiMap = outgoingNodes;
                $i$f$map = false;
                void var19_23 = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    IrCFGBlock irCFGBlock2 = (IrCFGBlock)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Intrinsics.areEqual((Object)it2, (Object)prevBlock) ? (IrCFGBlock)mergedBlock : it2);
                }
                collection = (List)destination$iv$iv;
                multiMap.put((Object)irCFGBlock, (Collection)collection);
            }
            for (IrCFGBlock nextBlock : outgoingNodes.get((Object)block)) {
                if (Intrinsics.areEqual((Object)nextBlock, (Object)prevBlock)) continue;
                Collection collection4 = incomingNodes.get((Object)nextBlock);
                Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"get(...)");
                $this$map$iv2 = collection4;
                irCFGBlock = nextBlock;
                multiMap = incomingNodes;
                $i$f$map = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it2 = (IrCFGBlock)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Intrinsics.areEqual((Object)it2, (Object)block) ? (IrCFGBlock)mergedBlock : it2);
                }
                collection = (List)destination$iv$iv;
                multiMap.put((Object)irCFGBlock, (Collection)collection);
            }
            Collection collection5 = incomingNodes.get((Object)prevBlock);
            Intrinsics.checkNotNullExpressionValue((Object)collection5, (String)"get(...)");
            Iterator iterator = collection5;
            irCFGBlock = mergedBlock;
            multiMap = incomingNodes;
            boolean $i$f$map2 = false;
            $this$map$iv2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrCFGBlock irCFGBlock3 = (IrCFGBlock)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(Intrinsics.areEqual((Object)it, (Object)block) ? (IrCFGBlock)mergedBlock : it);
            }
            collection = (List)destination$iv$iv2;
            multiMap.put((Object)irCFGBlock, (Collection)collection);
            Collection collection6 = outgoingNodes.get((Object)block);
            Intrinsics.checkNotNullExpressionValue((Object)collection6, (String)"get(...)");
            $this$map$iv = collection6;
            irCFGBlock = mergedBlock;
            multiMap = outgoingNodes;
            $i$f$map2 = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (IrCFGBlock)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(Intrinsics.areEqual((Object)it, (Object)prevBlock) ? (IrCFGBlock)mergedBlock : it);
            }
            collection = (List)destination$iv$iv2;
            multiMap.put((Object)irCFGBlock, collection);
            outgoingNodes.remove((Object)prevBlock);
            outgoingNodes.remove((Object)block);
            incomingNodes.remove((Object)prevBlock);
            incomingNodes.remove((Object)block);
            for (IrCFGBlock prePrevBlock : incomingNodes.get((Object)mergedBlock)) {
                newJumps.computeIfPresent(prePrevBlock, (arg_0, arg_1) -> BlocksMergeStage.transform$lambda$4((Function2)new Function2<IrCFGBlock, IrJump, IrJump>(this, prevBlock, mergedBlock){
                    final /* synthetic */ BlocksMergeStage this$0;
                    final /* synthetic */ IrCFGBlock $prevBlock;
                    final /* synthetic */ IrCFGBlockImpl $mergedBlock;
                    {
                        this.this$0 = $receiver;
                        this.$prevBlock = $prevBlock;
                        this.$mergedBlock = $mergedBlock;
                        super(2);
                    }

                    @Nullable
                    public final IrJump invoke(@NotNull IrCFGBlock irCFGBlock, @NotNull IrJump incomingJump) {
                        Intrinsics.checkNotNullParameter((Object)irCFGBlock, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)incomingJump, (String)"incomingJump");
                        return BlocksMergeStage.access$mapTargets(this.this$0, incomingJump, this.$prevBlock, this.$mergedBlock);
                    }
                }, arg_0, arg_1));
            }
        }
        return ((IrFunctionDecl)decl).modifyCfg(new IrCfg(newBlocks, newJumps, startBlock, exitBlock));
    }

    private final IrJump mapTargets(IrJump $this$mapTargets, IrCFGBlock from, IrCFGBlock to) {
        IrJump irJump;
        IrJump irJump2 = $this$mapTargets;
        if (irJump2 instanceof IrConditionalJump) {
            IrCFGBlock trueBranch = Intrinsics.areEqual((Object)((IrConditionalJump)$this$mapTargets).getTrueBranch(), (Object)from) ? to : ((IrConditionalJump)$this$mapTargets).getTrueBranch();
            IrCFGBlock falseBranch = Intrinsics.areEqual((Object)((IrConditionalJump)$this$mapTargets).getFalseBranch(), (Object)from) ? to : ((IrConditionalJump)$this$mapTargets).getFalseBranch();
            irJump = new IrConditionalJump(((IrConditionalJump)$this$mapTargets).getCondition(), trueBranch, falseBranch);
        } else if (irJump2 instanceof IrUnconditionalJump) {
            irJump = new IrUnconditionalJump(Intrinsics.areEqual((Object)((IrUnconditionalJump)$this$mapTargets).getNextBlock(), (Object)from) ? to : ((IrUnconditionalJump)$this$mapTargets).getNextBlock());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irJump;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    private static final IrJump transform$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (IrJump)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ IrJump access$mapTargets(BlocksMergeStage $this, IrJump $receiver, IrCFGBlock from, IrCFGBlock to) {
        return $this.mapTargets($receiver, from, to);
    }
}

