/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.dsl.translator;

import com.intellij.rml.dfa.RmlParseException;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.scripts.VariablesManager;
import com.intellij.rml.dfa.rml.dsl.ast.RmlDeclarationType;
import com.intellij.rml.dfa.rml.dsl.ast.RmlOption;
import com.intellij.rml.dfa.rml.dsl.ast.RmlProgram;
import com.intellij.rml.dfa.rml.dsl.ast.RmlRelationDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J*\u0010\u000b\u001a\u00020\u0006*\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/rml/dfa/impl/rml/dsl/translator/VariableManagerInitializer;", "", "manager", "Lcom/intellij/rml/dfa/impl/scripts/VariablesManager;", "(Lcom/intellij/rml/dfa/impl/scripts/VariablesManager;)V", "initialize", "", "program", "Lcom/intellij/rml/dfa/rml/dsl/ast/RmlProgram;", "processDeclarations", "processOptions", "addDeclaration", "decl", "Lcom/intellij/rml/dfa/rml/dsl/ast/RmlRelationDeclaration;", "type", "Lcom/intellij/rml/dfa/rml/dsl/ast/RmlDeclarationType;", "domainTypes", "", "Lcom/intellij/rml/dfa/impl/domains/DomainType;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nVariableManagerInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableManagerInitializer.kt\ncom/intellij/rml/dfa/impl/rml/dsl/translator/VariableManagerInitializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,46:1\n1855#2,2:47\n37#3,2:49\n*S KotlinDebug\n*F\n+ 1 VariableManagerInitializer.kt\ncom/intellij/rml/dfa/impl/rml/dsl/translator/VariableManagerInitializer\n*L\n26#1:47,2\n43#1:49,2\n*E\n"})
public final class VariableManagerInitializer {
    @NotNull
    private final VariablesManager manager;

    public VariableManagerInitializer(@NotNull VariablesManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
    }

    public final void initialize(@NotNull RmlProgram program2) {
        Intrinsics.checkNotNullParameter((Object)program2, (String)"program");
        this.processDeclarations(program2);
        this.processOptions(program2);
    }

    private final void processOptions(RmlProgram program2) {
        for (RmlOption option : program2.getOptions()) {
            this.manager.addOption(option.getName(), option.getDefaultValue(), option.getType().ordinal());
        }
    }

    private final void processDeclarations(RmlProgram program2) {
        for (RmlDeclarationType type : EntriesMappings.entries$0) {
            List<RmlRelationDeclaration> list = program2.getDeclarations().get((Object)type);
            Intrinsics.checkNotNull(list);
            for (RmlRelationDeclaration decl : list) {
                List domainTypes = new ArrayList();
                Iterable $this$forEach$iv = decl.getDomainTypes();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KClass klass = (KClass)element$iv;
                    boolean bl = false;
                    DomainType domainType = this.manager.getTypeManager().getDomainType(klass);
                    domainTypes.add(domainType);
                }
                this.addDeclaration(this.manager, decl, type, domainTypes);
                String subgroup = program2.getRelationSubgroups().get(decl.getRelationName());
                if (subgroup == null) continue;
                this.manager.setRelationSubgroup(decl.getRelationName(), subgroup);
            }
        }
    }

    private final void addDeclaration(VariablesManager $this$addDeclaration, RmlRelationDeclaration decl, RmlDeclarationType type, List<? extends DomainType> domainTypes) {
        if ($this$addDeclaration.containsRelation(decl.getRelationName())) {
            throw new RmlParseException("Redeclared " + type + " relation " + decl.getRelationName(), null, 2, null);
        }
        Collection $this$toTypedArray$iv = domainTypes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $this$addDeclaration.addRelationDeclaration(type, new RelationSignature(decl.getRelationName(), thisCollection$iv.toArray(new DomainType[0])), decl.getModifications());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<RmlDeclarationType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])RmlDeclarationType.values());
        }
    }
}

