/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.RelExprQuantify;
import com.intellij.rml.dfa.impl.rml.ast.Stmt;
import com.intellij.rml.dfa.impl.rml.ast.StmtRelAssign;
import com.intellij.rml.dfa.impl.rml.ast.StmtTransformer;
import com.intellij.rml.dfa.impl.rml.ast.StmtVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.ProfilePoint;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManagerKt;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StmtIncrementalize
extends Stmt {
    private Stmt header;
    private Stmt loop;
    private final String[] relations;

    public StmtIncrementalize(List<String> relsList, Stmt header2, Stmt loop, Context context) {
        super(context, header2, loop);
        this.header = header2;
        this.loop = loop;
        this.relations = ArrayUtil.toStringArray(relsList);
    }

    public String[] getRelations() {
        return this.relations;
    }

    @Override
    public void accept(StmtVisitor visitor) {
        this.header.accept(visitor);
        if (visitor.visitIncrementalizeStart(this)) {
            this.loop.accept(visitor);
        }
        visitor.visitIncrementalizeEnd(this);
    }

    @Override
    public Stmt transform(StmtTransformer transformer) {
        this.header = this.header.transform(transformer);
        this.loop = this.loop.transform(transformer);
        return transformer.transformIncrementalize(this);
    }

    @Override
    public void interpret(IRelationsManager relationsManager, final RuntimeVariablesManager variablesManager, Cancellation cancellation, final DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        boolean isEmpty;
        ProfilePoint start = RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager);
        cancellation.checkCancelled();
        IRelation[] results = new IRelation[this.relations.length];
        Domain[][] domains = new Domain[this.relations.length][];
        for (int i = 0; i < this.relations.length; ++i) {
            String relation = this.relations[i];
            domains[i] = variablesManager.getRelationDomains(relation);
            results[i] = relationsManager.makeRepositoryRelation(variablesManager.getRelation(relation, cancellation), relation);
        }
        this.header.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
        this.loop.accept(new StmtVisitor(){

            @Override
            public boolean visitRelAssignStart(StmtRelAssign stmt) {
                stmt.pushDomains(variablesManager, domainsPool);
                return true;
            }

            @Override
            public void visitRelAssignEnd(StmtRelAssign stmt) {
                stmt.popDomains(variablesManager);
            }

            @Override
            public boolean visitQuantifyStart(RelExprQuantify expr) {
                expr.pushDomain(variablesManager, domainsPool);
                return true;
            }

            @Override
            public void visitQuantifyEnd(RelExprQuantify expr) {
                expr.popDomain(variablesManager);
            }
        });
        do {
            IRelation work;
            int i;
            cancellation.checkCancelled();
            for (i = 0; i < this.relations.length; ++i) {
                work = relationsManager.makeRepositoryRelation(variablesManager.getRelation(this.relations[i], cancellation), "0" + this.toString());
                work = work.fastRename(domains[i], cancellation);
                IRelation oldResult = results[i];
                results[i] = results[i].unite(work, cancellation);
                oldResult.kill();
                work.kill();
            }
            this.loop.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
            for (i = 0; i < this.relations.length; ++i) {
                work = relationsManager.makeRepositoryRelation(variablesManager.getRelation(this.relations[i], cancellation), "1" + this.toString());
                work = work.fastRename(domains[i], cancellation);
                variablesManager.storeRelation(this.relations[i], work.subtract(results[i], cancellation));
                work.kill();
            }
            isEmpty = true;
            for (String relation : this.relations) {
                isEmpty &= variablesManager.getRelation(relation, cancellation).isEmpty();
            }
        } while (!isEmpty);
        for (int i = 0; i < this.relations.length; ++i) {
            variablesManager.storeRelation(this.relations[i], results[i]);
        }
        if (profileManager2 != null) {
            profileManager2.addDuration(this, start, RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager));
        }
    }

    @NotNull
    public Set<String> getAssignedRelations() {
        final HashSet<String> assignedRelations = new HashSet<String>();
        this.loop.accept(new StmtVisitor(){

            @Override
            public void visitRelAssignEnd(StmtRelAssign stmt) {
                assignedRelations.add(stmt.getRelName());
            }
        });
        HashSet<String> hashSet = assignedRelations;
        if (hashSet == null) {
            StmtIncrementalize.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @Override
    public String toLongString() {
        return "StmtIncrementalize{header=" + this.header.toLongString() + ", loop=" + this.loop.toLongString() + ", relations=" + Arrays.toString(this.relations) + "}";
    }

    @Override
    public String toShortString() {
        return "Incrementalize(" + String.join((CharSequence)", ", this.relations) + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/rml/dfa/impl/rml/ast/StmtIncrementalize", "getAssignedRelations"));
    }
}

