/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.QueryNode;
import com.intellij.rml.dfa.impl.rml.ast.RelExpr;
import com.intellij.rml.dfa.impl.rml.ast.RelExprTransformer;
import com.intellij.rml.dfa.impl.rml.ast.RelExprVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;

public class RelExprAttributeRegexp
extends RelExpr {
    private final String domain;
    private final String regexp;
    private final boolean equ;

    public RelExprAttributeRegexp(String domainName, String regexp, boolean equ, Context context) {
        super(context, new QueryNode[0]);
        this.domain = domainName;
        this.regexp = regexp;
        this.equ = equ;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public void accept(RelExprVisitor visitor) {
        visitor.visitAttributeRegexp(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        return transformer.transformAttributeRegexp(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        return new Domain[]{variablesManager.getDomain(this.domain)};
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        Domain dom = variablesManager.getDomain(this.domain);
        IRelation result = relationsManager.makeRegExprSet(dom, this.regexp, cancellation);
        if (!this.equ) {
            IRelation oldResult = result;
            result = result.complement(cancellation);
            oldResult.kill();
        }
        return result;
    }

    @Override
    public String toLongString() {
        return "RelExprAttributeRegexp{domain='" + this.domain + "', regexp='" + this.regexp + "', equ=" + this.equ + "}";
    }
}

