/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.providers;

import com.intellij.rml.dfa.AnalysisOptions;
import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.impl.bdd.BddManager;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.providers.RMLInstancesFactory;
import com.intellij.rml.dfa.impl.providers.RMLInstancesProvider;
import com.intellij.rml.dfa.impl.providers.RmlProviderDescriptor;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.relations.plain.PlainRelationsManager;
import com.intellij.rml.dfa.impl.repositories.HypoteticRelationsRepository;
import com.intellij.rml.dfa.impl.repositories.MutableRelationsRepository;
import com.intellij.rml.dfa.impl.rml.profiler.DummyProfileManager;
import com.intellij.rml.dfa.impl.rml.profiler.GlobalProfileManager;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.scripts.Script;
import com.intellij.rml.dfa.impl.symtable.MutableSymbolTable;
import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.rml.dfa.impl.ui.Task;
import com.intellij.rml.dfa.impl.ui.ThreadCallback;
import com.intellij.rml.dfa.impl.ui.UICallback;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.impl.ui.console.Console;
import com.intellij.rml.dfa.impl.visitors.Visitor;
import com.intellij.rml.dfa.impl.visitors.VisitorsManager;
import com.intellij.rml.dfa.utils.Cancellation;
import com.intellij.rml.dfa.utils.MetaInfo;
import com.intellij.rml.dfa.utils.RMLOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RMLMutableInstancesProvider
implements RMLInstancesProvider {
    protected RmlProviderDescriptor descriptor;
    protected RMLInstancesFactory factory;
    protected BddManager bddManager;
    protected IRelationsManager relationsManager;
    protected MutableSymbolTable symbolTable;
    protected final VisitorsManager dynamicVisitorManager = new VisitorsManager();
    protected GlobalProfileManager profileManager;
    protected Map<Script, RuntimeVariablesManager> variableManagers = new HashMap<Script, RuntimeVariablesManager>();
    protected MutableRelationsRepository relationsRepository;
    private final UIInstancesProvider uiInstancesProvider;

    public RMLMutableInstancesProvider(RMLInstancesFactory factory, RmlProviderDescriptor descriptor, @Nullable GlobalProfileManager profileManager2) {
        this.factory = factory;
        this.descriptor = descriptor;
        this.profileManager = profileManager2 != null ? profileManager2 : new DummyProfileManager();
        this.uiInstancesProvider = factory.uiInstancesProvider;
        this.symbolTable = this.createSymbolTable(factory.getTypeManager(), descriptor);
        this.bddManager = new BddManager(descriptor);
        this.relationsManager = new PlainRelationsManager(this.bddManager, this.symbolTable);
        this.relationsRepository = new MutableRelationsRepository(this.relationsManager);
    }

    @Override
    @NotNull
    public RmlProviderDescriptor getDescriptor() {
        RmlProviderDescriptor rmlProviderDescriptor = this.descriptor;
        if (rmlProviderDescriptor == null) {
            RMLMutableInstancesProvider.$$$reportNull$$$0(0);
        }
        return rmlProviderDescriptor;
    }

    public UICallback getUICallback() {
        return this.uiInstancesProvider.getUICallback();
    }

    public Console getConsole() {
        return this.uiInstancesProvider.getConsole();
    }

    public GlobalProfileManager getProfileManager() {
        return this.profileManager;
    }

    @NotNull
    protected MutableSymbolTable createSymbolTable(DomainTypeManager typeManager, RmlProviderDescriptor descriptor) {
        return new MutableSymbolTable(typeManager, descriptor, false);
    }

    @Override
    @NotNull
    public MutableSymbolTable getSymbolTable() {
        MutableSymbolTable mutableSymbolTable = this.symbolTable;
        if (mutableSymbolTable == null) {
            RMLMutableInstancesProvider.$$$reportNull$$$0(1);
        }
        return mutableSymbolTable;
    }

    @NotNull
    public Task getDomainsBuilderTask(final List<DfaTuple> input2) {
        return new Task(Messages.getString(HypoteticRelationsRepository.class.getName() + "-20") + " (" + this.toString() + ")"){

            @Override
            public void run(@NotNull Cancellation cancellation) {
                if (cancellation == null) {
                    1.$$$reportNull$$$0(0);
                }
                String name = this.getName();
                RMLMutableInstancesProvider.this.profileManager.withTimeAndBddOpsProfiling(name != null ? name : "", RMLMutableInstancesProvider.this.bddManager, (Function0<? extends List<MetaInfo>>)((Function0)() -> new ArrayList()), new ArrayList(), () -> {
                    VisitorsManager visitorManager = RMLMutableInstancesProvider.this.factory.visitorManager;
                    visitorManager.collectAttributes(input2, RMLMutableInstancesProvider.this.symbolTable, cancellation);
                    RMLMutableInstancesProvider.this.dynamicVisitorManager.collectAttributes(input2, RMLMutableInstancesProvider.this.symbolTable, cancellation);
                    RMLMutableInstancesProvider.this.symbolTable.sortAttributes();
                    return null;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancellation", "com/intellij/rml/dfa/impl/providers/RMLMutableInstancesProvider$1", "run"));
            }
        };
    }

    @NotNull
    public Task getVisitorsTask(final List<DfaTuple> input2) {
        return new Task(Messages.getString(HypoteticRelationsRepository.class.getName() + "-22") + " (" + this.toString() + ")"){

            @Override
            public void run(@NotNull Cancellation cancellation) {
                if (cancellation == null) {
                    2.$$$reportNull$$$0(0);
                }
                String name = this.getName();
                RMLMutableInstancesProvider.this.profileManager.withTimeAndBddOpsProfiling(name != null ? name : "", RMLMutableInstancesProvider.this.bddManager, (Function0<? extends List<MetaInfo>>)((Function0)() -> new ArrayList()), new ArrayList(), () -> {
                    VisitorsManager visitorManager = RMLMutableInstancesProvider.this.factory.visitorManager;
                    visitorManager.collectRelations(input2, RMLMutableInstancesProvider.this, cancellation);
                    RMLMutableInstancesProvider.this.dynamicVisitorManager.collectRelations(input2, RMLMutableInstancesProvider.this, cancellation);
                    return null;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancellation", "com/intellij/rml/dfa/impl/providers/RMLMutableInstancesProvider$2", "run"));
            }
        };
    }

    public void addVisitor(Visitor visitor) {
        this.dynamicVisitorManager.addVisitor(visitor);
    }

    public void clearDynamicVisitors() {
        this.dynamicVisitorManager.clearVisitors();
    }

    @NotNull
    public Task getRunScriptTask(final Script script, final RMLOptions options) {
        return new Task(Messages.getString(HypoteticRelationsRepository.class.getName() + "-21") + script.getName() + "\""){

            @Override
            public void run(@NotNull Cancellation cancellation) {
                if (cancellation == null) {
                    3.$$$reportNull$$$0(0);
                }
                RuntimeVariablesManager manager = RMLMutableInstancesProvider.this.factory.scriptManager.run(script, RMLMutableInstancesProvider.this.symbolTable, RMLMutableInstancesProvider.this.factory.hypotheticRepository, options, cancellation, RMLMutableInstancesProvider.this.uiInstancesProvider, RMLMutableInstancesProvider.this.relationsRepository, RMLMutableInstancesProvider.this.profileManager);
                RMLMutableInstancesProvider.this.variableManagers.put(script, manager);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancellation", "com/intellij/rml/dfa/impl/providers/RMLMutableInstancesProvider$3", "run"));
            }
        };
    }

    @NotNull
    public List<Task> getRelationBuildPlan(List<DfaTuple> input2, RMLOptions options) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        tasks.add(this.getDomainsBuilderTask(input2));
        tasks.add(this.getVisitorsTask(input2));
        List<Script> scripts = this.factory.hypotheticRepository.getScriptsOrder();
        for (Script script : scripts) {
            tasks.add(this.getRunScriptTask(script, options));
        }
        ArrayList<Task> arrayList = tasks;
        if (arrayList == null) {
            RMLMutableInstancesProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public RMLInstancesFactory getFactory() {
        RMLInstancesFactory rMLInstancesFactory = this.factory;
        if (rMLInstancesFactory == null) {
            RMLMutableInstancesProvider.$$$reportNull$$$0(3);
        }
        return rMLInstancesFactory;
    }

    @Override
    @NotNull
    public MutableRelationsRepository getRelationsRepository() {
        MutableRelationsRepository mutableRelationsRepository = this.relationsRepository;
        if (mutableRelationsRepository == null) {
            RMLMutableInstancesProvider.$$$reportNull$$$0(4);
        }
        return mutableRelationsRepository;
    }

    @Nullable
    public RuntimeVariablesManager getVariablesManager(@NotNull Script script) {
        if (script == null) {
            RMLMutableInstancesProvider.$$$reportNull$$$0(5);
        }
        return this.variableManagers.get(script);
    }

    @Override
    @NotNull
    public BddManager getBddManager() {
        BddManager bddManager = this.bddManager;
        if (bddManager == null) {
            RMLMutableInstancesProvider.$$$reportNull$$$0(6);
        }
        return bddManager;
    }

    public IRelationsManager getRelationsManager() {
        return this.relationsManager;
    }

    public void run(List<DfaTuple> input2, ThreadCallback threadCallback, RMLOptions options) {
        for (Task task : this.getRelationBuildPlan(input2, options)) {
            task.run(threadCallback);
        }
    }

    public void run(List<DfaTuple> input2, ThreadCallback threadCallback) {
        this.run(input2, threadCallback, AnalysisOptions.INSTANCE.getDefaultOptions());
    }

    public void runDynamicVisitors(ThreadCallback threadCallback) {
        this.getDomainsBuilderTask(List.of()).run(threadCallback);
        this.getVisitorsTask(List.of()).run(threadCallback);
        this.clearDynamicVisitors();
    }

    public String toString() {
        return this.descriptor.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/rml/dfa/impl/providers/RMLMutableInstancesProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelationBuildPlan";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelationsRepository";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/rml/dfa/impl/providers/RMLMutableInstancesProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBddManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVariablesManager";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }
}

